/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.functionadapterimpl;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValue;
import com.huawei.nglct.nemgr.tl1ngwdm.functionadapterimpl.TETL1WDMInfStaticData;
import com.huawei.nglct.nemgr.tl1ngwdm.functionadapterimpl.associcate.ITL1AssoHander;
import com.huawei.nglct.nemgr.tl1ngwdm.functionadapterimpl.associcate.TETL1PortMappingAssoHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TETL1AssociateAttrMgr {
    private static Map<String, ITL1AssoHander> associateAttrMap = new HashMap<String, ITL1AssoHander>();

    private static void initAssociateAttrMap() {
        TETL1AssociateAttrMgr.registerAssoAttrHandler(new TETL1PortMappingAssoHandler());
    }

    private static void registerAssoAttrHandler(ITL1AssoHander handler) {
        associateAttrMap.put(handler.getAttrName(), handler);
    }

    public static boolean isAssociateSupportAttri(TEGnlValueElement gnlValueElement) {
        TEGenValue genValue = new TEGenValue(gnlValueElement);
        String attrName = genValue.getAttrName();
        ITL1AssoHander assoHandler = associateAttrMap.get(attrName);
        if (null == assoHandler) {
            return true;
        }
        List<String> associateAttrList = assoHandler.getAssociateAttrList();
        if (null == associateAttrList || associateAttrList.isEmpty()) {
            return true;
        }
        int attrID = -1;
        boolean isSupport = false;
        TEGeneralKeyValue keyValue = null;
        TEDaoOperationResult result = null;
        TEGnlValueElement ele = null;
        List data = null;
        for (String associateAttr : associateAttrList) {
            keyValue = TETL1AssociateAttrMgr.getCloneKeyValue(gnlValueElement);
            if (null == keyValue) continue;
            attrID = TETL1WDMInfStaticData.getAttrNameIDMap().get(associateAttr);
            keyValue.setAttrID(attrID);
            result = TETL1AssociateAttrMgr.getAssociateAttrFromDB(keyValue);
            data = result.getData();
            TELogFactory.getNormalLogger().info("find gnl value. data.size->" + data.size());
            TELogFactory.getNormalLogger().info("find gnl value. result->" + result.toString());
            if (data.isEmpty() || (isSupport = assoHandler.isSupportByAssoAttr(associateAttr, ele = (TEGnlValueElement)data.get(0)))) continue;
            return false;
        }
        return true;
    }

    private static TEDaoOperationResult getAssociateAttrFromDB(TEGeneralKeyValue keyValue) {
        TEGnlValueElement element = new TEGnlValueElement();
        element.setGnlKeyValue(keyValue);
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>();
        elementList.add(element);
        TEDaoOperationResult result = TETL1AssociateAttrMgr.getElementFromDB(elementList);
        return result;
    }

    public static TEDaoOperationResult getElementFromDB(List<TEGnlValueElement> elementList) {
        StringBuffer buffer = new StringBuffer(0);
        buffer.append("find gnl value. req->").append('\n');
        for (TEGnlValueElement ele : elementList) {
            buffer.append(ele.toString()).append('\n');
        }
        TELogFactory.getNormalLogger().info("find gnl value. req->" + buffer.toString());
        TEDaoOperationResult result = TECommonDaoService.findGnlValue(elementList);
        TELogFactory.getNormalLogger().info("find gnl value. rsp->" + result.getResult());
        return result;
    }

    private static TEGeneralKeyValue getCloneKeyValue(TEGnlValueElement gnlValueElement) {
        TEGeneralKeyValue keyValue = null;
        try {
            keyValue = (TEGeneralKeyValue)gnlValueElement.getGnlKeyValue().clone();
        }
        catch (CloneNotSupportedException e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
        }
        return keyValue;
    }

    static {
        TETL1AssociateAttrMgr.initAssociateAttrMap();
    }
}

