/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.workmode;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.workmode.TEPortModeData;
import com.huawei.nglct.util.xml.TEResourceManager;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEWorkModeMgr {
    private static TEWorkModeMgr instance = null;
    private HashMap<Integer, ArrayList> workModeMap = new HashMap();
    private HashMap<Integer, String> boardModeMacroMap = new HashMap();
    private HashMap<Integer, String> portModeMacroMap = new HashMap();
    public static final String BOARDMODE = "boardmode";
    public static final String PORTMODE = "portmode";

    private TEWorkModeMgr() {
        this.parseWorkModeXML();
        this.praseMacroWorkModeXML();
    }

    public static synchronized TEWorkModeMgr getInstance() {
        if (instance == null) {
            instance = new TEWorkModeMgr();
        }
        return instance;
    }

    private void parseWorkModeXML() {
        String filepath = "nemgr" + File.separator + "tl1ngwdm" + File.separator + "conf" + File.separator + "board_attribute" + File.separator + "config" + File.separator + "workmodel" + File.separator + "workmodesupport.xml";
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile((String)"com.huawei.weblct.tl1ngwdm", (String)(TEResourceManager.getPath() + File.separator + filepath));
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("Parse XML Fail: " + filepath);
        }
        if (null == doc) {
            TELogFactory.getNormalLogger().info("Parse XML Fail: " + filepath);
            return;
        }
        SDXMLInterpreterMgr instance = SDXMLInterpreterMgr.getInstance();
        NodeList nl = doc.getElementsByTagName("work_mode_desc");
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Element eltWdm = (Element)nl.item(i);
            String cpTypeValue = eltWdm.getAttribute("cp_type");
            int cptype = instance.parseInt(cpTypeValue);
            if (cptype == 0) continue;
            ArrayList<TEPortModeData> workModeList = new ArrayList<TEPortModeData>();
            this.workModeMap.put(cptype, workModeList);
            NodeList itemNode = eltWdm.getElementsByTagName("item");
            int size = itemNode.getLength();
            for (int j = 0; j < size; ++j) {
                String pathid;
                String dependport;
                String portid;
                String workmode;
                TEPortModeData workModeData = new TEPortModeData();
                Element eltTmp = (Element)itemNode.item(j);
                String boardmode = eltTmp.getAttribute(BOARDMODE);
                if (!boardmode.equalsIgnoreCase("none")) {
                    workModeData.setBoardMode(Integer.parseInt(boardmode));
                }
                if (!(workmode = eltTmp.getAttribute("workmode")).equalsIgnoreCase("none")) {
                    workModeData.setWorkmode(workmode);
                }
                if (!(portid = eltTmp.getAttribute("portid")).equals("0")) {
                    workModeData.setPortid(portid);
                }
                if (!"".equals(dependport = eltTmp.getAttribute("dependport"))) {
                    workModeData.setDependPortId(dependport);
                }
                if ((pathid = eltTmp.getAttribute("pathid")) != null) {
                    workModeData.setPathid(pathid);
                }
                String versionRange = eltTmp.getAttribute("neversion");
                workModeData.setVersionRange(versionRange);
                String netype = eltTmp.getAttribute("netype");
                workModeData.setNeTypeStr(netype);
                workModeData.init();
                workModeList.add(workModeData);
            }
        }
    }

    private void praseMacroWorkModeXML() {
        String filepath = "nemgr" + File.separator + "tl1ngwdm" + File.separator + "conf" + File.separator + "board_attribute" + File.separator + "config" + File.separator + "workmodel" + File.separator + "macro_portmode.xml";
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile((String)"com.huawei.weblct.tl1ngwdm", (String)(TEResourceManager.getPath() + File.separator + filepath));
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("Parse XML Fail: " + filepath);
        }
        if (null == doc) {
            TELogFactory.getNormalLogger().info("Parse XML Fail: " + filepath);
            return;
        }
        this.parseBoardModeMap(doc);
        this.parsePortModeMap(doc);
    }

    public String getWorkModeValue(String mode, int workmode) {
        if (mode.equals(BOARDMODE)) {
            return this.boardModeMacroMap.get(workmode);
        }
        if (mode.equals(PORTMODE)) {
            return this.portModeMacroMap.get(workmode);
        }
        return "UNDEFINED";
    }

    public int getWorkModeIntValue(String mode, String workmode) {
        if (workmode == null || workmode.isEmpty()) {
            return -1;
        }
        Iterator<Map.Entry<Integer, String>> it = null;
        if (mode.equals(BOARDMODE)) {
            it = this.boardModeMacroMap.entrySet().iterator();
        } else if (mode.equals(PORTMODE)) {
            it = this.portModeMacroMap.entrySet().iterator();
        }
        if (it != null) {
            while (it.hasNext()) {
                Map.Entry<Integer, String> entry = it.next();
                Integer key = entry.getKey();
                String value = entry.getValue();
                if (!value.equals(workmode)) continue;
                return key;
            }
        }
        return -1;
    }

    private void parseBoardModeMap(Document doc) {
        NodeList nl = doc.getElementsByTagName(BOARDMODE);
        Element eltWdm = (Element)nl.item(0);
        NodeList itemNode = eltWdm.getElementsByTagName("item");
        int size = itemNode.getLength();
        for (int j = 0; j < size; ++j) {
            Element eltTmp = (Element)itemNode.item(j);
            String workmode = eltTmp.getAttribute("workMode");
            String value = eltTmp.getAttribute("value");
            this.boardModeMacroMap.put(Integer.valueOf(workmode), value);
        }
    }

    private void parsePortModeMap(Document doc) {
        NodeList nl = doc.getElementsByTagName(PORTMODE);
        Element eltWdm = (Element)nl.item(0);
        NodeList itemNode = eltWdm.getElementsByTagName("item");
        int size = itemNode.getLength();
        for (int j = 0; j < size; ++j) {
            Element eltTmp = (Element)itemNode.item(j);
            String workmode = eltTmp.getAttribute("workMode");
            String value = eltTmp.getAttribute("value");
            this.portModeMacroMap.put(Integer.valueOf(workmode), value);
        }
    }

    public ArrayList<Integer> getBoardModeList(int bdType, int neType, String neVersion) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        ArrayList workModeList = this.workModeMap.get(bdType);
        if (workModeList != null) {
            int size = workModeList.size();
            for (int i = 0; i < size; ++i) {
                int boardMode;
                TEPortModeData data = (TEPortModeData)workModeList.get(i);
                if (!data.checkNeType(neType) || !data.checkNeVersion(neVersion) || (boardMode = data.getBoardMode()) == -1 || list.contains(boardMode)) continue;
                list.add(boardMode);
            }
        }
        Collections.sort(list);
        return list;
    }

    public ArrayList<Integer> getPortModeList(int bdType, int boardMode, int portId, int neType, String neVersion) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        ArrayList workModeList = this.workModeMap.get(bdType);
        if (workModeList != null) {
            int size = workModeList.size();
            for (int i = 0; i < size; ++i) {
                TEPortModeData data = (TEPortModeData)workModeList.get(i);
                if (!data.checkNeType(neType) || !data.checkNeVersion(neVersion) || data.getBoardMode() != boardMode || !data.getPortidList().contains(Integer.valueOf(portId).intValue())) continue;
                TIntArrayList portList = data.getWorkModeList();
                int len = portList.size();
                for (int j = 0; j < len; ++j) {
                    if (list.contains(portList.get(j))) continue;
                    list.add(portList.get(j));
                }
            }
        }
        Collections.sort(list);
        return list;
    }

    public ArrayList<Integer> getPortIDList(int bdType, int boardMode, int neType, String neVersion) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        ArrayList workModeList = this.workModeMap.get(bdType);
        if (workModeList != null) {
            int size = workModeList.size();
            for (int i = 0; i < size; ++i) {
                TEPortModeData data = (TEPortModeData)workModeList.get(i);
                if (!data.checkNeType(neType) || !data.checkNeVersion(neVersion) || data.getBoardMode() != boardMode) continue;
                TIntArrayList portList = data.getPortidList();
                int len = portList.size();
                for (int j = 0; j < len; ++j) {
                    if (list.contains(portList.get(j))) continue;
                    list.add(portList.get(j));
                }
            }
        }
        Collections.sort(list);
        return list;
    }

    public boolean isSupportPortMode(int bdType, int boardMode, int neType, String neVersion) {
        boolean flag = false;
        ArrayList workModeList = this.workModeMap.get(bdType);
        if (workModeList != null) {
            int size = workModeList.size();
            for (int i = 0; i < size; ++i) {
                TIntArrayList portList;
                TEPortModeData data = (TEPortModeData)workModeList.get(i);
                if (!data.checkNeType(neType) || !data.checkNeVersion(neVersion) || data.getBoardMode() != boardMode || (portList = data.getWorkModeList()).isEmpty()) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public boolean isSupportPortMode(int boardType, int boardMode) {
        if (this.workModeMap.containsKey(boardType)) {
            ArrayList workModeList = this.workModeMap.get(boardType);
            for (TEPortModeData temp : workModeList) {
                if (temp.getBoardMode() != boardMode || temp.getWorkmode().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSupportBoardMode(int boardType) {
        return this.workModeMap.containsKey(boardType);
    }

    public String getPathID(int bdType, int boardMode, int portId, int neType, String neVersion) {
        ArrayList workModeList = this.workModeMap.get(bdType);
        if (workModeList != null) {
            int size = workModeList.size();
            for (int i = 0; i < size; ++i) {
                TEPortModeData data = (TEPortModeData)workModeList.get(i);
                if (!data.checkNeType(neType) || !data.checkNeVersion(neVersion) || data.getBoardMode() != boardMode || !data.getPortidList().contains(Integer.valueOf(portId).intValue())) continue;
                return data.getPathid();
            }
        }
        return "";
    }

    public int getDependPortID(int neid, int bdType, int boardMode, int portId) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        String neVersion = ne.getHostVersion();
        ArrayList workModeList = this.workModeMap.get(bdType);
        if (workModeList != null) {
            int size = workModeList.size();
            for (int i = 0; i < size; ++i) {
                TEPortModeData data = (TEPortModeData)workModeList.get(i);
                if (!data.checkNeType(neType) || !data.checkNeVersion(neVersion) || data.getBoardMode() != boardMode || data.getPortidList() == null || data.getPortidList().isEmpty() || data.getDependPortIdList() == null || data.getDependPortIdList().isEmpty()) continue;
                if (data.getDependPortIdList().size() != data.getPortidList().size()) {
                    if (!data.getDependPortIdList().contains(portId)) continue;
                    return data.getPortidList().get(0);
                }
                if (!data.getDependPortIdList().contains(portId)) continue;
                int len = data.getDependPortIdList().size();
                for (int j = 0; j < len; ++j) {
                    if (portId != data.getDependPortIdList().get(j)) continue;
                    return data.getPortidList().get(j);
                }
            }
        }
        return -1;
    }
}

