/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.workmode;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.workmode.TEWorkModeMgr;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1QueryLogicPort;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TENESetWorkmodeBean
extends TETL1NEExplorerBean {
    private int slotID = -1;

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param slotIDParam = null;
        if (part.getName().equalsIgnoreCase("AID")) {
            slotIDParam = rowparams.getParam("AID");
            if (slotIDParam == null) {
                return false;
            }
            part.setValue(slotIDParam.getValue());
        } else if (part.getName().equalsIgnoreCase("WORKMODE")) {
            slotIDParam = rowparams.getParam("workmode");
            if (slotIDParam == null) {
                return false;
            }
            part.setValue(this.getWorkMode(slotIDParam.getValue()));
        } else if (part.getName().equalsIgnoreCase("PST")) {
            part.setValue("OOS");
        }
        return flag;
    }

    private String getWorkMode(String mode) {
        return TEWorkModeMgr.getInstance().getWorkModeValue("portmode", Integer.parseInt(mode));
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, tl1OperList, subfunc, filterErrorCodeList);
        TETL1QueryLogicPort.queryRealMod2((int)neid, (int)this.slotID);
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        RowParams rowParams = null;
        int len = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowParams = inputData.getBussinessParams().getRowParams(i);
            this.slotID = Integer.parseInt(rowParams.getParam("slotid").getValue());
            int bdType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
            if (1620 != bdType) continue;
            String mod2 = rowParams.getParam("mod2").getValue();
            this.setPortStatusForELOM(neid, rowParams, mod2);
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    private void setPortStatusForELOM(int neid, RowParams rowParams, String mod2) {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = TECreateObjectFactory.getTL1Operation((int)neid, (String)"ED-ODUN");
        if (null == tl1Operation || "UNEQ".equals(mod2) || mod2.isEmpty()) {
            return;
        }
        tl1Operation.setMod1(mod2);
        super.fillStagBlock(rowParams, tl1Operation.getInMsg().getStagBlock());
        super.fillMsgBlock(rowParams, tl1Operation.getInMsg().getMsgBlock());
        operationList.add(tl1Operation);
        this.sendMessage(neid, operationList);
    }
}

