/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.workmode;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.workmode.TEWorkModeMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.uflight.tl1.tl1operation.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TENEGetWorkmodeBean
extends TETL1NEExplorerBean {
    private TEWorkModeMgr workModeInstance = TEWorkModeMgr.getInstance();
    private int neType = -1;
    private String neVersion = "";
    private int boardMode = -1;
    private int bdType = -1;
    private String slotid = "-1";

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param slotIDParam = null;
        Param portIDParam = null;
        Param pathIDParam = null;
        if (part.getName().equalsIgnoreCase("AID")) {
            slotIDParam = rowparams.getParam("slotid");
            portIDParam = rowparams.getParam("portid");
            pathIDParam = rowparams.getParam("pathid");
            if (slotIDParam == null) {
                return false;
            }
        } else {
            return super.convertPartValue(part, rowparams);
        }
        part.setValue(TETL1CommonUtil.getAIDFromPort((int)this.neid, (String)slotIDParam.getValue(), (String)portIDParam.getValue(), (String)pathIDParam.getValue()));
        return flag;
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap) {
        if (oldParam.getName().equalsIgnoreCase("slotid")) {
            Part part = (Part)partmap.get("AID");
            String str = part.getValue();
            int slotid = TETL1CommonUtil.getNMSlotStr((String)str, (int)this.neid);
            oldParam.setValue(String.valueOf(slotid));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("portworkmodel")) {
            Part part = (Part)partmap.get("WORKMODE");
            if (part != null && part.getValue() != null) {
                oldParam.setValue(this.getWorkMode(part.getValue()));
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("slotname")) {
            Part part = (Part)partmap.get("AID");
            int slotID = TETL1CommonUtil.getNMSlotStr((String)part.getValue(), (int)this.neid);
            TENE ne = TENEListUtils.getNEObj((int)this.neid);
            TEBoard board = ne.getBoard(slotID);
            if (part.getValue() != null) {
                oldParam.setValue(board.getBoardName());
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("portid")) {
            Part part = (Part)partmap.get("AID");
            if (part.getValue() != null) {
                int nmPort = TETL1CommonUtil.getNMPortNOFromAidStruct((String)part.getValue(), (int)this.neid);
                oldParam.setValue(String.valueOf(nmPort));
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("portname")) {
            Part part = (Part)partmap.get("AID");
            if (part.getValue() != null) {
                String[] aids = TETL1CommonUtil.parseAID((String)part.getValue(), (int)this.neid);
                int slotID = TETL1CommonUtil.getNMSlotStr((String)part.getValue(), (int)this.neid);
                String portName = TETL1CommonUtil.getPortNameFromNEPort((String)aids[0], (int)slotID, (int)Integer.parseInt(aids[3]), (int)this.neid);
                oldParam.setValue(portName);
            }
            return oldParam;
        }
        return oldParam;
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList<Integer> portList;
        BussinessParams bussinessParam = inputData.getBussinessParams();
        this.slotid = bussinessParam.getRowParams(0).getParam("slotid").getValue();
        TENE ne = TENEListUtils.getNEObj((int)neid);
        this.neType = ne.getNEType();
        this.neVersion = ne.getHostVersion();
        this.bdType = TEConfigurationDataMgr.getInstance().getBoardType(neid, Integer.parseInt(this.slotid));
        String boardModeStr = bussinessParam.getRowParams(0).getParam("boardMode").getValue();
        if (!boardModeStr.isEmpty()) {
            this.boardMode = this.workModeInstance.getWorkModeIntValue("boardmode", boardModeStr);
        }
        if ((portList = this.workModeInstance.getPortIDList(this.bdType, this.boardMode, this.neType, this.neVersion)).size() > 0) {
            RowParams rowParam = bussinessParam.getRowParams(0);
            rowParam.addParam("portid", String.valueOf(portList.get(0)));
            rowParam.addParam("pathid", this.workModeInstance.getPathID(this.bdType, this.boardMode, portList.get(0), this.neType, this.neVersion));
            int size = portList.size();
            for (int i = 1; i < size; ++i) {
                RowParams tmpRowParam = (RowParams)rowParam.clone();
                Integer portID = portList.get(i);
                String pathID = this.workModeInstance.getPathID(this.bdType, this.boardMode, portList.get(i), this.neType, this.neVersion);
                tmpRowParam.getParam("portid").setValue(String.valueOf(portID));
                tmpRowParam.getParam("pathid").setValue(pathID);
                bussinessParam.addRowParams(tmpRowParam);
            }
        }
        return super.getTL1Operation(neid, subFunc, inputData, memeryData);
    }

    private String getWorkMode(String mode) {
        return String.valueOf(this.workModeInstance.getWorkModeIntValue("portmode", mode));
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, tl1OperList, subfunc, filterErrorCodeList);
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        this.queryMod2ForELOM();
        int len = bussinessParams.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            if (bussinessParams.getRowParams(i) == null || bussinessParams.getRowParams(i).getParam("portid") == null) continue;
            int portID = Integer.parseInt(bussinessParams.getRowParams(i).getParam("portid").getValue());
            Param param = bussinessParams.getRowParams(i).getParam("portworkmodel");
            ArrayList<Integer> portModeList = this.workModeInstance.getPortModeList(this.bdType, this.boardMode, portID, this.neType, this.neVersion);
            int size = portModeList.size();
            for (int j = 0; j < size; ++j) {
                Integer portMode = portModeList.get(j);
                param.addOption(new Option(String.valueOf(portMode)));
            }
            if (1620 != this.bdType) continue;
            String mod2 = this.aidAndTypeList.getMod2(neid, Integer.parseInt(this.slotid), portID);
            bussinessParams.getRowParams(i).addParam(new Param("mod2", mod2));
        }
    }

    private void queryMod2ForELOM() {
        if (1620 != this.bdType) {
            return;
        }
        this.slotIDList = new HashSet();
        this.slotIDList.add(Integer.valueOf(this.slotid));
        this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)this.neid, (HashSet)this.slotIDList);
    }
}

