/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.workmode;

import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.workmode.TEWorkModeMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.tl1.tl1operation.Part;
import java.util.ArrayList;
import java.util.HashMap;

public class TENEGetBoardWorkmodeBean
extends TETL1NEExplorerBean {
    private int bdType = -1;

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param slotIDParam = null;
        if (part.getName().equalsIgnoreCase("AID")) {
            slotIDParam = rowparams.getParam("slotid");
            if (slotIDParam == null) {
                return false;
            }
        } else {
            return super.convertPartValue(part, rowparams);
        }
        this.bdType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, Integer.parseInt(slotIDParam.getValue()));
        String slotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotIDParam.getValue()));
        part.setValue("SLOT-" + slotID);
        return flag;
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap) {
        if (oldParam.getName().equalsIgnoreCase("subrackName")) {
            Part part = (Part)partmap.get("slotID");
            String str = part.getValue();
            int slotid = TETL1CommonUtil.getNMSlotStr((String)str, (int)this.neid);
            String subarckName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid);
            oldParam.setValue(subarckName);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("slotid")) {
            Part part = (Part)partmap.get("slotID");
            String str = part.getValue();
            int slotid = TETL1CommonUtil.getNMSlotStr((String)str, (int)this.neid);
            oldParam.setValue(String.valueOf(slotid));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pst")) {
            Part part = (Part)partmap.get("PST");
            String str = part.getValue();
            part = (Part)partmap.get("SST");
            if (part != null && part.getValue() != null && !part.getValue().equals("")) {
                str = str + "," + part.getValue();
            }
            oldParam.setValue(str);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("workmode")) {
            Part part = (Part)partmap.get("WORKMODE");
            if (part.getValue() != null) {
                oldParam.setValue(part.getValue());
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("slotname")) {
            Part part = (Part)partmap.get("slotID");
            int slotID = TETL1CommonUtil.getNMSlotStr((String)part.getValue(), (int)this.neid);
            TENE ne = TENEListUtils.getNEObj((int)this.neid);
            TEBoard board = ne.getBoard(slotID);
            if (part.getValue() != null) {
                oldParam.setValue(board.getBoardName());
            }
            return oldParam;
        }
        return oldParam;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, tl1OperList, subfunc, filterErrorCodeList);
        TEWorkModeMgr workModeInstance = TEWorkModeMgr.getInstance();
        String workMode = this.outputData.getBussinessParams().getRowParams(0).getParam("workmode").getValue();
        boolean isSupPortMode = false;
        TENE ne = TENEListUtils.getNEObj((int)neid);
        int neType = ne.getNEType();
        String neVersion = ne.getHostVersion();
        int boardMode = workModeInstance.getWorkModeIntValue("boardmode", workMode);
        if (workMode.equals("")) {
            boardMode = -1;
            isSupPortMode = true;
        } else {
            isSupPortMode = workModeInstance.isSupportPortMode(this.bdType, boardMode, neType, neVersion);
        }
        this.outputData.getBussinessParams().getRowParams(0).addParam("isSupportPortMode", String.valueOf(isSupPortMode));
        this.outputData.getBussinessParams().getRowParams(0).addParam("boardModeIntValue", String.valueOf(boardMode));
        ArrayList<Integer> boardModeList = workModeInstance.getBoardModeList(this.bdType, neType, neVersion);
        Param param = this.outputData.getBussinessParams().getRowParams(0).getParam("workmode");
        int size = boardModeList.size();
        for (int i = 0; i < size; ++i) {
            Integer tmpboardMode = boardModeList.get(i);
            param.addOption(new Option(String.valueOf(tmpboardMode)));
        }
    }
}

