/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.wdminterface;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgCmdFactory;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunAttr;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunCmd;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgSetBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TETL1SetWDMInterface
extends TETL1GenCfgSetBean {
    public static final String OPR_OTNNULL_SET = "CONN-TST";
    private static final int RMONBOARD_NOT_IPAPAIR = 1090593016;
    protected static List<Integer> romanBds = new ArrayList<Integer>();
    protected List<TL1Operation> LaserCfgOpers_need_refactor = new ArrayList<TL1Operation>();

    public TETL1SetWDMInterface() {
        this.bQueryAidAndType = true;
    }

    public ArrayList getSetOperationList(TL1Definitions definitions, TETL1GenCfgFunCmd funCmd, Datainterface inputData) {
        ArrayList opers = super.getSetOperationList(definitions, funCmd, inputData);
        return this.specialLaserOpenOperation(opers);
    }

    public int getTimeOut() {
        return 180;
    }

    public Datainterface handleOperationListError(ArrayList operationList, Datainterface outputData) {
        if (this.LaserCfgOpers_need_refactor.isEmpty()) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        } else {
            operationList.addAll(this.LaserCfgOpers_need_refactor);
            outputData = this.convertToDatainterface(this.neid, this.subfunc, operationList, null);
        }
        return outputData;
    }

    private ArrayList specialLaserOpenOperation(ArrayList<TL1Operation> opers) {
        this.LaserCfgOpers_need_refactor.clear();
        Iterator<TL1Operation> iter = opers.iterator();
        boolean needQueryIPAPairFlag = false;
        List<Object> rmonBoardList = new ArrayList();
        Part part = null;
        DataBlock dataBlock = null;
        OutMsg curOutput = null;
        while (iter.hasNext()) {
            TL1Operation oper = iter.next();
            int len = oper.getInMsg().getMsgBlock().getDataBlockCount();
            for (int i = 0; i < len; ++i) {
                dataBlock = oper.getInMsg().getMsgBlock().getDataBlock(i);
                int size = dataBlock.getPartCount();
                for (int j = 0; j < size; ++j) {
                    part = dataBlock.getPart(j);
                    if (part.getName().equals("LSRSTATE") && part.getValue() != null && part.getValue().equals("OPEN") && !needQueryIPAPairFlag) {
                        needQueryIPAPairFlag = true;
                        rmonBoardList = this.queryIPAPair();
                    }
                    if (!part.getName().equals("LSRSTATE") || part.getValue() == null || !part.getValue().equals("OPEN")) continue;
                    Part aidPart = oper.getInMsg().getStagBlock().getAID().getPart(0);
                    String aid = aidPart.getValue();
                    int nmSlotID = TETL1CommonUtil.getNMSlotStr((String)aid, (int)this.neid);
                    int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, nmSlotID);
                    if (!romanBds.contains(boardType) || rmonBoardList.contains(nmSlotID)) continue;
                    int portID = TETL1CommonUtil.getPortIDFromAID((String)aid, (int)this.neid);
                    if ((boardType != 2318 && boardType != 2335 || portID != 9) && (boardType == 2318 || boardType == 2335)) continue;
                    for (int index = oper.getOutMsgCount() - 1; index >= 0; --index) {
                        curOutput = oper.getOutMsg(index);
                        curOutput.getFault().setCompletionCode(1090593016);
                        curOutput.getFault().setErrDesc("The board does not belong to IPA pair.");
                    }
                    iter.remove();
                    this.LaserCfgOpers_need_refactor.add(oper);
                }
            }
        }
        return opers;
    }

    public String convertAttrID(String attrID) {
        if (attrID == null) {
            return null;
        }
        if (attrID.equals("DWDMTL1_ATTRSM_PST") || attrID.equals("DWDMTL1_ATTRPM_PST") || attrID.equals("DWDMTL1_ATTRTCM_PST")) {
            return "DWDMTL1_ATTRPORT_ADVANCED_PST";
        }
        if (attrID.equals("DWDMTL1_ATTRSM_SST") || attrID.equals("DWDMTL1_ATTRPM_SST") || attrID.equals("DWDMTL1_ATTRTCM_SST")) {
            return "DWDMTL1_ATTRPORT_ADVANCED_SST";
        }
        if (attrID.equals("DWDMTL1_ATTRPORT_BOARD_PST")) {
            return "BOARD_PST";
        }
        if (attrID.equals("DWDMTL1_ATTRPORT_BOARD_SST")) {
            return "BOARD_SST";
        }
        if (66 == this.neType && attrID.equals("DWDMTL1_ATTRPORT_FEC")) {
            return "DWDMTL1_ATTRPORT_WORKFEC";
        }
        return attrID;
    }

    protected String getMod2(int neid, int slotid, int portid, int pathid, String attrID) {
        TETL1GenCfgFunAttr attr = this.funCmd.getGenCfgFunAttr(attrID, "query");
        if (attr != null) {
            ArrayList list = attr.getModifierList();
            ArrayList mod2List = null;
            mod2List = pathid > 0 ? this.aidAndTypeList.getAllMod2(neid, slotid, portid, pathid) : this.aidAndTypeList.getAllMod2(neid, slotid, portid);
            int len = mod2List.size();
            for (int i = 0; i < len; ++i) {
                String mod2 = (String)mod2List.get(i);
                int size = list.size();
                for (int j = 0; j < size; ++j) {
                    String tempMod2 = (String)list.get(j);
                    if (!mod2.equals(tempMod2)) continue;
                    String tl1Mod2 = TETL1GenCfgCmdFactory.getInstance().getTL1DescMod2(mod2);
                    return tl1Mod2 + "&&" + mod2;
                }
            }
        }
        return "UNKNOWN";
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        operationList.addAll(this.LaserCfgOpers_need_refactor);
        ArrayList tempList = new ArrayList();
        tempList.addAll(operationList);
        this.outputData = this.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList);
        String aid = null;
        RowParams rowParams = null;
        String curMod2 = null;
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            rowParams = this.outputData.getBussinessParams().getRowParams(i);
            for (int j = rowParams.getRowErrorsCount() - 1; j >= 0; --j) {
                if (null == rowParams.getRowErrors(j).getParam("AID")) continue;
                aid = rowParams.getRowErrors(j).getParam("AID").getValue();
                curMod2 = this.findCurMod2FromOperation(aid, tempList);
                if (curMod2 != null) {
                    rowParams.getRowErrors(j).getParam("AID").setValue(TETL1CommonUtil.getGencfgObjFromAID((int)neid, (String)aid) + "-" + curMod2);
                    rowParams.getRowErrors(j).addParam(new Param("CurMod2", curMod2));
                } else {
                    rowParams.getRowErrors(j).getParam("AID").setValue(TETL1CommonUtil.getGencfgObjFromAID((int)neid, (String)aid));
                    rowParams.getRowErrors(j).addParam(new Param("CurMod2", ""));
                }
                rowParams.getRowErrors(j).addParam(new Param("RealAID", aid));
            }
        }
    }

    private String findCurMod2FromOperation(String _aid, ArrayList _operationList) {
        try {
            int len = _operationList.size();
            for (int i = 0; i < len; ++i) {
                TL1Operation oper = (TL1Operation)_operationList.get(i);
                if (!oper.getInMsg().getStagBlock().getAID().getPart(0).getValue().equals(_aid)) continue;
                return TETL1CommonUtil.getRealMod2((TL1Operation)oper);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1SetWDMInterface.findCurMod2FromOperation() Exception!", (Throwable)e);
        }
        return null;
    }

    public boolean isFillMsgBlock(String operationName, RowParams rowparams, MsgBlock msgBlock) {
        return !operationName.equals("RMV") && !operationName.equals("RST") && !operationName.equals("RLS-LPBK") && !operationName.equals("OPR-RPCASE") && operationName.indexOf("DISC-TST") == -1;
    }

    public String changeOperationName(String operationName, RowParams rowparams) {
        String tmpValue;
        Param tmpParam;
        if (operationName.equals("OPR-LPBK")) {
            String tmpValue2;
            tmpParam = rowparams.getParam("DWDMTL1_ATTRPORT_LOOPBACK");
            Param tmpAdvanceParam = rowparams.getParam("DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK");
            if (tmpParam != null && (tmpValue2 = tmpParam.getValue()) != null && tmpValue2.equals("NOLOOP")) {
                operationName = "RLS-LPBK";
            }
            if (tmpAdvanceParam != null && (tmpValue2 = tmpAdvanceParam.getValue()) != null && tmpValue2.equals("NOLOOP")) {
                operationName = "RLS-LPBK";
            }
        }
        if (operationName.equals(OPR_OTNNULL_SET) && (tmpParam = rowparams.getParam("DWDMTL1_ATTRPORT_OTNNULL")) != null && (tmpValue = tmpParam.getValue()) != null && tmpValue.equals("STOP")) {
            operationName = "DISC-TST";
        }
        return operationName;
    }

    private List<Integer> queryIPAPair() {
        ArrayList<Integer> rmonBoardList = new ArrayList<Integer>();
        try {
            ArrayList<TL1Operation> opers = new ArrayList<TL1Operation>();
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TL1Operation queryOper = definitions.getTL1Operation("RTRV-IPA");
            if (queryOper == null) {
                return rmonBoardList;
            }
            opers.add(queryOper);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neid, opers, this.TIME_OUT);
            if (result.retCode == 0) {
                int len = queryOper.getOutMsgCount();
                for (int i = 0; i < len; ++i) {
                    MsgBlock msgBlock = queryOper.getOutMsg(i).getMsgBlock();
                    int slotID = 0;
                    if (msgBlock.getPart("RAMANBID").getValue() != null) {
                        slotID = TETL1CommonUtil.getNMSlotStr((String)msgBlock.getPart("RAMANBID").getValue(), (int)this.neid);
                        rmonBoardList.add(slotID);
                    }
                    if (msgBlock.getPart("RAMANOPRT").getValue() != null) {
                        slotID = TETL1CommonUtil.getNMSlotStr((String)msgBlock.getPart("RAMANOPRT").getValue(), (int)this.neid);
                        rmonBoardList.add(slotID);
                    }
                    if (msgBlock.getPart("ROPOPRT").getValue() == null) continue;
                    slotID = TETL1CommonUtil.getNMSlotStr((String)msgBlock.getPart("ROPOPRT").getValue(), (int)this.neid);
                    rmonBoardList.add(slotID);
                }
            } else {
                TELogFactory.getNormalLogger().error("query ipa pair failed, error code is " + result.retCode);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return rmonBoardList;
        }
        return rmonBoardList;
    }

    static {
        romanBds.add(60003);
        romanBds.add(60028);
        romanBds.add(2318);
        romanBds.add(2335);
    }
}

