/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.wdminterface;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgCmdFactory;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunAttr;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgQueryBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEWaveLengthInfoStaticData;
import com.huawei.nglct.nemgr.tl1ngwdm.config.wdminterface.TL1RowDataProcessorFactory;
import com.huawei.nglct.ngwdm_pub.TETL1SimpleAID;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class TETL1QueryWDMInterBean
extends TETL1GenCfgQueryBean {
    private static final int TIME_OUT = 180;
    public static final String NEWNEVERSION_COMMON = "5.51.06.10";
    private static final int ODU0 = 5;
    private String fac = null;
    private static Set<String> noSupportAttri = new HashSet<String>();
    private static ArrayList<Integer> simpleTBoard;
    private static ArrayList<String> usePLDTypeList;

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        this.outputData = this.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList, this.aidAndTypeList);
        if (null == this.outputData) {
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        }
        this.specialHandleOutputData(neid);
        this.sortByPort(this.outputData);
    }

    private void specialHandleOutputData(int neid) {
        RowParams rowParams = null;
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            Param wavenumParam;
            String curMod2;
            rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowParams.getParamCount() == 0 && rowParams.getRowErrorsCount() == 0) {
                this.outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            Param portParam = rowParams.getParam("port");
            if (portParam != null && "0".equals(portParam.getValue())) {
                this.outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            Param[] param = rowParams.getParam();
            for (int j = 0; j < param.length; ++j) {
                if (!param[j].getName().equalsIgnoreCase("mode2") || !param[j].getValue().equals("/")) continue;
                rowParams.removeParam(param[j]);
            }
            if (null != rowParams.getParam("AID")) {
                String aidvar = rowParams.getParam("AID").getValue();
                TETL1SimpleAID sAid = new TETL1SimpleAID(aidvar, neid);
                curMod2 = rowParams.getParam("CurrentMOD2").getValue();
                int nmport = TETL1CommonUtil.getNMPortNOFromAidStruct((String)aidvar, (int)neid);
                int nmpath = TETL1CommonUtil.getPathIDFromAidStruct((String)aidvar, (int)neid);
                Param slotidpar = new Param("slotid", String.valueOf(sAid.getNmSlotID()));
                rowParams.addParam(slotidpar);
                Param portpar = new Param("port", String.valueOf(nmport));
                rowParams.addParam(portpar);
                Param pathpar = new Param("path", String.valueOf(nmpath));
                rowParams.addParam(pathpar);
                int portNMID = TETL1CommonUtil.getNMPortNOFromNEPort((String)sAid.getAidPre(), (int)this.nmCurrSlotID, (int)sAid.getPortID(), (int)neid);
                String comparePortPath = portNMID + "&" + sAid.getNmPath(curMod2);
                Param portPathParam = new Param("comparePortPath", comparePortPath);
                rowParams.addParam(portPathParam);
                String actport = this.aidAndTypeList.getMod2(neid, aidvar);
                StringTokenizer st = new StringTokenizer(actport, "|");
                while (st.hasMoreTokens()) {
                    String strMod2 = st.nextToken();
                    if (!strMod2.equals("EC")) continue;
                    Param edport = new Param("isECPort", "EC");
                    rowParams.addParam(edport);
                    break;
                }
                if (rowParams.getParam("mode2") != null) {
                    String mode2Str = rowParams.getParam("mode2").getValue();
                    String portMode = (String)this.portModelMap.get(String.valueOf(nmport));
                    if (portMode == null) {
                        portMode = "-1";
                    }
                    rowParams.getParam("mode2").setValue(mode2Str + "," + "BOARDMODE" + "," + this.boardMode + "," + "PORTMODE" + "," + portMode);
                }
            }
            if (null != rowParams.getParam("DWDMTL1_ATTRPORT_PST") || null != rowParams.getParam("DWDMTL1_ATTRPORT_ADVANCED_PST") || null != rowParams.getParam("DWDMTL1_ATTRPORT_BOARD_PST")) {
                TL1RowDataProcessorFactory.getInstance().buildProcessor("DWDMTL1_ATTRPORT_PST").specialProcessRowData(this.outputData, neid, i);
            }
            if (null != rowParams.getParam("DWDMTL1_ATTRPORT_PORTMEMO")) {
                TL1RowDataProcessorFactory.getInstance().buildProcessor("DWDMTL1_ATTRPORT_PORTMEMO").specialProcessRowData(this.outputData, neid, i);
            }
            if (null != rowParams.getParam("DWDMTL1_ATTRPORT_WORKMODE")) {
                TL1RowDataProcessorFactory.getInstance().buildProcessor("DWDMTL1_ATTRPORT_WORKMODE").specialProcessRowData(this.outputData, neid, i);
            }
            if (null != rowParams.getParam("DWDMTL1_ATTRPORT_ASECALIBRATE")) {
                TL1RowDataProcessorFactory.getInstance().buildProcessor("DWDMTL1_ATTRPORT_ASECALIBRATE").specialProcessRowData(this.outputData, neid, i);
            }
            if (null != rowParams.getParam("DWDMTL1_ATTRPORT_MAXWAVENUM") && null != (wavenumParam = rowParams.getParam("DWDMTL1_ATTRPORT_MAXWAVENUM")) && wavenumParam.getValue() != null && wavenumParam.getValue().equalsIgnoreCase("0xFF")) {
                wavenumParam.setValue("/");
            }
            if (null != rowParams.getParam("AID") && null != rowParams.getParam("DWDMTL1_ATTRPORT_PLDTYPE") || null != rowParams.getParam("DWDMTL1_ATTRPORT_CLNTPLDTYPE") || null != rowParams.getParam("DWDMTL1_ATTRPORT_CLIENTPRO")) {
                TL1RowDataProcessorFactory factory = TL1RowDataProcessorFactory.getInstance();
                factory.setBoardMode(this.boardMode);
                factory.setBoardPortModelMap(this.portModelMap);
                factory.buildProcessor("SERVICE_TYPE").specialProcessRowData(this.outputData, neid, i);
            }
            if (null == rowParams.getParam("AID")) continue;
            this.fac = rowParams.getParam("AID").getValue();
            int slotid = TETL1CommonUtil.getNMSlotStr((String)this.fac, (int)neid);
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            if (null != rowParams.getParam("DWDMTL1_ATTRPORT_MONBANDTYPE")) {
                String[] tmpStr = TETL1CommonUtil.parseAID((String)this.fac, (int)neid);
                String aidPref = tmpStr[0];
                String portStr = tmpStr[3];
                StringBuffer buffer = new StringBuffer();
                String neName = TEConfigurationDataMgr.getInstance().getNEName(neid);
                buffer.append(neName).append("-");
                String showSlot = TETL1CommonUtil.getShelfSlotName((int)neid, (int)slotid);
                buffer.append(showSlot).append("-");
                String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardType);
                buffer.append(boardName).append("-");
                String portNameTemp = TETL1CommonUtil.getPortNameFromNEPort((String)aidPref, (int)slotid, (int)Integer.parseInt(portStr), (int)neid);
                buffer.append(portNameTemp);
                int pathID = TETL1CommonUtil.getPathIDFromAidStruct((String)this.fac, (int)neid);
                String wavefre = TEWaveLengthInfoStaticData.getInstance().getNumberWaveLengthFrequency(1, pathID);
                buffer.append("-");
                buffer.append(wavefre);
                rowParams.getParam("AID").setValue(buffer.toString());
                rowParams.addParam("FACAID", this.fac);
                continue;
            }
            curMod2 = rowParams.getParam("CurrentMOD2").getValue();
            if (curMod2.equalsIgnoreCase("OSNREN")) {
                curMod2 = "WDM";
            }
            String curAid = TETL1CommonUtil.getGencfgObjFromAID((int)neid, (String)this.fac, (String)curMod2);
            if (curMod2.equals("CLNT") || curMod2.equals("CLIENT")) {
                curAid = TETL1CommonUtil.getGencfgObjFromAID((int)neid, (String)this.fac, (String)"");
                rowParams.getParam("AID").setValue(curAid);
                continue;
            }
            rowParams.getParam("AID").setValue(curAid);
        }
    }

    private void sortByPort(Datainterface outputData) {
        ArrayList rowList = outputData.getBussinessParams().getRowParamList();
        PortComparator portComparator = new PortComparator();
        Collections.sort(rowList, portComparator);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.add("INVALID DATA PARAMETER, Unsupported command returned by card");
        codeList.add("PARAMETER NOT VALID, The MOD2 is wrong");
        codeList.add("INVALID ACCESS IDENTIFIER: OCP, NO REG ERROR");
        codeList.add("INVALID DATA PARAMETER, Path-id Parameter is invalid");
        codeList.add("PARAMETER NOT VALID, AID mismatches MOD2 type");
        codeList.add("INVALID DATA PARAMETER, The specified object does not exist");
        codeList.add("COMMAND NOT VALID,UNSUPPORTED COMMAND:RTRV-OD-OSNREN");
        codeList.add("INVALID DATA PARAMETER, Invalid Port ID");
        return codeList;
    }

    public int getTimeOut() {
        return 180;
    }

    public String convertAttrID(String attrID) {
        if (attrID == null) {
            return null;
        }
        if (attrID.equals("DWDMTL1_ATTRSM_PST") || attrID.equals("DWDMTL1_ATTRPM_PST") || attrID.equals("DWDMTL1_ATTRTCM_PST")) {
            return "DWDMTL1_ATTRPORT_ADVANCED_PST";
        }
        if (attrID.equals("DWDMTL1_ATTRSM_SST") || attrID.equals("DWDMTL1_ATTRPM_SST") || attrID.equals("DWDMTL1_ATTRTCM_SST")) {
            return "DWDMTL1_ATTRPORT_ADVANCED_SST";
        }
        if (this.neType == 66) {
            if (attrID.equals("DWDMTL1_ATTRPORT_FEC")) {
                return "DWDMTL1_ATTRPORT_WORKFEC";
            }
            if (this.neVersion.compareTo("5.67.03.10") < 0) {
                if (attrID.equals("DWDMTL1_ATTRPORT_BANDTYPE")) {
                    return "DWDMTL1_ATTRPORT_ACTBANDTYPE";
                }
                if (attrID.equals("DWDMTL1_ATTRPORT_WVNUM")) {
                    return "DWDMTL1_ATTRPORT_ACTWVNUM";
                }
                if (attrID.equals("DWDMTL1_ATTRPORT_ACTBANDTYPE") || attrID.equals("DWDMTL1_ATTRPORT_ACTWVNUM")) {
                    return "";
                }
            }
        }
        return attrID;
    }

    protected String getMod2(int neid, int slotid, int portid, int pathid, String attrID, int grade) {
        if (grade == 5) {
            TETL1GenCfgFunAttr attr = this.funCmd.getGenCfgFunAttr(attrID, "query");
            if (attr != null) {
                ArrayList list = attr.getModifierList();
                ArrayList mod2List = null;
                mod2List = pathid > 0 ? this.aidAndTypeList.getAllMod2(neid, slotid, portid, pathid) : this.aidAndTypeList.getAllMod2(neid, slotid, portid);
                if (mod2List.size() == 0) {
                    return "NA";
                }
                int len = mod2List.size();
                for (int i = 0; i < len; ++i) {
                    String mod2 = (String)mod2List.get(i);
                    if (mod2.indexOf("ODU") == -1) continue;
                    int size = list.size();
                    for (int j = 0; j < size; ++j) {
                        String tempMod2 = (String)list.get(j);
                        if (!mod2.equals(tempMod2)) continue;
                        String tl1Mod2 = TETL1GenCfgCmdFactory.getInstance().getTL1DescMod2(mod2);
                        return tl1Mod2 + "&&" + mod2;
                    }
                }
            }
            return "UNKNOWN";
        }
        return this.getMod2(neid, slotid, portid, pathid, attrID);
    }

    protected String getMod2(int neid, int slotid, int portid, int pathid, String attrID) {
        if (this.bdtype == 60008 || this.bdtype == 1560 || this.bdtype == 1561 || this.bdtype == 1562) {
            return "WDM";
        }
        if (this.bdtype == 1310 && this.boardMode.equals("AP8MODE") && portid == 2 && attrID.equals("DWDMTL1_ATTRPORT_LOOPBACK")) {
            return "UNKNOWN";
        }
        TETL1GenCfgFunAttr attr = this.funCmd.getGenCfgFunAttr(attrID, "query");
        if (attr != null) {
            ArrayList list = attr.getModifierList();
            ArrayList mod2List = null;
            mod2List = usePLDTypeList.contains(attrID) ? this.aidAndTypeList.getPLDTYPEMod2List(neid, slotid, portid, pathid) : (pathid > 0 ? this.aidAndTypeList.getAllMod2(neid, slotid, portid, pathid) : this.aidAndTypeList.getAllMod2(neid, slotid, portid));
            if (mod2List.size() == 0) {
                return "NA";
            }
            if (mod2List.size() > 1 && (this.bdtype == 60003 || this.bdtype == 60028 || this.bdtype == 1206 || this.bdtype == 1207 || this.bdtype == 60008 || this.bdtype == 1560 || this.bdtype == 1561 || this.bdtype == 1562) && mod2List.contains("WDM")) {
                return "WDM";
            }
            int len = mod2List.size();
            for (int i = 0; i < len; ++i) {
                String mod2 = (String)mod2List.get(i);
                if (!(!attrID.equals("DWDMTL1_ATTRPORT_ADVANCED_PST") && !attrID.equals("DWDMTL1_ATTRPORT_ADVANCED_SST") || len <= 1 || i != 0 || mod2.indexOf("ODU") == -1 && mod2.indexOf("UNEQ") == -1)) continue;
                int size = list.size();
                for (int j = 0; j < size; ++j) {
                    String tempMod2 = (String)list.get(j);
                    if (attrID.equals("DWDMTL1_ATTRPORT_LOOPBACK") && 66 != this.neType && tempMod2.equals("EC") || !mod2.equals(tempMod2)) continue;
                    String tl1Mod2 = TETL1GenCfgCmdFactory.getInstance().getTL1DescMod2(mod2);
                    if (this.isByFun && (this.supportAttrList.contains("DWDMTL1_ATTRPORT_LOOPBACK") || this.supportAttrList.contains("DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK")) && mod2.indexOf("OTU") != -1) break;
                    return tl1Mod2 + "&&" + mod2;
                }
                if (1 != len || !this.isNotInnerPort()) continue;
                return mod2;
            }
        }
        return "UNKNOWN";
    }

    private boolean isNotInnerPort() {
        if (66 == this.neType) {
            return false;
        }
        return !simpleTBoard.contains(this.bdtype);
    }

    protected boolean isFilterParam(RowParams rowparams, TETL1GenCfgFunAttr funAttr) {
        if (this.bdtype != 1573) {
            return false;
        }
        if (rowparams.getParam("port") == null || rowparams.getParam("port").getValue() == null) {
            return false;
        }
        int portid = Integer.parseInt(rowparams.getParam("port").getValue());
        String portMode1 = (String)this.portModelMap.get("201");
        if (portMode1 != null && funAttr.getAttrId().equals("DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK") && this.isNotSupportLoopBackMode(portMode1) && portid == 161) {
            return true;
        }
        if (portMode1 != null && funAttr.getAttrId().equals("DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK") && portMode1.equalsIgnoreCase("ANY-OTU1") && portid == 51) {
            return true;
        }
        String portMode3 = (String)this.portModelMap.get("203");
        if (portMode3 != null && funAttr.getAttrId().equals("DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK") && this.isNotSupportLoopBackMode(portMode3) && portid == 162) {
            return true;
        }
        if (portMode3 != null && funAttr.getAttrId().equals("DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK") && portMode3.equalsIgnoreCase("ANY-OTU1") && portid == 52) {
            return true;
        }
        String portMode5 = (String)this.portModelMap.get("205");
        if (portMode5 != null && funAttr.getAttrId().equals("DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK") && this.isNotSupportLoopBackMode(portMode5) && portid == 163) {
            return true;
        }
        String portMode7 = (String)this.portModelMap.get("207");
        return portMode7 != null && funAttr.getAttrId().equals("DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK") && this.isNotSupportLoopBackMode(portMode7) && portid == 164;
    }

    private boolean isNotSupportLoopBackMode(String portMode) {
        return !portMode.equals("ANY-ODU0/-ODU1") && !portMode.equals("OTU1-ANY-ODU0-ODU1");
    }

    protected void getBoardPortMode(int nmCurrSlotID2) {
        int count;
        int port;
        TL1Definitions tl1definitions = null;
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("RTRV-CLNT getOperation fail!", (Throwable)e);
            return;
        }
        ArrayList<TL1Operation> tl1OperList1 = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = tl1definitions.getTL1Operation("RTRV-CLNT");
        String aidPre = "CLNT";
        String path = "1";
        if (this.bdtype == 2280 || this.bdtype == 2296) {
            port = 8;
            count = 1;
        } else if (this.bdtype == 2279) {
            port = 16;
            count = 1;
        } else if (this.bdtype == 2482) {
            port = 18;
            count = 1;
            aidPre = "FAC";
            path = "0";
        } else if (this.bdtype == 2481) {
            port = 10;
            count = 1;
            aidPre = "FAC";
            path = "0";
        } else if (this.bdtype == 2297) {
            port = 2;
            count = 1;
        } else if (this.bdtype == 2315) {
            port = 4;
            count = 1;
        } else {
            port = this.boardMode.equals("CASCADING") ? 1 : 7;
            count = 2;
        }
        for (int i = 1; i <= port; i += count) {
            String tmpAid = path.equals("0") ? aidPre + "-" + TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)nmCurrSlotID2) + "-" + i : aidPre + "-" + TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)nmCurrSlotID2) + "-" + i + "-" + 1;
            TL1Operation tmpTl1Operation1 = (TL1Operation)tl1Operation.clone();
            InMsg inputMsg = tmpTl1Operation1.getInMsg();
            StagBlock stagBlock = inputMsg.getStagBlock();
            AID aid = stagBlock.getAID();
            Part part = aid.getPart(0);
            part.setValue(tmpAid);
            tl1OperList1.clear();
            tl1OperList1.add(tmpTl1Operation1);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neid, tl1OperList1, 60);
            if (result.retCode != 0) continue;
            TL1Operation tOper1 = (TL1Operation)tl1OperList1.get(0);
            String typeStr1 = "";
            int portID = 0;
            int size = tOper1.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                HashMap partMap1;
                String aidStr;
                OutMsg output = tOper1.getOutMsg(row);
                if (output.getFault().getCompletionCode() != 0 || !(aidStr = ((Part)(partMap1 = TETL1CommonUtil.getOutMsgPart((OutMsg)output)).get("AID")).getValue()).equals(tmpAid)) continue;
                Part phyPart = (Part)partMap1.get("WORKMODE");
                if (phyPart != null) {
                    typeStr1 = TETL1CommonUtil.isNull((String)phyPart.getValue());
                }
                portID = TETL1CommonUtil.getNMPortNOFromAidStruct((String)aidStr, (int)this.neid);
            }
            this.portModelMap.put(String.valueOf(portID), typeStr1);
        }
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    protected boolean notSupportSpecialCol(String newAttrID) {
        if (noSupportAttri.contains(newAttrID)) {
            return true;
        }
        if ((this.boardMode.equals("AP8MODE") || this.boardMode.equals("REG") || this.boardMode.equals("OREG")) && newAttrID.equals("DWDMTL1_ATTRPORT_LOOPBACK")) {
            return true;
        }
        return this.boardMode.equals("REG") || this.boardMode.equals("OREG") && newAttrID.equals("DWDMTL1_ATTRPORT_OTNNULL");
    }

    static {
        noSupportAttri.add("DWDMTL1_ATTRPORT_LPTENABLE");
        noSupportAttri.add("DWDMTL1_ATTRPORT_ADVANCED_LPTENABLE");
        noSupportAttri.add("DWDMTL1_ATTRPORT_SRVPLDTYPE");
        noSupportAttri.add("DWDMTL1_ATTRPORT_FCEXTERN");
        noSupportAttri.add("DWDMTL1_ATTRPORT_TH8B10B");
        noSupportAttri.add("DWDMTL1_ATTRPORT_FEC");
        noSupportAttri.add("DWDMTL1_ATTRPORT_WORKFEC");
        noSupportAttri.add("DWDMTL1_ATTRPORT_LINERATE");
        noSupportAttri.add("DWDMTL1_ATTRPORT_SPEEDCHG");
        noSupportAttri.add("DWDMTL1_ATTRPORT_MAXSPEED");
        noSupportAttri.add("DWDMTL1_ATTRPORT_CLNTRATE");
        noSupportAttri.add("DWDMTL1_ATTRPORT_GCCTRANS");
        noSupportAttri.add("DWDMTL1_ATTRPORT_RESTRANS");
        noSupportAttri.add("DWDMTL1ATTR_MAC_WORKMODE");
        noSupportAttri.add("DWDMTL1ATTR_MAC_AUTONEGO");
        noSupportAttri.add("DWDMTL1ATTR_MAC_MAXPKGLEN");
        noSupportAttri.add("DWDMTL1ATTR_MAC_CIR");
        noSupportAttri.add("DWDMTL1_ATTRPORT_OFC");
        noSupportAttri.add("DWDMTL1_ATTRPORT_AUTOADAPT");
        noSupportAttri.add("DWDMTL1_ATTRPORT_MAPMODE");
        noSupportAttri.add("DWDMTL1_ATTRPORT_ENCAP");
        noSupportAttri.add("DWDMTL1ATTR_MAC_MAXPKTLEN");
        noSupportAttri.add("DWDMTL1_ATTRPORT_ALS");
        noSupportAttri.add("DWDMTL1_ATTRPORT_GCCMODE");
        noSupportAttri.add("DWDMTL1_ATTRPORT_OAWORKVALUE");
        noSupportAttri.add("DWDMTL1_ATTRPORT_AFECLVL");
        noSupportAttri.add("DWDMTL1_ATTRPORT_OSNRENABLE");
        noSupportAttri.add("DWDMTL1_ATTRPORT_INSCODE");
        noSupportAttri.add("DWDMTL1_ATTRPORT_ODUTSMODE");
        simpleTBoard = new ArrayList();
        simpleTBoard.add(2479);
        simpleTBoard.add(2480);
        simpleTBoard.add(2481);
        simpleTBoard.add(2482);
        simpleTBoard.add(2292);
        usePLDTypeList = new ArrayList();
        usePLDTypeList.add("DWDMTL1_ATTRPORT_CLNTPLDTYPE");
        usePLDTypeList.add("DWDMTL1_ATTRPORT_CLNTRATE");
        usePLDTypeList.add("DWDMTL1_ATTRPORT_ADVANCED_PST");
        usePLDTypeList.add("DWDMTL1_ATTRPORT_ADVANCED_SST");
    }

    class PortComparator
    implements Comparator {
        PortComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                int port2;
                RowParams r1 = (RowParams)o1;
                RowParams r2 = (RowParams)o2;
                if (r1.getParamCount() == 0 || r2.getParamCount() == 0) {
                    return 0;
                }
                String r1Param = r1.getParam("mode2").getValue();
                String aid1 = TETL1CommonUtil.parseMode2Str((String)r1Param, (String)"AID");
                String[] aid1s = TETL1CommonUtil.parseAID((String)aid1, (int)TETL1QueryWDMInterBean.this.neid);
                String r2Param = r2.getParam("mode2").getValue();
                String aid2 = TETL1CommonUtil.parseMode2Str((String)r2Param, (String)"AID");
                String[] aid2s = TETL1CommonUtil.parseAID((String)aid2, (int)TETL1QueryWDMInterBean.this.neid);
                int port1 = TETL1CommonUtil.getNMPortNOFromAidStruct((String)aid1, (int)TETL1QueryWDMInterBean.this.neid);
                if (port1 > (port2 = TETL1CommonUtil.getNMPortNOFromAidStruct((String)aid2, (int)TETL1QueryWDMInterBean.this.neid))) {
                    return 1;
                }
                if (port1 < port2) {
                    return -1;
                }
                if (port1 == port2) {
                    String r1PathParam = r1.getParam("comparePortPath").getValue();
                    String r2PathParam = r2.getParam("comparePortPath").getValue();
                    int r1PathID = Integer.valueOf(r1PathParam.split("&")[1]);
                    int r2PathID = Integer.valueOf(r2PathParam.split("&")[1]);
                    return r1PathID - r2PathID;
                }
                return 0;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("port sort fail!", (Throwable)e);
                return 0;
            }
        }
    }
}

