/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.wdminterface;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.gencfg.frame.attrvaluernge.AttrValueRangeConditions;
import com.huawei.nglct.gencfg.frame.attrvaluernge.MatchData;
import com.huawei.nglct.gencfg.frame.attrvaluernge.TEGnlAttrRangeMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.tl1necommon.staticdata.TL1MapDesMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TEWDMEXCUtil;
import com.huawei.nglct.nemgr.tl1ngwdm.config.wdminterface.SlotObject;
import com.huawei.nglct.nemgr.tl1ngwdm.config.wdminterface.TEServiceTypeKey;
import com.huawei.nglct.nemgr.tl1ngwdm.config.wdminterface.TEWdmInterfaceRowDataProcessorIF;
import com.huawei.nglct.nemgr.tl1ngwdm.config.workmode.TEWorkModeMgr;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.TEAIDAndType;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.buffer.RefreshTimeBufferIF;
import com.huawei.nglct.util.buffer.TETimeBuffer;
import com.huawei.nglct.util.buffer.TEUnknowmKeyTypeException;
import com.huawei.nglct.util.buffer.UnkownRefresherException;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEServiceTypeRowDataProcessor
implements TEWdmInterfaceRowDataProcessorIF {
    private static List<Integer> SERVICE_TYPE_NGWDM = new ArrayList<Integer>();
    private static List<Integer> SERVICE_TYPE_1800A = new ArrayList<Integer>();
    private static final Integer STM1 = 769;
    private static final Integer STM4 = 770;
    private static final Integer STM16 = 771;
    private static final Integer STM64 = 772;
    private static final Integer STM256 = 773;
    private static final int NONE = 0;
    public static final String GFP_OTU = "GFP_OTU";
    public static final String SDH_OTU = "SDH_OTU";
    private static final int PORTMODEOFFSET = 1000000;
    private static final int TYPE_1800A = 66;
    private static final String EC_PORT_TYPE = "9";
    private static TETimeBuffer<SlotObject, String> slotModeBuffer = new TETimeBuffer();
    private static TETimeBuffer<SlotObject, Map<String, String>> portModeBuffer = new TETimeBuffer();

    @Override
    public void specialProcessRowData(Datainterface outputData, int neid, int rowPosition) {
        String AID2;
        RowParams rowParams = outputData.getBussinessParams().getRowParams(rowPosition);
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        String portType = "0";
        if (null != rowParams.getParam("isECPort") && null != neObj && 66 == neObj.getNEType()) {
            portType = EC_PORT_TYPE;
        }
        if (null != (AID2 = rowParams.getParam("AID").getValue()) && null != rowParams.getParam("DWDMTL1_ATTRPORT_PLDTYPE") || null != rowParams.getParam("DWDMTL1_ATTRPORT_CLNTPLDTYPE") || null != rowParams.getParam("DWDMTL1_ATTRPORT_CLIENTPRO")) {
            List<Integer> serviceType = null;
            int slotid = TETL1CommonUtil.getNMSlotStr((String)AID2, (int)neid);
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            String serTypeStr = "";
            if (boardType != 1573) {
                if (this.special1800AServiceType(outputData, rowPosition, rowParams, neObj)) {
                    return;
                }
                serviceType = this.getServiceTypeToWDMInter(neid, TETL1CommonUtil.getNMSlotStr((String)AID2, (int)neid), TETL1CommonUtil.getNMPortNOFromAidStruct((String)AID2, (int)neid), TETL1CommonUtil.getPathIDFromAidStruct((String)AID2, (int)neid), boardType, TEServiceTypeRowDataProcessor.getNeVersion(neid), portType);
                this.dealOldVersionSTM(neid, serviceType);
                String temp = serviceType.toString();
                rowParams.addParam("serviceType", temp.substring(1, temp.length() - 1).replaceAll(" ", ""));
                rowParams.addParam("serviceTypeIp", temp.substring(1, temp.length() - 1).replaceAll(" ", ""));
            } else {
                serTypeStr = this.get52TomSevType(AID2, neid);
                rowParams.addParam("serviceType", serTypeStr);
                rowParams.addParam("serviceTypeIp", serTypeStr);
            }
        }
    }

    private boolean special1800AServiceType(Datainterface outputData, int rowPosition, RowParams rowParams, TENE teNE) {
        if (null != teNE && 66 == teNE.getNEType() && null != rowParams.getParam("DWDMTL1_ATTRPORT_CLIENTPRO") && "/".equals(rowParams.getParam("DWDMTL1_ATTRPORT_CLIENTPRO").getValue())) {
            outputData.getBussinessParams().removeRowParams(rowPosition);
            return true;
        }
        return false;
    }

    protected static long getNeVersion(int neID) {
        TENE neObj = TENEListMgr.getInstance().getNE(neID);
        String neVersion = neObj.getHostVersion();
        long version = Long.parseLong(neVersion.replace(".", ""));
        return version;
    }

    private void dealOldVersionSTM(int neid, List<Integer> serviceType) {
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        if (!TETL1CommonUtil.isNewNeVersion((int)ne.getNEType(), (String)ne.getHostVersion()) && serviceType != null) {
            Iterator<Integer> it = serviceType.iterator();
            while (it.hasNext()) {
                Integer serType = it.next();
                if (!serType.equals(STM1) && !serType.equals(STM4) && !serType.equals(STM16) && !serType.equals(STM64) && !serType.equals(STM256)) continue;
                it.remove();
            }
        }
    }

    private String getBoardMode(int neid, int slotID) {
        String boardMode = "";
        try {
            boardMode = (String)slotModeBuffer.get((Object)new SlotObject(neid, slotID));
        }
        catch (TEUnknowmKeyTypeException e) {
            TELogFactory.getNormalLogger().error("get cp mode failed!", (Throwable)e);
        }
        catch (UnkownRefresherException e) {
            TELogFactory.getNormalLogger().error("get cp mode failed!", (Throwable)e);
        }
        return boardMode;
    }

    private String getportMode(int neid, int slotID, int portid, int boardmode) {
        if (TESysManagerConstants.isIntegrationLCT()) {
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotID);
            List portList = TEQueryPortForDataMgr.getPortListOnInter((int)neid, (int)slotID, (int)boardType);
            TENE teNE = TENEListMgr.getInstance().getNE(neid);
            for (TEPort port : portList) {
                if (port.getPortNo() != portid) continue;
                int portMode = (int)port.getPortMode();
                if (boardType == 1620 && portMode != 65535) {
                    portMode = (int)port.getPortMode() + 1000000;
                }
                if (boardType != 1620 && null != teNE && teNE.getNEType() == 66 && portMode != 65535) {
                    portMode += 1000000;
                }
                TELogFactory.getNormalLogger().info("get for port[" + portid + "] port mode=" + port.getPortMode());
                String portModeNA = TEWorkModeMgr.getInstance().getWorkModeValue("portmode", portMode);
                return portModeNA;
            }
            return "";
        }
        String portMode = "";
        Map portModeMap = null;
        try {
            portModeMap = (Map)portModeBuffer.get((Object)new SlotObject(neid, slotID, boardmode));
        }
        catch (TEUnknowmKeyTypeException e) {
            TELogFactory.getNormalLogger().error("get port mode failed!", (Throwable)e);
        }
        catch (UnkownRefresherException e) {
            TELogFactory.getNormalLogger().error("get port mode failed!", (Throwable)e);
        }
        if (portModeMap != null) {
            portMode = (String)portModeMap.get(String.valueOf(portid));
        }
        return portMode;
    }

    private String getPortType(int neid, int slotID, int portid) {
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotID);
        List portList = TEQueryPortForDataMgr.getPortListOnInter((int)neid, (int)slotID, (int)boardType);
        for (TEPort port : portList) {
            if (port.getPortNo() != portid) continue;
            return String.valueOf(port.getPortAddibleType());
        }
        return "0";
    }

    private List<Integer> getServiceTypeToWDMInter(int neid, int slotid, int portid, int pathid, int boardtype, long neVersion, String portType) {
        List serviceType = null;
        List allServiceType = null;
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        if (TEGnlAttrRangeMgr.getInstance().isContainAttrID("SERIVCE_TYPE")) {
            int boardmodeintvalue;
            MatchData data = new MatchData();
            data.setBoardType(boardtype);
            data.setNeVersion(neVersion);
            data.setPortid(portid);
            data.setPathid(pathid);
            String boardmode = "";
            String tempPortMode = "";
            if (boardtype == 2280 || boardtype == 2279 || boardtype == 2296 || boardtype == 2315 || boardtype == 2297 || boardtype == 2479 || boardtype == 2480 || boardtype == 2481 || boardtype == 2482) {
                boardmode = this.getportMode(neid, slotid, portid, -1);
            } else if (boardtype == 1620) {
                boardmode = this.getBoardMode(neid, slotid);
                if (boardmode.equalsIgnoreCase("ANY-ODU0/ODU1")) {
                    boardmodeintvalue = TEWorkModeMgr.getInstance().getWorkModeIntValue("boardmode", boardmode);
                    boardmode = this.getportMode(neid, slotid, this.getELOMPortID(portid), boardmodeintvalue);
                }
            } else if (TEGenCfgDataMgr.isSupportAttr((int)neid, (int)slotid, (String)"W32BD_ATTR_SUBBDTYPE") || TEWorkModeMgr.getInstance().isSupportBoardMode(boardtype)) {
                boardmode = this.getBoardMode(neid, slotid);
                if (TEWorkModeMgr.getInstance().isSupportBoardMode(boardtype)) {
                    boardmodeintvalue = TEWorkModeMgr.getInstance().getWorkModeIntValue("boardmode", boardmode);
                    int dependPort = TEWorkModeMgr.getInstance().getDependPortID(neid, boardtype, boardmodeintvalue, portid);
                    if (-1 != dependPort) {
                        tempPortMode = this.getportMode(neid, slotid, dependPort, boardmodeintvalue);
                    }
                }
            }
            if (boardmode != null && !boardmode.isEmpty()) {
                data.addMacthParam("boardmode", (Object)boardmode);
            }
            if (tempPortMode != null && !tempPortMode.isEmpty()) {
                data.addMacthParam("portmode", (Object)tempPortMode);
            }
            if (null != portType) {
                data.addMacthParam("portype", (Object)portType);
            }
            AttrValueRangeConditions servRage = TEGnlAttrRangeMgr.getInstance().getAttrValueRageCondition("SERIVCE_TYPE", data);
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            if (servRage != null) {
                boolean isRemove = servRage.isRemoveRange();
                serviceType = servRage.getAttrValueRageByList();
                if (isRemove && serviceType != null) {
                    allServiceType = TEConfigurationDataMgr.getInstance().getSupportServiceType(neid, boardtype, portid, ne.getNEVersion());
                    allServiceType.removeAll(serviceType);
                } else {
                    allServiceType = serviceType == null ? TEConfigurationDataMgr.getInstance().getSupportServiceType(neid, boardtype, portid, ne.getNEVersion()) : serviceType;
                }
            } else {
                allServiceType = TEConfigurationDataMgr.getInstance().getSupportServiceType(neid, boardtype, portid, ne.getNEVersion());
            }
        }
        if (allServiceType != null) {
            TEServiceTypeRowDataProcessor.removeNotSupport(neObj.getNEType(), allServiceType);
            Collections.sort(allServiceType);
        }
        return allServiceType;
    }

    protected static void removeNotSupport(int netype, List<Integer> allServiceType) {
        Iterator<Integer> it = allServiceType.iterator();
        while (it.hasNext()) {
            Integer type = it.next();
            if (netype == 66) {
                if (SERVICE_TYPE_1800A.contains(type)) continue;
                it.remove();
                continue;
            }
            if (SERVICE_TYPE_NGWDM.contains(type)) continue;
            it.remove();
        }
    }

    protected static List<Integer> getXCTypeList(int neid, int slotid, int portid, int pathid, int boardType) {
        if (1573 == boardType) {
            return TEWDMEXCUtil.getInstance().get52TomXCLevelList(neid, portid, slotid);
        }
        return TEConfigurationDataMgr.getInstance().getSupportTLlXCLevelList(neid, boardType, portid, slotid);
    }

    public List<Integer> getServiceType(TEServiceTypeKey key) {
        int neid = key.getNeid();
        int slotid = key.getSlotid();
        int portid = key.getPortid();
        int pathid = key.getPathid();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        long neVersion = Long.parseLong(neObj.getHostVersion().replace(".", ""));
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        if (boardType == 1573) {
            String aid = TETL1CommonUtil.combineAID((int)neid, (int)slotid, (int)portid, (int)pathid);
            ArrayList<Integer> serviceBy52Tom = this.get52TomSevTypeToArrayList(aid, neid);
            return serviceBy52Tom;
        }
        String portType = this.getPortType(neid, slotid, portid);
        List<Integer> allServiceType = this.getServiceTypeToWDMInter(neid, slotid, portid, pathid, boardType, neVersion, portType);
        if (allServiceType != null && !allServiceType.isEmpty()) {
            return allServiceType;
        }
        return TEServiceTypeRowDataProcessor.getXCTypeList(neid, slotid, portid, pathid, boardType);
    }

    private String get52TomSevType(String fac2, int neid) {
        String slotShelf = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)neid, (int)TETL1CommonUtil.getNMSlotStr((String)fac2, (int)neid));
        HashSet<Integer> slotIDList = new HashSet<Integer>();
        slotIDList.add(TETL1CommonUtil.getNMSlotStr((String)fac2, (int)neid));
        TEAIDAndTypeList aidAndTypeList = null;
        try {
            aidAndTypeList = TETL1CommonUtil.queryPortTypeFromBuffer((int)neid, slotIDList);
        }
        catch (TEUnknowmKeyTypeException e) {
            TELogFactory.getNormalLogger().error("getMod2 failed!", (Throwable)e);
        }
        catch (UnkownRefresherException e) {
            TELogFactory.getNormalLogger().error("getMod2 failed!", (Throwable)e);
        }
        if (aidAndTypeList == null) {
            return "";
        }
        ArrayList aidTypeList = (ArrayList)aidAndTypeList.getAidAndTypeMap().get(slotShelf);
        StringBuffer servType = new StringBuffer();
        if (aidTypeList == null) {
            return "";
        }
        int size = aidTypeList.size();
        for (int i = 0; i < size; ++i) {
            TEAIDAndType aidType = (TEAIDAndType)aidTypeList.get(i);
            if (!aidType.getAid().equals(fac2)) continue;
            ArrayList typeList = aidType.getTypeList();
            int len = typeList.size();
            for (int j = 0; j < len; ++j) {
                servType.append(typeList.get(j));
                if (j == len - 1) continue;
                servType.append(',');
            }
            break;
        }
        return servType.toString();
    }

    private ArrayList<Integer> get52TomSevTypeToArrayList(String fac2, int neid) {
        ArrayList<Integer> serviceType = new ArrayList<Integer>();
        String slotShelf = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)neid, (int)TETL1CommonUtil.getNMSlotStr((String)fac2, (int)neid));
        HashSet<Integer> slotIDList = new HashSet<Integer>();
        slotIDList.add(TETL1CommonUtil.getNMSlotStr((String)fac2, (int)neid));
        TEAIDAndTypeList aidAndTypeList = null;
        try {
            aidAndTypeList = TETL1CommonUtil.queryPortTypeFromBuffer((int)neid, slotIDList);
        }
        catch (TEUnknowmKeyTypeException e) {
            TELogFactory.getNormalLogger().error("getMod2 failed!", (Throwable)e);
        }
        catch (UnkownRefresherException e) {
            TELogFactory.getNormalLogger().error("getMod2 failed!", (Throwable)e);
        }
        if (aidAndTypeList == null) {
            return null;
        }
        ArrayList aidTypeList = (ArrayList)aidAndTypeList.getAidAndTypeMap().get(slotShelf);
        if (aidTypeList == null) {
            return null;
        }
        int size = aidTypeList.size();
        for (int i = 0; i < size; ++i) {
            TEAIDAndType aidType = (TEAIDAndType)aidTypeList.get(i);
            if (!aidType.getAid().equals(fac2)) continue;
            ArrayList typeList = aidType.getTypeList();
            int len = typeList.size();
            for (int j = 0; j < len; ++j) {
                serviceType.add(TL1MapDesMgr.getInstance().getIntValueByStr(String.valueOf(typeList.get(j)), String.valueOf(271534)));
            }
            break;
        }
        serviceType.add(0);
        return serviceType;
    }

    public static String queryBoardMode(int neid, int slotID) {
        TL1Definitions tl1definitions = null;
        String boardMode = "";
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("RTRV-PORT getOperation fail!", (Throwable)e);
            return boardMode;
        }
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = tl1definitions.getTL1Operation("RTRV-EQPT");
        String tmpAid = "SLOT-" + TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)neid, (int)slotID);
        TL1Operation tmpTl1Operation = (TL1Operation)tl1Operation.clone();
        InMsg inputMsg = tmpTl1Operation.getInMsg();
        StagBlock stagBlock = inputMsg.getStagBlock();
        AID aid = stagBlock.getAID();
        Part part = aid.getPart(0);
        part.setValue(tmpAid);
        tl1OperList.add(tmpTl1Operation);
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, tl1OperList, 60);
        if (result.retCode == 0) {
            TL1Operation tOper = (TL1Operation)tl1OperList.get(0);
            int size = tOper.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                HashMap partMap;
                String aidStr;
                OutMsg output = tOper.getOutMsg(row);
                if (output.getFault().getCompletionCode() != 0 || !(aidStr = ((Part)(partMap = TETL1CommonUtil.getOutMsgPart((OutMsg)output)).get("slotID")).getValue()).equals(tmpAid)) continue;
                Part phyPart = (Part)partMap.get("WORKMODE");
                if (phyPart != null) {
                    boardMode = TETL1CommonUtil.isNull((String)phyPart.getValue());
                    continue;
                }
                Part mapModePart = (Part)partMap.get("MAPMODE");
                if (mapModePart == null) continue;
                String mapModeStr = mapModePart.getValue();
                if (mapModeStr.indexOf("GFP") != -1) {
                    boardMode = GFP_OTU;
                    continue;
                }
                if (mapModeStr.indexOf("SDH") == -1) continue;
                boardMode = SDH_OTU;
            }
        }
        return boardMode;
    }

    private int getELOMPortID(int portid) {
        if (portid >= 3 && portid <= 10) {
            return portid - 2 + 200;
        }
        return portid;
    }

    public static Map<String, String> queryPortMode(int neid, int nmCurrSlotID2, int boardMode) {
        HashMap<String, String> portModeMap = new HashMap<String, String>();
        TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        String neVersion = neObj.getHostVersion();
        int neType = neObj.getNEType();
        int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, nmCurrSlotID2);
        ArrayList<Integer> portList = TEWorkModeMgr.getInstance().getPortIDList(bdtype, boardMode, neType, neVersion);
        if (portList.size() == 0) {
            return portModeMap;
        }
        TL1Definitions tl1definitions = null;
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("RTRV-CLNT getOperation fail!", (Throwable)e);
            return portModeMap;
        }
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = neType == 66 ? tl1definitions.getTL1Operation("RTRV-CLIENT") : tl1definitions.getTL1Operation("RTRV-CLNT");
        int len = portList.size();
        for (int i = 0; i < len; ++i) {
            int portid = portList.get(i);
            String pathid = TEWorkModeMgr.getInstance().getPathID(bdtype, -1, portid, neType, neVersion);
            String tmpAid = TETL1CommonUtil.getAIDFromPort((int)neid, (String)String.valueOf(nmCurrSlotID2), (String)String.valueOf(portid), (String)pathid);
            TL1Operation tmpTl1Operation = (TL1Operation)tl1Operation.clone();
            InMsg inputMsg = tmpTl1Operation.getInMsg();
            StagBlock stagBlock = inputMsg.getStagBlock();
            AID aid = stagBlock.getAID();
            Part part = aid.getPart(0);
            part.setValue(tmpAid);
            tl1OperList.clear();
            tl1OperList.add(tmpTl1Operation);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, tl1OperList, 60);
            if (result.retCode != 0) continue;
            TL1Operation tOper = (TL1Operation)tl1OperList.get(0);
            String typeStr = "";
            int portID = 0;
            int size = tOper.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                HashMap partMap;
                String aidStr;
                OutMsg output = tOper.getOutMsg(row);
                if (output.getFault().getCompletionCode() != 0 || !(aidStr = ((Part)(partMap = TETL1CommonUtil.getOutMsgPart((OutMsg)output)).get("AID")).getValue()).equals(tmpAid)) continue;
                Part phyPart = (Part)partMap.get("WORKMODE");
                if (phyPart != null) {
                    typeStr = TETL1CommonUtil.isNull((String)phyPart.getValue());
                }
                portID = TETL1CommonUtil.getNMPortNOFromAidStruct((String)aidStr, (int)neid);
            }
            portModeMap.put(String.valueOf(portID), typeStr);
        }
        return portModeMap;
    }

    static {
        slotModeBuffer.setRefreshTimeBuffer(new RefreshTimeBufferIF(){

            public Object refreshTimeBuffer(Object key) throws TEUnknowmKeyTypeException {
                if (key instanceof SlotObject) {
                    SlotObject obj = (SlotObject)key;
                    return TEServiceTypeRowDataProcessor.queryBoardMode(obj.neid, obj.slotid);
                }
                throw new TEUnknowmKeyTypeException(key.toString() + " is unkown key type!");
            }
        });
        portModeBuffer.setRefreshTimeBuffer(new RefreshTimeBufferIF(){

            public Object refreshTimeBuffer(Object key) throws TEUnknowmKeyTypeException {
                if (key instanceof SlotObject) {
                    SlotObject obj = (SlotObject)key;
                    return TEServiceTypeRowDataProcessor.queryPortMode(obj.neid, obj.slotid, obj.boardmode);
                }
                throw new TEUnknowmKeyTypeException(key.toString() + " is unkown key type!");
            }
        });
        SERVICE_TYPE_NGWDM.clear();
        int[] type_ngwdm = new int[]{-1, 0, 65535, 257, 260, 265, 258, 513, 514, 515, 516, 521, 529, 530, 531, 532, 1025, 1026, 1027, 1028, 1029, 1281, 1282, 1283, 1284, 1289, 1285, 1286, 262, 1537, 1538, 1539, 1541, 1793, 1794, 1795, 1796, 2049, 2050, 2305, 2561, 2817, 2818, 2819, 2820, 3073, 3074, 769, 770, 771, 772, 773, 3075, 3329, 3330, 3331, 3585, 1544};
        for (int i = 0; i < type_ngwdm.length; ++i) {
            SERVICE_TYPE_NGWDM.add(type_ngwdm[i]);
        }
        SERVICE_TYPE_1800A.clear();
        int[] type_1800A = new int[]{0, 65535, 257, 260, 261, 258, 263, 513, 514, 518, 515, 516, 529, 530, 531, 532, 1025, 1026, 1027, 1028, 1029, 1281, 1282, 1288, 1283, 1287, 1284, 1285, 1286, 1289, 262, 263, 1537, 1539, 1541, 1542, 1538, 1543, 1544, 1793, 1794, 1795, 2049, 2050, 2305, 2561, 2817, 3329, 3330, 3331, 3332, 3333, 3334, 3335, 2308, 2309, 2306, 2307, 3073, 3074, 769, 770, 771, 772, 773};
        for (int i = 0; i < type_1800A.length; ++i) {
            SERVICE_TYPE_1800A.add(type_1800A[i]);
        }
    }
}

