/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.tdc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.HashMap;
import java.util.Map;

public class TEScanStateReport {
    private static TEStateReportHandler handlereventrespond = new TEStateReportHandler();
    private final int neID;
    private final int slotid;
    private static Map reportMap = new HashMap();
    private static BussinessParams bussinessParams = new BussinessParams();
    private final Datainterface reportedData = new Datainterface();

    private TEScanStateReport(int neID, int slotid) {
        this.neID = neID;
        this.slotid = slotid;
        this.reportedData.setBussinessParams(bussinessParams);
    }

    public static void register(int neid) {
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            TL1Operation oper = definitions.getTL1Operation("REPT_EVT_TDCSCAN");
            TETL1NECommMgr.getInstance().registerListener(oper, (TL1NoticeHandler)handlereventrespond);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEScanStateReport registerListener error", (Throwable)e);
        }
    }

    public static void unregister(int neid) {
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            TL1Operation oper = definitions.getTL1Operation("REPT_EVT_TDCSCAN");
            TETL1NECommMgr.getInstance().unregisterListener(oper, (TL1NoticeHandler)handlereventrespond);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEBitTestCache registerListener error", (Throwable)e);
        }
    }

    public Datainterface getReportData() {
        return this.reportedData;
    }

    public static TEScanStateReport getTthTestReport(int neid, int slotid) {
        String key = neid + "" + slotid;
        TEScanStateReport ptr = null;
        if (null != reportMap.get(key)) {
            return (TEScanStateReport)reportMap.get(key);
        }
        ptr = new TEScanStateReport(neid, slotid);
        reportMap.put(key, ptr);
        return ptr;
    }

    static class TEStateReportHandler
    implements TL1NoticeHandler {
        Part part = null;
        Param param = null;

        TEStateReportHandler() {
        }

        public void handleNotice(String cmdKey, long neid, TL1Operation oper) {
            int neID = (int)neid;
            OutMsg outPut = oper.getOutMsg(0);
            RowParams row = new RowParams();
            bussinessParams.addRowParams(row);
            this.addParam(outPut, "AID", row);
            this.addportParam(outPut, "AID", row, "port", neID);
            this.addParam(outPut, "STATE", row);
        }

        void addParam(OutMsg outPut, String retrunParam, RowParams row) {
            this.part = outPut.getMsgBlock().getPart(retrunParam);
            if (null == row.getParam(retrunParam)) {
                this.param = new Param(retrunParam, this.part.getValue());
                row.addParam(this.param);
            } else {
                row.getParam(retrunParam).setValue(this.part.getValue());
            }
        }

        void addportParam(OutMsg outPut, String retrunParam, RowParams row, String renname, int neid) {
            this.part = outPut.getMsgBlock().getPart(retrunParam);
            String[] parseaid = TETL1CommonUtil.parseAID((String)this.part.getValue(), (int)neid);
            String tempport = parseaid[3];
            if (null == row.getParam(renname)) {
                this.param = new Param(renname, tempport);
                row.addParam(this.param);
            } else {
                row.getParam(renname).setValue(tempport);
            }
        }
    }
}

