/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.spectrum;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.functions.Function;
import com.huawei.nglct.common.functions.Functions;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.tl1ngwdm.config.spectrum.TETL1SpectrumBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.buffer.TETimeBuffer;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;

public class TETL1SpectrumServlet
extends HttpServlet {
    private static final String SFID_PARAM = "sfid";
    private static final String INPUTDATA_PARAM = "inputdata";
    private static final String NEID_PARAM = "neid";
    private Datainterface outputData = null;
    private static Logger log = TELogFactory.getNormalLogger();
    private static final int SPEWAVEPIC = 2;
    private static final int SPESkELETONPIC = 3;
    private static final String SESSION_SPEC = "spectrum";

    public void emitJPEG(HttpServletRequest request, HttpServletResponse response, BufferedImage image) {
        response.setContentType("image/jpeg");
        try {
            ServletOutputStream out = response.getOutputStream();
            ImageIO.write((RenderedImage)image, "jpg", (OutputStream)out);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("TETL1SpectrumServlet.emitJPEG() fail!", (Throwable)e);
        }
    }

    public void emitSVG(HttpServletRequest request, HttpServletResponse response, String svgString) {
        response.setContentType("image/svg+xml");
        try {
            BufferedReader in = new BufferedReader(new StringReader(svgString));
            PrintWriter out = response.getWriter();
            String s = null;
            int i = 0;
            while ((s = in.readLine()) != null) {
                out.println(s);
                if (++i != 5) continue;
                out.println("<script type=\"text/javascript\"><![CDATA[");
                out.println("svgDocument.rootElement.setAttribute('zoomAndPan','disable')");
                out.println("contextMenu.removeChild(contextMenu.firstChild)");
                out.println("]]>");
                out.println("</script>");
            }
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1SpectrumServlet.emitSVG() fail!", (Throwable)e);
        }
    }

    private String getOperObject(HttpServletRequest request) {
        String neid = request.getParameter(NEID_PARAM);
        return String.valueOf(neid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int funid = Integer.parseInt(request.getParameter("funid"));
        TETL1SpectrumBean spectrumbean = null;
        String operObject = this.getOperObject(request);
        HttpSession session = request.getSession(true);
        TETimeBuffer spectrumBuffer = (TETimeBuffer)session.getAttribute(SESSION_SPEC);
        if (spectrumBuffer == null) {
            spectrumBuffer = new TETimeBuffer();
            spectrumBuffer.setBufferLimit(2);
            spectrumbean = new TETL1SpectrumBean();
            spectrumBuffer.put((Object)operObject, (Object)spectrumbean);
            session.setAttribute(SESSION_SPEC, (Object)spectrumBuffer);
        } else {
            log.info("the spectrum buffer size : " + spectrumBuffer.size());
            spectrumbean = (TETL1SpectrumBean)((Object)spectrumBuffer.getDataNotRefresh((Object)operObject));
            if (spectrumbean == null) {
                spectrumbean = new TETL1SpectrumBean();
                spectrumBuffer.put((Object)operObject, (Object)spectrumbean);
            }
        }
        if (funid == 2) {
            BufferedImage image = spectrumbean.getWaveImage();
            this.emitJPEG(request, response, image);
            return;
        }
        if (funid == 3) {
            BufferedImage image = spectrumbean.getSkeletonImage();
            this.emitJPEG(request, response, image);
            return;
        }
        int neid = -1;
        int sfid = -1;
        sfid = Integer.parseInt(request.getParameter(SFID_PARAM));
        response.setContentType("text/xml;charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        PrintWriter print = response.getWriter();
        Writer out = null;
        String inputDataStr = request.getParameter(INPUTDATA_PARAM);
        Datainterface inputData = null;
        Datainterface allData = null;
        SubFunc subFunc = null;
        try {
            TELogFactory.getInterfaceLogger().info("The sfid is \u00a3\u00ba" + sfid + "\nThe Page request XML is :\n" + inputDataStr);
            inputData = TECreateObjectFactory.parseInputData((String)inputDataStr);
            neid = this.getNEID(inputData);
            if (neid == -1) {
                throw new Exception("Don't write neid!!");
            }
            Functions functions = TECreateObjectFactory.parseFuncDesFile((int)neid);
            ArrayList list = this.getSubFunc(functions, sfid);
            subFunc = (SubFunc)list.get(1);
            list.clear();
            list = null;
            spectrumbean.init();
            String ipAddress = request.getRemoteAddr();
            String nmUser = request.getParameter("nmUser");
            this.outputData = allData = spectrumbean.performBussinessProcess(neid, subFunc, inputData, null, nmUser, ipAddress);
            out = new StringWriter();
            this.outputData.marshal(out);
            print.println(out.toString());
            TELogFactory.getInterfaceLogger().info("The sfid is " + sfid + "\nReturn page's XML Data\u00a3\u00ba" + out.toString());
            out.close();
        }
        catch (Exception e) {
            log.error("program inner error\u00a3\u00ba\n", (Throwable)e);
            this.outputData = new Datainterface();
            out = new StringWriter();
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            try {
                this.outputData.marshal(out);
                print.println(out.toString());
                TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "\nReturn page's XML Data is \u00a3\u00ba" + out.toString());
            }
            catch (Exception ex) {
                log.error("Parse fail\u00a3\u00ba", (Throwable)ex);
                return;
            }
        }
        finally {
            if (null != out) {
                out.close();
            }
            if (null != print) {
                print.close();
            }
        }
    }

    private int getNEID(Datainterface inputData) {
        Param[] paramArr = inputData.getBussinessParams().getRowParams(0).getParam();
        int neid = -1;
        int size = paramArr.length;
        for (int i = 0; i < size; ++i) {
            if (!paramArr[i].getName().equalsIgnoreCase(NEID_PARAM)) continue;
            try {
                neid = Integer.parseInt(paramArr[i].getValue());
            }
            catch (NumberFormatException e) {
                log.error("Get neid fail:\n", (Throwable)e);
                return -1;
            }
            return neid;
        }
        return -1;
    }

    private ArrayList getSubFunc(Functions functions, int sfid) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Function function = null;
        SubFunc subFunc = null;
        int funcid = -1;
        for (int i = functions.getFunction().length - 1; i >= 0; --i) {
            function = functions.getFunction(i);
            for (int j = function.getSubFunc().length - 1; j >= 0; --j) {
                if (function.getSubFunc(j).getCode() != sfid) continue;
                subFunc = function.getSubFunc(j);
                funcid = function.getId();
                break;
            }
            if (null != subFunc) break;
        }
        list.add(funcid);
        list.add((Integer)subFunc);
        return list;
    }

    public void writeLog(int neid, SubFunc subfunc, String ipAddress) {
        try {
            int i;
            if (this.outputData.getErrorMessage().getErrorcode().equals(String.valueOf(1090646019))) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            loginfo.setUserID(0);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateName(subfunc.getDes());
            loginfo.setOperateObject("");
            loginfo.setOperateDesc("");
            TENE neObj = TENEListUtils.getNEObj((int)neid);
            if (null == neObj) {
                loginfo.setOperateObject(String.valueOf(neid));
            } else {
                loginfo.setOperateObject(neObj.toString());
            }
            int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
            if (errorCode == 0) {
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo);
            } else {
                loginfo.setResult(2);
                if (errorCode == 1090646019) {
                    return;
                }
                if (errorCode == 2 || errorCode == 1) {
                    if (null == this.outputData.getBussinessParams() || this.outputData.getBussinessParams().getRowParamsCount() == 0) {
                        loginfo.setErrCode(errorCode);
                    }
                    int len = this.outputData.getBussinessParams().getRowParamsCount();
                    for (i = 0; i < len; ++i) {
                        RowErrors[] rowErrors = this.outputData.getBussinessParams().getRowParams(i).getRowErrors();
                        int size = rowErrors.length;
                        for (int j = 0; j < size; ++j) {
                            loginfo.setErrCode(Integer.parseInt(rowErrors[i].getErrorMessage().getErrorcode()));
                            loginfo.setErrInfo(rowErrors[i].getErrorMessage().getErrorinfo());
                            loginfoList.add(loginfo);
                        }
                    }
                } else {
                    loginfo.setErrCode(errorCode);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                    loginfoList.add(loginfo);
                }
            }
            int size = loginfoList.size();
            for (i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            log.error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

