/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.spectrum;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nemgr.tl1ngwdm.config.spectrum.TETL1OPTWaveInfo;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TETL1NESpectrumRsp {
    private int TIME_OUT = 90;
    private int recode = 0;
    private int wavetype = 1;
    private Fault fault = new Fault();
    private ArrayList infolist = new ArrayList();

    public int getWaveSize() {
        return this.infolist.size();
    }

    public ArrayList queryWaveInfo(int neid, int slotid, int portid, ArrayList operationList) {
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            TL1Operation oper = definitions.getTL1Operation("RTRV-MCADATA");
            oper.clearCmdFaultInfo();
            InMsg input = oper.getInMsg();
            Part partArr = input.getPart("AID");
            StringBuffer sb = new StringBuffer();
            sb.append("FAC-");
            String shelfSlofID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)neid, (int)slotid);
            sb.append(shelfSlofID);
            sb.append("-").append(portid);
            partArr.setValue(sb.toString());
            operationList.add(oper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1NESpectrumRsp.queryWaveInfo() fail!", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, (List)operationList, this.TIME_OUT);
        if (result.retCode == 0) {
            int size = operationList.size();
            for (int i = 0; i < size; ++i) {
                TL1Operation operation = (TL1Operation)operationList.get(i);
                for (OutMsg output : operation.getOutMsg()) {
                    if (output.getFault().getCompletionCode() != 0) {
                        int f = output.getFault().getCompletionCode();
                        this.fault = output.getFault();
                        operation.addCmdFault(this.fault);
                        this.recode = f;
                        return this.infolist;
                    }
                    HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
                    TETL1OPTWaveInfo waveinfo = new TETL1OPTWaveInfo();
                    Part temp = (Part)hm.get("WVCENTER");
                    if (temp.getValue() != null) {
                        waveinfo.setOptWAVELENGTH(Float.parseFloat(temp.getValue()));
                    }
                    if ((temp = (Part)hm.get("WVOFFSET")).getValue() != null) {
                        waveinfo.setOptWAVEEXCURSION(Float.parseFloat(temp.getValue()));
                    }
                    if ((temp = (Part)hm.get("WVPOWER")).getValue() != null) {
                        waveinfo.setOptPOWER(Float.parseFloat(temp.getValue()));
                    } else {
                        waveinfo.setOptPOWER(-60.0f);
                    }
                    temp = (Part)hm.get("WVOSNR");
                    if (temp.getValue() != null) {
                        waveinfo.setOptOSNR(Float.parseFloat(temp.getValue()));
                    } else {
                        waveinfo.setOptOSNR(-60.0f);
                    }
                    temp = (Part)hm.get("BANDTYPE");
                    if (temp.getValue() != null) {
                        int waveType = 0;
                        if (temp.getValue().equalsIgnoreCase("CBAND")) {
                            waveType = 1;
                        } else if (temp.getValue().equalsIgnoreCase("LBAND")) {
                            waveType = 2;
                        }
                        waveinfo.setWaveType(waveType);
                        this.setWavetype(waveType);
                    }
                    if ((temp = (Part)hm.get("WVNUM")).getValue() != null) {
                        waveinfo.setOptWaveNo(Integer.parseInt(temp.getValue()));
                    }
                    this.infolist.add(waveinfo);
                }
            }
            return this.infolist;
        }
        this.recode = result.retCode;
        return this.infolist;
    }

    public Fault getFault() {
        return this.fault;
    }

    public void setFault(Fault fault) {
        this.fault = fault;
    }

    public void setRecode(int recode) {
        this.recode = recode;
    }

    public int getRecode() {
        return this.recode;
    }

    public void setInfolist(ArrayList infolist) {
        this.infolist = infolist;
    }

    public ArrayList getInfolist() {
        return this.infolist;
    }

    public void setWavetype(int wavetype) {
        this.wavetype = wavetype;
    }

    public int getWavetype() {
        return this.wavetype;
    }
}

