/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.rstp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TEAIDAndType;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class TEP2PAttrQueryBean
extends TETL1NEExplorerBean {
    private int bdtype = -1;
    private int nmCurrSlotID = -1;
    private static final int OSN8800A = 73;
    private static final int OSN8800AII = 75;

    public TEP2PAttrQueryBean() {
        this.bQueryAidAndType = true;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            if (this.bQueryAidAndType) {
                this.slotIDList = this.getSlotIDFromInputDdata(inputData);
                Object[] nmCurrSlotIDArr = this.slotIDList.toArray();
                this.nmCurrSlotID = (Integer)nmCurrSlotIDArr[0];
                if (this.slotIDList.size() > 0) {
                    this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
                    if (this.aidAndTypeList == null) {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                        return this.outputData;
                    }
                    if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0 && this.aidAndTypeList.getErrorCount() > 0) {
                        Object[] slotIDArr = this.slotIDList.toArray();
                        int slotID = (Integer)slotIDArr[0];
                        Fault fault = this.aidAndTypeList.getFaultInfo(slotID);
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2, (String)fault.getErrDesc()));
                        return this.outputData;
                    }
                }
            }
            this.bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.nmCurrSlotID);
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            this.tl1OperList = new ArrayList();
            Iterator it = this.aidAndTypeList.getAidAndTypeMap().entrySet().iterator();
            TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
            String shelfType = TEBoardUtil.getTl1SubrackType((int)neid, (int)ne.getNEType(), (int)this.nmCurrSlotID);
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ArrayList teAIDAndTypeList = (ArrayList)entry.getValue();
                int m = teAIDAndTypeList.size();
                for (int j = 0; j < m; ++j) {
                    TEAIDAndType teAIDAndType = (TEAIDAndType)teAIDAndTypeList.get(j);
                    String mod2 = teAIDAndType.getPldType();
                    if (mod2 == null || mod2.equals("UNEQ") || mod2.equals("NA") || mod2.isEmpty() || this.bdtype == 2272 && (mod2.indexOf("OTU") != -1 || mod2.indexOf("ODU") != -1)) continue;
                    String aid = teAIDAndType.getAid();
                    String port = TETL1CommonUtil.parseAID((String)aid, (int)neid)[3];
                    if (!(this.bdtype != 2110 && this.bdtype != 2109 || !port.equals("3") && !port.equals("4")) && aid.indexOf("FAC") != -1 || !(ne.getNEType() != 73 && ne.getNEType() != 75 || !shelfType.equalsIgnoreCase("SHELF8800T32") && !shelfType.equalsIgnoreCase("SHELF8800T64") || this.bdtype != 2110 && this.bdtype != 2109 || aid.indexOf("ACC") == -1) && (port.equals("3") || port.equals("4")) || aid.indexOf("FAC") == -1 && aid.indexOf("ACC") == -1) continue;
                    TL1Operation queryOper = definitions.getTL1Operation("RTRV-FETH");
                    InMsg input = queryOper.getInMsg();
                    input.getPart("AID").setValue(aid);
                    queryOper.setCmdCode("RTRV");
                    queryOper.setMod1(mod2);
                    queryOper.setName("RTRV-" + mod2);
                    this.tl1OperList.add(queryOper);
                }
            }
            if (null == this.tl1OperList || this.tl1OperList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid, this.tl1OperList);
            if (result == 0) {
                this.handleMessage(neid, this.tl1OperList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, this.tl1OperList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc) {
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        RowParams rowparams = null;
        RowErrors errorRowparams = null;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        ArrayList<TEP2PAttribute> p2pAttrList = new ArrayList<TEP2PAttribute>();
        int n = tl1OperList.size();
        for (int i = 0; i < n; ++i) {
            TL1Operation tl1Operation = (TL1Operation)tl1OperList.get(i);
            for (OutMsg out : tl1Operation.getOutMsg()) {
                HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
                if (out.getFault().getCompletionCode() != 0) {
                    String errorCode = out.getFault().getErrCode();
                    String errorinfo = out.getFault().getErrDesc();
                    ErrorMessage errorMessage = new ErrorMessage();
                    Param errorparam = null;
                    errorRowparams = new RowErrors();
                    errorMessage.setErrorcode(errorCode);
                    errorMessage.setErrorinfo(errorinfo);
                    errorRowparams.setErrorMessage(errorMessage);
                    TENE ne = TENEListUtils.getNEObj((int)neid);
                    errorparam = new Param("nename", ne.getNEName());
                    errorRowparams.addParam(errorparam);
                    errorDataList.add(errorRowparams);
                    tl1Operation.addCmdFault(out.getFault());
                    continue;
                }
                Part aidPart = (Part)hm.get("AID");
                String[] aid = TETL1CommonUtil.parseAID((String)aidPart.getValue(), (int)neid);
                String portName = "";
                if (aid[0].equals("FAC")) {
                    portName = "PORT" + aid[3];
                } else if (aid[0].equals("ACC")) {
                    portName = "VCTRUNK" + aid[3];
                }
                TEP2PAttribute teP2PAttribute = new TEP2PAttribute();
                teP2PAttribute.setPortName(portName);
                teP2PAttribute.setPortID(Integer.parseInt(aid[3]));
                teP2PAttribute.setIndex(aid[0]);
                teP2PAttribute.setAid(aidPart.getValue());
                teP2PAttribute.setMod2(tl1Operation.getMod1());
                Part p2pAtt = (Part)hm.get("PTPMODE");
                teP2PAttribute.setPtpMode(p2pAtt.getValue() == null ? "" : p2pAtt.getValue());
                p2pAttrList.add(teP2PAttribute);
            }
        }
        TEP2PAttrComparator comparator = new TEP2PAttrComparator();
        Collections.sort(p2pAttrList, comparator);
        int n2 = p2pAttrList.size();
        for (int i = 0; i < n2; ++i) {
            TEP2PAttribute teP2PAttribute = (TEP2PAttribute)p2pAttrList.get(i);
            rowparams = new RowParams();
            rowparams.addParam(new Param("mod2", teP2PAttribute.getMod2()));
            rowparams.addParam(new Param("neid", String.valueOf(neid)));
            rowparams.addParam(new Param("AID", teP2PAttribute.getAid()));
            int slotID = TETL1CommonUtil.getNMSlotStr((String)teP2PAttribute.getAid(), (int)neid);
            rowparams.addParam(new Param("portName", String.valueOf(teP2PAttribute.getPortName())));
            int portID = TETL1CommonUtil.getNMPortNOFromNEPort((String)teP2PAttribute.getIndex(), (int)slotID, (int)teP2PAttribute.getPortID(), (int)neid);
            rowparams.addParam(new Param("portid", String.valueOf(portID)));
            rowparams.addParam(new Param("slotid", String.valueOf(slotID)));
            rowparams.addParam(new Param("p2pAttri", teP2PAttribute.getPtpMode() == null ? "" : teP2PAttribute.getPtpMode()));
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
        this.outputData.setErrorMessage(new ErrorMessage());
        if (errorDataList.size() != 0) {
            rowparams = new RowParams();
            int y = errorDataList.size();
            for (int x = 0; x < y; ++x) {
                rowparams.addRowErrors((RowErrors)errorDataList.get(x));
            }
            this.outputData.getBussinessParams().addRowParams(rowparams);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        }
    }

    public class TEP2PAttrComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            TEP2PAttribute fb1 = (TEP2PAttribute)o1;
            TEP2PAttribute fb2 = (TEP2PAttribute)o2;
            if (fb1.getIndex().equals(fb2.getIndex())) {
                if (fb1.getPortID() > fb2.getPortID()) {
                    return 1;
                }
                return -1;
            }
            if (fb1.getIndex().compareTo(fb1.getIndex()) > 0) {
                return 1;
            }
            if (fb1.getIndex().compareTo(fb1.getIndex()) < 0) {
                return -1;
            }
            return 0;
        }
    }

    class TEP2PAttribute {
        private String portName = "";
        private int portID = -1;
        private String ptpMode = "";
        private String index = "";
        private String aid = "";
        private String mod2 = "";

        TEP2PAttribute() {
        }

        public String getPortName() {
            return this.portName;
        }

        public void setPortName(String portName) {
            this.portName = portName;
        }

        public int getPortID() {
            return this.portID;
        }

        public void setPortID(int portID) {
            this.portID = portID;
        }

        public String getPtpMode() {
            return this.ptpMode;
        }

        public void setPtpMode(String ptpMode) {
            this.ptpMode = ptpMode;
        }

        public String getIndex() {
            return this.index;
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public String getAid() {
            return this.aid;
        }

        public void setAid(String aid) {
            this.aid = aid;
        }

        public String getMod2() {
            return this.mod2;
        }

        public void setMod2(String mod2) {
            this.mod2 = mod2;
        }
    }
}

