/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.prbs;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.ngwdm_pub.TETL1SimpleAID;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.eventinterpret.prbs.TEPRBSCache;
import com.huawei.nglct.tl1.eventinterpret.prbs.TEPRBSData;
import com.huawei.nglct.tl1.eventinterpret.prbs.TEPRBSSupportPortMgr;
import com.huawei.nglct.tl1.eventinterpret.prbs.TEPRBSUtility;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class TEPRBSTableInitBean
extends TETL1NEExplorerBean {
    private int slotID = 0;
    private static final int REG = 169;
    private static final int OREG = 170;

    public TEPRBSTableInitBean() {
        this.bQueryAidAndType = true;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        ArrayList boardModeList;
        TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid).getNETimeZone();
        this.neid = neid;
        TENE ne = TENEListUtils.getNEObj((int)neid);
        this.outputData = new Datainterface();
        RowParams rowpara = inputData.getBussinessParams().getRowParams(0);
        BussinessParams bussiness = new BussinessParams();
        this.outputData.setBussinessParams(bussiness);
        Param para = rowpara.getParam("slotid");
        this.slotID = Integer.parseInt(para.getValue());
        TEConfigurationDataMgr configmgr = TEConfigurationDataMgr.getInstance();
        int boardType = configmgr.getBoardType(neid, this.slotID);
        String boardMode = "";
        boolean isNeedQueryBoardMode = false;
        TEGenCfgAttribute attribute = TEGenCfgDataMgr.getGenCfgMode((int)boardType).getAttrFromId("W32BD_ATTR_SUBBDTYPE");
        if (null != attribute && null != (boardModeList = attribute.getDomainList()) && (boardModeList.contains(169) || boardModeList.contains(170))) {
            isNeedQueryBoardMode = true;
        }
        if (isNeedQueryBoardMode) {
            boardMode = this.getBoardMode(this.slotID);
        }
        if (boardMode.equalsIgnoreCase("REG") || boardMode.equalsIgnoreCase("OREG")) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        if (this.bQueryAidAndType) {
            this.slotIDList = this.getSlotIDFromInputDdata(inputData);
            if (this.slotIDList.size() > 0) {
                this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
                if (this.aidAndTypeList == null) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                    return this.outputData;
                }
                if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                    this.addRTRVPORTError(neid, ne);
                    return this.outputData;
                }
            }
        }
        TEPRBSSupportPortMgr prbsPortMgr = TEPRBSSupportPortMgr.getInstance((int)neid);
        String[] portList = prbsPortMgr.getBoardSupportPorts(neid, String.valueOf(boardType));
        TL1Operation oper = null;
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        this.cloneTL1OperationList.clear();
        try {
            for (int i = 0; i < portList.length; ++i) {
                TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
                oper = definitions.getTL1Operation("RTRV-RSLT");
                if (oper == null) continue;
                String[] support = portList[i].split("-");
                int portID = TETL1CommonUtil.getNMPortNOFromNEPort((String)support[0], (int)this.slotID, (int)Integer.parseInt(support[1]), (int)neid);
                String portChannel = String.valueOf(portID);
                if (support.length > 2) {
                    portChannel = portChannel + "-" + support[2];
                }
                ArrayList mode2List = TEPRBSUtility.getQueryPRBSMod2((int)neid, (int)this.slotID, (TEAIDAndTypeList)this.aidAndTypeList, (TL1Operation)oper, (String[])portChannel.split("-"), (String)"");
                int len = mode2List.size();
                for (int j = 0; j < len; ++j) {
                    TL1Operation operClone = (TL1Operation)oper.clone();
                    String curMod2 = (String)mode2List.get(j);
                    if (boardType == 1186 && curMod2.equals("OTU1") && portID == 201 || boardType == 2447 && curMod2.equals("OTU1") && (portID == 9 || portID == 10)) continue;
                    operClone.setMod2(curMod2);
                    operClone.setName(operClone.getName() + "-" + curMod2);
                    oper.clearCmdFaultInfo();
                    operationList.add(operClone);
                    this.cloneTL1OperationList.add(operClone);
                }
            }
            if (operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid, operationList);
            if (result == 0) {
                this.getPRBSData(operationList);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, subFunc, user, ipAddress, (ArrayList)operationList.clone());
            }
        }
        catch (MarshalException e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
        }
        catch (ValidationException e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
        }
        return this.outputData;
    }

    private void getPRBSData(ArrayList operationList) {
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        RowParams rowparams = null;
        RowErrors errorRowparams = null;
        int iLength = operationList.size();
        for (int i = 0; i < iLength; ++i) {
            TL1Operation oper = (TL1Operation)operationList.get(i);
            String mod2 = oper.getMod2();
            OutMsg[] outMsgs = oper.getOutMsg();
            Part aidPart = oper.getInMsg().getPart("AID");
            String errPortName = TEPRBSUtility.getPortNameFormAid((int)this.neid, (String)aidPart.getValue(), (String)mod2);
            int m = outMsgs.length;
            for (int j = 0; j < m; ++j) {
                String testtime;
                Calendar cal;
                rowparams = new RowParams();
                if (outMsgs[j] != null && outMsgs[j].getFault().getCompletionCode() != 0) {
                    oper.addCmdFault(outMsgs[j].getFault());
                    String errorCode = outMsgs[j].getFault().getErrCode();
                    String errorinfo = outMsgs[j].getFault().getErrDesc();
                    if (!this.getFilterErrorCodeList().contains(errorinfo)) {
                        ErrorMessage errorMessage = new ErrorMessage();
                        Param errorparam = null;
                        errorRowparams = new RowErrors();
                        errorMessage.setErrorcode(errorCode);
                        errorMessage.setErrorinfo(errorinfo);
                        errorRowparams.setErrorMessage(errorMessage);
                        TENE ne = TENEListUtils.getNEObj((int)this.neid);
                        errorparam = new Param("nename", ne.getNEName());
                        errorRowparams.addParam(new Param("portname", errPortName));
                        errorRowparams.addParam(errorparam);
                        errorDataList.add(errorRowparams);
                        rowparams.addRowErrors(errorRowparams);
                    }
                }
                HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsgs[j]);
                rowparams.addParam(new Param("neid", String.valueOf(this.neid)));
                Part part = (Part)hm.get("ST");
                String startTime = part.getValue() == null ? "/" : part.getValue();
                TENE ne = TENEListUtils.getNEObj((int)this.neid);
                if (!ne.getServerOrClient() && !startTime.equals("/")) {
                    cal = TEDateUtils.strToCalendar((String)startTime, (String)"yyyy-MM-dd HH-mm-ss");
                    startTime = String.valueOf(TEDateUtils.getTL1NMTimeFromNETime((int)this.neid, (long)cal.getTimeInMillis()).getTimeInMillis());
                } else if (!startTime.equals("/")) {
                    cal = TEDateUtils.strToCalendar((String)startTime, (String)"yyyy-MM-dd HH-mm-ss");
                    startTime = String.valueOf(cal.getTimeInMillis());
                }
                rowparams.addParam(new Param("startTime", startTime));
                part = oper.getInMsg().getPart("AID");
                rowparams.addParam(new Param("AID", part.getValue()));
                String portName = "";
                if (part.getValue() != null) {
                    TETL1SimpleAID sAid = new TETL1SimpleAID(part.getValue(), this.neid);
                    portName = TEPRBSUtility.getPortNameFormAid((int)this.neid, (String)part.getValue(), (String)mod2);
                    rowparams.addParam(new Param("portname", portName));
                    rowparams.addParam(new Param("portid", String.valueOf(sAid.getPortID())));
                    String pstsst = this.getState(part.getValue(), mod2);
                    rowparams.addParam(new Param("PST", pstsst));
                }
                part = (Part)hm.get("IPFLAG");
                rowparams.addParam("progress", "0%");
                if (part.getValue() == null) {
                    rowparams.addParam("teststate", "1");
                    rowparams.addParam("curstate", "STOP");
                } else if (part.getValue().trim().equals("IP")) {
                    rowparams.addParam("teststate", "10");
                    rowparams.addParam("curstate", "RUNNING");
                } else if (part.getValue().trim().equals("COMPLD")) {
                    rowparams.addParam("teststate", "1");
                    rowparams.addParam("curstate", "STOP");
                    Part partET = (Part)hm.get("ET");
                    if (partET.getValue() == null || partET.getValue().equals("0")) {
                        TEPRBSCache.getInstance().removePortCache(portName);
                    }
                }
                part = (Part)hm.get("ET");
                String testTimeTemp = testtime = part.getValue() == null ? "/" : part.getValue();
                TEPRBSData testdata = TEPRBSCache.getInstance().getCahce(portName);
                if (!testtime.equals("/")) {
                    float value = Float.parseFloat(testtime);
                    if (testdata != null) {
                        testdata.setElapsedperiod(String.valueOf(value));
                    }
                    if ((testtime = String.valueOf(100.0f * value / 60.0f)).indexOf(".") != -1) {
                        testtime = testtime.substring(0, testtime.indexOf("."));
                    }
                    if (testtime.equals("")) {
                        testtime = "0";
                    }
                    testtime = String.valueOf(Float.parseFloat(testtime) / 100.0f);
                }
                rowparams.addParam("testtime", testtime);
                if (testdata != null) {
                    rowparams.addParam("reportInterval", String.valueOf(testdata.getTesttime()));
                    String tempTestMode = "SPLTE";
                    if (testdata.getTestMode() != null) {
                        tempTestMode = testdata.getTestMode();
                    }
                    rowparams.addParam("testMode", tempTestMode);
                    rowparams.addParam("testDur", String.valueOf(testdata.getSumTime()));
                    int process = this.caluTestProcess(testTimeTemp, testdata.getSumTime());
                    rowparams.getParam("progress").setValue(process + "%");
                } else {
                    rowparams.addParam("reportInterval", "1");
                    rowparams.addParam("testDur", "0");
                    TEBoard board = ne.getBoard(this.slotID);
                    if ((board.getBoardType() == 1196 || board.getBoardType() == 60035) && mod2.indexOf("OC192") != -1) {
                        rowparams.addParam("testMode", "SPLTF");
                        rowparams.addParam("testMode", "SPLTE");
                    } else if ((board.getBoardType() == 1196 || board.getBoardType() == 60035) && mod2.indexOf("ODU2") != -1) {
                        rowparams.addParam("testMode", "SPLTF");
                    } else if (ne.getNEType() == 66 && board.getBoardType() != 1318 && board.getBoardType() != 2093 && board.getBoardType() != 2450 && board.getBoardType() != 2448 && board.getBoardType() != 2437 && board.getBoardType() != 2415 && board.getBoardType() != 1620 && board.getBoardType() != 2445 && board.getBoardType() != 2447) {
                        rowparams.addParam("testMode", "NONE");
                    } else if (ne.getNEType() == 66 && mod2.indexOf("GETH") != -1) {
                        rowparams.addParam("testMode", "SPLTF");
                        rowparams.addParam("testMode", "SPLTE");
                    } else {
                        rowparams.addParam("testMode", "SPLTE");
                    }
                }
                rowparams.addParam("mod2", mod2);
                this.outputData.getBussinessParams().addRowParams(rowparams);
            }
            this.outputData.setErrorMessage(new ErrorMessage());
            if (errorDataList.size() != 0) {
                rowparams = new RowParams();
                int y = errorDataList.size();
                for (int x = 0; x < y; ++x) {
                    rowparams.addRowErrors((RowErrors)errorDataList.get(x));
                }
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)1));
                continue;
            }
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        }
    }

    private String getState(String aid, String mod2) {
        TL1Definitions definitions = null;
        TL1Operation operstate = null;
        ArrayList<TL1Operation> clntOperList = new ArrayList<TL1Operation>();
        try {
            definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
        }
        catch (MarshalException e) {
            TELogFactory.getNormalLogger().error("TEPRBSTableInitBean.getState() fail!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("TEPRBSTableInitBean.getState() fail!", (Throwable)e);
        }
        catch (ValidationException e) {
            TELogFactory.getNormalLogger().error("TEPRBSTableInitBean.getState() fail!", (Throwable)e);
        }
        if (definitions == null || definitions.getTL1OperationCount() == 0) {
            return "-";
        }
        String tempMod2 = TETL1CommonUtil.getTL1CmdMod2((String)("RTRV-" + mod2));
        operstate = definitions.getTL1Operation(tempMod2);
        TETL1CommonUtil.modifyMOD2((TL1Operation)operstate, (String)mod2);
        if (operstate == null) {
            return "-";
        }
        operstate.getInMsg().getStagBlock().getAID().getPart(0).setValue(aid);
        clntOperList.add(operstate);
        int result = this.sendMessage(this.neid, clntOperList);
        if (result == 0) {
            if (clntOperList != null && clntOperList.size() > 0) {
                operstate = (TL1Operation)clntOperList.get(0);
                if (!operstate.getOutMsg(0).getFault().getErrDesc().equals("")) {
                    return "-";
                }
                String pst = operstate.getOutMsg(0).getMsgBlock().getPart("PST").getValue();
                String sst = operstate.getOutMsg(0).getMsgBlock().getPart("SST").getValue();
                if (sst == null || sst.isEmpty() || sst.equals("/")) {
                    return pst;
                }
                return pst + "," + sst;
            }
            return "-";
        }
        return "-";
    }

    private int caluTestProcess(String testtime, int sumTime) {
        int value = 0;
        if (sumTime == 0) {
            return value;
        }
        try {
            value = 100 * Integer.parseInt(testtime) / sumTime;
        }
        catch (NumberFormatException e) {
            value = 0;
        }
        return value;
    }

    private String getBoardMode(int slotID) {
        TL1Definitions tl1definitions = null;
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("RTRV-PORT getOperation fail!", (Throwable)e);
            return "";
        }
        ArrayList<TL1Operation> tl1OperPrbsList = new ArrayList<TL1Operation>();
        TL1Operation tl1OperationPrbs = tl1definitions.getTL1Operation("RTRV-EQPT");
        String tmpAid = "SLOT-" + TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotID);
        TL1Operation tmpTl1Operation = (TL1Operation)tl1OperationPrbs.clone();
        InMsg inputMsg = tmpTl1Operation.getInMsg();
        StagBlock stagBlock = inputMsg.getStagBlock();
        AID aid = stagBlock.getAID();
        Part part = aid.getPart(0);
        part.setValue(tmpAid);
        tl1OperPrbsList.add(tmpTl1Operation);
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neid, tl1OperPrbsList, 60);
        if (result.retCode == 0) {
            TL1Operation tOper = (TL1Operation)tl1OperPrbsList.get(0);
            int size = tOper.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                HashMap partMap;
                String aidStr;
                OutMsg output = tOper.getOutMsg(row);
                if (output.getFault().getCompletionCode() != 0 || !(aidStr = ((Part)(partMap = TETL1CommonUtil.getOutMsgPart((OutMsg)output)).get("slotID")).getValue()).equals(tmpAid)) continue;
                String typeStr = "";
                Part phyPart = (Part)partMap.get("WORKMODE");
                if (phyPart != null) {
                    typeStr = TETL1CommonUtil.isNull((String)phyPart.getValue());
                }
                return typeStr;
            }
        }
        return "";
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<String> errorList = new ArrayList<String>();
        errorList.add("PARAMETER NOT VALID, PRBS is not test");
        errorList.add("PARAMETER NOT VALID, The MOD2 is wrong");
        errorList.add("INVALID DATA PARAMETER, Command not supported");
        return errorList;
    }
}

