/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.prbs;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.eventinterpret.prbs.TEPRBSCache;
import com.huawei.nglct.tl1.eventinterpret.prbs.TEPRBSData;
import com.huawei.nglct.tl1.eventinterpret.prbs.TEPRBSNum;
import com.huawei.nglct.tl1.eventinterpret.prbs.TEPRBSUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TEPRBSRefreshRecord
extends TETL1NEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        String hashKey = this.getCahceKey(inputData);
        TEPRBSData testdata = TEPRBSCache.getInstance().getCahce(hashKey);
        this.filterTestData(testdata);
        BussinessParams bussiness = this.getSaveData(testdata);
        RowParams param = new RowParams();
        param.addParam("selectAid", hashKey);
        bussiness.addRowParams(param);
        this.outputData.setBussinessParams(bussiness);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        return this.outputData;
    }

    private void filterTestData(TEPRBSData testdata) {
        if (testdata == null) {
            return;
        }
        List it = testdata.getReportResult();
        ArrayList<TEPRBSNum> temp = new ArrayList<TEPRBSNum>();
        int n = it.size();
        for (int i = 0; i < n; ++i) {
            TEPRBSNum testnum = (TEPRBSNum)it.get(i);
            if (testnum.getCurrentState().equals("COMPLD") && i < n - 1) {
                temp = new ArrayList();
                continue;
            }
            temp.add(testnum);
        }
        testdata.setReportResult(temp);
    }

    private BussinessParams getSaveData(TEPRBSData testdata) {
        BussinessParams bussiness = new BussinessParams();
        if (testdata == null) {
            return bussiness;
        }
        this.handledata(testdata);
        RowParams param = null;
        for (int i = 0; i < testdata.getResultData().size(); ++i) {
            TEPRBSNum testnum = (TEPRBSNum)testdata.getResultData().get(i);
            param = new RowParams();
            param.addParam("systime", String.valueOf(testnum.getHappenTime()));
            param.addParam("eslss", testnum.getEslss());
            param.addParam("tbe", testnum.getErrnum() + "");
            param.addParam("totalerrors", testnum.getTotalErrNum() + "");
            param.addParam("currentStatus", testnum.getCurrentState());
            param.addParam("et", testnum.getEt());
            bussiness.addRowParams(param);
        }
        param = new RowParams();
        if (testdata.getCurrentStatus().equals("COMPLD")) {
            param.addParam("teststate", "10");
            param.addParam("elapsedperiod", testdata.getElapsedperiod());
            param.addParam("progress", "100%");
        } else {
            param.addParam("teststate", "1");
            param.addParam("elapsedperiod", testdata.getElapsedperiod());
            param.addParam("progress", testdata.getProgress() + "%");
        }
        param.addParam("startTime", String.valueOf(testdata.getStartTime()));
        bussiness.addRowParams(param);
        return bussiness;
    }

    private void handledata(TEPRBSData testdata) {
        if (testdata == null) {
            return;
        }
        if (testdata.getTeststate() == 0) {
            return;
        }
        if (testdata.getCurrentStatus().equals("COMPLD")) {
            return;
        }
        int timeUnit = testdata.getTimeUnit();
        int abletime = 0;
        abletime = timeUnit == 1 ? 25000 : 120000;
        Date d = new Date();
        long current = d.getTime();
        long lastreporttime = testdata.getLastreportTime();
        if (lastreporttime == 0L && testdata.getQueryList().size() <= 0) {
            testdata.setTeststate(1);
            return;
        }
        if (current - lastreporttime > (long)abletime) {
            testdata.setTeststate(0);
        }
    }

    private String getCahceKey(Datainterface inputData) {
        RowParams rowpara = inputData.getBussinessParams().getRowParams(0);
        Param para = rowpara.getParam("AID");
        String mod2 = rowpara.getParam("MODE2").getValue();
        String hashvalue = TEPRBSUtility.getPortNameFormAid((int)this.neid, (String)para.getValue(), (String)mod2);
        return hashvalue;
    }
}

