/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.prbs;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1DataConverter;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class TEPRBSQueryPortState
extends TETL1NEExplorerBean {
    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        BussinessParams businessparams = inputData.getBussinessParams();
        TL1Definitions definitions = null;
        TL1Operation operstate = null;
        RowParams rowparams = null;
        ArrayList<TL1Operation> clntOperList = new ArrayList<TL1Operation>();
        try {
            definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (MarshalException e) {
            TELogFactory.getNormalLogger().error("TEPRBSQueryPortState.getTL1Operation() fail!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("TEPRBSQueryPortState.getTL1Operation() fail!", (Throwable)e);
        }
        catch (ValidationException e) {
            TELogFactory.getNormalLogger().error("TEPRBSQueryPortState.getTL1Operation() fail!", (Throwable)e);
        }
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            String aidstr = rowparams.getParam("AID").getValue();
            String mod2 = rowparams.getParam("mod2").getValue();
            String tempMod2 = TETL1CommonUtil.getTL1CmdMod2((String)("RTRV-" + mod2));
            operstate = definitions.getTL1Operation(tempMod2);
            TETL1CommonUtil.modifyMOD2((TL1Operation)operstate, (String)mod2);
            operstate.getInMsg().getStagBlock().getAID().getPart(0).setValue(aidstr);
            clntOperList.add(operstate);
        }
        return clntOperList;
    }

    protected Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList tl1OperList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        int tl1OperSize = tl1OperList.size();
        ArrayList errorData = this.joinTL1Operation(neid, subfunc, tl1OperList, filterErrorCodeList);
        TL1Operation tl1Operation = null;
        RowParams rowparams = null;
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        if (0 == tl1OperSize) {
            if (null == errorData || 0 == errorData.size()) {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            } else if (errorData.size() >= tl1OperSize) {
                rowparams = new RowParams();
                int sizei = errorData.size();
                for (int ii = 0; ii < sizei; ++ii) {
                    rowparams.addRowErrors((RowErrors)errorData.get(ii));
                }
                outputData.getBussinessParams().addRowParams(rowparams);
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            } else {
                rowparams = new RowParams();
                int sizei = errorData.size();
                for (int ii = 0; ii < sizei; ++ii) {
                    rowparams.addRowErrors((RowErrors)errorData.get(ii));
                }
                outputData.getBussinessParams().addRowParams(rowparams);
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
            }
            return outputData;
        }
        InMsg input = null;
        OutMsg output = null;
        int len = tl1OperList.size();
        for (int i = 0; i < len; ++i) {
            tl1Operation = (TL1Operation)tl1OperList.get(i);
            input = tl1Operation.getInMsg();
            int size = tl1Operation.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                String mod2;
                rowparams = new RowParams();
                output = tl1Operation.getOutMsg(row);
                if (!this.handleRowData(neid, subfunc, rowparams, input, output, mod2 = tl1Operation.getMod1())) continue;
                outputData.getBussinessParams().addRowParams(rowparams);
            }
        }
        if (null != errorData && 0 != errorData.size()) {
            rowparams = new RowParams();
            int sizei = errorData.size();
            for (int ii = 0; ii < sizei; ++ii) {
                rowparams.addRowErrors((RowErrors)errorData.get(ii));
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (0 == errorData.size()) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (errorData.size() >= tl1OperSize) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        return outputData;
    }

    protected boolean handleRowData(int neid, SubFunc subfunc, RowParams rowparams, InMsg input, OutMsg output, String mod2) {
        HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
        if (this.isFilterRowData(partmap)) {
            return false;
        }
        Param param = null;
        ArrayList<Param> paramList = new ArrayList<Param>();
        param = new Param("PST", "");
        String pst = ((Part)partmap.get("PST")).getValue();
        String sst = ((Part)partmap.get("SST")).getValue();
        if (sst == null || sst.isEmpty()) {
            param.setValue(pst);
        } else {
            param.setValue(pst + "," + sst);
        }
        paramList.add(param);
        param = new Param("mod2", mod2);
        paramList.add(param);
        param = new Param("AID", "");
        String aidstr = ((Part)partmap.get("AID")).getValue();
        param.setValue(aidstr);
        paramList.add(param);
        int len = paramList.size();
        if (len != 0) {
            for (int j = 0; j < len; ++j) {
                rowparams.addParam((Param)paramList.get(j));
            }
        } else {
            return false;
        }
        TETL1DataConverter.addReturnParam((int)neid, (RowParams)rowparams);
        return true;
    }
}

