/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.portprotection;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1DataConverter;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class TEQueryPortProtectionGroup
extends TETL1NEExplorerBean {
    private static final int SHELFPOS = 1;
    private static final int SLOTIDPOS = 2;
    private static int GROUP_ID = 0;
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private ArrayList stateOperList = new ArrayList();
    private String neName = "";
    private String ctrlBoardMod2 = "OCH";

    public TEQueryPortProtectionGroup() {
        this.bQueryAidAndType = true;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        TENE ne = this.mgr.getNE(neid);
        if (null != ne) {
            this.neName = ne.getNEName();
        }
        this.outputData = super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        this.writeLog(neid, this.subfunc, user, ipAddress, this.stateOperList);
        return this.outputData;
    }

    public int sendMessage(int neid, ArrayList tl1OperList) {
        int retCode = 0;
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, (List)tl1OperList, this.getTimeOut());
        if (null != result) {
            retCode = result.retCode;
        }
        if (retCode == 0) {
            this.stateOperList = this.getStateOperation();
            if (this.stateOperList != null && this.stateOperList.size() != 0) {
                retCode = super.sendMessage(neid, this.stateOperList);
            }
        }
        return retCode;
    }

    private ArrayList getStateOperation() {
        TL1Definitions tl1definitions = null;
        ArrayList tl1OperationList = new ArrayList();
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
        TL1Operation tl1Operation = null;
        TL1Operation tempOperation = null;
        tl1Operation = tl1definitions.getTL1Operation("RTRV-WDM");
        if (tl1Operation == null) {
            return null;
        }
        tempOperation = (TL1Operation)this.tl1OperList.get(0);
        Part part = null;
        HashSet slotIDList = new HashSet();
        int len = tempOperation.getOutMsgCount();
        for (int i = 0; i < len; ++i) {
            TENE ne = this.mgr.getNE(this.neid);
            part = tempOperation.getOutMsg(i).getMsgBlock().getPart("PROTECT");
            String protectPortInfo = null;
            Part portNE = tempOperation.getOutMsg(i).getMsgBlock().getPart("PROTNE");
            boolean protNECommFlag = true;
            if (part != null && part.getValue() != null && (portNE.getValue() == null || portNE.getValue().equals(ne.getNEName()))) {
                protectPortInfo = part.getValue();
                HashSet temp = this.getSlotIDList(tempOperation, 1);
                if (null != temp && 0 != temp.size()) {
                    slotIDList.addAll(temp);
                }
            } else {
                protNECommFlag = false;
            }
            Part workNE = tempOperation.getOutMsg(i).getMsgBlock().getPart("WORKNE");
            part = tempOperation.getOutMsg(i).getMsgBlock().getPart("WORK");
            String wordPortInfo = null;
            boolean workNECommFlag = true;
            if (part != null && part.getValue() != null && (workNE.getValue() == null || workNE.getValue().equals(ne.getNEName()))) {
                wordPortInfo = part.getValue();
                HashSet temp = this.getSlotIDList(tempOperation, 2);
                if (null != temp && 0 != temp.size()) {
                    slotIDList.addAll(temp);
                }
            } else {
                workNECommFlag = false;
            }
            Part ctrlNE = tempOperation.getOutMsg(i).getMsgBlock().getPart("CTRLNE");
            part = tempOperation.getOutMsg(i).getMsgBlock().getPart("CTRL");
            String ctrl = part.getValue();
            boolean ctrlNECommFlag = true;
            if (ctrl == null) {
                part = tempOperation.getOutMsg(i).getMsgBlock().getPart("DETECT");
                ctrl = part.getValue();
            }
            if (ctrlNE.getValue() == null || ctrlNE.getValue().equals(ne.getNEName())) {
                HashSet temp = this.getSlotIDList(tempOperation, 3);
                if (null != temp && 0 != temp.size()) {
                    slotIDList.addAll(temp);
                }
            } else {
                ctrlNECommFlag = false;
            }
            this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)this.neid, slotIDList);
            if (ctrl != null && ctrlNECommFlag) {
                this.getOperation(tl1OperationList, tl1Operation, tempOperation, i, ctrl, true);
            }
            if (wordPortInfo != null && workNECommFlag) {
                this.getOperation(tl1OperationList, tl1Operation, tempOperation, i, wordPortInfo, false);
            }
            if (protectPortInfo == null || !protNECommFlag) continue;
            this.getOperation(tl1OperationList, tl1Operation, tempOperation, i, protectPortInfo, false);
        }
        return tl1OperationList;
    }

    private void getOperation(ArrayList tl1OperationList, TL1Operation tl1Operation, TL1Operation tempOperation, int i, String portInfo, boolean isCtrlBoardFlag) {
        tl1Operation.getInMsg().getPart("AID").setValue(portInfo);
        String mod = this.aidAndTypeList != null ? this.aidAndTypeList.getMod2(this.neid, TETL1CommonUtil.getNMSlotStr((String)portInfo, (int)this.neid), TETL1CommonUtil.getNMPortNOFromAidStruct((String)portInfo, (int)this.neid)) : tempOperation.getOutMsg(i).getMsgBlock().getPart("MOD2").getValue();
        String proType = tempOperation.getOutMsg(i).getMsgBlock().getPart("FFPTYPE").getValue();
        int slotID = TETL1CommonUtil.getNMSlotStr((String)portInfo, (int)this.neid);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID);
        int wdmType = TEConfigurationDataMgr.getInstance().getBoardWDMFunType(this.neid, boardType);
        if (wdmType == 16384 && proType.equals("OLP1+1")) {
            mod = "WDM";
        }
        if (wdmType == 16384 && proType.equals("CLIENT1+1")) {
            return;
        }
        if (wdmType == 16384 && proType.equals("INNER1+1")) {
            mod = this.ctrlBoardMod2;
        } else {
            if (mod.indexOf("|") > -1) {
                mod = mod.substring(0, mod.indexOf("|"));
            }
            if (isCtrlBoardFlag) {
                this.ctrlBoardMod2 = mod;
            }
        }
        tl1Operation.setMod1(mod);
        tl1Operation.setName(tl1Operation.getCmdCode() + "-" + tl1Operation.getMod1());
        tl1OperationList.add(tl1Operation.clone());
    }

    private HashSet getSlotIDList(TL1Operation operation, int type) {
        HashSet<Integer> set = new HashSet<Integer>();
        int len = operation.getOutMsgCount();
        for (int i = 0; i < len; ++i) {
            String ctrlPortInfo;
            Part part = operation.getOutMsg(i).getMsgBlock().getPart("PROTECT");
            String protectPortInfo = part.getValue();
            int slotid = TETL1CommonUtil.getNMSlotStr((String)protectPortInfo, (int)this.neid);
            if (type == 1) {
                set.add(slotid);
            }
            part = operation.getOutMsg(i).getMsgBlock().getPart("WORK");
            String workPortInfo = part.getValue();
            slotid = TETL1CommonUtil.getNMSlotStr((String)workPortInfo, (int)this.neid);
            if (type == 2) {
                set.add(slotid);
            }
            if ((ctrlPortInfo = (part = operation.getOutMsg(i).getMsgBlock().getPart("CTRL")).getValue()) != null) {
                slotid = TETL1CommonUtil.getNMSlotStr((String)ctrlPortInfo, (int)this.neid);
                if (type == 3) {
                    set.add(slotid);
                }
            }
            if ((ctrlPortInfo = (part = operation.getOutMsg(i).getMsgBlock().getPart("DETECT")).getValue()) == null) continue;
            slotid = TETL1CommonUtil.getNMSlotStr((String)ctrlPortInfo, (int)this.neid);
            if (type != 3) continue;
            set.add(slotid);
        }
        return set;
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap) {
        String[] strArr;
        Part part;
        Part part2;
        Part ctrlNE;
        if (oldParam.getName().equalsIgnoreCase("groupId")) {
            oldParam.setValue(String.valueOf(GROUP_ID++));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("currentWorkingPath")) {
            Part wpart = (Part)partmap.get("WORK");
            Part ppart = (Part)partmap.get("PROTECT");
            Part existAct = (Part)partmap.get("ACTIVE");
            this.setCurrentWorkingPathParam(oldParam, wpart, ppart, existAct);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("wnename")) {
            Part part3 = (Part)partmap.get("WORKNE");
            this.setWnenameParam(oldParam, part3);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("wslotId")) {
            Part part4 = (Part)partmap.get("WORK");
            if (part4 != null) {
                String[] strArr2 = part4.getValue().split("-");
                int wslotid = this.getSlotID(strArr2);
                oldParam.setValue(String.valueOf(wslotid));
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("wshowSlot")) {
            Part part5 = (Part)partmap.get("WORK");
            if (part5 != null) {
                String[] strArr3 = part5.getValue().split("-");
                int wslotid = this.getSlotID(strArr3);
                String showSlot = TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)wslotid);
                oldParam.setValue(showSlot);
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("wboardName")) {
            Part part6 = (Part)partmap.get("WORK");
            if (part6 != null) {
                String[] strArr4 = part6.getValue().split("-");
                int wslotid = this.getSlotID(strArr4);
                oldParam.setValue(this.getBoardName(wslotid));
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("revertivemode")) {
            Part part7 = (Part)partmap.get("RVRTV");
            if (part7 != null && part7.getValue() != null && !part7.getValue().equals("")) {
                oldParam.setValue(part7.getValue());
            } else {
                oldParam.setValue("Unknown");
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("wtrtime")) {
            Part part8 = (Part)partmap.get("RVTM");
            if (part8 != null && part8.getValue() != null && !part8.getValue().equals("")) {
                oldParam.setValue(part8.getValue());
            } else {
                oldParam.setValue("0");
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("wportName")) {
            Part part9 = (Part)partmap.get("WORK");
            if (part9 != null) {
                String[] strArr5 = part9.getValue().split("-");
                int wslotid = this.getSlotID(strArr5);
                int wportid = this.getPortID(part9.getValue());
                oldParam.setValue(this.getPortName(wslotid, wportid));
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("flag")) {
            oldParam.setValue("");
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("workingPathStatus")) {
            Part part10 = (Part)partmap.get("WORKSTATE");
            if (part10 != null && part10.getValue() != null) {
                oldParam.setValue(part10.getValue());
            } else {
                oldParam.setValue("Unknown");
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("wdelayTime")) {
            Part part11 = (Part)partmap.get("WORK");
            oldParam.setValue(this.getStateParamValue(part11.getValue(), "DELAYTIME", "0"));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("MARK")) {
            Part part12 = (Part)partmap.get("MARK");
            String remarkstr = "";
            if (null != part12 && null != part12.getValue()) {
                remarkstr = TETL1FaultUtil.subStringSpecial((String)part12.getValue());
                oldParam.setValue(remarkstr);
            }
            return oldParam;
        }
        if (partmap.get("CTRL") != null && ((Part)partmap.get("CTRL")).getValue() != null && this.setCTRLParam(oldParam, ctrlNE = (Part)partmap.get("CTRLNE"), part2 = (Part)partmap.get("CTRL")) != null) {
            return this.setCTRLParam(oldParam, ctrlNE, part2);
        }
        if (partmap.get("DETECT") != null && ((Part)partmap.get("DETECT")).getValue() != null && this.setDETECTParam(oldParam, part = (Part)partmap.get("DETECT")) != null) {
            return this.setDETECTParam(oldParam, part);
        }
        if (oldParam.getName().equalsIgnoreCase("pnename")) {
            oldParam.setValue(this.neName);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pslotId")) {
            part = (Part)partmap.get("PROTECT");
            if (part != null) {
                strArr = part.getValue().split("-");
                int pslotid = this.getSlotID(strArr);
                oldParam.setValue(String.valueOf(pslotid));
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pshowSlot")) {
            part = (Part)partmap.get("PROTECT");
            if (part != null) {
                strArr = part.getValue().split("-");
                int pslotid = this.getSlotID(strArr);
                String showSlot = TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)pslotid);
                oldParam.setValue(showSlot);
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pboardName")) {
            part = (Part)partmap.get("PROTECT");
            if (part != null) {
                strArr = part.getValue().split("-");
                int pslotid = this.getSlotID(strArr);
                oldParam.setValue(this.getBoardName(pslotid));
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pportName")) {
            part = (Part)partmap.get("PROTECT");
            if (part != null) {
                strArr = part.getValue().split("-");
                int pslotid = this.getSlotID(strArr);
                int pportid = this.getPortID(part.getValue());
                oldParam.setValue(this.getPortName(pslotid, pportid));
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("protectionPathStatus")) {
            part = (Part)partmap.get("PROTSTATE");
            this.setProectionpathStatusParam(oldParam, part);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pdelayTime")) {
            part = (Part)partmap.get("PROTECT");
            oldParam.setValue(this.getStateParamValue(part.getValue(), "DELAYTIME", "0"));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("cdelayTime")) {
            part = (Part)partmap.get("CTRL");
            if (part.getValue() == null) {
                part = (Part)partmap.get("DETECT");
            }
            oldParam.setValue(this.getStateParamValue(part.getValue(), "DELAYTIME", "-"));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("switchingStatus")) {
            part = (Part)partmap.get("SWSTATE");
            if (null == part || null == part.getValue()) {
                oldParam.setValue("Unknown");
            } else {
                oldParam.setValue(part.getValue());
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("workingunitShow")) {
            Part workNE = (Part)partmap.get("WORKNE");
            part2 = (Part)partmap.get("WORK");
            return this.setWorkingunitShowParam(oldParam, workNE, part2);
        }
        if (oldParam.getName().equalsIgnoreCase("protectionunitShow")) {
            Part protNE = (Part)partmap.get("PROTNE");
            part2 = (Part)partmap.get("PROTECT");
            return this.setProtectionunitShowParam(oldParam, protNE, part2);
        }
        if (oldParam.getName().equalsIgnoreCase("controlunitworkingpathShow")) {
            ctrlNE = (Part)partmap.get("CTRLNE");
            part2 = (Part)partmap.get("CTRL");
            if (part2.getValue() == null) {
                part2 = (Part)partmap.get("DETECT");
            }
            this.setControlunitworkingpathShowParam(oldParam, ctrlNE, part2);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("switchDectTime")) {
            part = (Part)partmap.get("CONFRIMTIME");
            if (null == part || null == part.getValue()) {
                oldParam.setValue("-");
            } else {
                oldParam.setValue(part.getValue());
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("switchType")) {
            part = (Part)partmap.get("PSDIRN");
            if (null == part || null == part.getValue()) {
                oldParam.setValue("-");
            } else {
                oldParam.setValue(this.convertTONumValue(part.getValue()));
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("apsChannel")) {
            part = (Part)partmap.get("APSMFIDX");
            if (null == part || null == part.getValue()) {
                oldParam.setValue("-");
            } else {
                oldParam.setValue(part.getValue());
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("apsChannelUnit")) {
            part = (Part)partmap.get("APSCHN");
            if (null == part || null == part.getValue()) {
                oldParam.setValue("-");
            } else {
                String unitName = TETL1CommonUtil.getGencfgObjFromAID((int)this.neid, (String)part.getValue());
                oldParam.setValue(unitName);
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("shelfId")) {
            part = (Part)partmap.get("APSCHN");
            if (null == part || null == part.getValue()) {
                oldParam.setValue("-");
            } else {
                int slotNMID = TETL1CommonUtil.getNMSlotStr((String)part.getValue(), (int)this.neid);
                oldParam.setValue(String.valueOf(TEBoardUtil.getSubrackIDFromSlot((int)this.neid, (int)slotNMID)));
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("cslotId")) {
            part = (Part)partmap.get("APSCHN");
            if (null == part || null == part.getValue()) {
                oldParam.setValue("-");
            } else {
                int slotNMID = TETL1CommonUtil.getNMSlotStr((String)part.getValue(), (int)this.neid);
                oldParam.setValue(String.valueOf(slotNMID));
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("cportId")) {
            part = (Part)partmap.get("APSCHN");
            if (null == part || null == part.getValue()) {
                oldParam.setValue("-");
            } else {
                int portID = TETL1CommonUtil.getPortIDFromAID((String)part.getValue(), (int)this.neid);
                oldParam.setValue(String.valueOf(portID));
            }
            return oldParam;
        }
        return super.convertParamValue(oldParam, partmap);
    }

    private String convertTONumValue(String value) {
        String tmpValue = "0";
        if (value.equalsIgnoreCase("UNI")) {
            tmpValue = "0";
        } else if (value.equalsIgnoreCase("BI")) {
            tmpValue = "1";
        }
        return tmpValue;
    }

    private Param setDETECTParam(Param oldParamDetect, Part part) {
        if (oldParamDetect.getName().equalsIgnoreCase("cwnename")) {
            oldParamDetect.setValue(this.neName);
            return oldParamDetect;
        }
        if (oldParamDetect.getName().equalsIgnoreCase("cwslotId") && part != null && part.getValue() != null) {
            String[] strArr = part.getValue().split("-");
            int cwslotid = this.getSlotID(strArr);
            oldParamDetect.setValue(String.valueOf(cwslotid));
            return oldParamDetect;
        }
        if (oldParamDetect.getName().equalsIgnoreCase("cwshowSlot") && part != null && part.getValue() != null) {
            String[] strArr = part.getValue().split("-");
            int cwslotid = this.getSlotID(strArr);
            String showSlot = TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)cwslotid);
            oldParamDetect.setValue(showSlot);
            return oldParamDetect;
        }
        if (oldParamDetect.getName().equalsIgnoreCase("cwboardName")) {
            String[] strArr = part.getValue().split("-");
            int cslotid = this.getSlotID(strArr);
            oldParamDetect.setValue(this.getBoardName(cslotid));
            return oldParamDetect;
        }
        if (oldParamDetect.getName().equalsIgnoreCase("cwportName")) {
            String[] strArr = part.getValue().split("-");
            int cslotid = this.getSlotID(strArr);
            int cportid = this.getPortID(part.getValue());
            oldParamDetect.setValue(this.getPortName(cslotid, cportid));
            return oldParamDetect;
        }
        return null;
    }

    private Param setCTRLParam(Param oldParamCtrl, Part ctrlNE, Part part) {
        if (oldParamCtrl.getName().equalsIgnoreCase("cwnename")) {
            if (ctrlNE.getValue() != null && ctrlNE.getValue().equals("OTHER")) {
                oldParamCtrl.setValue("otherdevice");
            } else if (ctrlNE.getValue() != null && !ctrlNE.getValue().equals(this.neName)) {
                oldParamCtrl.setValue("Unknown");
            } else {
                oldParamCtrl.setValue(this.neName);
            }
            return oldParamCtrl;
        }
        if (oldParamCtrl.getName().equalsIgnoreCase("cwslotId") && part != null && part.getValue() != null) {
            String[] strArr = part.getValue().split("-");
            int cwslotid = this.getSlotID(strArr);
            oldParamCtrl.setValue(String.valueOf(cwslotid));
            return oldParamCtrl;
        }
        if (oldParamCtrl.getName().equalsIgnoreCase("cwshowSlot") && part != null && part.getValue() != null) {
            String[] strArr = part.getValue().split("-");
            int cwslotid = this.getSlotID(strArr);
            String showSlot = TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)cwslotid);
            oldParamCtrl.setValue(showSlot);
            return oldParamCtrl;
        }
        if (oldParamCtrl.getName().equalsIgnoreCase("cwboardName")) {
            String[] strArr = part.getValue().split("-");
            int cslotid = this.getSlotID(strArr);
            oldParamCtrl.setValue(this.getBoardName(cslotid));
            return oldParamCtrl;
        }
        if (oldParamCtrl.getName().equalsIgnoreCase("cwportName")) {
            String[] strArr = part.getValue().split("-");
            int cslotid = this.getSlotID(strArr);
            int cportid = this.getPortID(part.getValue());
            oldParamCtrl.setValue(this.getPortName(cslotid, cportid));
            return oldParamCtrl;
        }
        return null;
    }

    private Param setProtectionunitShowParam(Param oldParam, Part protNE, Part part) {
        StringBuffer sb = new StringBuffer();
        TENE ne = this.mgr.getNE(this.neid);
        if ((protNE.getValue() == null || protNE.getValue().equals(ne.getNEName())) && part.getValue() != null) {
            sb.append(TETL1CommonUtil.getBoardStructFromAID((String)part.getValue(), (int)this.neid, (boolean)true));
        } else if (protNE.getValue() != null && (protNE.getValue().equals("OTHER") || protNE.getValue().indexOf("EBM") != -1)) {
            sb.append("otherdevice");
        } else {
            if (protNE.getValue() != null && !protNE.getValue().equals(ne.getNEName())) {
                return null;
            }
            sb.append("Unknown");
        }
        oldParam.setValue(sb.toString());
        return oldParam;
    }

    private void setControlunitworkingpathShowParam(Param oldParam, Part ctrlNE, Part part) {
        StringBuffer sb = new StringBuffer();
        TENE ne = this.mgr.getNE(this.neid);
        if ((ctrlNE.getValue() == null || ctrlNE.getValue().equals(ne.getNEName())) && part.getValue() != null) {
            sb.append(TETL1CommonUtil.getBoardStructFromAID((String)part.getValue(), (int)this.neid, (boolean)true));
        } else if (ctrlNE.getValue() != null && (ctrlNE.getValue().equals("OTHER") || ctrlNE.getValue().indexOf("EBM") != -1)) {
            sb.append("otherdevice");
        } else if (ctrlNE.getValue() != null && !ctrlNE.getValue().equals(ne.getNEName())) {
            sb.append("Unknown");
        } else {
            sb.append("NULL");
        }
        oldParam.setValue(sb.toString());
    }

    private Param setWorkingunitShowParam(Param oldParam, Part workNE, Part part) {
        StringBuffer sb = new StringBuffer();
        TENE ne = this.mgr.getNE(this.neid);
        if ((workNE.getValue() == null || workNE.getValue().equals(ne.getNEName())) && part.getValue() != null) {
            sb.append(TETL1CommonUtil.getBoardStructFromAID((String)part.getValue(), (int)this.neid, (boolean)true));
        } else if (workNE.getValue() != null && workNE.getValue().equals("OTHER")) {
            sb.append("otherdevice");
        } else {
            if (workNE.getValue() != null && !workNE.getValue().equals(ne.getNEName())) {
                return null;
            }
            sb.append("Unknown");
        }
        oldParam.setValue(sb.toString());
        return oldParam;
    }

    private void setProectionpathStatusParam(Param oldParam, Part part) {
        if (part == null) {
            oldParam.setValue(this.getStateParamValue("Unknown", "SWITCHSTATE", "Unknown"));
        } else if (part.getValue() != null) {
            oldParam.setValue(part.getValue());
        } else {
            oldParam.setValue(this.getStateParamValue(part.getValue(), "SWITCHSTATE", "Unknown"));
        }
    }

    private void setWnenameParam(Param oldParam, Part part) {
        String worknename = "";
        worknename = part != null && part.getValue() != null && !part.getValue().equals("") ? part.getValue() : this.neName;
        if (!worknename.equalsIgnoreCase(this.neName)) {
            worknename = "otherdevice";
        }
        oldParam.setValue(worknename);
    }

    private void setCurrentWorkingPathParam(Param oldParam, Part wpart, Part ppart, Part existAct) {
        if (existAct != null && existAct.getValue() != null && !existAct.getValue().equals("")) {
            if (existAct.getValue().equalsIgnoreCase("WORK")) {
                oldParam.setValue("1");
            } else if (existAct.getValue().equalsIgnoreCase("PROTECT")) {
                oldParam.setValue("0");
            } else {
                oldParam.setValue(existAct.getValue());
            }
        } else {
            oldParam.setValue(this.getCurPathValue(wpart, ppart));
        }
    }

    private int getSlotID(String[] infoStrArr) {
        int slotid = TETL1CommonUtil.hasShelfNE((int)this.neid) ? TETL1CommonUtil.neShelfIDSlotIDToSlotIDNM((String)(infoStrArr[1] + "-" + infoStrArr[2])) : Integer.parseInt(infoStrArr[1]);
        return slotid;
    }

    private int getPortID(String aid) {
        return TETL1CommonUtil.getPortIDFromAID((String)aid, (int)this.neid);
    }

    private String getBoardName(int slotid) {
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
        return TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
    }

    private String getPortName(int slotid, int portid) {
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
        return TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotid, boardtype, portid);
    }

    private String getStateParamValue(String aid, String attrib, String convertStr) {
        String attribStr = convertStr;
        TL1Operation tl1Oper = null;
        int len = this.stateOperList.size();
        for (int i = 0; i < len; ++i) {
            tl1Oper = (TL1Operation)this.stateOperList.get(i);
            if (tl1Oper.getOutMsgCount() <= 0 || tl1Oper.getOutMsg(0).getFault().getCompletionCode() != 0 || !tl1Oper.getOutMsg(0).getMsgBlock().getPart("AID").getValue().equals(aid)) continue;
            if (null == tl1Oper.getOutMsg(0).getMsgBlock().getPart(attrib).getValue()) break;
            attribStr = tl1Oper.getOutMsg(0).getMsgBlock().getPart(attrib).getValue();
            break;
        }
        return attribStr;
    }

    private String getCurPathValue(Part wpart, Part ppart) {
        String curChannel = "255";
        String sstStr = "";
        TL1Operation tl1Oper = null;
        int len = this.stateOperList.size();
        for (int i = 0; i < len; ++i) {
            tl1Oper = (TL1Operation)this.stateOperList.get(i);
            if (tl1Oper.getOutMsgCount() <= 0 || tl1Oper.getOutMsg(0).getFault().getCompletionCode() != 0 || null == tl1Oper.getOutMsg(0).getMsgBlock().getPart("SST") || null == tl1Oper.getOutMsg(0).getMsgBlock().getPart("SST").getValue()) continue;
            sstStr = tl1Oper.getOutMsg(0).getMsgBlock().getPart("SST").getValue();
            if (tl1Oper.getOutMsg(0).getMsgBlock().getPart("AID").getValue().equals(wpart.getValue()) && sstStr.indexOf("ACT") > -1) {
                curChannel = "1";
                break;
            }
            if (tl1Oper.getOutMsg(0).getMsgBlock().getPart("AID").getValue().equals(ppart.getValue()) && sstStr.indexOf("ACT") > -1) {
                curChannel = "0";
                break;
            }
            curChannel = "255";
        }
        return curChannel;
    }

    protected boolean handleRowData(int neid, SubFunc subfunc, RowParams rowparams, InMsg input, OutMsg output) {
        int lenParam;
        Part part = null;
        HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
        if (this.isFilterRowData(partmap)) {
            return false;
        }
        Param paramTmp = null;
        ArrayList<Param> paramList = new ArrayList<Param>();
        Param newParam = null;
        int len = subfunc.getOutput().getParamCount();
        for (int col = 0; col < len; ++col) {
            paramTmp = new Param(subfunc.getOutput().getParam(col).getName(), "");
            if ("neid".equalsIgnoreCase(paramTmp.getName())) {
                paramTmp.setValue(String.valueOf(neid));
            }
            if (null != input) {
                part = input.getPart(paramTmp.getName());
            }
            if (null != part) {
                paramTmp.setValue(part.getValue());
            }
            if ((newParam = this.convertParamValue(paramTmp, partmap)) == null) {
                paramList = new ArrayList();
                break;
            }
            paramList.add(newParam);
        }
        if ((lenParam = paramList.size()) != 0) {
            for (int j = 0; j < lenParam; ++j) {
                rowparams.addParam((Param)paramList.get(j));
            }
        } else {
            return false;
        }
        TETL1DataConverter.addReturnParam((int)neid, (RowParams)rowparams);
        return true;
    }
}

