/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.portprotection;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;

public class TEModifyPortProtectionGroup
extends TETL1NEExplorerBean {
    private static final int SHELFPOS = 1;
    private static final int SLOTIDPOS = 2;
    private HashMap protectionTypeToMod2;
    private String ctrlBoardMod2 = null;

    public TEModifyPortProtectionGroup() {
        this.bQueryAidAndType = true;
        this.protectionTypeToMod2 = new HashMap();
        this.protectionTypeToMod2.put("OLP1+1", "WDM");
        this.protectionTypeToMod2.put("INNER1+1", "OCH");
        this.protectionTypeToMod2.put("CLIENT1+1", "OC");
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList tl1OList = super.getTL1Operation(neid, subFunc, inputData, memeryData);
        try {
            TL1Definitions tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            TL1Operation tl1Operation = null;
            tl1Operation = tl1definitions.getTL1Operation("ED-WDM");
            if (tl1Operation == null) {
                return tl1OList;
            }
            ArrayList entwdmOperList = this.getEntWDMOperList(tl1OList, tl1Operation, inputData);
            tl1OList.addAll(entwdmOperList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        return tl1OList;
    }

    private ArrayList getEntWDMOperList(ArrayList tl1OList, TL1Operation tl1Operation, Datainterface inputData) {
        ArrayList entwdmOperList = new ArrayList();
        if (tl1OList == null || tl1OList.size() == 0) {
            return null;
        }
        String aid = null;
        Param param = inputData.getBussinessParams().getRowParams(0).getParam("cdelaytime");
        if (param != null && param.getValue() != null) {
            Param paramCtrl = inputData.getBussinessParams().getRowParams(0).getParam("DETECT");
            if (paramCtrl.getValue() == null) {
                paramCtrl = inputData.getBussinessParams().getRowParams(0).getParam("CTRL");
            }
            aid = paramCtrl.getValue();
            this.getDelayOperation(tl1Operation, inputData, entwdmOperList, aid, "cdelaytime");
        }
        if ((param = inputData.getBussinessParams().getRowParams(0).getParam("wdelaytime")) != null && param.getValue() != null) {
            Param paramWork = inputData.getBussinessParams().getRowParams(0).getParam("WORK");
            aid = paramWork.getValue();
            this.getDelayOperation(tl1Operation, inputData, entwdmOperList, aid, "wdelaytime");
        }
        if ((param = inputData.getBussinessParams().getRowParams(0).getParam("pdelaytime")) != null && param.getValue() != null) {
            Param paramProt = inputData.getBussinessParams().getRowParams(0).getParam("AID");
            aid = paramProt.getValue();
            this.getDelayOperation(tl1Operation, inputData, entwdmOperList, aid, "pdelaytime");
        }
        return entwdmOperList;
    }

    private void getDelayOperation(TL1Operation tl1Operation, Datainterface inputData, ArrayList entwdmOperList, String aid, String delayType) {
        if (aid == null) {
            return;
        }
        int pslotid = this.getSlotID(aid.split("-"));
        String proType = inputData.getBussinessParams().getRowParams(0).getParam("protectionType").getValue();
        int slotID = TETL1CommonUtil.getNMSlotStr((String)aid, (int)this.neid);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID);
        int wdmType = TEConfigurationDataMgr.getInstance().getBoardWDMFunType(this.neid, boardType);
        String mod = "WDM";
        if (wdmType == 16384 && !proType.equals("INNER1+1")) {
            mod = "WDM";
        } else if (wdmType == 16384 && proType.equals("INNER1+1")) {
            mod = this.ctrlBoardMod2 != null ? this.ctrlBoardMod2 : "OCH";
        } else {
            mod = this.aidAndTypeList.getMod2(this.neid, pslotid, TETL1CommonUtil.getNMPortNOFromAidStruct((String)aid, (int)this.neid));
            StringTokenizer st = new StringTokenizer(mod, "|");
            while (st.hasMoreTokens()) {
                String strMod2 = st.nextToken();
                if (-1 == strMod2.indexOf("WDM") && -1 == strMod2.indexOf("OC") && -1 == strMod2.indexOf("OCH")) continue;
                mod = strMod2;
                break;
            }
        }
        tl1Operation.setMod1(mod);
        tl1Operation.getInMsg().getStagBlock().getAID().getPart(0).setValue(aid);
        tl1Operation.setName(tl1Operation.getCmdCode() + "-" + tl1Operation.getMod1());
        Param param = inputData.getBussinessParams().getRowParams(0).getParam(delayType);
        tl1Operation.getInMsg().getMsgBlock().getPart("DELAYTIME").setValue(param.getValue());
        entwdmOperList.add(tl1Operation.clone());
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        String protectionType = null;
        String aidStr = null;
        String mod2 = null;
        StringTokenizer st = null;
        String strMod2 = null;
        if (null == this.aidAndTypeList || 0 == this.aidAndTypeList.size()) {
            return;
        }
        protectionType = rowparams.getParam("protectionType").getValue();
        aidStr = rowparams.getParam("AID").getValue();
        if ("CLIENT1+1".equalsIgnoreCase(protectionType)) {
            mod2 = this.aidAndTypeList.getMod2(this.neid, aidStr);
            st = new StringTokenizer(mod2, "|");
            while (st.hasMoreTokens()) {
                strMod2 = st.nextToken();
                if (-1 == strMod2.indexOf("WDM") && -1 == strMod2.indexOf("OC") && -1 == strMod2.indexOf("OCH")) continue;
                mod2 = strMod2;
                break;
            }
            if (mod2.equals("")) {
                mod2 = String.valueOf(this.protectionTypeToMod2.get(protectionType));
            }
        } else if ("INNER1+1".equalsIgnoreCase(protectionType)) {
            if (rowparams.getParam("DETECT") != null) {
                aidStr = rowparams.getParam("DETECT").getValue();
            } else if (rowparams.getParam("CTRL") != null) {
                aidStr = rowparams.getParam("CTRL").getValue();
            }
            this.ctrlBoardMod2 = mod2 = this.aidAndTypeList.getMod2(this.neid, aidStr);
            st = new StringTokenizer(mod2, "|");
            while (st.hasMoreTokens()) {
                strMod2 = st.nextToken();
                if (-1 == strMod2.indexOf("WDM") && -1 == strMod2.indexOf("OC") && -1 == strMod2.indexOf("OCH")) continue;
                mod2 = strMod2;
                this.ctrlBoardMod2 = strMod2;
                break;
            }
        } else {
            mod2 = String.valueOf(this.protectionTypeToMod2.get(protectionType));
        }
        tl1Operation.setMod2(mod2);
        tl1Operation.setName(tl1Operation.getCmdCode() + "-" + tl1Operation.getMod1() + "-" + mod2);
    }

    protected HashSet getSlotIDFromInputDdata(Datainterface inputData) {
        HashSet<Integer> set = new HashSet<Integer>();
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = null;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            Param tmpParam = rowparams.getParam("slotid");
            if (tmpParam != null) {
                set.add(new Integer(tmpParam.getValue()));
            }
            if ((tmpParam = rowparams.getParam("wslotid")) != null) {
                set.add(new Integer(tmpParam.getValue()));
            }
            if ((tmpParam = rowparams.getParam("DETECT")) != null) {
                int detectSlot = TETL1CommonUtil.getNMSlotStr((String)tmpParam.getValue(), (int)this.neid);
                set.add(new Integer(detectSlot));
            }
            if ((tmpParam = rowparams.getParam("CRTL")) == null) continue;
            int crtlSlot = TETL1CommonUtil.getNMSlotStr((String)tmpParam.getValue(), (int)this.neid);
            set.add(new Integer(crtlSlot));
        }
        return set;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        if (part.getName().equalsIgnoreCase("NE")) {
            TENE ne = TENEListUtils.getNEObj((int)this.neid);
            part.setValue(ne.getNEName());
            return true;
        }
        Param tmpParam = null;
        if (part.getName().equalsIgnoreCase("CONFRIMTIME")) {
            tmpParam = rowparams.getParam("switchDectTime");
            if (tmpParam != null && tmpParam.getValue() != null) {
                part.setValue(tmpParam.getValue());
                return true;
            }
            return false;
        }
        if (part.getName().equalsIgnoreCase("PSDIRN")) {
            tmpParam = rowparams.getParam("switchType");
            if (tmpParam != null && tmpParam.getValue() != null) {
                part.setValue(this.convertToNAValue(tmpParam.getValue()));
                return true;
            }
            return false;
        }
        if (part.getName().equalsIgnoreCase("APSMFIDX")) {
            tmpParam = rowparams.getParam("apsChannel");
            if (tmpParam != null && tmpParam.getValue() != null) {
                part.setValue(tmpParam.getValue());
                return true;
            }
            return false;
        }
        if (part.getName().equalsIgnoreCase("APSCHN")) {
            tmpParam = rowparams.getParam("apsslotId");
            if (tmpParam != null && tmpParam.getValue() != null) {
                int slotID = Integer.parseInt(tmpParam.getValue());
                int portID = Integer.parseInt(rowparams.getParam("apsport").getValue());
                String aid = TETL1CommonUtil.combineAID((int)this.neid, (int)slotID, (int)portID, (int)-1);
                part.setValue(aid);
                return true;
            }
            return false;
        }
        return super.convertPartValue(part, rowparams);
    }

    private String convertToNAValue(String value) {
        String tmpValue = "UNI";
        if (value.equals("0")) {
            tmpValue = "UNI";
        } else if (value.equals("1")) {
            tmpValue = "BI";
        }
        return tmpValue;
    }

    private int getSlotID(String[] infoStrArr) {
        int slotid = TETL1CommonUtil.hasShelfNE((int)this.neid) ? TETL1CommonUtil.neShelfIDSlotIDToSlotIDNM((String)(infoStrArr[1] + "-" + infoStrArr[2])) : Integer.parseInt(infoStrArr[1]);
        return slotid;
    }
}

