/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.portprotection;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.portprotection.TEAvailableResourceOfPortProtectionGroup;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class TEGetAvailableResourceOfPortProtectionGroup
extends TETL1NEExplorerBean {
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private static final int[] OLPPORTS = new int[]{3};
    private static final int[] DCPPORTS = new int[]{5, 6};
    private static final int TIME_OUT = 20;
    private static final int WDM_FUNC_UNIT_LPU = 16384;
    private ArrayList availableResList = new ArrayList();
    private ArrayList needFileOLPBoardTypes = new ArrayList();
    private ArrayList needFileDCPBoardTypes = new ArrayList();
    private String workMode;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.getAllResource(neid);
        this.needFileOLPBoardTypes.add(new Integer(944));
        this.needFileOLPBoardTypes.add(new Integer(1206));
        this.needFileOLPBoardTypes.add(new Integer(1339));
        this.needFileDCPBoardTypes.add(new Integer(943));
        this.needFileDCPBoardTypes.add(new Integer(1207));
        this.filterSeparateProtecitonGroup(operationList);
        this.setFiberLinkOTU();
        operationList.clear();
        this.outputData = this.constructRtnData(neid);
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private void getAllResource(int neid) {
        TENE ne = TENEListUtils.getNEObj((int)neid);
        Vector boardList = ne.getBoardList();
        int size = boardList.size();
        for (int x = 0; x < size; ++x) {
            TEAvailableResourceOfPortProtectionGroup availableRes = null;
            ArrayList portList = null;
            TEBoard board = (TEBoard)boardList.get(x);
            int slotId = board.getSlotID();
            int boardType = board.getBoardType();
            int boardWDMFunType = this.mgr.getBoardWDMFunType(neid, board.getBoardType());
            if (boardType == 1275 || boardType == 1262 || TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_CFG_WDM_OPPG", "OTN_ATTR_SUPPORT_PORTPTCTUNIT_REMOVEPORTBYPORTUSED")) {
                portList = this.mgr.getBoardPortList(neid, boardType);
                availableRes = new TEAvailableResourceOfPortProtectionGroup(neid, slotId, boardType, board.getBoardName(), new HashSet(portList), boardWDMFunType);
            }
            if (boardWDMFunType == 16384) {
                portList = this.mgr.getBoardPortList(neid, boardType);
                if (this.mgr.isDynPortBoardType(neid, boardType) && ne.getNEType() != 66 && this.mgr.getSupportedDynPortList(neid, boardType).size() > 0) {
                    portList.removeAll(this.mgr.getSupportedDynPortList(neid, boardType));
                    portList.addAll(this.mgr.getLogicPortList(neid, slotId));
                }
                availableRes = new TEAvailableResourceOfPortProtectionGroup(neid, slotId, boardType, board.getBoardName(), new HashSet(portList), 16384);
            } else if (boardWDMFunType == 4) {
                portList = this.mgr.getBoardPortList(neid, boardType);
                if (this.mgr.isDynPortBoardType(neid, boardType) && ne.getNEType() != 66 && this.mgr.getSupportedDynPortList(neid, boardType).size() > 0) {
                    portList.removeAll(this.mgr.getSupportedDynPortList(neid, boardType));
                    portList.addAll(this.mgr.getLogicPortList(neid, slotId));
                }
                availableRes = new TEAvailableResourceOfPortProtectionGroup(neid, slotId, boardType, board.getBoardName(), new HashSet(portList), 4);
            } else if (boardWDMFunType == 16) {
                portList = this.mgr.getBoardPortList(neid, boardType);
                if (this.mgr.isDynPortBoardType(neid, boardType) && ne.getNEType() != 66 && this.mgr.getSupportedDynPortList(neid, boardType).size() > 0) {
                    portList.removeAll(this.mgr.getSupportedDynPortList(neid, boardType));
                    portList.addAll(this.mgr.getLogicPortList(neid, slotId));
                }
                availableRes = new TEAvailableResourceOfPortProtectionGroup(neid, slotId, boardType, board.getBoardName(), new HashSet(portList), 16);
            }
            if (availableRes == null) continue;
            this.availableResList.add(availableRes);
        }
    }

    private void filterSeparateProtecitonGroup(ArrayList operationList) {
        int length = operationList.size();
        for (int i = 0; i < length; ++i) {
            TL1Operation operation = (TL1Operation)operationList.get(i);
            String operationName = operation.getName();
            if (!operationName.equals("RTRV-FFP-ALL")) continue;
            for (OutMsg output : operation.getOutMsg()) {
                int boardType;
                int slotId;
                int portId;
                String pPortInfo;
                if (output.getFault().getCompletionCode() != 0) continue;
                if (output.getMsgBlock().getPart("PROTECT") != null) {
                    pPortInfo = output.getMsgBlock().getPart("PROTECT").getValue();
                    portId = TETL1CommonUtil.getNMPortNOFromAidStruct((String)pPortInfo, (int)this.neid);
                    slotId = TETL1CommonUtil.getNMSlotStr((String)pPortInfo, (int)this.neid);
                    boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotId);
                    this.removeUsedRes(slotId, portId, boardType);
                }
                if (output.getMsgBlock().getPart("WORK") != null) {
                    pPortInfo = output.getMsgBlock().getPart("WORK").getValue();
                    portId = TETL1CommonUtil.getNMPortNOFromAidStruct((String)pPortInfo, (int)this.neid);
                    slotId = TETL1CommonUtil.getNMSlotStr((String)pPortInfo, (int)this.neid);
                    boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotId);
                    this.removeUsedRes(slotId, portId, boardType);
                }
                if (output.getMsgBlock().getPart("CTRL") == null || output.getMsgBlock().getPart("CTRL").getValue() == null) continue;
                pPortInfo = output.getMsgBlock().getPart("CTRL").getValue();
                portId = TETL1CommonUtil.getNMPortNOFromAidStruct((String)pPortInfo, (int)this.neid);
                slotId = TETL1CommonUtil.getNMSlotStr((String)pPortInfo, (int)this.neid);
                boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotId);
                this.removeUsedRes(slotId, portId, boardType);
            }
        }
    }

    private void removeUsedRes(int sloitid, int portid, int boardtype) {
        for (int x = this.availableResList.size() - 1; x >= 0; --x) {
            TEAvailableResourceOfPortProtectionGroup availableRes = (TEAvailableResourceOfPortProtectionGroup)this.availableResList.get(x);
            if (sloitid != availableRes.getSlotID()) continue;
            availableRes.getPortList().remove(new Integer(portid));
            if ((this.needFileDCPBoardTypes.contains(new Integer(boardtype)) || this.needFileOLPBoardTypes.contains(new Integer(boardtype))) && portid == 1) {
                availableRes.getPortList().remove(new Integer(portid + 1));
            }
            if (availableRes.getPortList().size() > 0) continue;
            this.availableResList.remove(x);
        }
    }

    private Datainterface constructRtnData(int neid) {
        Datainterface datainterface = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        String subrackName = "";
        int size = this.availableResList.size();
        for (int i = 0; i < size; ++i) {
            TEAvailableResourceOfPortProtectionGroup res = (TEAvailableResourceOfPortProtectionGroup)this.availableResList.get(i);
            RowParams rParams = new RowParams();
            Param param = null;
            param = new Param("neId", String.valueOf(res.getNeid()));
            rParams.addParam(param);
            param = new Param("neName", this.mgr.getNE(res.getNeid()).getNEName());
            rParams.addParam(param);
            subrackName = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)res.getSlotID());
            param = new Param("subrackName", subrackName);
            rParams.addParam(param);
            param = new Param("shelfId", String.valueOf(TEBoardUtil.getSubrackIDFromSlot((int)res.getNeid(), (int)res.getSlotID())));
            rParams.addParam(param);
            param = new Param("slotId", String.valueOf(res.getSlotID()));
            rParams.addParam(param);
            param = new Param("boardType", String.valueOf(res.getBoardType()));
            rParams.addParam(param);
            param = new Param("boardName", res.getBoardName());
            rParams.addParam(param);
            param = new Param("wdmFuncUnit", String.valueOf(res.getWdmFuncUnit()));
            rParams.addParam(param);
            param = new Param("linkSlot", String.valueOf(res.getLinkSlot()));
            rParams.addParam(param);
            param = new Param("linkPort", String.valueOf(res.getLinkPort()));
            rParams.addParam(param);
            if (res.getBoardType() == 1310) {
                this.queryWorkMode(res.getSlotID());
                if (this.workMode != null) {
                    param = new Param("workMode", this.workMode);
                    rParams.addParam(param);
                }
            }
            boolean temp = true;
            Param portParam = null;
            Param portNameParam = null;
            Option option = null;
            Set portList = res.getPortList();
            Iterator it = portList.iterator();
            while (it.hasNext()) {
                int portid = (Integer)it.next();
                String portName = this.mgr.getPortName(neid, res.getSlotID(), res.getBoardType(), portid);
                if (temp) {
                    portParam = new Param("portId", String.valueOf(portid));
                    portNameParam = new Param("portName", portName);
                    temp = false;
                    continue;
                }
                option = new Option(String.valueOf(portid));
                portParam.addOption(option);
                option = new Option(portName);
                portNameParam.addOption(option);
            }
            if (null != portParam) {
                rParams.addParam(portParam);
            }
            if (null != portNameParam) {
                rParams.addParam(portNameParam);
            }
            bParams.addRowParams(rParams);
        }
        datainterface.setBussinessParams(bParams);
        datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        return datainterface;
    }

    private void setFiberLinkOTU() {
        try {
            int retCode;
            OperationResult result;
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TL1Operation operation = definitions.getTL1Operation("RTRV-FIBER");
            TEAvailableResourceOfPortProtectionGroup res = null;
            this.tl1OperList = new ArrayList();
            int m = this.availableResList.size();
            for (int i = 0; i < m; ++i) {
                res = (TEAvailableResourceOfPortProtectionGroup)this.availableResList.get(i);
                int boardType = res.getBoardType();
                if (!this.needFileDCPBoardTypes.contains(new Integer(boardType)) && !this.needFileOLPBoardTypes.contains(new Integer(boardType))) continue;
                InMsg input = operation.getInMsg();
                Part aid = new Part();
                aid.setName("AID");
                aid.setValue("FAC-" + TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)res.getSlotID()) + "-ALL");
                AID temaid = new AID();
                temaid.addPart(aid);
                input.getStagBlock().setAID(temaid);
            }
            if (this.tl1OperList.size() > 0 && null != (result = TETL1NECommMgr.getInstance().sendCommand(this.neid, (List)this.tl1OperList, 20)) && 0 == (retCode = result.retCode)) {
                for (int i = this.tl1OperList.size() - 1; i >= 0; --i) {
                    operation = (TL1Operation)this.tl1OperList.get(i);
                    boolean flag = true;
                    for (int j = operation.getOutMsgCount() - 1; j >= 0; --j) {
                        OutMsg output = operation.getOutMsg(j);
                        if (!output.getFault().getErrCode().equals("0")) {
                            flag = false;
                        }
                        if (!flag) continue;
                        String srcPortInfo = output.getMsgBlock().getPart("SRCPORT").getValue();
                        int srcSlot = TETL1CommonUtil.neShelfIDSlotIDToSlotIDNM((String)srcPortInfo);
                        int boardType = this.mgr.getBoardType(this.neid, srcSlot);
                        int srcPort = TETL1CommonUtil.getNMPortNOFromAidStruct((String)srcPortInfo, (int)this.neid);
                        String snkPortInfo = output.getMsgBlock().getPart("DSTPORT").getValue();
                        int snkSlot = TETL1CommonUtil.neShelfIDSlotIDToSlotIDNM((String)snkPortInfo);
                        int bType = this.mgr.getBoardType(this.neid, snkSlot);
                        int funType = this.mgr.getBoardWDMFunType(this.neid, bType);
                        if (4 != funType && 16 != funType || !(this.needFileOLPBoardTypes.contains(new Integer(boardType)) && srcPort == OLPPORTS[0] || this.needFileDCPBoardTypes.contains(new Integer(boardType)) && srcPort == DCPPORTS[0]) && (!this.needFileDCPBoardTypes.contains(new Integer(boardType)) || srcPort != DCPPORTS[1])) continue;
                        int n = this.availableResList.size();
                        for (int t = 0; t < n; ++t) {
                            res = (TEAvailableResourceOfPortProtectionGroup)this.availableResList.get(t);
                            if (res.getSlotID() != snkSlot) continue;
                            res.setLinkSlot(srcSlot);
                            res.setLinkPort(srcPort);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("handleFiber fail!", (Throwable)e);
        }
    }

    private void queryWorkMode(int slotid) {
        ArrayList<Object> operationList = new ArrayList<Object>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TL1Operation oper1 = definitions.getTL1Operation("RTRV-EQPT");
            InMsg input = oper1.getInMsg();
            String shelfSlot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotid);
            input.getPart("AID").setValue("SLOT-" + shelfSlot);
            operationList.add(oper1.clone());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neid, operationList, 20);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().info("query board fail,the errorCode is " + result.retCode);
            return;
        }
        OutMsg[] outMsgs = ((TL1Operation)operationList.get(0)).getOutMsg();
        int size = outMsgs.length;
        for (int i = 0; i < size; ++i) {
            if (0 != outMsgs[i].getFault().getCompletionCode()) {
                return;
            }
            HashMap dataBlock = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsgs[i]);
            Part workModePart = (Part)dataBlock.get("WORKMODE");
            if (workModePart == null) continue;
            this.workMode = workModePart.getValue();
        }
    }
}

