/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.pidipa;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TEPidIPAQueryBean
extends TETL1NEExplorerBean {
    private static String W32PORT_ATTR_PIDIPA_PARA = "W32PORT_ATTR_PIDIPA_PARA";
    private int slotid = -1;

    public TEPidIPAQueryBean() {
        this.bQueryAidAndType = false;
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        try {
            this.slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams()[0].getParam("slotid").getValue());
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotid);
            ArrayList portList = TEGenCfgDataMgr.getAttrSupportCPPorts((int)neid, (String)W32PORT_ATTR_PIDIPA_PARA, (int)boardType);
            String tmpAid = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)neid, (int)this.slotid);
            TL1Definitions tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            TL1Operation ipaOperation = null;
            TL1Operation laserStatusOperation = null;
            String aid = null;
            int len = portList.size();
            for (int i = 0; i < len; ++i) {
                ipaOperation = tl1definitions.getTL1Operation("RTRV-IPA-WDM");
                laserStatusOperation = tl1definitions.getTL1Operation("RTRV-WDM");
                aid = "FAC-" + tmpAid + "-" + portList.get(i);
                ipaOperation.getInMsg().getStagBlock().getAID().getPart(0).setValue(aid);
                laserStatusOperation.getInMsg().getStagBlock().getAID().getPart(0).setValue(aid);
                tl1OperList.add(ipaOperation);
                tl1OperList.add(laserStatusOperation);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEPidIPAQueryBean getOperation fail!", (Throwable)e);
        }
        return tl1OperList;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, tl1OperList, subfunc, filterErrorCodeList);
        RowParams rowParams = null;
        String aid = null;
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotid);
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowParams.getParam("AID") == null) continue;
            aid = rowParams.getParam("AID").getValue();
            int portid = TETL1CommonUtil.getPortIDFromAID((String)aid, (int)neid);
            String portName = TEConfigurationDataMgr.getInstance().getPortName(neid, this.slotid, boardType, portid);
            rowParams.addParam("portname", portName);
        }
    }
}

