/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.oxc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallCPPortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TESDCircuitPackRecord;
import com.huawei.nglct.nemgr.tl1ngwdm.config.oxc.TEWDMSingleSiteOXCPreBean;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.List;

public class TEWDMSingleSiteOXCLinkageBean
extends TEWDMSingleSiteOXCPreBean {
    private static final int PUS_IDLE = 0;
    private static final int PUS_SOURCE_USED = 2;
    private static final int PUS_SINK_USED = 3;

    public boolean isNeedOperationlog(String ipAddress) {
        return true;
    }

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        TEConfigurationDataMgr cfgData = TEConfigurationDataMgr.getInstance();
        RowParams rParams = inputData.getBussinessParams().getRowParams(0);
        Param flagParam = rParams.getParam("flag");
        String flag = flagParam.getValue();
        Param slotParam = rParams.getParam("slot");
        int slotId = Integer.parseInt(slotParam.getValue());
        int boardType = cfgData.getBoardType(neid, slotId);
        List edgePortList = this.getEdgePortBySlotID(slotId, Integer.parseInt(flag));
        if (edgePortList != null && edgePortList.size() > 0) {
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            RowParams rowParams = new RowParams();
            Param param = new Param("port", "");
            int portId = (Integer)edgePortList.get(0);
            String portName = cfgData.getPortName(neid, slotId, boardType, portId);
            param.setValue(portName);
            int n = edgePortList.size();
            for (int i = 1; i < n; ++i) {
                int port = (Integer)edgePortList.get(i);
                portName = cfgData.getPortName(neid, slotId, boardType, port);
                Option option = new Option(portName);
                param.addOption(option);
            }
            rowParams.addParam(param);
            List bandList = this.getWaveBandList(slotId, boardType, portId);
            if (null != bandList && bandList.size() > 0) {
                param = new Param("band", "");
                String bandId = (String)bandList.get(0);
                param.setValue(bandId);
                int mn = bandList.size();
                for (int k = 1; k < mn; ++k) {
                    Option option = new Option((String)bandList.get(k));
                    param.addOption(option);
                }
                rowParams.addParam(param);
            }
            rowParams.addParam(new Param("flag", flag));
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
        return this.outputData;
    }

    private List getEdgePortBySlotID(int slotId, int srcFlag) {
        ArrayList<Integer> edgePortList = new ArrayList<Integer>();
        TL1Definitions definitions = null;
        try {
            definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEWDMSingleSiteOXCLinkageBean.getEdgePortBySlotID() fail!", (Throwable)e);
            return null;
        }
        this.tl1OperList = new ArrayList();
        TL1Operation operation = definitions.getTL1Operation("RTRV-OXC-NEPORT");
        InMsg input = operation.getInMsg();
        String devSlotid = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotId);
        input.getPart("AID").setValue("FAC-" + devSlotid + "-ALL");
        this.tl1OperList.add(operation);
        int result = this.sendMessage(this.neid, this.tl1OperList);
        if (result == 0) {
            OutMsg output = null;
            boolean row_succ = true;
            operation = (TL1Operation)this.tl1OperList.get(0);
            int n = operation.getOutMsgCount();
            block6: for (int j = 0; j < n; ++j) {
                output = operation.getOutMsg(j);
                if (this.isFilterEgdePort(output.getMsgBlock().getPart("AID").getValue())) continue;
                if (output.getFault().getCompletionCode() != 0 || !output.getFault().getErrDesc().equals("")) {
                    row_succ = false;
                }
                if (!row_succ) continue;
                String srcaid = output.getMsgBlock().getPart("AID").getValue();
                int slot = TETL1CommonUtil.getNMSlotStr((String)srcaid, (int)this.neid);
                int port = TETL1CommonUtil.getNMPortNOFromAidStruct((String)srcaid, (int)this.neid);
                int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slot);
                TESDCircuitPackRecord boardTypePro = TEConfigurationDataMgr.getInstance().getBoardTypeProperty(this.neid, boardType);
                TEInstallCPPortRecord portPro = boardTypePro.getPortProperty(port);
                int portUsage = portPro.getPortUsage();
                switch (srcFlag) {
                    case 0: {
                        if (portUsage == 0 && output.getMsgBlock().getPart("OUT").getValue().equals("ENABLE")) {
                            if (slot != slotId) continue block6;
                            edgePortList.add(port);
                            continue block6;
                        }
                        if (portUsage != 2 || !output.getMsgBlock().getPart("IN").getValue().equals("DISABLE") || !output.getMsgBlock().getPart("OUT").getValue().equals("ENABLE") || slot != slotId) continue block6;
                        edgePortList.add(port);
                        continue block6;
                    }
                    case 1: {
                        if (portUsage == 0 && output.getMsgBlock().getPart("IN").getValue().equals("ENABLE")) {
                            if (slot != slotId) continue block6;
                            edgePortList.add(port);
                            continue block6;
                        }
                        if (portUsage != 3 || !output.getMsgBlock().getPart("IN").getValue().equals("ENABLE") || !output.getMsgBlock().getPart("OUT").getValue().equals("DISABLE") || slot != slotId) continue block6;
                        edgePortList.add(port);
                        continue block6;
                    }
                }
            }
        }
        return edgePortList;
    }

    protected boolean isFilterEgdePort(String aid) {
        String aidarr = aid;
        int tempNmSlotid = TETL1CommonUtil.getNMSlotStr((String)aidarr, (int)this.neid);
        int tempBdType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, tempNmSlotid);
        if (tempBdType == -1 || tempBdType == 60028) {
            return true;
        }
        int tempport = TETL1CommonUtil.getNMPortNOFromAidStruct((String)aid, (int)this.neid);
        if (tempBdType == 951 && (tempport == 1 || tempport == 2)) {
            return true;
        }
        if (!(tempBdType != 952 && tempBdType != 1091 || tempport != 1 && tempport != 2 && tempport != 3 && tempport != 4)) {
            return true;
        }
        return tempBdType == 60003 && tempport == 3;
    }
}

