/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.oxc;

import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nemgr.tl1ngwdm.config.oxc.TEWDMOXCBoardInfoBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEWDMOXCCommon {
    private static final String WDM_OXC_BOARD_PATH = "conf" + File.separator + "ne_attribute" + File.separator + "config" + File.separator + "oxc" + File.separator + "oxcboard.xml";
    private static final String TL1_WAVE_BAND_CMD_PATH = "conf" + File.separator + "ne_attribute" + File.separator + "config" + File.separator + "oxc" + File.separator + "tl1wavebandcmd.xml";
    private static final String TL1_SUPPORT_BOARDCAST = "conf" + File.separator + "ne_attribute" + File.separator + "config" + File.separator + "oxc" + File.separator + "supportBoardcast.xml";
    private static final String WORK_BAND_BY_BOARD_PATH = "conf" + File.separator + "ne_attribute" + File.separator + "config" + File.separator + "oxc" + File.separator + "workbandbyboard.xml";

    public static Map getOXCBoardMap(int neid) {
        Document doc = TEParseXMLFile.parseFile((String)(TEResourceManager.getPath() + TEGetFilePath.getFilePath((int)neid, (String)WDM_OXC_BOARD_PATH)));
        if (doc != null) {
            HashMap<Integer, TEWDMOXCBoardInfoBean> oxcBoardMap = new HashMap<Integer, TEWDMOXCBoardInfoBean>();
            NodeList firstNodeList = doc.getChildNodes();
            Node firstNode = firstNodeList.item(0);
            NodeList secondNodeList = firstNode.getChildNodes();
            int m = secondNodeList.getLength();
            for (int i = 0; i < m; ++i) {
                Node secondNode = secondNodeList.item(i);
                if (!secondNode.getNodeName().equalsIgnoreCase("board_type")) continue;
                TEWDMOXCBoardInfoBean boardInfoBean = new TEWDMOXCBoardInfoBean();
                String boardType = secondNode.getAttributes().getNamedItem("value").getNodeValue();
                boardInfoBean.setBoardType(Integer.parseInt(boardType));
                NodeList thirdNodeList = secondNode.getChildNodes();
                int n = thirdNodeList.getLength();
                for (int j = 0; j < n; ++j) {
                    String portName;
                    Node fourNode;
                    int k;
                    int mn;
                    NodeList fourNodeList;
                    Node thirdNode = thirdNodeList.item(j);
                    if (thirdNode.getNodeName().equalsIgnoreCase("input_port")) {
                        fourNodeList = thirdNode.getChildNodes();
                        mn = fourNodeList.getLength();
                        for (k = 0; k < mn; ++k) {
                            fourNode = fourNodeList.item(k);
                            if (!fourNode.getNodeName().equalsIgnoreCase("port")) continue;
                            portName = fourNode.getAttributes().getNamedItem("value").getNodeValue();
                            boardInfoBean.addSrcPortList(portName);
                        }
                        continue;
                    }
                    if (!thirdNode.getNodeName().equalsIgnoreCase("output_port")) continue;
                    fourNodeList = thirdNode.getChildNodes();
                    mn = fourNodeList.getLength();
                    for (k = 0; k < mn; ++k) {
                        fourNode = fourNodeList.item(k);
                        if (!fourNode.getNodeName().equalsIgnoreCase("port")) continue;
                        portName = fourNode.getAttributes().getNamedItem("value").getNodeValue();
                        boardInfoBean.addSnkPortList(portName);
                    }
                }
                oxcBoardMap.put(Integer.valueOf(boardType), boardInfoBean);
            }
            return oxcBoardMap;
        }
        return null;
    }

    public static Map getBoardcastPort(int neid) {
        Document doc = TEParseXMLFile.parseFile((String)(TEResourceManager.getPath() + TEGetFilePath.getFilePath((int)neid, (String)TL1_SUPPORT_BOARDCAST)));
        if (doc != null) {
            HashMap<String, ArrayList> boardcastMap = new HashMap<String, ArrayList>();
            NodeList firstNodeList = doc.getChildNodes();
            Node firstNode = firstNodeList.item(0);
            NodeList secondNodeList = firstNode.getChildNodes();
            int m = secondNodeList.getLength();
            for (int i = 0; i < m; ++i) {
                Node secondNode = secondNodeList.item(i);
                if (!secondNode.getNodeName().equalsIgnoreCase("cmd")) continue;
                NodeList thirdNodeList = secondNode.getChildNodes();
                int n = thirdNodeList.getLength();
                for (int j = 0; j < n; ++j) {
                    Node thirdNode = thirdNodeList.item(j);
                    if (!thirdNode.getNodeName().equalsIgnoreCase("board")) continue;
                    String bdtype = thirdNode.getAttributes().getNamedItem("bdid").getNodeValue();
                    Node portListNode = thirdNode.getAttributes().getNamedItem("portlist");
                    String portListValue = null;
                    if (portListNode != null) {
                        portListValue = portListNode.getNodeValue();
                    }
                    ArrayList portList = TEWDMOXCCommon.getPortList(portListValue);
                    boardcastMap.put(bdtype, portList);
                }
            }
            return boardcastMap;
        }
        return null;
    }

    public static String getFindWaveBandCmd(int neid, int boardType, int portId) {
        int cmdid = 0;
        String portexist = "false";
        Document doc = TEParseXMLFile.parseFile((String)(TEResourceManager.getPath() + TEGetFilePath.getFilePath((int)neid, (String)TL1_WAVE_BAND_CMD_PATH)));
        if (doc != null) {
            NodeList firstNodeList = doc.getChildNodes();
            Node firstNode = firstNodeList.item(0);
            NodeList secondNodeList = firstNode.getChildNodes();
            int m = secondNodeList.getLength();
            for (int i = 0; i < m; ++i) {
                Node secondNode = secondNodeList.item(i);
                if (!secondNode.getNodeName().equalsIgnoreCase("cmd")) continue;
                String cmdStr = secondNode.getAttributes().getNamedItem("cmdid").getNodeValue();
                NodeList thirdNodeList = secondNode.getChildNodes();
                boolean flag = false;
                int n = thirdNodeList.getLength();
                for (int j = 0; j < n; ++j) {
                    Node thirdNode = thirdNodeList.item(j);
                    if (!thirdNode.getNodeName().equalsIgnoreCase("board")) continue;
                    String bdid = thirdNode.getAttributes().getNamedItem("bdid").getNodeValue();
                    Node portListNode = thirdNode.getAttributes().getNamedItem("portlist");
                    String portListValue = null;
                    if (portListNode != null) {
                        portListValue = portListNode.getNodeValue();
                    }
                    ArrayList portList = TEWDMOXCCommon.getPortList(portListValue);
                    if (Integer.parseInt(bdid) != boardType) continue;
                    if (portList.contains(portId)) {
                        cmdid = Integer.parseInt(cmdStr);
                        portexist = "true";
                    } else {
                        if (boardType == 2213 || boardType == 2430) continue;
                        cmdid = Integer.parseInt(cmdStr);
                        portexist = "false";
                    }
                    flag = true;
                    break;
                }
                if (flag) break;
            }
        }
        return portexist + "-" + cmdid;
    }

    private static ArrayList getPortList(String port_no_list) {
        ArrayList portlist = TEWDMOXCCommon.splitFromChar(port_no_list, ',');
        String subStr = null;
        int minno = -1;
        int maxno = -1;
        int index = -1;
        for (int i = portlist.size() - 1; i >= 0; --i) {
            subStr = (String)portlist.get(i);
            index = subStr.indexOf("-");
            if (index > 0 && index < subStr.length() - 1) {
                minno = Integer.parseInt(subStr.split("-")[0]);
                maxno = Integer.parseInt(subStr.split("-")[1]);
                portlist.remove(i);
                for (int start = minno; start <= maxno; ++start) {
                    portlist.add(i, start);
                }
                continue;
            }
            subStr = subStr.replaceAll("-", "");
            portlist.remove(i);
            portlist.add(i, Integer.valueOf(subStr));
        }
        return portlist;
    }

    private static ArrayList splitFromChar(String allValue, char splitChar) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (null == allValue) {
            return returnList;
        }
        StringBuffer strBuff = new StringBuffer();
        int len = allValue.length();
        for (int i = 0; i < len; ++i) {
            char tmpChar = allValue.charAt(i);
            if (tmpChar != splitChar && '[' != tmpChar && ']' != tmpChar) {
                strBuff.append(tmpChar);
                continue;
            }
            if (0 == strBuff.length()) continue;
            if (!returnList.contains(strBuff.toString().trim())) {
                returnList.add(strBuff.toString().trim());
            }
            strBuff.delete(0, strBuff.length());
        }
        if (0 != strBuff.length()) {
            if (!returnList.contains(strBuff.toString().trim())) {
                returnList.add(strBuff.toString().trim());
            }
            strBuff.delete(0, strBuff.length());
        }
        return returnList;
    }

    public static List getWorkBandList(int neid, int boardType) {
        ArrayList<String> bandList = new ArrayList<String>();
        Document doc = TEParseXMLFile.parseFile((String)(TEResourceManager.getPath() + TEGetFilePath.getFilePath((int)neid, (String)WORK_BAND_BY_BOARD_PATH)));
        if (doc != null) {
            NodeList firstNodeList = doc.getChildNodes();
            Node firstNode = firstNodeList.item(0);
            NodeList secondNodeList = firstNode.getChildNodes();
            int m = secondNodeList.getLength();
            for (int i = 0; i < m; ++i) {
                int bdType;
                Node secondNode = secondNodeList.item(i);
                if (!secondNode.getNodeName().equalsIgnoreCase("board") || (bdType = Integer.parseInt(secondNode.getAttributes().getNamedItem("type").getNodeValue())) != boardType) continue;
                NodeList thirdNodeList = secondNode.getChildNodes();
                int n = thirdNodeList.getLength();
                for (int j = 0; j < n; ++j) {
                    Node thirdNode = thirdNodeList.item(j);
                    if (!thirdNode.getNodeName().equalsIgnoreCase("band")) continue;
                    String bandId = thirdNode.getAttributes().getNamedItem("id").getNodeValue();
                    bandList.add(bandId);
                }
            }
        }
        return bandList;
    }

    public static int getBandParity(int neid, int boardType, String bandId) {
        int parity = 0;
        Document doc = TEParseXMLFile.parseFile((String)(TEResourceManager.getPath() + TEGetFilePath.getFilePath((int)neid, (String)WORK_BAND_BY_BOARD_PATH)));
        if (doc != null) {
            NodeList firstNodeList = doc.getChildNodes();
            Node firstNode = firstNodeList.item(0);
            NodeList secondNodeList = firstNode.getChildNodes();
            int m = secondNodeList.getLength();
            for (int i = 0; i < m; ++i) {
                int bdType;
                Node secondNode = secondNodeList.item(i);
                if (!secondNode.getNodeName().equalsIgnoreCase("board") || (bdType = Integer.parseInt(secondNode.getAttributes().getNamedItem("type").getNodeValue())) != boardType) continue;
                NodeList thirdNodeList = secondNode.getChildNodes();
                boolean flag = false;
                int n = thirdNodeList.getLength();
                for (int j = 0; j < n; ++j) {
                    String waveBandId;
                    Node thirdNode = thirdNodeList.item(j);
                    if (!thirdNode.getNodeName().equalsIgnoreCase("band") || !(waveBandId = thirdNode.getAttributes().getNamedItem("id").getNodeValue()).equals(bandId)) continue;
                    parity = Integer.parseInt(thirdNode.getAttributes().getNamedItem("parity").getNodeValue());
                    flag = true;
                    break;
                }
                if (flag) break;
            }
        }
        return parity;
    }
}

