/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.oxc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEWaveLengthInfoStaticData;
import com.huawei.nglct.nemgr.tl1ngwdm.config.oxc.TEOXCUsedWaveAndPort;
import com.huawei.nglct.nemgr.tl1ngwdm.config.oxc.TEWDMOXCCommon;
import com.huawei.nglct.nemgr.tl1ngwdm.config.oxc.WaveLengthComparetor;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEWDMGetUnusedWaveLengthNoListBean
extends TETL1NEExplorerBean {
    private static final int ALL_PARITY = 0;
    private static final int ODD_PARITY = 1;
    private static final int EVEN_PARITY = 2;
    private static final int ALL_PARITY_PLUS = 3;
    private static final int ODD_PARITY_PLUS = 4;
    private static final int EVEN_PARITY_PLUS = 5;
    private static final int MAX_WAVELENGTH_NO = 80;
    private static final int MAX_WAVELENGTH_NO_DEFAULT = 1;
    private static final int MAX_WAVELENGTH_NO_PLUS = 96;
    private static final String DEFAULT_WAVLENGTH = "2/1529.55/196.000";
    private Set usedWaveLengthNoSet = new LinkedHashSet();
    private TEWaveLengthInfoStaticData waveLengthInfoStaticData = TEWaveLengthInfoStaticData.getInstance();
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private String cmdid = "";
    private String portexist = "";

    public boolean isNeedOperationlog() {
        return true;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        List waveLengthList;
        this.neid = neid;
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        int slotid = Integer.parseInt(rowParams.getParam("slotid").getValue());
        int boardType = this.mgr.getBoardType(neid, slotid);
        int oxcflag = Integer.parseInt(rowParams.getParam("oxcflag").getValue());
        int portid = Integer.parseInt(rowParams.getParam("portid").getValue());
        String bandid = rowParams.getParam("bandid").getValue();
        int srcFlag = Integer.parseInt(rowParams.getParam("srcflag").getValue());
        int srcslotid = -1;
        int sinkslotid = -1;
        int srcport = -1;
        int sinkport = -1;
        if (oxcflag == 1) {
            srcslotid = Integer.parseInt(rowParams.getParam("srcslotid").getValue());
            sinkslotid = Integer.parseInt(rowParams.getParam("sinkslotid").getValue());
            srcport = Integer.parseInt(rowParams.getParam("srcport").getValue());
            sinkport = Integer.parseInt(rowParams.getParam("sinkport").getValue());
        }
        if ((waveLengthList = this.getWaveLengthList(slotid, boardType, portid, bandid)) == null) {
            TELogFactory.getNormalLogger().error("Get Unused WaveLengthNo failed!", (Throwable)new Exception("Get Unused WaveLengthNo failed!"));
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            return this.outputData;
        }
        if (waveLengthList.size() > 0) {
            for (TEOXCUsedWaveAndPort tempOxcObj : this.usedWaveLengthNoSet) {
                int waveNo = tempOxcObj.getWaveLenNO();
                if (!this.isFilterWaveNo(tempOxcObj, srcslotid, srcport, sinkslotid, sinkport, srcFlag, this.usedWaveLengthNoSet)) continue;
                String wavelength = this.waveLengthInfoStaticData.getNumberWaveLengthFrequency(1, waveNo);
                waveLengthList.remove(wavelength);
            }
        }
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        RowParams newRowParams = new RowParams();
        Collections.sort(waveLengthList, new WaveLengthComparetor());
        if (waveLengthList.size() > 0) {
            String unusedWaveLength = (String)waveLengthList.get(0);
            Param param = new Param("wavelength", unusedWaveLength);
            int m = waveLengthList.size();
            for (int j = 1; j < m; ++j) {
                unusedWaveLength = (String)waveLengthList.get(j);
                Option option = new Option(unusedWaveLength);
                param.addOption(option);
            }
            newRowParams.addParam(param);
        }
        outputData.getBussinessParams().addRowParams(newRowParams);
        return outputData;
    }

    private boolean isFilterWaveNo(TEOXCUsedWaveAndPort curWaveAndPort, int srcSlotID, int srcPort, int sinkSlotID, int sinkPort, int srcFlag, Set usedWaveLengthNo) {
        int bdtype;
        Map boardCast = TEWDMOXCCommon.getBoardcastPort(this.neid);
        if (boardCast.get((bdtype = this.mgr.getBoardType(this.neid, sinkSlotID)) + "") == null) {
            return true;
        }
        if (srcFlag == 0) {
            int counter = 0;
            boolean isBoardcastPort = false;
            ArrayList portlist = (ArrayList)boardCast.get(bdtype + "");
            int boardcastsize = portlist.size();
            for (int i = 0; i < boardcastsize; ++i) {
                int port = Integer.parseInt(portlist.get(i).toString());
                if (port != sinkPort) continue;
                isBoardcastPort = true;
                break;
            }
            if (isBoardcastPort) {
                for (TEOXCUsedWaveAndPort tempWaveAndP : usedWaveLengthNo) {
                    if (tempWaveAndP.getSrcSlotID() != srcSlotID || tempWaveAndP.getSrcPortID() != srcPort || tempWaveAndP.getSinkSlotID() != sinkSlotID || tempWaveAndP.getWaveLenNO() != curWaveAndPort.getWaveLenNO()) continue;
                    ++counter;
                }
                if (counter < boardcastsize) {
                    return false;
                }
            }
        } else if (srcFlag == 1) {
            return true;
        }
        return true;
    }

    private List getOCHWaveinfo(int neid, int slotid, int portid) {
        ArrayList<String> waveLengthInfoList = new ArrayList<String>();
        waveLengthInfoList.add(DEFAULT_WAVLENGTH);
        if (!this.portexist.equalsIgnoreCase("true")) {
            return waveLengthInfoList;
        }
        String cmdvar = "RTRV-OCH";
        try {
            ArrayList<TL1Operation> clntOperList = new ArrayList<TL1Operation>();
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            TL1Operation operation = definitions.getTL1Operation(cmdvar);
            String aid = TETL1CommonUtil.getAIDFromPort((int)neid, (String)(slotid + ""), (String)(portid + ""), (String)"");
            operation.getInMsg().getStagBlock().getAID().getPart(0).setValue(aid);
            clntOperList.add(operation);
            int result = this.sendMessage(neid, clntOperList);
            if (result == 0) {
                if (clntOperList != null && clntOperList.size() > 0) {
                    operation = (TL1Operation)clntOperList.get(0);
                    if (!operation.getOutMsg(0).getFault().getErrDesc().equals("")) {
                        return waveLengthInfoList;
                    }
                    String workbandtype = operation.getOutMsg(0).getMsgBlock().getPart("BANDTYPE").getValue();
                    String workwvinfo = operation.getOutMsg(0).getMsgBlock().getPart("WVNUM").getValue();
                    if (workbandtype != null && !workbandtype.equals("") && workwvinfo != null && !workwvinfo.equals("")) {
                        int bdtype = 1;
                        if (workbandtype.equalsIgnoreCase("CBAND")) {
                            bdtype = 1;
                        } else if (workbandtype.equalsIgnoreCase("CWDMBAND")) {
                            bdtype = 6;
                        }
                        waveLengthInfoList.clear();
                        String wvinfo = this.waveLengthInfoStaticData.getNumberWaveLengthFrequency(bdtype, Integer.parseInt(workwvinfo));
                        waveLengthInfoList.add(wvinfo);
                    }
                    return waveLengthInfoList;
                }
                return waveLengthInfoList;
            }
            return waveLengthInfoList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOCHWaveinfo Exception!");
            return waveLengthInfoList;
        }
    }

    private int getBandParity(int neid, int slotid, int portid) {
        int parity = 2;
        String cmdvar = "RTRV-WDM";
        try {
            ArrayList<TL1Operation> clntOperList = new ArrayList<TL1Operation>();
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            if (!this.portexist.equalsIgnoreCase("true")) {
                portid = 1;
            }
            TL1Operation operation = definitions.getTL1Operation(cmdvar);
            String aid = TETL1CommonUtil.getAIDFromPort((int)neid, (String)(slotid + ""), (String)(portid + ""), (String)"");
            operation.getInMsg().getStagBlock().getAID().getPart(0).setValue(aid);
            clntOperList.add(operation);
            int result = this.sendMessage(neid, clntOperList);
            if (result == 0) {
                if (clntOperList != null && clntOperList.size() > 0) {
                    operation = (TL1Operation)clntOperList.get(0);
                    if (!operation.getOutMsg(0).getFault().getErrDesc().equals("")) {
                        return 2;
                    }
                    String workbandtype = operation.getOutMsg(0).getMsgBlock().getPart("PROWORKBAND").getValue();
                    if (workbandtype == null || workbandtype.equals("")) {
                        return 2;
                    }
                    return this.getRtrvWdmParity(workbandtype);
                }
                return 2;
            }
            return 2;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEWDMGetUnusedWaveLengthNoListBean.getBandParity() fail!", (Throwable)e);
            return parity;
        }
    }

    private int getRtrvWdmParity(String workbandtype) {
        int parity = 0;
        if (workbandtype.equalsIgnoreCase("C-ALL")) {
            parity = 0;
            return parity;
        }
        if (workbandtype.equalsIgnoreCase("C-ODD")) {
            parity = 1;
            return parity;
        }
        if (workbandtype.equalsIgnoreCase("C-EVEN")) {
            parity = 2;
            return parity;
        }
        if (workbandtype.equalsIgnoreCase("CPLUS-ALL")) {
            parity = 3;
            return parity;
        }
        if (workbandtype.equalsIgnoreCase("CPLUS-ODD")) {
            parity = 4;
            return parity;
        }
        if (workbandtype.equalsIgnoreCase("CPLUS-EVEN")) {
            parity = 5;
            return parity;
        }
        return parity;
    }

    private List getWaveLengthList(int slotid, int boardType, int portid, String bandid) {
        List<String> waveLengthList = null;
        int parity = 2;
        String cmdidvar = TEWDMOXCCommon.getFindWaveBandCmd(this.neid, boardType, portid);
        this.portexist = cmdidvar.split("-")[0];
        this.cmdid = cmdidvar.split("-")[1];
        if (1542 == boardType && portid == 1) {
            HashSet<Integer> slotIDSet = new HashSet<Integer>();
            slotIDSet.add(slotid);
            this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)this.neid, slotIDSet);
            String mode2 = "";
            mode2 = this.aidAndTypeList.getMod2(this.neid, slotid, portid);
            if (mode2.indexOf("WDM") != -1) {
                waveLengthList = this.waveLengthInfoStaticData.getWaveLengthInfoList(1, 0, 80);
                return waveLengthList;
            }
        }
        if (this.cmdid.equals("60000")) {
            parity = this.getBandParity(this.neid, slotid, portid);
        } else {
            if (this.cmdid.equals("60001") && this.portexist.equals("false")) {
                waveLengthList = this.waveLengthInfoStaticData.getWaveLengthInfoList(1, parity, 1);
                return waveLengthList;
            }
            if (this.cmdid.equals("60001") && this.portexist.equals("true")) {
                waveLengthList = this.getOCHWaveinfo(this.neid, slotid, portid);
                return waveLengthList;
            }
            if (this.cmdid.equals("60002")) {
                waveLengthList = this.waveLengthInfoStaticData.getWaveLengthInfoList(1, 0, 80);
                return waveLengthList;
            }
        }
        if (951 == boardType || 952 == boardType || 1091 == boardType) {
            waveLengthList = this.waveLengthInfoStaticData.getWaveLengthInfoList(1, 0, 80);
        } else if (1119 == boardType) {
            int bandRang = 80;
            waveLengthList = this.waveLengthInfoStaticData.getWaveLengthInfoList(1, 0, bandRang);
        } else if (60027 == boardType && portid >= 6) {
            int tempwvno = 0;
            tempwvno = parity == 1 ? (portid - 5) * 2 - 1 : portid * 2 - 10;
            String wavelen = TEWaveLengthInfoStaticData.getInstance().getWaveLengthInfo(1, tempwvno);
            String wavefre = TEWaveLengthInfoStaticData.getInstance().getFrequency(1, tempwvno);
            String tempwvleninfo = tempwvno + "/" + wavelen + "/" + wavefre;
            waveLengthList = new ArrayList<String>();
            waveLengthList.add(tempwvleninfo);
        } else {
            waveLengthList = parity == 3 ? this.waveLengthInfoStaticData.getWaveLengthInfoList(1, 0, 96) : (parity == 4 ? this.waveLengthInfoStaticData.getWaveLengthInfoList(1, 1, 96) : (parity == 5 ? this.waveLengthInfoStaticData.getWaveLengthInfoList(1, 2, 96) : this.waveLengthInfoStaticData.getWaveLengthInfoList(1, parity, 80)));
        }
        return waveLengthList;
    }
}

