/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.oxc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallCPPortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nelist.model.circuitpack.TESDCircuitPackRecord;
import com.huawei.nglct.nemgr.tl1ngwdm.config.oxc.TEEdgePortData;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TEWDMGetOXCEdgePortBean
extends TETL1NEExplorerBean {
    private final List edgePointList = new ArrayList();
    private static final String IN_DIRECTION = "DISABLE";
    private static final String OUT_DIRECTION = "ENABLE";
    private static final String NULL_QUERY = "38662";
    private static final int PUS_IDLE = 0;
    private static final int PUS_SOURCE_USED = 2;
    private static final int PUS_SINK_USED = 3;
    private static final String splitSign = "/";

    public boolean isNeedOperationlog() {
        return true;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(new Integer(NULL_QUERY));
        return codeList;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Option option;
        String edge_port;
        RowParams[] rowParamses;
        super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        if (2 == errorCode) {
            return this.outputData;
        }
        TEConfigurationDataMgr confData = TEConfigurationDataMgr.getInstance();
        TENE ne = TENEListUtils.getNEObj((int)neid);
        ArrayList<TEEdgePortData> fixedEdgePointList = new ArrayList<TEEdgePortData>();
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        if (bussinessParams != null && (rowParamses = bussinessParams.getRowParams()) != null && rowParamses.length > 0) {
            int m = rowParamses.length;
            for (int i = 0; i < m; ++i) {
                int slotId = Integer.parseInt(rowParamses[i].getParam("Slot").getValue());
                int portId = Integer.parseInt(rowParamses[i].getParam("Port").getValue());
                String inattr = rowParamses[i].getParam("inPort").getValue();
                String outattr = rowParamses[i].getParam("outPort").getValue();
                TEEdgePortData edgePort = null;
                TEBoard board = ne.getBoard(slotId);
                if (board == null) continue;
                int boardType = board.getBoardType();
                TEPortParaRecord portPara = confData.getPortParaRecord(neid, boardType, portId);
                if (null != portPara) {
                    edgePort = new TEEdgePortData(slotId, portId, inattr, outattr);
                    if (portPara.inName != null) {
                        edgePort.setPortName(portPara.inName);
                    }
                    if (portPara.outName != null) {
                        String renPortName = "";
                        renPortName = edgePort.getPortName() != null && !edgePort.getPortName().equals("") ? edgePort.getPortName() + splitSign + portPara.outName : portPara.outName;
                        edgePort.setPortName(renPortName);
                    }
                }
                if (null == edgePort) continue;
                if (this.isFixedEdgePoint(neid, boardType, edgePort.getPortID())) {
                    fixedEdgePointList.add(edgePort);
                    continue;
                }
                this.edgePointList.add(edgePort);
            }
        }
        this.tl1OperList.clear();
        this.removePortUsedByFiber();
        ArrayList<TEEdgePortData> selectPointList = new ArrayList<TEEdgePortData>();
        if (this.edgePointList.size() > 0) {
            for (int t = this.edgePointList.size() - 1; t >= 0; --t) {
                TEEdgePortData edgePort = (TEEdgePortData)this.edgePointList.get(t);
                int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, edgePort.getSlotID());
                TESDCircuitPackRecord boardTypePro = TEConfigurationDataMgr.getInstance().getBoardTypeProperty(neid, boardType);
                TEInstallCPPortRecord portPro = boardTypePro.getPortProperty(edgePort.getPortID());
                int portUsage = portPro.getPortUsage();
                if (portUsage == 0) {
                    if (!edgePort.getInattr().equalsIgnoreCase(IN_DIRECTION) || !edgePort.getOutattr().equalsIgnoreCase(IN_DIRECTION)) continue;
                    selectPointList.add(edgePort);
                    this.edgePointList.remove(t);
                    continue;
                }
                if (portUsage == 2) {
                    if (edgePort.getInattr().equalsIgnoreCase(IN_DIRECTION) && edgePort.getOutattr().equalsIgnoreCase(OUT_DIRECTION)) continue;
                    selectPointList.add(edgePort);
                    this.edgePointList.remove(t);
                    continue;
                }
                if (portUsage != 3 || edgePort.getInattr().equalsIgnoreCase(OUT_DIRECTION) && edgePort.getOutattr().equalsIgnoreCase(IN_DIRECTION)) continue;
                selectPointList.add(edgePort);
                this.edgePointList.remove(t);
            }
        }
        Datainterface output = new Datainterface();
        output.setBussinessParams(new BussinessParams());
        RowParams rowparams = new RowParams();
        if (fixedEdgePointList.size() > 0) {
            Param param = new Param("fixed", "");
            int n = fixedEdgePointList.size();
            for (int k = 0; k < n; ++k) {
                TEEdgePortData edgePort = (TEEdgePortData)fixedEdgePointList.get(k);
                TEBoard board = ne.getBoard(edgePort.getSlotID());
                if (board == null) {
                    TELogFactory.getNormalLogger().info("[TEWDMGetOXCEdgePortBean] board is null.");
                    continue;
                }
                int boardType = board.getBoardType();
                String nmShelfSlot = TETL1CommonUtil.getShelfSlotName((int)neid, (int)edgePort.getSlotID());
                edge_port = edgePort.getSlotID() + "-" + confData.getBoardTypeName(neid, boardType) + "-" + edgePort.getPortID() + "(" + edgePort.getPortName() + ")" + "[" + nmShelfSlot;
                if ("".equals(param.getValue())) {
                    param.setValue(edge_port);
                    continue;
                }
                option = new Option(edge_port);
                param.addOption(option);
            }
            rowparams.addParam(param);
            fixedEdgePointList.clear();
        }
        if (selectPointList.size() > 0) {
            Param param = new Param("select", "");
            for (int k = selectPointList.size() - 1; k >= 0; --k) {
                TEEdgePortData edgePort = (TEEdgePortData)selectPointList.get(k);
                TEBoard board = ne.getBoard(edgePort.getSlotID());
                if (board == null) {
                    TELogFactory.getNormalLogger().info("[TEWDMGetOXCEdgePortBean] board is null.");
                    continue;
                }
                int boardType = board.getBoardType();
                String nmShelfSlot = TETL1CommonUtil.getShelfSlotName((int)neid, (int)edgePort.getSlotID());
                String edge_port2 = edgePort.getSlotID() + "-" + confData.getBoardTypeName(neid, boardType) + "-" + edgePort.getPortID() + "(" + edgePort.getPortName() + ")" + "[" + nmShelfSlot;
                if ("".equals(param.getValue())) {
                    param.setValue(edge_port2);
                    continue;
                }
                Option option2 = new Option(edge_port2);
                param.addOption(option2);
            }
            rowparams.addParam(param);
            selectPointList.clear();
        }
        if (this.edgePointList.size() > 0) {
            Param param = new Param("selected", "");
            int n = this.edgePointList.size();
            for (int k = 0; k < n; ++k) {
                TEEdgePortData edgePort = (TEEdgePortData)this.edgePointList.get(k);
                TEBoard board = ne.getBoard(edgePort.getSlotID());
                if (board == null) {
                    TELogFactory.getNormalLogger().info("[TEWDMGetOXCEdgePortBean] board is null.");
                    continue;
                }
                int boardType = board.getBoardType();
                String nmShelfSlot = TETL1CommonUtil.getShelfSlotName((int)neid, (int)edgePort.getSlotID());
                edge_port = edgePort.getSlotID() + "-" + confData.getBoardTypeName(neid, boardType) + "-" + edgePort.getPortID() + "(" + edgePort.getPortName() + ")" + "[" + nmShelfSlot;
                if ("".equals(param.getValue())) {
                    param.setValue(edge_port);
                    continue;
                }
                option = new Option(edge_port);
                param.addOption(option);
            }
            rowparams.addParam(param);
            this.edgePointList.clear();
        }
        output.getBussinessParams().addRowParams(rowparams);
        ErrorMessage error = this.outputData.getErrorMessage();
        output.setErrorMessage(error);
        return output;
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap) {
        if (oldParam.getName().equalsIgnoreCase("Slot")) {
            Part AID2 = (Part)partmap.get("AID");
            int slotidd = TETL1CommonUtil.getNMSlotStr((String)AID2.getValue(), (int)this.neid);
            oldParam.setValue(slotidd + "");
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("Port")) {
            Part AID3 = (Part)partmap.get("AID");
            int portNO = TETL1CommonUtil.getNMPortNOFromAidStruct((String)AID3.getValue(), (int)this.neid);
            oldParam.setValue(portNO + "");
            return oldParam;
        }
        oldParam = super.convertParamValue(oldParam, partmap);
        return oldParam;
    }

    private boolean isFixedEdgePoint(int neid, int boardType, int portid) {
        if ((boardType == 2213 || boardType == 2430 || boardType == 1542) && portid == 1) {
            return false;
        }
        if (boardType == 2282 && portid == 1) {
            return true;
        }
        int wdmFunType = TEConfigurationDataMgr.getInstance().getWDMFunType(neid, boardType);
        return wdmFunType == 2048 || wdmFunType == 4 || wdmFunType == 16;
    }

    private void resetEdgePointAttr(int slotId, int portId, String inOrout) {
        if (this.edgePointList.size() > 0) {
            for (int i = this.edgePointList.size() - 1; i >= 0; --i) {
                TEEdgePortData edgePort = (TEEdgePortData)this.edgePointList.get(i);
                if (edgePort.getSlotID() != slotId || edgePort.getPortID() != portId) continue;
                this.edgePointList.remove(i);
                break;
            }
        }
    }

    private void removePortUsedByFiber() {
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TL1Operation operation = definitions.getTL1Operation("RTRV-FIBER");
            this.tl1OperList.add(operation);
            int result = this.sendMessage(this.neid, this.tl1OperList);
            if (result == 0 && !this.tl1OperList.isEmpty()) {
                operation = (TL1Operation)this.tl1OperList.get(0);
                int m = operation.getOutMsgCount();
                for (int i = 0; i < m; ++i) {
                    OutMsg output = operation.getOutMsg(i);
                    boolean flag = false;
                    if (output.getFault().getCompletionCode() != 0 || !output.getFault().getErrCode().equals("") || !output.getFault().getErrDesc().equals("")) {
                        flag = true;
                    }
                    if (flag) continue;
                    int slotId = TETL1CommonUtil.getNMSlotStr((String)output.getMsgBlock().getPart("SRCPORT").getValue(), (int)this.neid);
                    int portId = TETL1CommonUtil.getNMPortNOFromAidStruct((String)output.getMsgBlock().getPart("SRCPORT").getValue(), (int)this.neid);
                    this.resetEdgePointAttr(slotId, portId, OUT_DIRECTION);
                    slotId = TETL1CommonUtil.getNMSlotStr((String)output.getMsgBlock().getPart("DSTPORT").getValue(), (int)this.neid);
                    portId = TETL1CommonUtil.getNMPortNOFromAidStruct((String)output.getMsgBlock().getPart("DSTPORT").getValue(), (int)this.neid);
                    this.resetEdgePointAttr(slotId, portId, IN_DIRECTION);
                }
                this.tl1OperList.clear();
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
    }

    protected boolean isFilterRowData(HashMap partmap) {
        Part AID2 = (Part)partmap.get("AID");
        if (AID2 == null || AID2.getValue() == null) {
            return true;
        }
        String aidarr = AID2.getValue();
        int tempNmSlotid = TETL1CommonUtil.getNMSlotStr((String)aidarr, (int)this.neid);
        int tempBdType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, tempNmSlotid);
        int tempegport = TETL1CommonUtil.getNMPortNOFromAidStruct((String)aidarr, (int)this.neid);
        return tempBdType == -1 || tempBdType == 60028 || tempBdType == 60032 || tempBdType == 1542 && tempegport == 1 || tempBdType == 60003 && tempegport == 3;
    }
}

