/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.oxc;

import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class TEPrintSingleStationOxcBean
extends TETL1NEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String STRING_SOURCE = "res" + File.separator + "stringresource_" + LANGUAGE + ".ini";
    private static final int FIND_NULL_ERROR_CODE = 38662;
    private static final String E2ESTR = "E2E";
    private static final int SLOTIDPOS = 1;
    private static final int PORTIDPOS = 2;
    private static final int WAVELENPOS = 3;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TL1Operation tl1Oper = null;
        if (operationList == null || operationList.size() == 0) {
            this.outputData = null;
            return;
        }
        tl1Oper = (TL1Operation)operationList.get(0);
        for (int i = tl1Oper.getOutMsgCount() - 1; i >= 0; --i) {
            OutMsg output = tl1Oper.getOutMsg(i);
            if (output.getMsgBlock().getPart("CRSTYPE").getValue().equals(E2ESTR)) continue;
            tl1Oper.removeOutMsg(output);
        }
        super.handleMessage(neid, this.tl1OperList, subfunc, filterErrorCodeList);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(38662);
        return errorCodeList;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap) {
        Param param1 = super.convertParamValue(oldParam, partmap);
        if (param1.getName().equalsIgnoreCase("srcSlot")) {
            Part part = (Part)partmap.get("FROM");
            if (part != null) {
                String[] strArr = part.getValue().split("-");
                int slotid = Integer.parseInt(strArr[1]);
                String boardName = this.getBoardName(slotid);
                param1.setValue(slotid + "-" + boardName);
            }
            return param1;
        }
        if (param1.getName().equalsIgnoreCase("srcPort")) {
            Part part = (Part)partmap.get("FROM");
            if (part != null) {
                String[] strArr = part.getValue().split("-");
                int slotid = Integer.parseInt(strArr[1]);
                int portid = Integer.parseInt(strArr[2]);
                param1.setValue(this.getPortName(slotid, portid));
            }
            return param1;
        }
        if (param1.getName().equalsIgnoreCase("srcBand")) {
            Part part = (Part)partmap.get("BANDTYPE");
            if (part != null) {
                param1.setValue(part.getValue());
            }
            return param1;
        }
        if (param1.getName().equalsIgnoreCase("srcWaveLenNO")) {
            String[] strArr;
            String wavelenStr;
            Part part = (Part)partmap.get("FROM");
            if (part != null && (wavelenStr = (strArr = part.getValue().split("-"))[3]) != null) {
                param1.setValue(wavelenStr);
            }
            return param1;
        }
        if (param1.getName().equalsIgnoreCase("sinkSlot")) {
            Part part = (Part)partmap.get("TO");
            if (part != null) {
                String[] strArr = part.getValue().split("-");
                int slotid = Integer.parseInt(strArr[1]);
                param1.setValue(slotid + "-" + this.getBoardName(slotid));
            }
            return param1;
        }
        if (param1.getName().equalsIgnoreCase("sinkPort")) {
            Part part = (Part)partmap.get("TO");
            if (part != null) {
                String[] strArr = part.getValue().split("-");
                int slotid = Integer.parseInt(strArr[1]);
                int portid = Integer.parseInt(strArr[2]);
                param1.setValue(this.getPortName(slotid, portid));
            }
            return param1;
        }
        if (param1.getName().equalsIgnoreCase("sinkBand")) {
            Part part = (Part)partmap.get("BANDTYPE");
            if (part != null) {
                param1.setValue(part.getValue());
            }
            return param1;
        }
        if (param1.getName().equalsIgnoreCase("sinkWaveLenNO")) {
            Part part = (Part)partmap.get("TO");
            if (part != null) {
                String[] strArr = part.getValue().split("-");
                String wavelenStr = strArr[3];
                param1.setValue(wavelenStr);
            }
            return param1;
        }
        if (param1.getName().equalsIgnoreCase("CCT")) {
            Part part = (Part)partmap.get("CCT");
            if (part != null) {
                param1.setValue(this.getDirection(part.getValue()));
            }
            return param1;
        }
        if (param1.getName().equalsIgnoreCase("SST")) {
            Part part = (Part)partmap.get("SST");
            if (part != null) {
                param1.setValue(this.getRedLine(part.getValue()));
            }
            return param1;
        }
        return param1;
    }

    private String getBoardName(int slotid) {
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
        return TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
    }

    private String getPortName(int slotid, int portid) {
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
        return TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotid, boardtype, portid);
    }

    private String getRedLine(String sst) {
        String sstName = "";
        sstName = sst.equals("RDLD") ? "Yes" : "No";
        return sstName;
    }

    private String getDirection(String directionStr) {
        String directionName = "";
        directionName = directionStr.equals("1WAY") ? this.getResource("singledirection") : this.getResource("bidirection");
        return directionName;
    }

    private String getResource(String str) {
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)STRING_SOURCE);
        String string = resourceUtil.getString(str);
        return string;
    }
}

