/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.opticalpower;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmConfigDataMgr;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmMOD2Struct;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class TETL1QueryOpticalPowerInputTHBean
extends TETL1NEExplorerBean {
    private static final String DWDMTL1_ATTROPTPWR_INPUTDOWNTH = "DWDMTL1_ATTROPTPWR_INPUTDOWNTHRANGE";
    private static final String DWDMTL1_ATTROPTPWR_INPUTUPTH = "DWDMTL1_ATTROPTPWR_INPUTUPTHRANGE";
    private static final String DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH = "DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH";
    private static final String DWDMTL1_ATTROPTPWR_CFPINPUTUPTH = "DWDMTL1_ATTROPTPWR_CFPINPUTUPTH";
    private static final String TL1OPERCMD = "RTRV-ALMTHRNG-MOD2";
    private static final int OPERSUCC = 0;
    private static final int OPERFAIL = -1;
    private static final int BLOCKPART_INDEX = 0;
    private static final int DATABLOCK_INDEX = 1;
    private static final String MSGBLOCK_PARAM = "OPR";
    private static final String MSGBLOCK_PARAM_SPECIAL = "CFPOPR";
    private int slotID = -1;
    private int boardType = -1;
    private static Set<Integer> supportCFPBdTypeList = new HashSet<Integer>();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.curUser = user;
        this.curIpAddress = ipAddress;
        this.subfunc = subFunc;
        this.slotID = this.getCurSlotID(inputData);
        this.boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
        this.outputData = new Datainterface();
        int operResult = this.queryAidTypeList(inputData);
        if (-1 == operResult) {
            TELogFactory.getNormalLogger().error("RTRV-PORT Query Fail!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            return this.outputData;
        }
        List<TEGenCfgPortAttribute> supportPortList = this.getSupportPortList(DWDMTL1_ATTROPTPWR_INPUTUPTH, DWDMTL1_ATTROPTPWR_INPUTDOWNTH);
        supportPortList.addAll(this.getSupportPortList(DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH, DWDMTL1_ATTROPTPWR_CFPINPUTUPTH));
        this.tl1OperList = this.getTL1OpertaionList(supportPortList);
        if (null == this.tl1OperList || this.tl1OperList.isEmpty()) {
            BussinessParams businessParams = new BussinessParams();
            RowParams rowParams = new RowParams();
            rowParams.addParam("notSupport", "true");
            businessParams.addRowParams(rowParams);
            this.outputData.setBussinessParams(businessParams);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid, this.tl1OperList);
        if (result == 0) {
            this.handleResponseMessage(this.tl1OperList);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        this.printLog();
        return this.outputData;
    }

    private void handleResponseMessage(List tl1OperList) {
        this.cloneTL1OperationList.clear();
        RowParams rowparams = null;
        this.outputData.setBussinessParams(new BussinessParams());
        int size = tl1OperList.size();
        for (int i = 0; i < size; ++i) {
            TL1Operation tl1Operation = (TL1Operation)tl1OperList.get(i);
            if (tl1Operation.getOutMsgCount() == 0) {
                return;
            }
            OutMsg out = tl1Operation.getOutMsg(0);
            if (out.getFault().getCompletionCode() != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)2));
                tl1Operation.addCmdFault(out.getFault());
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
            }
            HashMap outMsgPartMap = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
            rowparams = this.createResponseRowParam(outMsgPartMap);
            if (out.getFault().getCompletionCode() != 0) {
                String temaid = tl1Operation.getInMsg().getStagBlock().getAID().getPart(0).getValue();
                rowparams = this.createErrRowParam(temaid);
            }
            if (rowparams != null) {
                this.outputData.getBussinessParams().addRowParams(rowparams);
            }
            this.cloneTL1OperationList.add(tl1Operation.clone());
        }
    }

    private RowParams createErrRowParam(String aid) {
        RowParams rowparams = new RowParams();
        rowparams.addParam("AID", aid);
        rowparams.addParam("UPTHMaxValue", "/");
        rowparams.addParam("UPTHMinValue", "/");
        rowparams.addParam("DOWNTHMaxValue", "/");
        rowparams.addParam("DOWNTHMinValue", "/");
        return rowparams;
    }

    private RowParams createResponseRowParam(Map outMsgPartMap) {
        RowParams rowparams = new RowParams();
        Part part = (Part)outMsgPartMap.get("AID");
        if (this.isInvalidPart(part)) {
            return null;
        }
        rowparams.addParam("AID", part.getValue());
        part = (Part)outMsgPartMap.get("OVERLOADUPTH");
        if (this.isInvalidPart(part)) {
            return null;
        }
        this.addParam(rowparams, "UPTHMaxValue", "CFPUPTHMaxValue", part.getValue());
        part = (Part)outMsgPartMap.get("OVERLOADDOWNTH");
        if (this.isInvalidPart(part)) {
            return null;
        }
        this.addParam(rowparams, "UPTHMinValue", "CFPUPTHMinValue", part.getValue());
        part = (Part)outMsgPartMap.get("DETECTUPTH");
        if (this.isInvalidPart(part)) {
            return null;
        }
        this.addParam(rowparams, "DOWNTHMaxValue", "CFPDOWNTHMaxValue", part.getValue());
        part = (Part)outMsgPartMap.get("DETECTDOWNTH");
        if (this.isInvalidPart(part)) {
            return null;
        }
        this.addParam(rowparams, "DOWNTHMinValue", "CFPDOWNTHMinValue", part.getValue());
        return rowparams;
    }

    private void addParam(RowParams rowparams, String attribute, String cfpAttribute, String value) {
        if (value.equals("INVALID")) {
            value = "/";
        }
        if (supportCFPBdTypeList.contains(this.boardType)) {
            rowparams.addParam(cfpAttribute, value);
        } else {
            rowparams.addParam(attribute, value);
        }
    }

    private boolean isInvalidPart(Part part) {
        if (part == null || part.getValue() == null) {
            TELogFactory.getNormalLogger().error("NE Data is Error!");
            return true;
        }
        return false;
    }

    private ArrayList<TL1Operation> getTL1OpertaionList(List<TEGenCfgPortAttribute> supportPortList) {
        ArrayList<TL1Operation> operList = new ArrayList<TL1Operation>();
        TL1Operation operation = this.getTL1Operation(TL1OPERCMD);
        if (null == operation) {
            return null;
        }
        int size = supportPortList.size();
        for (int i = 0; i < size; ++i) {
            TEGenCfgPortAttribute portAttribute = supportPortList.get(i);
            String curMod2 = this.getPortSupportMod2(portAttribute);
            TL1Operation curOpertion = this.createOpertion(operation, portAttribute, curMod2);
            operList.add(curOpertion);
        }
        return operList;
    }

    private boolean isInvalid(String curMod2) {
        if (curMod2 == null || curMod2.isEmpty()) {
            return true;
        }
        if (this.boardType == 2281) {
            return false;
        }
        if (curMod2.equalsIgnoreCase("CFP")) {
            return false;
        }
        return !curMod2.equalsIgnoreCase("OC") && !curMod2.equalsIgnoreCase("OCH");
    }

    private TL1Operation createOpertion(TL1Operation _opertion, TEGenCfgPortAttribute portAttribute, String curMod2) {
        TL1Operation curOpertion = (TL1Operation)_opertion.clone();
        TETL1CommonUtil.modifyMOD2((TL1Operation)curOpertion, (String)curMod2);
        int portID = portAttribute.getPort();
        int pathID = portAttribute.getPath();
        String aidValue = TETL1CommonUtil.combineAID((int)this.neid, (int)this.slotID, (int)portID, (int)pathID);
        InMsg inmsg = curOpertion.getInMsg();
        inmsg.getStagBlock().getAID().getPart(0).setValue(aidValue);
        if (supportCFPBdTypeList.contains(this.boardType)) {
            inmsg.getMsgBlock().getDataBlock(1).getPart(0).setValue(MSGBLOCK_PARAM_SPECIAL);
        } else {
            inmsg.getMsgBlock().getDataBlock(1).getPart(0).setValue(MSGBLOCK_PARAM);
        }
        return curOpertion;
    }

    private String getPortSupportMod2(TEGenCfgPortAttribute portAttribute) {
        TETL1PfmMOD2Struct mode2;
        ArrayList pfmMonObjIDs = TETL1PfmConfigDataMgr.getInstance().getPfmCPSupportMOD2(this.boardType);
        if (this.boardType == 2281) {
            mode2 = new TETL1PfmMOD2Struct("WDM", 3, 0);
            mode2.setAidPreFix("FAC");
            pfmMonObjIDs.add(mode2);
        }
        if (supportCFPBdTypeList.contains(this.boardType)) {
            mode2 = new TETL1PfmMOD2Struct("CFP", 3, 0);
            mode2.setAidPreFix("FAC");
            pfmMonObjIDs.add(mode2);
        }
        int portID = portAttribute.getPort();
        int pathID = portAttribute.getPath();
        ArrayList mod2List = this.aidAndTypeList.getActTypeMod2List(this.neid, this.slotID, portID, pathID);
        int size = pfmMonObjIDs.size();
        for (int i = 0; i < size; ++i) {
            TETL1PfmMOD2Struct mod2Struct = (TETL1PfmMOD2Struct)pfmMonObjIDs.get(i);
            if (!this.isSupportALMTHMod2(mod2Struct, portID, pathID) || !mod2List.contains(mod2Struct.getMod2Name())) continue;
            return mod2Struct.getMod2Name();
        }
        return null;
    }

    private boolean isSupportALMTHMod2(TETL1PfmMOD2Struct mod2Struct, int portID, int pathID) {
        return mod2Struct.getPortID() == portID && this.equalsPathID(mod2Struct.getPathID(), pathID) && !this.isInvalid(mod2Struct.getMod2Name());
    }

    private boolean equalsPathID(int pathID, int pathID2) {
        if (pathID == pathID2) {
            return true;
        }
        return pathID < 1 && pathID2 < 1;
    }

    private TL1Operation getTL1Operation(String operCmd) {
        TL1Definitions tl1definitions = null;
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
        }
        catch (MarshalException e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
        catch (ValidationException e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
        return tl1definitions.getTL1Operation(operCmd);
    }

    private int queryAidTypeList(Datainterface inputData) {
        this.slotIDList = this.getSlotIDFromInputDdata(inputData);
        if (!this.slotIDList.isEmpty()) {
            this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)this.neid, (HashSet)this.slotIDList);
            if (this.aidAndTypeList == null) {
                return -1;
            }
            if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                return -1;
            }
        }
        return 0;
    }

    private List<TEGenCfgPortAttribute> getSupportPortList(String dwdmtl1_attroptpwr_inputupth, String dwdmtl1_attroptpwr_inputdownth) {
        TEGenCfgAttribute attUpTH;
        ArrayList<TEGenCfgPortAttribute> list = new ArrayList<TEGenCfgPortAttribute>();
        TEGenCfgModel genCfgMode = TEGenCfgDataMgr.getGenCfgMode((int)this.boardType);
        TEGenCfgAttribute attrDownTH = genCfgMode.getAttrFromId(dwdmtl1_attroptpwr_inputupth);
        if (attrDownTH != null) {
            list.addAll(attrDownTH.getPortList());
        }
        if ((attUpTH = genCfgMode.getAttrFromId(dwdmtl1_attroptpwr_inputdownth)) != null) {
            ArrayList upTHPortList = attUpTH.getPortList();
            int size = upTHPortList.size();
            for (int i = 0; i < size; ++i) {
                TEGenCfgPortAttribute attribute = (TEGenCfgPortAttribute)upTHPortList.get(i);
                if (list.contains(attribute)) continue;
                list.add(attribute);
            }
        }
        return list;
    }

    private int getCurSlotID(Datainterface inputData) {
        Param param = inputData.getBussinessParams().getRowParams(0).getParam("slotid");
        if (param != null && param.getValue() != "undefined") {
            int slot = -1;
            try {
                slot = Integer.valueOf(param.getValue());
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Query Optical Power InputAlmThRange:slotid is error!", (Throwable)e);
            }
            return slot;
        }
        return -1;
    }

    static {
        supportCFPBdTypeList.add(2308);
        supportCFPBdTypeList.add(2313);
        supportCFPBdTypeList.add(2576);
        supportCFPBdTypeList.add(2836);
        supportCFPBdTypeList.add(2875);
    }
}

