/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.opticalpower;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmConfigDataMgr;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmMOD2Struct;
import com.huawei.nglct.nemgr.tl1ngwdm.config.opticalpower.OpticalPowerComparor;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class OpticalPowerQueryBean
extends TETL1NEExplorerBean {
    int slotID = -1;
    private int neType = -1;
    private static final String DWDMTL1_ATTROPTPWR_INPWR = "DWDMTL1_ATTROPTPWR_INPWR";
    private static final String DWDMTL1_ATTROPTPWR_INPUTDOWNTH = "DWDMTL1_ATTROPTPWR_INPUTDOWNTH";
    private static final String DWDMTL1_ATTROPTPWR_INPUTUPTH = "DWDMTL1_ATTROPTPWR_INPUTUPTH";
    private static final String DWDMTL1_ATTROPTPWR_OUTPWR = "DWDMTL1_ATTROPTPWR_OUTPWR";
    private static final String DWDMTL1_ATTROPTPWR_OUTPUTDOWNTH = "DWDMTL1_ATTROPTPWR_OUTPUTDOWNTH";
    private static final String DWDMTL1_ATTROPTPWR_OUTPUTUPTH = "DWDMTL1_ATTROPTPWR_OUTPUTUPTH";
    private static final String DWDMTL1_ATTROPTPWR_OPR_DNRANGEH = "DWDMTL1_ATTROPTPWR_OPR_DNRANGEH";
    private static final String DWDMTL1_ATTROPTPWR_OPR_DNRANGEL = "DWDMTL1_ATTROPTPWR_OPR_DNRANGEL";
    private static final String DWDMTL1_ATTROPTPWR_OPR_UPRANGEH = "DWDMTL1_ATTROPTPWR_OPR_UPRANGEH";
    private static final String DWDMTL1_ATTROPTPWR_OPR_UPRANGEL = "DWDMTL1_ATTROPTPWR_OPR_UPRANGEL";
    private static final String DWDMTL1_ATTROPTPWR_EXPOPT = "DWDMTL1_ATTROPTPWR_EXPOPT";
    private static final String DWDMTL1_ATTROPTPWR_EXPOPR = "DWDMTL1_ATTROPTPWR_EXPOPR";
    private static final String DWDMTL1_ATTRALMTH_OPR = "DWDMTL1_ATTRALMTH_OPR";
    private static final String DWDMTL1_ATTRALMTH_CFPOPR = "DWDMTL1_ATTRALMTH_CFPOPR";
    private static final String DWDMTL1_ATTRALMTH_AGOPR = "DWDMTL1_ATTRALMTH_AGOPR";
    private static final String DWDMTL1_ATTRALMTH_LSIOP = "DWDMTL1_ATTRALMTH_LSIOP";
    private static final String DWDMTL1_ATTRALMTH_OPT = "DWDMTL1_ATTRALMTH_OPT";
    private static final String DWDMTL1_ATTRALMTH_AGOPT = "DWDMTL1_ATTRALMTH_AGOPT";
    private static final String DWDMTL1_ATTRALMTH_LSOOP = "DWDMTL1_ATTRALMTH_LSOOP";
    private static final String DWDMTL1_ATTRALMTH_SUMIOP = "DWDMTL1_ATTRALMTH_SUMIOP";
    private static final String DWDMTL1_ATTRALMTH_SUMOOP = "DWDMTL1_ATTRALMTH_SUMOOP";
    private static final String DWDMTL1_ATTRALMTH_LSIOPRANGE = "DWDMTL1_ATTRALMTH_LSIOPRANGE";
    private static final String INVALIDVALUE = "3276.7";
    private static final String DWDMTL1_ATTROPTPWR_PEAK_INPOWER_CUR = "DWDMTL1_ATTROPTPWR_PEAK_INPOWER_CUR";
    private static final String DWDMTL1_ATTROPTPWR_VALLEY_INPOWER_CUR = "DWDMTL1_ATTROPTPWR_VALLEY_INPOWER_CUR";
    private String neVersion = "";

    public OpticalPowerQueryBean() {
        this.bQueryAidAndType = true;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            String slotinfo = inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
            TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
            this.neType = ne.getNEType();
            this.neVersion = ne.getHostVersion();
            if (this.bQueryAidAndType) {
                this.slotIDList = this.getSlotIDFromInputDdata(inputData);
                if (this.slotIDList.size() > 0) {
                    this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
                    if (this.aidAndTypeList == null) {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090650120));
                        return this.outputData;
                    }
                    if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                        BussinessParams bParams = new BussinessParams();
                        this.outputData.setBussinessParams(bParams);
                        RowParams rowparams = new RowParams();
                        bParams.addRowParams(rowparams);
                        Object[] slotIDArr = this.slotIDList.toArray();
                        for (int i = 0; i < slotIDArr.length; ++i) {
                            int slotID = (Integer)slotIDArr[i];
                            Fault fault = this.aidAndTypeList.getFaultInfo(slotID);
                            if (fault == null) continue;
                            TEBoard board = ne.getBoard(Integer.parseInt(slotinfo));
                            String errorCode = fault.getErrCode();
                            String errorinfo = fault.getErrDesc();
                            RowErrors rowError = new RowErrors();
                            ErrorMessage errorMessage = new ErrorMessage();
                            Param errorparam = null;
                            errorMessage.setErrorcode(errorCode);
                            errorMessage.setErrorinfo(errorinfo);
                            rowError.setErrorMessage(errorMessage);
                            errorparam = new Param("nename", ne.getNEName());
                            rowError.addParam(errorparam);
                            errorparam = new Param("boardname", slotinfo + "-" + board.getBoardName());
                            rowError.addParam(errorparam);
                            rowparams.addRowErrors(rowError);
                        }
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
                        return this.outputData;
                    }
                }
            }
            this.slotID = Integer.parseInt(slotinfo);
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
            ArrayList pfmMonObjIDs = TETL1PfmConfigDataMgr.getInstance().getPfmCPSupportMOD2(boardType);
            HashMap opticalHm = this.fillTL1OperList(neid, ne, boardType, pfmMonObjIDs);
            if (null == this.tl1OperList || this.tl1OperList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid, this.tl1OperList);
            if (result == 0) {
                this.handleMessage(neid, this.tl1OperList, subFunc, opticalHm);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, this.tl1OperList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private HashMap fillTL1OperList(int neid, TETL1NE ne, int boardType, ArrayList pfmMonObjIDs) throws FileNotFoundException, ValidationException, MarshalException {
        this.tl1OperList = new ArrayList();
        int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
        TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        HashMap<String, OpticalParam> opticalHm = new HashMap<String, OpticalParam>();
        if (bdtype == 2281) {
            TETL1PfmMOD2Struct mode2 = new TETL1PfmMOD2Struct("WDM", 3, 0);
            mode2.setAidPreFix("FAC");
            pfmMonObjIDs.add(mode2);
        }
        int n = pfmMonObjIDs.size();
        for (int i = 0; i < n; ++i) {
            ArrayList list;
            TETL1PfmMOD2Struct mod2Struct = (TETL1PfmMOD2Struct)pfmMonObjIDs.get(i);
            if (boardType == 60027 && mod2Struct.getPortID() == 4 && mod2Struct.getPathID() >= 1 || !(list = this.getCurMod2List(mod2Struct)).contains(mod2Struct.getMod2Name())) continue;
            String AIDStr = TETL1CommonUtil.getAIDFromPort((int)neid, (String)String.valueOf(this.slotID), (String)String.valueOf(mod2Struct.getPortID()), (String)"");
            if (mod2Struct.getPathID() != 0) {
                AIDStr = AIDStr + "-" + mod2Struct.getPathID();
            }
            OpticalParam opticalParam = new OpticalParam();
            opticalParam.setMod2(mod2Struct.getMod2Name());
            opticalParam.setAID(AIDStr);
            opticalParam.setNeID(neid);
            if (this.filterNotSupportPort(mod2Struct, bdtype) || !this.isEnableParam(opticalParam, boardType, mod2Struct.getPortID(), mod2Struct.getPathID())) continue;
            opticalHm.put(AIDStr, opticalParam);
            TL1Operation queryOper = null;
            InMsg input = null;
            if (ne.getNEType() != 66) {
                queryOper = definitions.getTL1Operation("RTRV-PM-MOD2");
                input = queryOper.getInMsg();
                input.getPart("AID").setValue(AIDStr);
                queryOper.setCmdCode("RTRV");
                queryOper.setMod1("PM");
                queryOper.setMod2(mod2Struct.getMod2Name());
                queryOper.setName("RTRV-PM-" + mod2Struct.getMod2Name());
                this.tl1OperList.add(queryOper);
            } else {
                queryOper = definitions.getTL1Operation("RTRV-PWR");
                input = queryOper.getInMsg();
                input.getPart("AID").setValue(AIDStr);
                queryOper.setCmdCode("RTRV");
                if (opticalParam.getDWDMTL1_ATTROPTPWR_INPWR().equals("/")) {
                    queryOper.setMod1("INPWR");
                    queryOper.setName("RTRV-INPWR");
                    this.tl1OperList.add(queryOper);
                }
                if (opticalParam.getDWDMTL1_ATTROPTPWR_OUTPWR().equals("/")) {
                    TL1Operation outqueryOper = (TL1Operation)queryOper.clone();
                    outqueryOper.setMod1("OUTPWR");
                    outqueryOper.setName("RTRV-OUTPWR");
                    this.tl1OperList.add(outqueryOper);
                }
            }
            TL1Operation queryThOper = null;
            queryThOper = ne.getNEType() == 66 ? definitions.getTL1Operation("RTRV-ALMTH-1800A") : definitions.getTL1Operation("RTRV-ALMTH-MOD2");
            TEGenCfgModel genCfgMode = TEGenCfgDataMgr.getGenCfgMode((int)boardType);
            String almInputType = this.getInputAlmthValue(genCfgMode, mod2Struct.getPortID(), mod2Struct.getPathID(), bdtype);
            if (!almInputType.equals("")) {
                TL1Operation queryThOperClone = (TL1Operation)queryThOper.clone();
                input = queryThOperClone.getInMsg();
                AIDStr = TETL1CommonUtil.getAIDFromPort((int)neid, (String)String.valueOf(this.slotID), (String)String.valueOf(mod2Struct.getPortID()), (String)"");
                if (mod2Struct.getPathID() != 0) {
                    AIDStr = AIDStr + "-" + mod2Struct.getPathID();
                }
                input.getPart("AID").setValue(AIDStr);
                input.getPart("ALMTHTYPE").setValue(almInputType);
                queryThOperClone.setCmdCode("RTRV");
                queryThOperClone.setMod1("ALMTH");
                queryThOperClone.setMod2(mod2Struct.getMod2Name());
                queryThOperClone.setName("RTRV-ALMTH-" + mod2Struct.getMod2Name());
                this.tl1OperList.add(queryThOperClone);
                if (almInputType.equals("CFPOPR")) {
                    opticalParam.setDWDMTL1_ATTROPTPWR_INPUTUPTH("-");
                    opticalParam.setDWDMTL1_ATTROPTPWR_INPUTDOWNTH("-");
                }
            } else {
                opticalParam.setDWDMTL1_ATTROPTPWR_INPUTUPTH("-");
                opticalParam.setDWDMTL1_ATTROPTPWR_INPUTDOWNTH("-");
            }
            if (66 == this.neType && TETL1CommonUtil.isNewNeVersion((int)this.neType, (String)this.neVersion)) {
                String lsiopRangeType = this.getLSIOPAlmthValue(genCfgMode, mod2Struct.getPortID(), mod2Struct.getPathID());
                if (!lsiopRangeType.equals("")) {
                    TL1Operation queryThOperClone = (TL1Operation)queryThOper.clone();
                    input = queryThOperClone.getInMsg();
                    AIDStr = TETL1CommonUtil.getAIDFromPort((int)neid, (String)String.valueOf(this.slotID), (String)String.valueOf(mod2Struct.getPortID()), (String)"");
                    if (mod2Struct.getPathID() != 0) {
                        AIDStr = AIDStr + "-" + mod2Struct.getPathID();
                    }
                    input.getPart("AID").setValue(AIDStr);
                    input.getPart("ALMTHTYPE").setValue(lsiopRangeType);
                    queryThOperClone.setCmdCode("RTRV");
                    queryThOperClone.setMod1("ALMTH");
                    queryThOperClone.setMod2(mod2Struct.getMod2Name());
                    queryThOperClone.setName("RTRV-ALMTH-" + mod2Struct.getMod2Name());
                    this.tl1OperList.add(queryThOperClone);
                } else {
                    opticalParam.setDWDMTL1_ATTROPTPWR_OPR_UPRANGEH("-");
                    opticalParam.setDWDMTL1_ATTROPTPWR_OPR_UPRANGEL("-");
                    opticalParam.setDWDMTL1_ATTROPTPWR_OPR_DNRANGEH("-");
                    opticalParam.setDWDMTL1_ATTROPTPWR_OPR_DNRANGEL("-");
                }
            } else {
                opticalParam.setDWDMTL1_ATTROPTPWR_OPR_UPRANGEH("-");
                opticalParam.setDWDMTL1_ATTROPTPWR_OPR_UPRANGEL("-");
                opticalParam.setDWDMTL1_ATTROPTPWR_OPR_DNRANGEH("-");
                opticalParam.setDWDMTL1_ATTROPTPWR_OPR_DNRANGEL("-");
            }
            String almType = this.getOutputAlmthValue(genCfgMode, mod2Struct.getPortID(), mod2Struct.getPathID());
            if (!almType.equals("")) {
                TL1Operation queryOUTThOper = (TL1Operation)queryThOper.clone();
                AIDStr = TETL1CommonUtil.getAIDFromPort((int)neid, (String)String.valueOf(this.slotID), (String)String.valueOf(mod2Struct.getPortID()), (String)"");
                if (mod2Struct.getPathID() != 0) {
                    AIDStr = AIDStr + "-" + mod2Struct.getPathID();
                }
                InMsg OUTTh = queryOUTThOper.getInMsg();
                OUTTh.getPart("AID").setValue(AIDStr);
                OUTTh.getPart("ALMTHTYPE").setValue(almType);
                queryOUTThOper.setCmdCode("RTRV");
                queryOUTThOper.setMod1("ALMTH");
                queryOUTThOper.setMod2(mod2Struct.getMod2Name());
                queryOUTThOper.setName("RTRV-ALMTH-" + mod2Struct.getMod2Name());
                this.tl1OperList.add(queryOUTThOper);
            } else {
                opticalParam.setDWDMTL1_ATTROPTPWR_OUTPUTUPTH("-");
                opticalParam.setDWDMTL1_ATTROPTPWR_OUTPUTDOWNTH("-");
            }
            String exportAlm = this.getExportAlmthValue(genCfgMode, mod2Struct.getPortID(), mod2Struct.getPathID());
            if (!exportAlm.equals("") && TETL1CommonUtil.isNewNeVersion((int)ne.getNEType(), (String)ne.getHostVersion())) {
                TL1Operation exportOper = (TL1Operation)queryThOper.clone();
                input = exportOper.getInMsg();
                AIDStr = TETL1CommonUtil.getAIDFromPort((int)neid, (String)String.valueOf(this.slotID), (String)String.valueOf(mod2Struct.getPortID()), (String)"");
                if (mod2Struct.getPathID() != 0) {
                    AIDStr = AIDStr + "-" + mod2Struct.getPathID();
                }
                input.getPart("AID").setValue(AIDStr);
                input.getPart("ALMTHTYPE").setValue(exportAlm);
                exportOper.setCmdCode("RTRV");
                exportOper.setMod1("ALMTH");
                exportOper.setMod2(mod2Struct.getMod2Name());
                exportOper.setName("RTRV-ALMTH-" + mod2Struct.getMod2Name());
                this.tl1OperList.add(exportOper);
                continue;
            }
            opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPR_UPTH("-");
            opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH("-");
            opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPT_UPTH("-");
            opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH("-");
            opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPR("-");
            opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPT("-");
        }
        return opticalHm;
    }

    private boolean filterNotSupportPort(TETL1PfmMOD2Struct mod2Struct, int bdtype) {
        int portID = mod2Struct.getPortID();
        if (mod2Struct.getAidPreFix().equals("") || portID == 0) {
            return true;
        }
        if (bdtype == 1542 || bdtype == 2213 || bdtype == 2430 ? portID > 50 && (portID < 133 || portID > 144) : portID > 50) {
            return true;
        }
        if ((bdtype == 2889 || bdtype == 1149) && portID == 1) {
            return true;
        }
        return bdtype == 2318 && portID == 9;
    }

    private String getLSIOPAlmthValue(TEGenCfgModel genCfgMode, int port, int path) {
        TEGenCfgAttribute att = genCfgMode.getAttrFromId(DWDMTL1_ATTRALMTH_LSIOPRANGE);
        if (att != null && att.getPort(port, path == 0 ? -1 : path) != null) {
            return "LSIOPRANGE";
        }
        return "";
    }

    private String getInputAlmthValue(TEGenCfgModel genCfgMode, int port, int path, int boardType) {
        TEGenCfgAttribute att = genCfgMode.getAttrFromId(DWDMTL1_ATTRALMTH_AGOPR);
        if (att != null && att.getPort(port, path == 0 ? -1 : path) != null) {
            return "AGOPR";
        }
        att = genCfgMode.getAttrFromId(DWDMTL1_ATTRALMTH_OPR);
        if (att != null && att.getPort(port, path == 0 ? -1 : path) != null) {
            return "OPR";
        }
        att = genCfgMode.getAttrFromId(DWDMTL1_ATTRALMTH_CFPOPR);
        if (att != null && att.getPort(port, path == 0 ? -1 : path) != null) {
            return "CFPOPR";
        }
        att = genCfgMode.getAttrFromId(DWDMTL1_ATTRALMTH_LSIOP);
        if (att != null && att.getPort(port, path == 0 ? -1 : path) != null) {
            return "LSIOP";
        }
        att = genCfgMode.getAttrFromId(DWDMTL1_ATTRALMTH_SUMIOP);
        if (att != null && att.getPort(port, path == 0 ? -1 : path) != null) {
            return "SUMIOP";
        }
        return "";
    }

    private String getExportAlmthValue(TEGenCfgModel genCfgMode, int port, int path) {
        TEGenCfgAttribute att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_EXPOPR);
        if (att != null && att.getPort(port, path == 0 ? -1 : path) != null) {
            return "EXPOPR";
        }
        att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_EXPOPT);
        if (att != null && att.getPort(port, path == 0 ? -1 : path) != null) {
            return "EXPOPT";
        }
        return "";
    }

    private String getOutputAlmthValue(TEGenCfgModel genCfgMode, int port, int path) {
        TEGenCfgAttribute att = genCfgMode.getAttrFromId(DWDMTL1_ATTRALMTH_AGOPT);
        if (att != null && att.getPort(port, path == 0 ? -1 : path) != null) {
            return "AGOPT";
        }
        att = genCfgMode.getAttrFromId(DWDMTL1_ATTRALMTH_OPT);
        if (att != null && att.getPort(port, path == 0 ? -1 : path) != null) {
            return "OPT";
        }
        att = genCfgMode.getAttrFromId(DWDMTL1_ATTRALMTH_LSOOP);
        if (att != null && att.getPort(port, path == 0 ? -1 : path) != null) {
            return "LSOOP";
        }
        att = genCfgMode.getAttrFromId(DWDMTL1_ATTRALMTH_SUMOOP);
        if (att != null && att.getPort(port, path == 0 ? -1 : path) != null) {
            return "SUMOOP";
        }
        return "";
    }

    private boolean isEnableParam(OpticalParam opticalParam, int boardType, int port, int path) {
        TEGenCfgModel genCfgMode = TEGenCfgDataMgr.getGenCfgMode((int)boardType);
        TEGenCfgAttribute att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_INPWR);
        boolean isVisable = false;
        if (att == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_INPWR("/");
            isVisable = true;
        }
        if ((att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_INPUTDOWNTH)) == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_INPUTDOWNTH("/");
            isVisable = true;
        }
        if ((att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_INPUTUPTH)) == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_INPUTUPTH("/");
            isVisable = true;
        }
        if ((att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_OUTPWR)) == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_OUTPWR("/");
            isVisable = true;
        }
        isVisable = this.isPeakVisable(genCfgMode, port, path, opticalParam, isVisable);
        isVisable = this.isValleyVisable(genCfgMode, port, path, opticalParam, isVisable);
        att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_OUTPUTDOWNTH);
        if (att == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_OUTPUTDOWNTH("/");
            isVisable = true;
        }
        if ((att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_OUTPUTUPTH)) == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_OUTPUTUPTH("/");
            isVisable = true;
        }
        if ((att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_EXPOPT)) == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPT_UPTH("/");
            opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH("/");
            opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPT("/");
            isVisable = true;
        }
        if ((att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_EXPOPR)) == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPR_UPTH("/");
            opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH("/");
            opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPR("/");
            isVisable = true;
        }
        if ((att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_OPR_DNRANGEH)) == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_OPR_DNRANGEH("/");
            isVisable = true;
        }
        if ((att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_OPR_DNRANGEL)) == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_OPR_DNRANGEL("/");
            isVisable = true;
        }
        if ((att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_OPR_UPRANGEH)) == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_OPR_UPRANGEH("/");
            isVisable = true;
        }
        if ((att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_OPR_UPRANGEL)) == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_OPR_UPRANGEL("/");
            isVisable = true;
        }
        if ((att = genCfgMode.getAttrFromId(DWDMTL1_ATTRALMTH_CFPOPR)) == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH("/");
            opticalParam.setDWDMTL1_ATTROPTPWR_CFPINPUTUPTH("/");
            isVisable = true;
        }
        return isVisable;
    }

    private boolean isValleyVisable(TEGenCfgModel genCfgMode, int port, int path, OpticalParam opticalParam, boolean isVisable) {
        TEGenCfgAttribute att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_VALLEY_INPOWER_CUR);
        if (att == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_VALLEY_INPOWER_CUR("/");
            isVisable = true;
        }
        return isVisable;
    }

    private boolean isPeakVisable(TEGenCfgModel genCfgMode, int port, int path, OpticalParam opticalParam, boolean isVisable) {
        TEGenCfgAttribute att = genCfgMode.getAttrFromId(DWDMTL1_ATTROPTPWR_PEAK_INPOWER_CUR);
        if (att == null || att.getPort(port, path == 0 ? -1 : path) != null) {
            opticalParam.setDWDMTL1_ATTROPTPWR_PEAK_INPOWER_CUR("/");
            isVisable = true;
        }
        return isVisable;
    }

    private ArrayList getCurMod2List(TETL1PfmMOD2Struct mod2Struct) {
        ArrayList<String> list = new ArrayList<String>();
        int brdType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, this.slotID);
        if (brdType == 1262 || brdType == 1275) {
            list.add("OSC");
            return list;
        }
        int portID = mod2Struct.getPortID();
        int pathID = mod2Struct.getPathID();
        String facMod2 = "";
        facMod2 = pathID == 0 ? this.aidAndTypeList.getMod2(this.neid, this.slotID, portID) : this.aidAndTypeList.getMod2(this.neid, this.slotID, portID, pathID);
        if (!facMod2.equals("")) {
            StringTokenizer st = new StringTokenizer(facMod2, "|");
            while (st.hasMoreTokens()) {
                String modifier = st.nextToken();
                if (list.contains(modifier)) continue;
                list.add(modifier);
            }
        }
        return list;
    }

    private void handleMessage(int neid, ArrayList tl1OperList, SubFunc subFunc, HashMap opticalHm) {
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        RowErrors errorRowparams = null;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        int n = tl1OperList.size();
        for (int i = 0; i < n; ++i) {
            TL1Operation tl1Operation = (TL1Operation)tl1OperList.get(i);
            for (OutMsg out : tl1Operation.getOutMsg()) {
                HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
                Part aidPart = tl1Operation.getInMsg().getPart("AID");
                OpticalParam opticalParam = (OpticalParam)opticalHm.get(aidPart.getValue());
                if (opticalParam == null) {
                    opticalParam = new OpticalParam();
                    opticalParam.setMod2(tl1Operation.getMod2());
                    opticalParam.setAID(aidPart.getValue());
                    opticalHm.put(aidPart.getValue(), opticalParam);
                }
                if (out.getFault().getCompletionCode() != 0) {
                    String errorCode = out.getFault().getErrCode();
                    String errorinfo = out.getFault().getErrDesc();
                    ErrorMessage errorMessage = new ErrorMessage();
                    Param errorparam = null;
                    errorRowparams = new RowErrors();
                    errorMessage.setErrorcode(errorCode);
                    errorMessage.setErrorinfo(errorinfo);
                    errorRowparams.setErrorMessage(errorMessage);
                    String objectName = TETL1CommonUtil.getBoardStructFromAID((String)opticalParam.getAID(), (int)neid, (boolean)true);
                    String portID = String.valueOf(TETL1CommonUtil.getPortIDFromAID((String)opticalParam.getAID(), (int)neid));
                    errorparam = new Param("boardname", objectName);
                    errorRowparams.addParam(errorparam);
                    errorparam = new Param("portID", portID);
                    errorRowparams.addParam(errorparam);
                    errorDataList.add(errorRowparams);
                    tl1Operation.addCmdFault(out.getFault());
                    continue;
                }
                String aid = ((Part)hm.get("AID")).getValue();
                if (tl1Operation.getName().indexOf("RTRV-PM-") != -1) {
                    String monType = ((Part)hm.get("MONTYPE")).getValue();
                    String monVal = ((Part)hm.get("MONVAL")).getValue();
                    if (monType == null || !aid.equals(opticalParam.getAID())) continue;
                    if (monType.equals("LSIOPCUR") || monType.equals("LINEINPOWERCUR") || monType.equals("SUMIOPCUR") || monType.equals("AGOPRCUR") || monType.equals("OPRCUR") || monType.equals("VALLEYOPRCUR")) {
                        opticalParam.setDWDMTL1_ATTROPTPWR_INPWR(monVal);
                    } else if (monType.equals("LSOOPCUR") || monType.equals("LINEOUTPOWERCUR") || monType.equals("SUMOOPCUR") || monType.equals("AGOPTCUR") || monType.equals("OPTCUR") || monType.equals("VALLEYOPTCUR")) {
                        opticalParam.setDWDMTL1_ATTROPTPWR_OUTPWR(monVal);
                    }
                    if (monType.equals("VALLEYOPRCUR")) {
                        opticalParam.setDWDMTL1_ATTROPTPWR_VALLEY_INPOWER_CUR(monVal);
                        continue;
                    }
                    if (!monType.equals("PEAKOPRCUR")) continue;
                    opticalParam.setDWDMTL1_ATTROPTPWR_PEAK_INPOWER_CUR(monVal);
                    continue;
                }
                if (tl1Operation.getName().indexOf("RTRV-ALMTH-") != -1) {
                    String export;
                    if (!aid.equals(opticalParam.getAID())) continue;
                    String aidType = ((Part)hm.get("ALMTHTYPE")).getValue();
                    String upTh = ((Part)hm.get("UPTH")).getValue();
                    String downTh = ((Part)hm.get("DOWNTH")).getValue();
                    String upRangeH = "-";
                    String upRangeL = "-";
                    String downRangeH = "-";
                    String downRangeL = "-";
                    if (66 == this.neType && TETL1CommonUtil.isNewNeVersion((int)this.neType, (String)this.neVersion)) {
                        upRangeH = ((Part)hm.get("UPRANGEH")).getValue();
                        upRangeL = ((Part)hm.get("UPRANGEL")).getValue();
                        downRangeH = ((Part)hm.get("DNRANGEH")).getValue();
                        downRangeL = ((Part)hm.get("DNRANGEL")).getValue();
                    }
                    if (aidType != null && (aidType.equals("OPR") || aidType.equals("AGOPR") || aidType.equals("LSIOP") || aidType.equals("SUMIOP"))) {
                        opticalParam.setDWDMTL1_ATTROPTPWR_INPUTUPTH(this.getALMTHValue(upTh));
                        opticalParam.setDWDMTL1_ATTROPTPWR_INPUTDOWNTH(this.getALMTHValue(downTh));
                        continue;
                    }
                    if (aidType != null && aidType.equals("CFPOPR")) {
                        opticalParam.setDWDMTL1_ATTROPTPWR_CFPINPUTUPTH(this.getALMTHValue(upTh));
                        opticalParam.setDWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH(this.getALMTHValue(downTh));
                        continue;
                    }
                    if (aidType != null && aidType.equals("LSIOPRANGE")) {
                        opticalParam.setDWDMTL1_ATTROPTPWR_OPR_UPRANGEH(this.getALMTHValue(upRangeH));
                        opticalParam.setDWDMTL1_ATTROPTPWR_OPR_UPRANGEL(this.getALMTHValue(upRangeL));
                        opticalParam.setDWDMTL1_ATTROPTPWR_OPR_DNRANGEH(this.getALMTHValue(downRangeH));
                        opticalParam.setDWDMTL1_ATTROPTPWR_OPR_DNRANGEL(this.getALMTHValue(downRangeL));
                        continue;
                    }
                    if (aidType != null && (aidType.equals("OPT") || aidType.equals("LSOOP") || aidType.equals("AGOPT"))) {
                        opticalParam.setDWDMTL1_ATTROPTPWR_OUTPUTUPTH(this.getALMTHValue(upTh));
                        opticalParam.setDWDMTL1_ATTROPTPWR_OUTPUTDOWNTH(this.getALMTHValue(downTh));
                        continue;
                    }
                    if (aidType != null && aidType.equals("EXPOPR")) {
                        opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPR_UPTH(this.getALMTHValue(upTh));
                        opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH(this.getALMTHValue(downTh));
                        export = ((Part)hm.get("EXPPWR")).getValue();
                        opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPR(this.getALMTHValue(export));
                        continue;
                    }
                    if (aidType == null || !aidType.equals("EXPOPT")) continue;
                    opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPT_UPTH(this.getALMTHValue(upTh));
                    opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH(this.getALMTHValue(downTh));
                    export = ((Part)hm.get("EXPPWR")).getValue();
                    opticalParam.setDWDMTL1_ATTROPTPWR_EXPOPT(this.getALMTHValue(export));
                    continue;
                }
                if (tl1Operation.getName().indexOf("RTRV-INPWR") != -1) {
                    if (!aid.equals(opticalParam.getAID())) continue;
                    String inpower = ((Part)hm.get("INPWR")).getValue();
                    opticalParam.setDWDMTL1_ATTROPTPWR_INPWR(this.getALMTHValue(inpower));
                    continue;
                }
                if (tl1Operation.getName().indexOf("RTRV-OUTPWR") == -1 || !aid.equals(opticalParam.getAID())) continue;
                String outpower = ((Part)hm.get("OUTPWR")).getValue();
                opticalParam.setDWDMTL1_ATTROPTPWR_OUTPWR(this.getALMTHValue(outpower));
            }
        }
        List list = this.sortHashMap(opticalHm);
        this.convertOutputData(neid, list);
        this.outputData.setErrorMessage(new ErrorMessage());
        if (errorDataList.size() != 0) {
            this.sortErrorDataByBoardName(errorDataList, this.outputData);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        }
    }

    private void sortErrorDataByBoardName(List<RowErrors> errorDataList, Datainterface outputData) {
        RowErrors rowErrors = null;
        HashMap<Integer, RowErrors> mapTemp = new HashMap<Integer, RowErrors>();
        for (int i = errorDataList.size() - 1; i >= 0; --i) {
            rowErrors = errorDataList.get(i);
            mapTemp.put(Integer.parseInt(rowErrors.getParam("portID").getValue()), rowErrors);
        }
        ArrayList listTemp = new ArrayList();
        listTemp.addAll(mapTemp.keySet());
        Collections.sort(listTemp);
        RowParams rowparams = null;
        RowErrors errorRowparams = null;
        Param errorparam = null;
        Integer key = null;
        for (int i = listTemp.size() - 1; i >= 0; --i) {
            key = (Integer)listTemp.get(i);
            rowparams = new RowParams();
            errorRowparams = new RowErrors();
            errorparam = new Param("boardname", ((RowErrors)mapTemp.get(key)).getParam("boardname").getValue());
            errorRowparams.addParam(errorparam);
            errorRowparams.setErrorMessage(((RowErrors)mapTemp.get(key)).getErrorMessage());
            rowparams.addRowErrors(errorRowparams);
            outputData.getBussinessParams().addRowParams(rowparams);
        }
    }

    private void convertOutputData(int neid, List list) {
        Collections.sort(list);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            RowParams rowparams = new RowParams();
            OpticalParam opticalParam = (OpticalParam)list.get(i);
            rowparams.addParam(new Param("mod2", opticalParam.getMod2()));
            rowparams.addParam(new Param("neid", String.valueOf(neid)));
            rowparams.addParam(new Param("AID", opticalParam.getAID()));
            int nmPort = TETL1CommonUtil.getNMPortNOFromAidStruct((String)opticalParam.getAID(), (int)neid);
            rowparams.addParam(new Param("port", String.valueOf(nmPort)));
            rowparams.addParam(new Param(DWDMTL1_ATTROPTPWR_INPWR, opticalParam.getDWDMTL1_ATTROPTPWR_INPWR()));
            rowparams.addParam(new Param(DWDMTL1_ATTROPTPWR_OUTPWR, opticalParam.getDWDMTL1_ATTROPTPWR_OUTPWR()));
            rowparams.addParam(new Param(DWDMTL1_ATTROPTPWR_INPUTDOWNTH, opticalParam.getDWDMTL1_ATTROPTPWR_INPUTDOWNTH()));
            rowparams.addParam(new Param(DWDMTL1_ATTROPTPWR_INPUTUPTH, opticalParam.getDWDMTL1_ATTROPTPWR_INPUTUPTH()));
            rowparams.addParam(new Param(DWDMTL1_ATTROPTPWR_OUTPUTDOWNTH, opticalParam.getDWDMTL1_ATTROPTPWR_OUTPUTDOWNTH()));
            rowparams.addParam(new Param(DWDMTL1_ATTROPTPWR_OUTPUTUPTH, opticalParam.getDWDMTL1_ATTROPTPWR_OUTPUTUPTH()));
            rowparams.addParam(new Param("DWDMTL1_ATTROPTPWR_EXPOPR_UPTH", opticalParam.getDWDMTL1_ATTROPTPWR_EXPOPR_UPTH()));
            rowparams.addParam(new Param("DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH", opticalParam.getDWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH()));
            rowparams.addParam(new Param("DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH", opticalParam.getDWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH()));
            rowparams.addParam(new Param("DWDMTL1_ATTROPTPWR_EXPOPT_UPTH", opticalParam.getDWDMTL1_ATTROPTPWR_EXPOPT_UPTH()));
            rowparams.addParam(new Param(DWDMTL1_ATTROPTPWR_EXPOPT, opticalParam.getDWDMTL1_ATTROPTPWR_EXPOPT()));
            rowparams.addParam(new Param(DWDMTL1_ATTROPTPWR_EXPOPR, opticalParam.getDWDMTL1_ATTROPTPWR_EXPOPR()));
            rowparams.addParam(new Param(DWDMTL1_ATTROPTPWR_OPR_DNRANGEH, opticalParam.getDWDMTL1_ATTROPTPWR_OPR_DNRANGEH()));
            rowparams.addParam(new Param(DWDMTL1_ATTROPTPWR_OPR_DNRANGEL, opticalParam.getDWDMTL1_ATTROPTPWR_OPR_DNRANGEL()));
            rowparams.addParam(new Param(DWDMTL1_ATTROPTPWR_OPR_UPRANGEH, opticalParam.getDWDMTL1_ATTROPTPWR_OPR_UPRANGEH()));
            rowparams.addParam(new Param(DWDMTL1_ATTROPTPWR_OPR_UPRANGEL, opticalParam.getDWDMTL1_ATTROPTPWR_OPR_UPRANGEL()));
            rowparams.addParam(new Param("DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH", opticalParam.getDWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH()));
            rowparams.addParam(new Param("DWDMTL1_ATTROPTPWR_CFPINPUTUPTH", opticalParam.getDWDMTL1_ATTROPTPWR_CFPINPUTUPTH()));
            rowparams.addParam(new Param(DWDMTL1_ATTROPTPWR_PEAK_INPOWER_CUR, opticalParam.getDWDMTL1_ATTROPTPWR_PEAK_INPOWER_CUR()));
            rowparams.addParam(new Param(DWDMTL1_ATTROPTPWR_VALLEY_INPOWER_CUR, opticalParam.getDWDMTL1_ATTROPTPWR_VALLEY_INPOWER_CUR()));
            String portName = TETL1CommonUtil.getBoardStructFromAID((String)opticalParam.getAID(), (int)neid, (boolean)false);
            rowparams.addParam(new Param("portname", portName));
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
    }

    private String getALMTHValue(String value) {
        if (value == null) {
            return "/";
        }
        if (value.equals("INVALID")) {
            return "/";
        }
        if (66 == this.neType && value.equals(INVALIDVALUE)) {
            return "/";
        }
        return value;
    }

    private List sortHashMap(HashMap hashMap) {
        ArrayList portList = new ArrayList();
        Object[] keys = hashMap.keySet().toArray();
        OpticalPowerComparor comparor = new OpticalPowerComparor(this.neid);
        Arrays.sort(keys, comparor);
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            portList.add(hashMap.get(keys[i]));
        }
        return portList;
    }

    static class OpticalParam
    implements Comparable {
        int neID;
        String AID;
        String mod2;
        String DWDMTL1_ATTROPTPWR_INPWR = "-";
        String DWDMTL1_ATTROPTPWR_INPUTDOWNTH = "-";
        String DWDMTL1_ATTROPTPWR_INPUTUPTH = "-";
        String DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH = "-";
        String DWDMTL1_ATTROPTPWR_CFPINPUTUPTH = "-";
        String DWDMTL1_ATTROPTPWR_OUTPWR = "-";
        String DWDMTL1_ATTROPTPWR_OUTPUTDOWNTH = "-";
        String DWDMTL1_ATTROPTPWR_OUTPUTUPTH = "-";
        String DWDMTL1_ATTROPTPWR_EXPOPT_UPTH = "-";
        String DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH = "-";
        String DWDMTL1_ATTROPTPWR_EXPOPR_UPTH = "-";
        String DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH = "-";
        String DWDMTL1_ATTROPTPWR_OPR_UPRANGEH = "-";
        String DWDMTL1_ATTROPTPWR_OPR_UPRANGEL = "-";
        String DWDMTL1_ATTROPTPWR_OPR_DNRANGEH = "-";
        String DWDMTL1_ATTROPTPWR_OPR_DNRANGEL = "-";
        String DWDMTL1_ATTROPTPWR_EXPOPR = "-";
        String DWDMTL1_ATTROPTPWR_EXPOPT = "-";
        String DWDMTL1_ATTROPTPWR_PEAK_INPOWER_CUR = "-";
        String DWDMTL1_ATTROPTPWR_VALLEY_INPOWER_CUR = "-";

        OpticalParam() {
        }

        public String getDWDMTL1_ATTROPTPWR_PEAK_INPOWER_CUR() {
            return this.DWDMTL1_ATTROPTPWR_PEAK_INPOWER_CUR;
        }

        public void setDWDMTL1_ATTROPTPWR_PEAK_INPOWER_CUR(String dwdmtl1_attroptpwr_peak_inpower_cur) {
            this.DWDMTL1_ATTROPTPWR_PEAK_INPOWER_CUR = dwdmtl1_attroptpwr_peak_inpower_cur;
        }

        public String getDWDMTL1_ATTROPTPWR_VALLEY_INPOWER_CUR() {
            return this.DWDMTL1_ATTROPTPWR_VALLEY_INPOWER_CUR;
        }

        public void setDWDMTL1_ATTROPTPWR_VALLEY_INPOWER_CUR(String dwdmtl1_attroptpwr_valley_inpower_cur) {
            this.DWDMTL1_ATTROPTPWR_VALLEY_INPOWER_CUR = dwdmtl1_attroptpwr_valley_inpower_cur;
        }

        public String getDWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH() {
            return this.DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH;
        }

        public void setDWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH(String dwdmtl1_attroptpwr_cfpinputdownth) {
            this.DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH = dwdmtl1_attroptpwr_cfpinputdownth;
        }

        public String getDWDMTL1_ATTROPTPWR_CFPINPUTUPTH() {
            return this.DWDMTL1_ATTROPTPWR_CFPINPUTUPTH;
        }

        public void setDWDMTL1_ATTROPTPWR_CFPINPUTUPTH(String dwdmtl1_attroptpwr_cfpinputupth) {
            this.DWDMTL1_ATTROPTPWR_CFPINPUTUPTH = dwdmtl1_attroptpwr_cfpinputupth;
        }

        public String getDWDMTL1_ATTROPTPWR_EXPOPR() {
            return this.DWDMTL1_ATTROPTPWR_EXPOPR;
        }

        public void setDWDMTL1_ATTROPTPWR_EXPOPR(String dwdmtl1_attroptpwr_expopr) {
            this.DWDMTL1_ATTROPTPWR_EXPOPR = dwdmtl1_attroptpwr_expopr;
        }

        public String getDWDMTL1_ATTROPTPWR_EXPOPT() {
            return this.DWDMTL1_ATTROPTPWR_EXPOPT;
        }

        public void setDWDMTL1_ATTROPTPWR_EXPOPT(String dwdmtl1_attroptpwr_expopt) {
            this.DWDMTL1_ATTROPTPWR_EXPOPT = dwdmtl1_attroptpwr_expopt;
        }

        public String getDWDMTL1_ATTROPTPWR_EXPOPT_UPTH() {
            return this.DWDMTL1_ATTROPTPWR_EXPOPT_UPTH;
        }

        public void setDWDMTL1_ATTROPTPWR_EXPOPT_UPTH(String dwdmtl1_attroptpwr_expopt_upth) {
            this.DWDMTL1_ATTROPTPWR_EXPOPT_UPTH = dwdmtl1_attroptpwr_expopt_upth;
        }

        public String getDWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH() {
            return this.DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH;
        }

        public void setDWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH(String dwdmtl1_attroptpwr_expopt_downth) {
            this.DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH = dwdmtl1_attroptpwr_expopt_downth;
        }

        public String getDWDMTL1_ATTROPTPWR_EXPOPR_UPTH() {
            return this.DWDMTL1_ATTROPTPWR_EXPOPR_UPTH;
        }

        public void setDWDMTL1_ATTROPTPWR_EXPOPR_UPTH(String dwdmtl1_attroptpwr_expopr_upth) {
            this.DWDMTL1_ATTROPTPWR_EXPOPR_UPTH = dwdmtl1_attroptpwr_expopr_upth;
        }

        public String getDWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH() {
            return this.DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH;
        }

        public void setDWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH(String dwdmtl1_attroptpwr_expopr_downth) {
            this.DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH = dwdmtl1_attroptpwr_expopr_downth;
        }

        public int getNeID() {
            return this.neID;
        }

        public void setNeID(int neID) {
            this.neID = neID;
        }

        public String getAID() {
            return this.AID;
        }

        public void setAID(String aid) {
            this.AID = aid;
        }

        public String getMod2() {
            return this.mod2;
        }

        public void setMod2(String mod2) {
            this.mod2 = mod2;
        }

        public String getDWDMTL1_ATTROPTPWR_INPWR() {
            return this.DWDMTL1_ATTROPTPWR_INPWR;
        }

        public void setDWDMTL1_ATTROPTPWR_INPWR(String dwdmtl1_attroptpwr_inpwr) {
            this.DWDMTL1_ATTROPTPWR_INPWR = dwdmtl1_attroptpwr_inpwr;
        }

        public String getDWDMTL1_ATTROPTPWR_INPUTDOWNTH() {
            return this.DWDMTL1_ATTROPTPWR_INPUTDOWNTH;
        }

        public void setDWDMTL1_ATTROPTPWR_INPUTDOWNTH(String dwdmtl1_attroptpwr_inputdownth) {
            this.DWDMTL1_ATTROPTPWR_INPUTDOWNTH = dwdmtl1_attroptpwr_inputdownth;
        }

        public String getDWDMTL1_ATTROPTPWR_INPUTUPTH() {
            return this.DWDMTL1_ATTROPTPWR_INPUTUPTH;
        }

        public void setDWDMTL1_ATTROPTPWR_INPUTUPTH(String dwdmtl1_attroptpwr_inputupth) {
            this.DWDMTL1_ATTROPTPWR_INPUTUPTH = dwdmtl1_attroptpwr_inputupth;
        }

        public String getDWDMTL1_ATTROPTPWR_OUTPWR() {
            return this.DWDMTL1_ATTROPTPWR_OUTPWR;
        }

        public void setDWDMTL1_ATTROPTPWR_OUTPWR(String dwdmtl1_attroptpwr_outpwr) {
            this.DWDMTL1_ATTROPTPWR_OUTPWR = dwdmtl1_attroptpwr_outpwr;
        }

        public String getDWDMTL1_ATTROPTPWR_OUTPUTDOWNTH() {
            return this.DWDMTL1_ATTROPTPWR_OUTPUTDOWNTH;
        }

        public void setDWDMTL1_ATTROPTPWR_OUTPUTDOWNTH(String dwdmtl1_attroptpwr_outputdownth) {
            this.DWDMTL1_ATTROPTPWR_OUTPUTDOWNTH = dwdmtl1_attroptpwr_outputdownth;
        }

        public String getDWDMTL1_ATTROPTPWR_OUTPUTUPTH() {
            return this.DWDMTL1_ATTROPTPWR_OUTPUTUPTH;
        }

        public void setDWDMTL1_ATTROPTPWR_OUTPUTUPTH(String dwdmtl1_attroptpwr_outputupth) {
            this.DWDMTL1_ATTROPTPWR_OUTPUTUPTH = dwdmtl1_attroptpwr_outputupth;
        }

        public String getDWDMTL1_ATTROPTPWR_OPR_UPRANGEH() {
            return this.DWDMTL1_ATTROPTPWR_OPR_UPRANGEH;
        }

        public void setDWDMTL1_ATTROPTPWR_OPR_UPRANGEH(String dwdmtl1_attroptpwr_opr_uprangeh) {
            this.DWDMTL1_ATTROPTPWR_OPR_UPRANGEH = dwdmtl1_attroptpwr_opr_uprangeh;
        }

        public String getDWDMTL1_ATTROPTPWR_OPR_UPRANGEL() {
            return this.DWDMTL1_ATTROPTPWR_OPR_UPRANGEL;
        }

        public void setDWDMTL1_ATTROPTPWR_OPR_UPRANGEL(String dwdmtl1_attroptpwr_opr_uprangel) {
            this.DWDMTL1_ATTROPTPWR_OPR_UPRANGEL = dwdmtl1_attroptpwr_opr_uprangel;
        }

        public String getDWDMTL1_ATTROPTPWR_OPR_DNRANGEH() {
            return this.DWDMTL1_ATTROPTPWR_OPR_DNRANGEH;
        }

        public void setDWDMTL1_ATTROPTPWR_OPR_DNRANGEH(String dwdmtl1_attroptpwr_opr_dnrangeh) {
            this.DWDMTL1_ATTROPTPWR_OPR_DNRANGEH = dwdmtl1_attroptpwr_opr_dnrangeh;
        }

        public String getDWDMTL1_ATTROPTPWR_OPR_DNRANGEL() {
            return this.DWDMTL1_ATTROPTPWR_OPR_DNRANGEL;
        }

        public void setDWDMTL1_ATTROPTPWR_OPR_DNRANGEL(String dwdmtl1_attroptpwr_opr_dnrangel) {
            this.DWDMTL1_ATTROPTPWR_OPR_DNRANGEL = dwdmtl1_attroptpwr_opr_dnrangel;
        }

        public int getNMPort() {
            return TETL1CommonUtil.getNMPortNOFromAidStruct((String)this.AID, (int)this.neID);
        }

        public int compareTo(Object o) {
            if (!(o instanceof OpticalParam)) {
                return -1;
            }
            OpticalParam o1 = (OpticalParam)o;
            return this.getNMPort() - o1.getNMPort();
        }
    }
}

