/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.ophbyte.otn;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.tl1ngwdm.config.ophbyte.otn.TETL1OTNAvailableResObject;
import com.huawei.nglct.ngwdm_pub.TETL1SimpleAID;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TETL1QueryExcExistPathBean
extends TETL1NEExplorerBean {
    private Map<Integer, TETL1OTNAvailableResObject> portgradeMap = new HashMap<Integer, TETL1OTNAvailableResObject>();

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        int slotid = Integer.parseInt(this.inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        TL1Operation operation = (TL1Operation)tl1OperList.get(0);
        int count = operation.getOutMsgCount();
        for (int i = 0; i < count; ++i) {
            String autoFlagValue;
            OutMsg outmsg = operation.getOutMsg(i);
            if (!outmsg.getFault().getErrCode().isEmpty() || (autoFlagValue = outmsg.getMsgBlock().getPart("AUTOFLAG").getValue()).equalsIgnoreCase("Y")) continue;
            String fromAid = outmsg.getMsgBlock().getPart("FROM").getValue();
            String exclevel = outmsg.getMsgBlock().getPart("LEVEL").getValue();
            this.addExcData(neid, slotid, fromAid, exclevel);
            String toAid = outmsg.getMsgBlock().getPart("TO").getValue();
            this.addExcData(neid, slotid, toAid, exclevel);
        }
        this.constuctOutput();
    }

    private void addExcData(int neid, int slotid, String aid, String exclevel) {
        int slot = TETL1CommonUtil.getNMSlotStr((String)aid, (int)neid);
        if (slotid == slot) {
            int portid = TETL1CommonUtil.getNMPortNOFromAidStruct((String)aid, (int)neid);
            TETL1OTNAvailableResObject avalibleList = this.portgradeMap.get(portid);
            if (avalibleList == null) {
                avalibleList = new TETL1OTNAvailableResObject(portid);
                this.portgradeMap.put(portid, avalibleList);
            }
            int pathid = this.getPath(exclevel, aid);
            avalibleList.addFbPath(exclevel, pathid);
        }
    }

    private void constuctOutput() {
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        Iterator<Map.Entry<Integer, TETL1OTNAvailableResObject>> iterator = this.portgradeMap.entrySet().iterator();
        Map.Entry<Integer, TETL1OTNAvailableResObject> entry = null;
        TETL1OTNAvailableResObject available = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            available = entry.getValue();
            RowParams rParams = new RowParams();
            Param param = new Param("port", String.valueOf(available.getPort()));
            rParams.addParam(param);
            param = new Param("gradepath", available.getFBPathStr());
            rParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rParams);
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private int getPath(String excLevel, String aid) {
        TETL1SimpleAID aidObj = new TETL1SimpleAID(aid, this.neid);
        if (aidObj.isSimplesBoard()) {
            return aidObj.getNmPath(excLevel);
        }
        return TETL1CommonUtil.getPathIDFromAidStruct((String)aid, (int)this.neid);
    }
}

