/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.ophbyte.otn;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgSetBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.ngwdm_pub.TESimpleModelUtil;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TETL1OTNSetBean
extends TETL1GenCfgSetBean {
    private static final String[][] ODUGRADE = new String[][]{{"ODU1"}, {"ODU2"}, {"ODU3"}, {"ODU5g"}};
    private static final String[][] TCMLEVEL = new String[][]{{"TCM1"}, {"TCM2"}, {"TCM3"}, {"TCM4"}, {"TCM5"}, {"TCM6"}};
    private static final int PMLEVEL = 1;
    private static final int SMLEVEL = 8;
    private static final int OTSLEVEL = 9;
    private static final int GRADE_NULL = 255;

    public TETL1OTNSetBean() {
        this.TIME_OUT = 120;
    }

    public String getOperObjStr(TENE neObj, Datainterface inputData) {
        int level;
        StringBuffer operObj = new StringBuffer();
        if (null == neObj) {
            operObj.append(String.valueOf(this.neid));
        } else {
            operObj.append(neObj.getNEName());
        }
        int slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
        int portID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("port").getValue());
        int path = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("path").getValue());
        int grade = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("grade").getValue());
        operObj.append("-").append(slotid).append("-").append(TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype));
        operObj.append("-").append(TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotid, boardtype, portID));
        if (255 != grade) {
            operObj.append("-").append(ODUGRADE[grade - 1][0]);
        }
        operObj.append("-").append(path);
        if (null != inputData.getBussinessParams().getRowParams(0).getParam("level") && (level = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("level").getValue())) != 1 && level != 8 && level != 9) {
            operObj.append("-").append(TCMLEVEL[level - 2][0]);
        }
        return operObj.toString();
    }

    public String specialHandle(String attrId, String attrValue, Datainterface inputData, String actvalue, TEResourceUtil res) {
        int value = Integer.parseInt(actvalue);
        if (value > 6 && value < 128 && value != 16 && value != 17 && value != 32 || value > 143 && value < 253) {
            return actvalue + "-" + res.getString(attrId + "_" + "7");
        }
        if (value > 127 && value < 144) {
            return actvalue + "-" + res.getString(attrId + "_" + "128");
        }
        return actvalue + "-" + attrValue;
    }

    public String getExtendOperName(String name, RowParams rowparams) {
        if (null != rowparams.getParam("mode2")) {
            String modStr = rowparams.getParam("mode2").getValue();
            String[] modCarrier = modStr.split(",");
            for (int i = modCarrier.length - 1; i > 0; --i) {
                if (!modCarrier[i].equals("level")) continue;
                return name.substring(0, name.indexOf("-") + 1) + modCarrier[i + 1];
            }
        }
        return name;
    }

    public String convertAttrID(String attrID) {
        if (attrID == null) {
            return attrID;
        }
        if (this.subfunc.getCode() == 2106555) {
            if (attrID.equalsIgnoreCase("DWDMTL1_ATTRPM_PST")) {
                return "DWDMTL1_ATTRFTFL_PST";
            }
            if (attrID.equalsIgnoreCase("DWDMTL1_ATTRPM_SST")) {
                return "DWDMTL1_ATTRFTFL_SST";
            }
        }
        if (this.subfunc.getCode() == 2105850) {
            if (attrID.equalsIgnoreCase("DWDMTL1_ATTRPM_PST")) {
                return "DWDMTL1_ATTROPU_PST";
            }
            if (attrID.equalsIgnoreCase("DWDMTL1_ATTRPM_SST")) {
                return "DWDMTL1_ATTROPU_SST";
            }
        }
        return attrID;
    }

    public boolean isNeedHandle(String attrId, String attrValue) {
        return attrId.equals("SR_OTN_OTN_PT");
    }

    public RowErrors handleErrorData(int neid, SubFunc subfunc, TL1Operation oper, OutMsg output) {
        InMsg input = oper.getInMsg();
        String errorCode = output.getFault().getErrCode();
        String errorinfo = output.getFault().getErrDesc();
        String aidstr = oper.getInMsg().getStagBlock().getAID().getPart(0).getValue();
        String monObj = TETL1CommonUtil.getBoardStructFromAID((String)aidstr, (int)neid, (boolean)true);
        monObj = monObj + ":" + oper.getMod1();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param("neObj", monObj);
        rowError.addParam(errorparam);
        DataBlock dataBlock = null;
        String convertName = null;
        String partName = null;
        if (null != input) {
            int i;
            AID aid = input.getStagBlock().getAID();
            int len = aid.getPartCount();
            for (i = 0; i < len; ++i) {
                if (aid.getPart(i).getName().equalsIgnoreCase("AID")) {
                    String aidValue = aid.getPart(i).getValue();
                    String mod2 = TETL1CommonUtil.getRealMod2((TL1Operation)oper);
                    ArrayList aidTempList = TESimpleModelUtil.handleTL1SimpleModelPath((String)aidValue, (String)mod2, (int)neid);
                    errorparam = new Param(aid.getPart(i).getName(), (String)aidTempList.get(0));
                } else {
                    errorparam = new Param(aid.getPart(i).getName(), aid.getPart(i).getValue());
                }
                rowError.addParam(errorparam);
            }
            len = input.getMsgBlock().getDataBlockCount();
            for (i = 0; i < len; ++i) {
                dataBlock = input.getMsgBlock().getDataBlock(i);
                int size = dataBlock.getPartCount();
                for (int j = 0; j < size; ++j) {
                    errorparam = new Param(dataBlock.getPart(j).getName(), dataBlock.getPart(j).getValue());
                    if (errorparam.getValue() == null) continue;
                    rowError.addParam(errorparam);
                    partName = dataBlock.getPart(j).getName();
                    convertName = dataBlock.getPart(j).getConvert();
                    if (null != convertName && !"".equals(convertName)) {
                        partName = convertName;
                    }
                    if (rowError.getParam("attrId") != null) {
                        errorparam = rowError.getParam("attrId");
                        errorparam.setValue(rowError.getParam("attrId").getValue() + "," + partName);
                    } else {
                        errorparam = new Param("attrId", partName);
                    }
                    rowError.addParam(errorparam);
                }
            }
        }
        return rowError;
    }

    public String parseMode2Str(String mode2Str, String attrID) {
        String[] str = mode2Str.split(",");
        if (str.length == 1) {
            return mode2Str;
        }
        if (!attrID.equals("AID")) {
            attrID = "OTNMODE2";
        }
        int size = str.length - 1;
        for (int i = 0; i < size; ++i) {
            if (!str[i].equals(attrID)) continue;
            return str[i + 1];
        }
        return "";
    }
}

