/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.ophbyte.otn;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgCmdFactory;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunAttr;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunCmd;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgQueryBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.ngwdm_pub.TETL1SimpleAID;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1DataConverter;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TETL1OTNQueryBean
extends TETL1GenCfgQueryBean {
    private static final int LQM2_PORT2 = 2;
    private ArrayList attrIDList = null;
    private static final String UNKNOWN = "UNKNOWN";

    public ArrayList getQueryOperationList(TETL1GenCfgFunCmd funCmd, TL1Definitions definitions, Datainterface inputData) {
        ArrayList operationList = new ArrayList();
        Datainterface tmpData = new Datainterface();
        for (int rowIndex = 0; rowIndex < inputData.getBussinessParams().getRowParamsCount(); ++rowIndex) {
            RowParams rowparams = inputData.getBussinessParams().getRowParams(rowIndex);
            this.supportAttrList = this.getQueryAttrList(rowparams);
            tmpData.setBussinessParams(new BussinessParams());
            tmpData.getBussinessParams().addRowParams(rowparams);
            String attrId = "";
            ArrayList groupAttr = null;
            for (int i = this.supportAttrList.size() - 1; i >= 0; --i) {
                attrId = (String)this.supportAttrList.get(i);
                TETL1GenCfgFunAttr funAttr = funCmd.getGenCfgFunAttr(attrId, "query");
                if (null == funAttr) continue;
                if (groupAttr == null) {
                    groupAttr = funAttr.getGroupAttrList();
                } else if (groupAttr.contains(attrId)) continue;
                this.getQueryAttrOperationList(definitions, funAttr, operationList, attrId, tmpData);
            }
        }
        this.filterOperationByInput(operationList, inputData);
        return operationList;
    }

    protected void filterOperationByInput(ArrayList operationList, Datainterface inputData) {
        HashSet<String> inputSet = new HashSet<String>();
        int rowLength = inputData.getBussinessParams().getRowParamsCount();
        for (int rowIndex = 1; rowIndex < rowLength; ++rowIndex) {
            RowParams row = inputData.getBussinessParams().getRowParams(rowIndex);
            if (row.getParam("changePort") == null || row.getParam("changePath") == null) continue;
            String changePort = row.getParam("changePort").getValue();
            String changePath = row.getParam("changePath").getValue();
            inputSet.add(changePort + "-" + changePath);
        }
        if (inputSet.isEmpty()) {
            return;
        }
        for (int i = operationList.size() - 1; i >= 0; --i) {
            TL1Operation oper = (TL1Operation)operationList.get(i);
            String portId = oper.getInMsg().getPart("port").getValue();
            String pathid = oper.getInMsg().getPart("path").getValue();
            if (inputSet.contains(portId + "-" + pathid)) continue;
            operationList.remove(i);
        }
    }

    public Datainterface expandOperObj(String srcObjType, String sinkObjType, String attrId, Datainterface inputData) {
        switch (this.subfunc.getCode()) {
            case 2105847: {
                sinkObjType = "ID_OBJECT_TYPE_NE_BOARD_PORT_ODU_TCM";
                break;
            }
            case 2105853: {
                sinkObjType = "ID_OBJECT_TYPE_NE_BOARD_PORT_ODU";
                break;
            }
            case 2105851: {
                sinkObjType = "ID_OBJECT_TYPE_NE_BOARD_PORT_ODU";
                break;
            }
            case 2105849: {
                sinkObjType = "ID_OBJECT_TYPE_NE_BOARD_PORT_ODU";
                break;
            }
            case 2106554: {
                sinkObjType = "ID_OBJECT_TYPE_NE_BOARD_PORT_ODU";
                break;
            }
            case 2107500: {
                sinkObjType = "ID_OBJECT_TYPE_NE_BOARD_PORT_ODU_OTS";
                break;
            }
        }
        return super.expandOperObj(srcObjType, sinkObjType, attrId, inputData);
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        this.initSupportAttrIDList();
        if (2105847 == subfunc.getCode()) {
            TL1Operation oper = null;
            int m = operationList.size();
            for (int i = 0; i < m; ++i) {
                oper = (TL1Operation)operationList.get(i);
                DataBlock db = new DataBlock();
                Part part = new Part();
                part.setName("level");
                part.setValue(oper.getMod1());
                db.addPart(part);
                oper.getInMsg().getMsgBlock().addDataBlock(db);
                oper.getOutMsg(0).getMsgBlock().addDataBlock(db);
            }
        }
        this.outputData = this.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList, this.aidAndTypeList);
        if (null == this.outputData || null == this.outputData.getBussinessParams()) {
            return;
        }
        if (this.outputData.getBussinessParams().getRowParamsCount() == 0) {
            return;
        }
        RowParams rowparams = null;
        String aid = null;
        String pst = null;
        Param param = null;
        String value = "";
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            String sst;
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowparams.getParamCount() == 0) continue;
            if (null != rowparams.getParam("AID")) {
                aid = rowparams.getParam("AID").getValue();
                TETL1SimpleAID sAid = new TETL1SimpleAID(aid, neid);
                String curMod2 = rowparams.getParam("CurrentMOD2").getValue();
                if (null != rowparams.getParam("mode2")) {
                    String pstValue = rowparams.getParam("mode2").getValue();
                    String mod2 = this.getRealMod2(this.parseMode2Str(pstValue, "OTNMODE2"));
                    rowparams.getParam("AID").setValue(TETL1CommonUtil.getGencfgObjFromAID((int)neid, (String)aid, (String)mod2));
                } else {
                    rowparams.getParam("AID").setValue(TETL1CommonUtil.getGencfgObjFromAID((int)neid, (String)aid));
                }
                int portNMID = TETL1CommonUtil.getNMPortNOFromNEPort((String)sAid.getAidPre(), (int)this.nmCurrSlotID, (int)sAid.getPortID(), (int)neid);
                String comparePortPath = portNMID + "&" + sAid.getNmPath(curMod2);
                Param portPathParam = new Param("comparePortPath", comparePortPath);
                rowparams.addParam(portPathParam);
            }
            if (2105847 == subfunc.getCode()) {
                Param[] params = rowparams.getParam();
                int n = params.length;
                for (int j = 0; j < n; ++j) {
                    if (!params[j].getName().equals("mode2")) continue;
                    String tmpStr = params[j].getValue();
                    tmpStr = tmpStr + tmpStr.substring(0, tmpStr.lastIndexOf(",") + 1) + rowparams.getParam("level").getValue();
                    params[j].setValue(tmpStr);
                }
            }
            int m = rowparams.getParamCount();
            for (int j = 0; j < m; ++j) {
                param = rowparams.getParam(j);
                if (param.getName().indexOf("EXPTTISAPI") == -1 && param.getName().indexOf("EXPTTIDAPI") == -1 && param.getName().indexOf("TTISAPI") == -1 && param.getName().indexOf("TTIDAPI") == -1 && param.getName().indexOf("TTIOPER") == -1 && param.getName().indexOf("INCTTISAPI") == -1 && param.getName().indexOf("INCTTIDAPI") == -1 && param.getName().indexOf("INCTTIOPER") == -1 && param.getName().indexOf("FTFLOPER") == -1 && param.getName().indexOf("INCFWOI") == -1 && param.getName().indexOf("INCFWOPER") == -1 && param.getName().indexOf("INCBWOI") == -1 && param.getName().indexOf("INCBWOPER") == -1) continue;
                value = param.getValue();
                value = this.removeQuotation(value);
                param.setValue(value);
            }
            String pstString = "";
            String sstString = "";
            if (2105847 == subfunc.getCode()) {
                pstString = "DWDMTL1_ATTRTCM_PST";
                sstString = "DWDMTL1_ATTRTCM_SST";
            } else if (2105853 == subfunc.getCode()) {
                pstString = "DWDMTL1_ATTRPM_PST";
                sstString = "DWDMTL1_ATTRPM_SST";
            } else if (2105849 == subfunc.getCode()) {
                pstString = "DWDMTL1_ATTROPU_PST";
                sstString = "DWDMTL1_ATTROPU_SST";
            } else if (2106554 == subfunc.getCode()) {
                pstString = "DWDMTL1_ATTRFTFL_PST";
                sstString = "DWDMTL1_ATTRFTFL_SST";
            } else if (2105851 == subfunc.getCode()) {
                pstString = "DWDMTL1_ATTRSM_PST";
                sstString = "DWDMTL1_ATTRSM_SST";
            }
            if (null == rowparams.getParam(pstString)) continue;
            pst = rowparams.getParam(pstString).getValue();
            if (null != rowparams.getParam(sstString) && !(sst = rowparams.getParam(sstString).getValue()).equals("") && !sst.equals("/")) {
                pst = pst + "," + sst;
            }
            rowparams.getParam(pstString).setValue(pst);
        }
    }

    protected boolean notSupportSpecialCol(String newAttrID) {
        if (newAttrID.equals("DWDMTL1_ATTRSM_TTISAPI") || newAttrID.equals("DWDMTL1_ATTRSM_TTIDAPI") || newAttrID.equals("DWDMTL1_ATTRSM_TTIOPER") || newAttrID.equals("DWDMTL1_ATTRPM_TTISAPI") || newAttrID.equals("DWDMTL1_ATTRPM_TTIDAPI") || newAttrID.equals("DWDMTL1_ATTRPM_TTIOPER") || newAttrID.equals("DWDMTL1_ATTRTCM_TTISAPI") || newAttrID.equals("DWDMTL1_ATTRTCM_TTIDAPI") || newAttrID.equals("DWDMTL1_ATTRTCM_TTIOPER") || newAttrID.equals("DWDMTL1_ATTRPM_INSODUMT") || newAttrID.equals("DWDMTL1_ATTRPM_TIMACT") || newAttrID.equals("DWDMTL1_ATTRSM_TIMACT") || newAttrID.equals("DWDMTL1_ATTRPM_SFBER") || newAttrID.equals("DWDMTL1_ATTRPM_SDBER")) {
            return true;
        }
        return this.attrIDList.contains(newAttrID);
    }

    public String getExtendOperName(String name, RowParams rowparams) {
        if (null != rowparams.getParam("level")) {
            String[] arr = name.split("-");
            String[] modArr = arr[arr.length - 1].split("&&");
            String temp = modArr[modArr.length - 1];
            temp = temp + "TCM" + (Integer.parseInt(rowparams.getParam("level").getValue()) - 1);
            return arr[0] + "-" + modArr[0] + "&&" + temp;
        }
        return name;
    }

    public String handleSpecialChar(String mode2) {
        if (2105851 == this.subfunc.getCode()) {
            if (-1 != mode2.indexOf("OTU")) {
                mode2 = -1 != (mode2 = mode2.substring(mode2.indexOf("OTU"))).indexOf("|") ? mode2.substring(0, mode2.indexOf("|")) : mode2.substring(0, mode2.length());
            } else {
                return UNKNOWN;
            }
        }
        if (2105853 == this.subfunc.getCode()) {
            if (-1 != mode2.indexOf("ODU")) {
                mode2 = -1 != (mode2 = mode2.substring(mode2.indexOf("ODU"))).indexOf("|") ? mode2.substring(0, mode2.indexOf("|")) : mode2.substring(0, mode2.length());
            } else {
                return UNKNOWN;
            }
        }
        if (2105849 == this.subfunc.getCode()) {
            if (-1 != mode2.indexOf("ODU")) {
                mode2 = -1 != (mode2 = mode2.substring(mode2.indexOf("ODU"))).indexOf("|") ? mode2.substring(0, mode2.indexOf("|")) : mode2.substring(0, mode2.length());
            } else {
                return UNKNOWN;
            }
        }
        if (2105847 == this.subfunc.getCode()) {
            if (-1 != mode2.indexOf("ODU")) {
                mode2 = -1 != (mode2 = mode2.substring(mode2.indexOf("ODU"))).indexOf("|") ? mode2.substring(0, mode2.indexOf("|")) : mode2.substring(0, mode2.length());
            } else {
                return UNKNOWN;
            }
        }
        return mode2;
    }

    protected String getMod2(int neid, int slotid, int portid, int pathid, String attrID) {
        if ((2105849 == this.subfunc.getCode() || 2105851 == this.subfunc.getCode() || 2105853 == this.subfunc.getCode()) && this.bdtype == 1310 && this.boardMode.equals("AP8MODE") && portid == 7) {
            return UNKNOWN;
        }
        TETL1GenCfgFunAttr attr = this.funCmd.getGenCfgFunAttr(attrID, "query");
        if (2105847 == this.subfunc.getCode()) {
            String mod2 = UNKNOWN;
            mod2 = pathid > 0 ? this.aidAndTypeList.getPayLoadMod2(neid, slotid, portid, pathid) : this.aidAndTypeList.getPayLoadMod2(neid, slotid, portid);
            if (-1 != mod2.indexOf("|") && -1 == mod2.indexOf("OTU")) {
                return UNKNOWN;
            }
            if (-1 == mod2.indexOf("|")) {
                mod2 = mod2.replaceAll("OTU", "ODU");
            }
            if (-1 != mod2.indexOf("ODU") && !mod2.equalsIgnoreCase("ODUFLEX")) {
                mod2 = -1 != (mod2 = mod2.substring(mod2.indexOf("ODU"))).indexOf("|") ? mod2.substring(0, mod2.indexOf("|")) : mod2.substring(0, mod2.length());
            }
            boolean isSupportTCM = false;
            if (attr != null) {
                ArrayList list = attr.getModifierList();
                int size = list.size();
                for (int j = 0; j < size; ++j) {
                    String tempMod2 = (String)list.get(j);
                    if (!mod2.equals(tempMod2)) continue;
                    isSupportTCM = true;
                    break;
                }
            }
            if (isSupportTCM) {
                return "TCMMOD2&&" + mod2;
            }
            return UNKNOWN;
        }
        if (attr != null) {
            ArrayList list = attr.getModifierList();
            ArrayList mod2List = null;
            mod2List = pathid > 0 ? this.aidAndTypeList.getAllMod2(neid, slotid, portid, pathid) : this.aidAndTypeList.getAllMod2(neid, slotid, portid);
            int len = mod2List.size();
            for (int i = 0; i < len; ++i) {
                String mod2 = (String)mod2List.get(i);
                int size = list.size();
                for (int j = 0; j < size; ++j) {
                    String tempMod2 = (String)list.get(j);
                    if (!mod2.equals(tempMod2)) continue;
                    String tl1Mod2 = TETL1GenCfgCmdFactory.getInstance().getTL1DescMod2(mod2);
                    return tl1Mod2 + "&&" + mod2;
                }
            }
        }
        return UNKNOWN;
    }

    public boolean isNeedExpandOperObj(String attrId) {
        return true;
    }

    public ArrayList joinTL1Operation(int neid, SubFunc subfunc, ArrayList tl1OperationList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        TL1Operation tl1Oper = null;
        OutMsg curOutput = null;
        String errorCode = "OK";
        if (null == tl1OperationList || 0 == tl1OperationList.size()) {
            return errorDataList;
        }
        this.cloneTL1OperationList.clear();
        for (int i = tl1OperationList.size() - 1; i >= 0; --i) {
            tl1Oper = (TL1Operation)tl1OperationList.get(i);
            boolean flag = true;
            for (int index = tl1Oper.getOutMsgCount() - 1; index >= 0; --index) {
                curOutput = tl1Oper.getOutMsg(index);
                errorCode = String.valueOf(curOutput.getFault().getCompletionCode());
                if (!"0".equals(errorCode)) {
                    tl1Oper.addCmdFault(curOutput.getFault());
                }
                if (this.isFilterErrorCode(filterErrorCodeList, curOutput.getFault().getErrDesc())) {
                    tl1Oper.removeOutMsg(curOutput);
                    continue;
                }
                if ("0".equals(errorCode)) continue;
                String errorinfo = curOutput.getFault().getErrDesc();
                if (!this.containFilterErrorInfo(errorinfo)) {
                    errorDataList.add(0, this.handleErrorData(neid, subfunc, tl1Oper, curOutput));
                    continue;
                }
                flag = false;
            }
            if (!flag) continue;
            this.cloneTL1OperationList.add(tl1Oper.clone());
        }
        int operSize = tl1OperationList.size();
        if (0 == operSize) {
            return errorDataList;
        }
        return errorDataList;
    }

    private String removeQuotation(String value) {
        if (value.length() >= 4) {
            String strFirst = value.substring(0, 2);
            String strLast = value.substring(value.length() - 2);
            if ("\\\"".equals(strFirst) && "\\\"".equals(strLast)) {
                value = value.length() == 4 ? "" : value.substring(2, value.length() - 2);
            }
        }
        return value;
    }

    public boolean handleRowData(int neid, RowParams rowparams, OutMsg output, String mode2) {
        String tmpValue = "";
        String tmpName = "";
        Param param = null;
        HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
        if (this.isFilterRowData(partmap)) {
            return false;
        }
        Part part = (Part)partmap.get("AID");
        int portNMID = -1;
        TEGenCfgModel genCfgModel = null;
        int pathID = -1;
        int brdType = -1;
        if (part != null && part.getValue() != null) {
            String aidStr = part.getValue();
            TETL1SimpleAID sAid = new TETL1SimpleAID(aidStr, neid);
            int slotNMID = sAid.getNmSlotID();
            int portID = sAid.getPortID();
            portNMID = TETL1CommonUtil.getNMPortNOFromNEPort((String)sAid.getAidPre(), (int)slotNMID, (int)portID, (int)neid);
            brdType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotNMID);
            pathID = sAid.getNmPath(mode2);
            genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)brdType);
        }
        if (this.filter1800OldVersionPort(portNMID)) {
            return false;
        }
        rowparams.addParam("neid", String.valueOf(neid));
        DataBlock dataBlock = null;
        int size = output.getMsgBlock().getDataBlockCount();
        for (int tmpCol = 0; tmpCol < size; ++tmpCol) {
            dataBlock = output.getMsgBlock().getDataBlock(tmpCol);
            for (int index = dataBlock.getPartCount() - 1; index >= 0; --index) {
                tmpName = dataBlock.getPart(index).getName();
                tmpValue = dataBlock.getPart(index).getValue();
                String attrID = tmpName;
                String convertID = dataBlock.getPart(index).getConvert();
                if (convertID != null && !convertID.equals("")) {
                    attrID = dataBlock.getPart(index).getConvert();
                } else if (null != this.funCmd) {
                    attrID = this.funCmd.getParamAttrID(tmpName);
                }
                String newAttrID = this.convertAttrID(attrID);
                if (!this.isSupportAttr(newAttrID, genCfgModel, portNMID, pathID)) continue;
                rowparams = this.handleSepicalCol(newAttrID, tmpValue, rowparams, mode2);
                if (null == tmpValue) {
                    if (this.notSupportSpecialCol(newAttrID) || brdType == 1310 && this.boardMode.equals("AP8MODE") && portNMID == 2 && (newAttrID.equals("DWDMTL1_ATTRPM_BIP8MODE") || newAttrID.equals("DWDMTL1_ATTRPM_DEGTH") || newAttrID.equals("DWDMTL1_ATTRPM_DEGTIME") || newAttrID.equals("DWDMTL1_ATTRPM_STAT") || newAttrID.equals("DWDMTL1_ATTRPM_INSODUMT") || newAttrID.equals("DWDMTL1_ATTRSM_BIP8MODE") || newAttrID.equals("DWDMTL1_ATTRSM_DEGTH") || newAttrID.equals("DWDMTL1_ATTRSM_DEGTIME"))) continue;
                    tmpValue = "/";
                }
                if (null != rowparams.getParam(newAttrID) && rowparams.getParam(newAttrID).getValue().equals(tmpValue) && (-1 != newAttrID.indexOf("PST") || -1 != newAttrID.indexOf("SST") || newAttrID.equals("AID"))) continue;
                param = new Param(newAttrID, tmpValue);
                rowparams.addParam(param);
            }
            if (tmpCol != size - 1) continue;
            String clntAID = output.getMsgBlock().getDataBlock(0).getPart(0).getValue();
            String clntpayload = this.getClientPayload(clntAID);
            if (clntpayload == null) {
                clntpayload = "";
            }
            param = new Param("CLNTPLDTYPE", clntpayload);
            rowparams.addParam(param);
        }
        TETL1DataConverter.addReturnParam((int)neid, (RowParams)rowparams);
        return true;
    }

    private boolean filter1800OldVersionPort(int port) {
        if (this.neType == 66 && !TETL1CommonUtil.isNewNeVersion((int)this.neType, (String)this.neVersion)) {
            if (this.bdtype == 1310 && this.boardMode.equals("AP8MODE") && port == 2) {
                return true;
            }
            if (this.bdtype == 1433 && (port == 2 || port == 4)) {
                return true;
            }
            if ((this.bdtype == 1311 || this.bdtype == 1309 || this.bdtype == 1316 || this.bdtype == 1317) && port == 2) {
                return true;
            }
        }
        return false;
    }

    public String convertAttrID(String attrID) {
        if (attrID == null) {
            return attrID;
        }
        if (this.subfunc.getCode() == 2106554) {
            if (attrID.equalsIgnoreCase("DWDMTL1_ATTRPM_PST")) {
                return "DWDMTL1_ATTRFTFL_PST";
            }
            if (attrID.equalsIgnoreCase("DWDMTL1_ATTRPM_SST")) {
                return "DWDMTL1_ATTRFTFL_SST";
            }
        }
        if (this.subfunc.getCode() == 2105849) {
            if (attrID.equalsIgnoreCase("DWDMTL1_ATTRPM_PST")) {
                return "DWDMTL1_ATTROPU_PST";
            }
            if (attrID.equalsIgnoreCase("DWDMTL1_ATTRPM_SST")) {
                return "DWDMTL1_ATTROPU_SST";
            }
        }
        return attrID;
    }

    private String getClientPayload(String aid) {
        String[] aidarr = TETL1CommonUtil.parseAID((String)aid, (int)this.neid);
        if (aidarr[0].indexOf("CLNT") != -1) {
            try {
                ArrayList<TL1Operation> clntOperList = new ArrayList<TL1Operation>();
                TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
                TL1Operation operation = definitions.getTL1Operation("RTRV-CLNT");
                operation.getInMsg().getStagBlock().getAID().getPart(0).setValue(aid);
                clntOperList.add(operation);
                int result = this.sendMessage(this.neid, clntOperList);
                if (result == 0) {
                    if (clntOperList != null && clntOperList.size() > 0) {
                        operation = (TL1Operation)clntOperList.get(0);
                        if (operation.getOutMsgCount() == 0 || !operation.getOutMsg(0).getFault().getErrDesc().equals("")) {
                            return "-";
                        }
                        return operation.getOutMsg(0).getMsgBlock().getPart("PLDTYPE").getValue();
                    }
                    return "-";
                }
                return "-";
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TETL1OTNQueryBean.getClientPayload() fail!", (Throwable)e);
            }
        }
        return "-";
    }

    protected RowParams handleSepicalCol(String part, String partValue, RowParams rowparams, String _mod2) {
        Param tmpParam = null;
        String tmpMode2 = "";
        if (part.equals("AID")) {
            Param param = rowparams.getParam("mode2");
            if (param == null) {
                StringBuffer tmpPart = new StringBuffer(",");
                tmpPart.append(part).append(",").append(partValue);
                tmpParam = new Param("mode2", tmpPart.toString());
                rowparams.addParam("mode2", tmpParam.getValue());
            }
        } else {
            Param param = rowparams.getParam("mode2");
            if (null == param) {
                return rowparams;
            }
            String tmpValue = param.getValue();
            if (tmpValue.indexOf("OTNMODE2") != -1) {
                return rowparams;
            }
            String tl1Mod2 = TETL1GenCfgCmdFactory.getInstance().getTL1DescMod2(_mod2);
            if (_mod2.indexOf("TCM") != -1) {
                tl1Mod2 = "TCMMOD2";
            }
            tmpMode2 = tl1Mod2 + "&&" + _mod2;
            tmpValue = tmpValue + "," + "OTNMODE2" + "," + tmpMode2;
            param.setValue(tmpValue);
        }
        return rowparams;
    }

    protected boolean isFilterParam(RowParams rowparams, TETL1GenCfgFunAttr funAttr) {
        if (this.subfunc.getCode() == 2105853) {
            String mod;
            if (rowparams.getParam("port") == null) {
                return false;
            }
            int slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
            int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
            if (this.isNotOTUBoard(bdtype)) {
                return false;
            }
            int pathid = -1;
            int portid = Integer.parseInt(rowparams.getParam("port").getValue());
            int neid = Integer.parseInt(rowparams.getParam("neid").getValue());
            if (null != rowparams.getParam("path")) {
                pathid = Integer.parseInt(rowparams.getParam("path").getValue());
            }
            if (!(portid != 201 && portid != 202 && portid != 203 && portid != 204 || (mod = this.aidAndTypeList.getMod2(neid, slotid, portid, 1)).indexOf("OTU") == -1 || pathid != 2 && pathid != 3 && pathid != 4 && pathid != 5 && pathid != 6 && pathid != 7 && pathid != 8)) {
                return true;
            }
        }
        return false;
    }

    private boolean isNotOTUBoard(int _bdtype) {
        return _bdtype != 60034 && _bdtype != 1185 && _bdtype != 1186 && _bdtype != 1187 && _bdtype != 1193 && _bdtype != 1188;
    }

    protected boolean isFilterRowData(HashMap partmap) {
        if (this.subfunc.getCode() != 2105853) {
            return false;
        }
        Part aidPart = (Part)partmap.get("BIP8MODE");
        return !(this.bdtype != 1573 && this.bdtype != 2280 && this.bdtype != 2279 || aidPart != null && aidPart.getValue() != null);
    }

    private void initSupportAttrIDList() {
        if (this.attrIDList == null) {
            this.attrIDList = new ArrayList();
        } else {
            this.attrIDList.clear();
        }
        this.attrIDList.add("DWDMTL1_ATTRSM_NONINTRMON");
        this.attrIDList.add("DWDMTL1_ATTRSM_SFBER");
        this.attrIDList.add("DWDMTL1_ATTRSM_SDBER");
        this.attrIDList.add("DWDMTL1_ATTRSM_DEGTH");
        this.attrIDList.add("DWDMTL1_ATTRSM_DEGTIME");
        this.attrIDList.add("DWDMTL1_ATTRSM_DEGINTERVAL");
        this.attrIDList.add("DWDMTL1_ATTRPM_LCKEN");
        this.attrIDList.add("DWDMTL1_ATTRPM_NONINTRMON");
        this.attrIDList.add("DWDMTL1_ATTRPM_PLM2AIS");
        this.attrIDList.add("DWDMTL1_ATTRPM_MSIM2AIS");
        this.attrIDList.add("DWDMTL1_ATTRPM_VCPLM2AIS");
        this.attrIDList.add("DWDMTL1_ATTRPM_GCCTRANS");
        this.attrIDList.add("DWDMTL1_ATTRPM_RESTRANS");
        this.attrIDList.add("DWDMTL1_ATTRPM_SFBER");
        this.attrIDList.add("DWDMTL1_ATTRPM_SDBER");
        this.attrIDList.add("DWDMTL1_ATTRPM_DEGTH");
        this.attrIDList.add("DWDMTL1_ATTRPM_DEGTIME");
        this.attrIDList.add("DWDMTL1_ATTRPM_DEGINTERVAL");
        this.attrIDList.add("DWDMTL1_ATTRTCM_LTCACTEN");
        this.attrIDList.add("DWDMTL1_ATTRTCM_LCKEN");
        this.attrIDList.add("DWDMTL1_ATTRTCM_NONINTRMON");
        this.attrIDList.add("DWDMTL1_ATTRTCM_SFBER");
        this.attrIDList.add("DWDMTL1_ATTRTCM_SDBER");
        this.attrIDList.add("DWDMTL1_ATTRTCM_DEGTH");
        this.attrIDList.add("DWDMTL1_ATTRTCM_DEGTIME");
        this.attrIDList.add("DWDMTL1_ATTRTCM_DEGINTERVAL");
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("INVALID ACCESS IDENTIFIER: OCP, NO REG ERROR");
        list.add("INVALID DATA PARAMETER, Path-id Parameter is invalid");
        list.add("COMMAND NOT VALID,UNSUPPORTED COMMAND:RTRV-UNEQTCM1");
        list.add("COMMAND NOT VALID,UNSUPPORTED COMMAND:RTRV-UNEQTCM2");
        list.add("COMMAND NOT VALID,UNSUPPORTED COMMAND:RTRV-UNEQTCM3");
        list.add("COMMAND NOT VALID,UNSUPPORTED COMMAND:RTRV-UNEQTCM4");
        list.add("COMMAND NOT VALID,UNSUPPORTED COMMAND:RTRV-UNEQTCM5");
        list.add("COMMAND NOT VALID,UNSUPPORTED COMMAND:RTRV-UNEQTCM6");
        list.add("REPLY TIMEOUT OCCURRED, REPLY TIMEOUT OCCURRED");
        return list;
    }
}

