/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.ophbyte.otn;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.tl1ngwdm.config.ophbyte.otn.TETL1OTNAvailableResObject;
import com.huawei.nglct.ngwdm_pub.TETL1AIDTranslateRuleMgr;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TETL1OTNGetAvailableResBean
extends TETL1NEExplorerBean {
    private int slotID = -1;
    private int boardType = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.curUser = user;
        this.curIpAddress = ipAddress;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.slotIDList = this.getSlotIDFromInputDdata(inputData);
        this.outputData = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        this.outputData.setBussinessParams(bParams);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        if (!this.slotIDList.isEmpty()) {
            Object[] nmCurrSlotIDArr = this.slotIDList.toArray();
            this.slotID = (Integer)nmCurrSlotIDArr[0];
        }
        if (this.slotID == -1) {
            return this.outputData;
        }
        this.boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
        Set<TEGenCfgPortAttribute> portAttrList = this.getPortAttrList(neid, this.slotID, this.boardType);
        boolean simpleBoard = TETL1AIDTranslateRuleMgr.getInstance().isSimpleBoard(this.boardType);
        RowParams rParams = new RowParams();
        Map<Integer, TETL1OTNAvailableResObject> portfbMap = this.getPortFBMap(portAttrList);
        boolean bNullGrade = this.isContainsNullGrade(portfbMap);
        boolean isSupportFilter = simpleBoard && !bNullGrade;
        Param param = new Param("isSupportFilter", String.valueOf(isSupportFilter));
        rParams.addParam(param);
        bParams.addRowParams(rParams);
        this.constuctOutput(this.slotID, this.boardType, portfbMap);
        return this.outputData;
    }

    private boolean isContainsNullGrade(Map<Integer, TETL1OTNAvailableResObject> portfbMap) {
        Set<Map.Entry<Integer, TETL1OTNAvailableResObject>> entryset = portfbMap.entrySet();
        Iterator<Map.Entry<Integer, TETL1OTNAvailableResObject>> iterator = entryset.iterator();
        Map.Entry<Integer, TETL1OTNAvailableResObject> entry = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!entry.getValue().getFbPathMap().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private Map<Integer, TETL1OTNAvailableResObject> getPortFBMap(Set<TEGenCfgPortAttribute> portAttrList) {
        TreeMap<Integer, TETL1OTNAvailableResObject> portFbMap = new TreeMap<Integer, TETL1OTNAvailableResObject>();
        Iterator<TEGenCfgPortAttribute> iterator = portAttrList.iterator();
        TEGenCfgPortAttribute portAttr = null;
        String curFB = "";
        TETL1OTNAvailableResObject fbList = null;
        while (iterator.hasNext()) {
            portAttr = iterator.next();
            fbList = (TETL1OTNAvailableResObject)portFbMap.get(portAttr.getPort());
            if (fbList == null) {
                fbList = new TETL1OTNAvailableResObject(portAttr.getPort());
                portFbMap.put(portAttr.getPort(), fbList);
            }
            if ((curFB = this.getCurrFB(portAttr)) == null || curFB.isEmpty()) continue;
            fbList.addFbPath(curFB, portAttr.getPath());
        }
        return portFbMap;
    }

    private String getCurrFB(TEGenCfgPortAttribute portAttr) {
        int pathid = portAttr.getPath();
        String mod2 = TETL1AIDTranslateRuleMgr.getInstance().getCurMod2(this.boardType, String.valueOf(pathid));
        return mod2;
    }

    private void constuctOutput(int slotid, int boardType, Map<Integer, TETL1OTNAvailableResObject> portfbMap) {
        Set<Map.Entry<Integer, TETL1OTNAvailableResObject>> entryset = portfbMap.entrySet();
        Iterator<Map.Entry<Integer, TETL1OTNAvailableResObject>> iterator = entryset.iterator();
        Map.Entry<Integer, TETL1OTNAvailableResObject> entry = null;
        RowParams rParams = null;
        Param param = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            rParams = new RowParams();
            param = new Param("port", entry.getKey().toString());
            rParams.addParam(param);
            param = new Param("portname", TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotid, boardType, entry.getKey().intValue()));
            rParams.addParam(param);
            param = new Param("fbtype", entry.getValue().getAvailableFBStr());
            rParams.addParam(param);
            param = new Param("gradepath", entry.getValue().getFBPathStr());
            rParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rParams);
        }
    }

    private Set<TEGenCfgPortAttribute> getPortAttrList(int neid, int slotid, int boardType) {
        HashSet<TEGenCfgPortAttribute> portAttrList = new HashSet<TEGenCfgPortAttribute>();
        String attrNames = this.inputData.getBussinessParams().getRowParams(0).getParam("attrNames").getValue();
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardType);
        if (genCfgModel != null) {
            String[] attrArray = attrNames.split(",");
            TEGenCfgAttribute gencfgattr = null;
            int len = attrArray.length;
            for (int i = 0; i < len; ++i) {
                gencfgattr = genCfgModel.getAttrFromId(attrArray[i]);
                if (gencfgattr == null || gencfgattr.getPortList() == null) continue;
                portAttrList.addAll(gencfgattr.getPortList());
            }
        }
        return portAttrList;
    }
}

