/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.netimesyn;

import com.huawei.nglct.nemgr.tl1ngwdm.config.netimesyn.TENESynFileMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.netimesyn.TENESynTimeAutoTask;
import com.huawei.nglct.nemgr.tl1ngwdm.config.netimesyn.TENESynTimeData;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class TENESynTimeTaskInstance {
    private Map taskInstanceMap = new HashMap();
    private static TENESynTimeTaskInstance instance = null;

    private TENESynTimeTaskInstance() {
    }

    public static synchronized TENESynTimeTaskInstance getInstance() {
        if (instance == null) {
            instance = new TENESynTimeTaskInstance();
        }
        return instance;
    }

    public Timer getTaskInstanceByNeId(int neId) {
        return (Timer)this.taskInstanceMap.get(new Integer(neId));
    }

    public void addInstance(int neId, Timer instance) {
        this.taskInstanceMap.put(new Integer(neId), instance);
    }

    public void removeInstanceByNeId(int neId) {
        this.taskInstanceMap.remove(new Integer(neId));
    }

    public void handleSynTimeTask(int neid, String synMode) {
        TENESynTimeData synTimeInfo;
        Timer task = instance.getTaskInstanceByNeId(neid);
        if (task != null) {
            task.cancel();
            instance.removeInstanceByNeId(neid);
        }
        if ((synTimeInfo = TENESynFileMgr.getNeSynTimeInfo(neid)) == null) {
            return;
        }
        String startTimeStr = synTimeInfo.getSynStartDate();
        String cycleStr = synTimeInfo.getAutoSynCycle();
        if (synMode.equals("2") && !startTimeStr.equals("") && !cycleStr.equals("")) {
            Timer timerTask = new Timer();
            TENESynTimeAutoTask newTask = new TENESynTimeAutoTask(neid);
            TENESynTimeTaskInstance.getInstance().addInstance(neid, timerTask);
            long startTime = Long.parseLong(startTimeStr);
            long cycle = (Long.parseLong(cycleStr) + 1L) * 24L * 3600L * 1000L;
            long currTime = new GregorianCalendar().getTimeInMillis();
            if (startTime - 1000L < currTime) {
                long times = (currTime - startTime) / cycle;
                startTime += cycle * (times + 1L);
            }
            timerTask.scheduleAtFixedRate((TimerTask)newTask, new Date(startTime), cycle);
        }
    }
}

