/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.netimesyn;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.tl1ngwdm.config.netimesyn.TENESynFileMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.netimesyn.TENESynTimeTaskInstance;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.TETL1LogUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class TENESynTimeSetInfoBean
extends TETL1NEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.cloneTL1OperationList.clear();
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
            String synMode = rowParams[0].getParam("synmode").getValue();
            boolean flag = true;
            if (synMode.equals("3")) {
                String authPara = rowParams[0].getParam("ntpauth").getValue();
                flag = this.setNTPMode(authPara, "Y");
            } else {
                flag = this.setNTPMode("", "N");
            }
            if (flag && !this.modifyNeTime(neid, subFunc, inputData, memeryData, user, ipAddress)) {
                return this.outputData;
            }
            if (!synMode.equals("3")) {
                boolean writeDocResult = true;
                writeDocResult = TENESynFileMgr.setNeSynTimeInfo(neid, synMode, "", "");
                if (!writeDocResult) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)3843));
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                    TENESynTimeTaskInstance.getInstance().handleSynTimeTask(neid, synMode);
                }
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
            this.printLog();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENESynTimeSetInfoBean.performBussinessProcess() fail!", (Throwable)e);
        }
        return this.outputData;
    }

    public boolean setNTPMode(String ntpauth, String ntpenable) {
        ArrayList<TL1Operation> operList = new ArrayList<TL1Operation>();
        try {
            TENE ne = TENEListUtils.getNEObj((int)this.neid);
            String TL1_DES_PATH = TEGetFilePath.getFilePath((int)ne.getNEType(), (String)ne.getHostVersion(), (String)("conf" + File.separator + "tl1describ.xml"));
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((String)"com.huawei.weblct.tl1ngwdm", (String)TL1_DES_PATH);
            TL1Operation queryOper = definitions.getTL1Operation("ED-NTP-SYS");
            InMsg input = queryOper.getInMsg();
            input.getPart("ENABLE").setValue(ntpenable);
            if (!ntpauth.isEmpty()) {
                input.getPart("AUTH").setValue(ntpauth);
            }
            operList.add(queryOper);
            this.cloneTL1OperationList.add(queryOper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENESynTimeSetInfoBean.setNTPMode() fail!", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neid, operList, this.TIME_OUT);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().error("SET NTP fail, the errorCode is" + result.retCode);
            return false;
        }
        return true;
    }

    private boolean modifyNeTime(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        Param timeParam = rowParams[0].getParam("neTime");
        if (timeParam != null) {
            String neTime = timeParam.getValue();
            long neTimelong = Long.parseLong(neTime);
            GregorianCalendar neTimeCalendar = new GregorianCalendar();
            if (neTime != null && neTime.length() > 0) {
                Calendar currDate = TEDateUtils.getTL1NETimeFromNMUTCTime((int)neid, (long)neTimelong);
                neTimeCalendar.setTimeInMillis(currDate.getTimeInMillis());
                String date = neTimeCalendar.get(1) + "-" + (neTimeCalendar.get(2) + 1) + "-" + neTimeCalendar.get(5);
                String time = neTimeCalendar.get(11) + "-" + neTimeCalendar.get(12) + "-" + neTimeCalendar.get(13);
                RowParams rParams = inputData.getBussinessParams().getRowParams(0);
                rParams.addParam("DATE", date);
                rParams.addParam("TIME", time);
            }
            this.outputData = super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
            int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
            if (errorCode != 0) {
                return false;
            }
        }
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        TETL1LogUtil.writeLog((int)neid, (SubFunc)subfunc, (String)this.addProtectionToString(inputData), (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    private String addProtectionToString(Datainterface inputData) {
        TEResourceUtil res = null;
        StringBuffer strBuf = new StringBuffer();
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        int neId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"neId").getValue());
        String neName = TENEListUtils.getNEObj((int)this.neid).getNEName();
        StringBuffer filePath = new StringBuffer();
        filePath.append(TEPathManager.RESOURCE_PROFILE_PATH).append("config").append(File.separator).append("netimesyn").append(File.separator).append("netimesynlog_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        res = TEGetFilePath.getResource((int)neId, (StringBuffer)filePath);
        strBuf.append(res.getString("NEname")).append(":").append(neName).append("  ");
        String synmode = Datainterface.getParam((Param[])params, (String)"synmode").getValue();
        String SYNMode = "SYN" + synmode;
        strBuf.append(res.getString("synmode")).append(":").append(res.getString(SYNMode)).append(";");
        return strBuf.toString();
    }
}

