/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.netimesyn;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.tl1ngwdm.config.netimesyn.TENESynFileMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.netimesyn.TENESynTimeData;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class TENESynTimeQueryBean
extends TETL1NEExplorerBean {
    private static final int NTP_ENABLE = 0;
    private static final int NTP_AUTH = 1;

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        String[] ntpFlag = null;
        ArrayList<Object> tempOperationList = new ArrayList<Object>();
        int len = tl1OperList.size();
        for (int t = 0; t < len; ++t) {
            TL1Operation oper = (TL1Operation)tl1OperList.get(t);
            if (oper.getName().equalsIgnoreCase("RTRV-NTP-SYS")) {
                ntpFlag = this.getNTPEnableFlag(oper);
            }
            tempOperationList.add(oper.clone());
        }
        Datainterface tempOutputData = super.convertToDatainterface(neid, subfunc, tempOperationList, null);
        BussinessParams bParams = tempOutputData.getBussinessParams();
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(tempOutputData.getErrorMessage());
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.getBussinessParams().addRowParams(new RowParams());
        RowParams outPutRowparams = this.outputData.getBussinessParams().getRowParams(0);
        RowParams[] tempRParams = bParams.getRowParams();
        if (tempRParams.length != 0) {
            outPutRowparams.setRowErrors(tempRParams[tempRParams.length - 1].getRowErrors());
        }
        TENE ne = TENEListUtils.getNEObj((int)neid);
        outPutRowparams.addParam("nename", ne.getNEName());
        outPutRowparams.addParam("sychronmode", "");
        outPutRowparams.addParam("ntpauth", "");
        outPutRowparams.addParam("necurrtime", "");
        long nmTime = new GregorianCalendar().getTimeInMillis();
        outPutRowparams.addParam("nmtime", String.valueOf(nmTime));
        TENESynTimeData synTimeData = TENESynFileMgr.getNeSynTimeInfo(neid);
        if (synTimeData == null) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)3843));
        } else {
            if (ntpFlag != null && ntpFlag[0] != null && ntpFlag[0].equalsIgnoreCase("Y")) {
                outPutRowparams.getParam("sychronmode").setValue("3");
                outPutRowparams.getParam("ntpauth").setValue(ntpFlag[1]);
            } else {
                outPutRowparams.getParam("sychronmode").setValue(synTimeData.getSynMode());
                outPutRowparams.getParam("ntpauth").setValue("N");
            }
            outPutRowparams.addParam("synstarttime", synTimeData.getSynStartDate());
            outPutRowparams.addParam("aoutsyncycle", synTimeData.getAutoSynCycle());
        }
        this.setNETimeOutputParam(outPutRowparams, this.getOperation(tl1OperList));
    }

    private String[] getNTPEnableFlag(TL1Operation oper) {
        String[] ntpStrArray = new String[2];
        if (oper.getOutMsgCount() != 0) {
            int count = oper.getOutMsg(0).getMsgBlock().getDataBlock(0).getPartCount();
            for (int i = 0; i < count; ++i) {
                Part part = oper.getOutMsg(0).getMsgBlock().getDataBlock(0).getPart(i);
                if (part.getName().equals("ENABLE")) {
                    ntpStrArray[0] = part.getValue();
                    continue;
                }
                if (!part.getName().equals("AUTH")) continue;
                ntpStrArray[1] = part.getValue();
            }
        }
        return ntpStrArray;
    }

    private TL1Operation getOperation(ArrayList tempOperationList) {
        int n = tempOperationList.size();
        for (int i = 0; i < n; ++i) {
            TL1Operation operation = (TL1Operation)tempOperationList.get(i);
            if (!operation.getName().equals("RTRV-DAT")) continue;
            return operation;
        }
        return null;
    }

    private void setNETimeOutputParam(RowParams outPutRowparams, TL1Operation operation) {
        Calendar cal = null;
        Calendar calUtc = null;
        String tmZone = "";
        String dsTime = "";
        try {
            OutMsg[] outmsgs = operation.getOutMsg();
            String neTime = "";
            String tempTime = "";
            for (OutMsg out : outmsgs) {
                int m = out.getMsgBlock().getDataBlockCount();
                for (int i = 0; i < m; ++i) {
                    DataBlock dataBlock = out.getMsgBlock().getDataBlock(i);
                    neTime = dataBlock.getPart(0).getValue();
                    tempTime = dataBlock.getPart(1).getValue();
                    tmZone = dataBlock.getPart(2).getValue();
                    dsTime = dataBlock.getPart(3).getValue();
                }
            }
            neTime = neTime + " " + tempTime;
            cal = TEDateUtils.strToCalendar((String)neTime, (String)"yyyy-MM-dd HH-mm-ss");
            calUtc = TEDateUtils.getTL1UTCTimeFromNETime((int)this.neid, (long)cal.getTimeInMillis());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENESynTimeQueryBean.setNETimeOutputParam() fail!", (Throwable)e);
        }
        if (calUtc != null) {
            outPutRowparams.addParam("necurrtime", String.valueOf(calUtc.getTimeInMillis()));
        } else {
            outPutRowparams.addParam("necurrtime", "");
        }
        outPutRowparams.addParam("tmZone", tmZone);
        outPutRowparams.addParam("dsTime", dsTime);
    }
}

