/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.netimesyn;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nemgr.tl1ngwdm.config.netimesyn.TENESynFileMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.netimesyn.TENESynTimeTaskInstance;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.TETL1LogUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.Calendar;

public class TENESynSetAutoInfoBean
extends TETL1NEExplorerBean {
    private TEResourceUtil res = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
            this.outputData = new Datainterface();
            String synStartTime = rowParams[0].getParam("synstarttime").getValue();
            String synCycle = rowParams[0].getParam("syncycle").getValue();
            boolean writeDocResult = TENESynFileMgr.setNeSynTimeInfo(neid, "2", synStartTime, synCycle);
            if (!writeDocResult) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)3843));
            } else {
                TENESynTimeTaskInstance.getInstance().handleSynTimeTask(neid, "2");
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENESynSetAutoInfoBean.performBussinessProcess() fail!", (Throwable)e);
        }
        return this.outputData;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        TETL1LogUtil.writeLog((int)neid, (SubFunc)subfunc, (String)this.addProtectionToString(inputData), (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    private String addProtectionToString(Datainterface inputData) {
        StringBuffer strBuf = new StringBuffer();
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        int neId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"neId").getValue());
        StringBuffer filePath = new StringBuffer();
        filePath.append(TEPathManager.RESOURCE_PROFILE_PATH).append("config").append(File.separator).append("netimesyn").append(File.separator).append("netimesynlog_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neId, (StringBuffer)filePath);
        Calendar cal = Calendar.getInstance();
        long synStartTime = Long.parseLong(Datainterface.getParam((Param[])params, (String)"synstarttime").getValue());
        cal.setTimeInMillis(synStartTime);
        String timeformat = TimeZoneDateBean.getTimeConvertFormat();
        String sdf = TEDateUtils.calendarToStr((Calendar)cal, (String)timeformat);
        int synCycle = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"syncycle").getValue());
        strBuf.append(this.res.getString("synstarttime")).append(":").append(sdf).append(",").append(this.res.getString("syncycle")).append(":").append(Integer.toString(synCycle + 1));
        return strBuf.toString();
    }
}

