/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.ipa;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.tl1necommon.TETL1NecommonUtil;
import com.huawei.nglct.nemgr.tl1ngwdm.config.ipa.TEIPADelBean;
import com.huawei.nglct.nemgr.tl1ngwdm.config.ipa.TENEIpaContainer;
import com.huawei.nglct.tl1.TEAIDAndType;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class TEIPASetBean
extends TEIPADelBean {
    public TEIPASetBean() {
        this.msgBlockFlag = false;
    }

    public ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions, ArrayList tl1OperNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> tl1List = tl1OperNameList;
        if (null == tl1OperNameList) {
            tl1List = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                tl1List.add(subfunc.getQxMapping(i).getContent());
            }
        }
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            this.setRaman(rowparams, tl1OperList);
            int size = tl1List.size();
            for (int i = 0; i < size; ++i) {
                this.curTL1Operation = tl1Operation = tl1Definitions.getTL1Operation((String)tl1List.get(i));
                if (null == tl1Operation) continue;
                inputMsg = tl1Operation.getInMsg();
                if (null == inputMsg) {
                    tl1OperList.add(tl1Operation);
                    continue;
                }
                tl1Operation.clearCmdFaultInfo();
                fillComplete = this.fillStagBlock(rowparams, inputMsg.getStagBlock());
                if (fillComplete) {
                    fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                }
                if (!this.msgBlockFlag && !fillComplete) continue;
                tl1OperList.add(tl1Operation);
            }
            Param downTH = rowparams.getParam("ramanThreshold");
            Param slotID = rowparams.getParam("slotid");
            if (downTH == null || downTH.getValue() == null || slotID == null || slotID.getValue() == null) continue;
            this.setAlmth(Integer.parseInt(slotID.getValue()), downTH.getValue(), tl1OperList);
        }
        return tl1OperList;
    }

    @Override
    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        if (part.getName().equalsIgnoreCase("DECT")) {
            StringBuffer sb = new StringBuffer();
            sb.append("FAC-");
            Param slotIDParam = rowparams.getParam("alarmSlotid");
            Param portParam = rowparams.getParam("alarmPort");
            Param neidParam = rowparams.getParam("neid");
            if (slotIDParam == null || portParam == null || neidParam == null) {
                return false;
            }
            if (slotIDParam.getValue().equals("0")) {
                part.setValue("NULL");
            } else {
                String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)Integer.parseInt(neidParam.getValue()), (int)Integer.parseInt(slotIDParam.getValue()));
                sb.append(shelfSlotID);
                sb.append("-").append(portParam.getValue());
                part.setValue(sb.toString());
            }
        } else if (part.getName().equalsIgnoreCase("OPRT")) {
            StringBuffer sb = new StringBuffer();
            sb.append("FAC-");
            Param slotIDParam = rowparams.getParam("ctlSlotid");
            Param portParam = rowparams.getParam("ctlPort");
            Param neidParam = rowparams.getParam("neid");
            if (slotIDParam == null || portParam == null || neidParam == null) {
                return false;
            }
            if (slotIDParam.getValue().equals("0")) {
                part.setValue("NULL");
            } else {
                String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)Integer.parseInt(neidParam.getValue()), (int)Integer.parseInt(slotIDParam.getValue()));
                sb.append(shelfSlotID);
                sb.append("-").append(portParam.getValue());
                part.setValue(sb.toString());
            }
        } else if (part.getName().equalsIgnoreCase("RAMANOPRT")) {
            Param param = rowparams.getParam("auxiliaryRamanCard");
            if (param == null) {
                return false;
            }
            if (!param.getValue().equals("NULL") && !param.getValue().equals("-") && param.getModifyFlag()) {
                String slotKey = this.neid + "-" + param.getValue();
                int slotID = Integer.parseInt(TENEIpaContainer.getInstance().getipaBoardStuctSlotMap(slotKey));
                String aid = this.writeAidFormat(String.valueOf(slotID), "SLOT");
                part.setValue(aid);
            }
        } else if (part.getName().equalsIgnoreCase("ROPOPRT")) {
            Param param = rowparams.getParam("ropCard");
            if (param == null) {
                return false;
            }
            if (!param.getValue().equals("NULL") && !param.getValue().equals("-") && param.getModifyFlag()) {
                String slotKey = this.neid + "-" + param.getValue();
                int slotID = Integer.parseInt(TENEIpaContainer.getInstance().getipaBoardStuctSlotMap(slotKey));
                String aid = this.writeAidFormat(String.valueOf(slotID), "SLOT");
                part.setValue(aid);
            }
        } else {
            return super.convertPartValue(part, rowparams);
        }
        return flag;
    }

    private void setAlmth(int slotid, String value, ArrayList operList) {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(slotid));
        this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)this.neid, set);
        String aid = this.writeAidFormat(String.valueOf(slotid), "FAC");
        aid = aid + "-1";
        HashMap aidMap = this.aidAndTypeList.getAidAndTypeMap();
        Iterator it = aidMap.entrySet().iterator();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ArrayList list = (ArrayList)entry.getValue();
                TEAIDAndType aidAndType = (TEAIDAndType)list.get(0);
                ArrayList actTypesList = TETL1CommonUtil.parseString((String)aidAndType.getType(), (String)"|");
                int n = actTypesList.size();
                for (int i = 0; i < n; ++i) {
                    String mod2 = String.valueOf(actTypesList.get(i));
                    if (!mod2.equals("WDM")) continue;
                    TL1Operation queryOper = definitions.getTL1Operation("ED-ALMTH-MOD2");
                    InMsg input = queryOper.getInMsg();
                    input.getPart("AID").setValue(aid);
                    input.getPart("ALMTHTYPE").setValue("OPR");
                    input.getPart("DOWNTH").setValue(value);
                    input.getPart("UPTH").setValue("INVALID");
                    queryOper.setCmdCode("ED");
                    queryOper.setMod1("ALMTH");
                    queryOper.setMod2(mod2);
                    queryOper.setName("ED-ALMTH-" + mod2);
                    operList.add(queryOper);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Search TOM Port Fail!", (Throwable)e);
        }
    }

    private void setRaman(RowParams rowparams, ArrayList operList) {
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TL1Operation queryOper = definitions.getTL1Operation("ED-IPA");
            InMsg input = queryOper.getInMsg();
            Part dect = input.getPart("DECT");
            this.convertPartValue(dect, rowparams);
            Part oprt = input.getPart("OPRT");
            this.convertPartValue(oprt, rowparams);
            Part auxPart = input.getPart("RAMANOPRT");
            Param auxParam = rowparams.getParam("auxParam");
            if (auxParam != null && auxParam.getValue() != null && auxParam.getModifyFlag()) {
                auxPart.setValue("NULL");
            }
            Part ropPart = input.getPart("ROPOPRT");
            Param ropParam = rowparams.getParam("ropParam");
            if (ropParam != null && ropParam.getValue() != null && ropParam.getModifyFlag()) {
                ropPart.setValue("NULL");
            }
            if (auxParam != null && auxParam.getModifyFlag() || ropParam != null && ropParam.getModifyFlag()) {
                operList.add(queryOper);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("setRaman Board Fail!", (Throwable)e);
        }
    }

    @Override
    public void addErrorParam(int neid, RowErrors rowError) {
        TETL1NecommonUtil.addErrorParam((int)neid, (RowErrors)rowError);
    }

    private String writeAidFormat(String slotID, String index) {
        StringBuffer sb = new StringBuffer();
        sb.append(index);
        sb.append("-");
        String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotID));
        sb.append(shelfSlotID);
        return sb.toString();
    }

    @Override
    protected boolean isNeedQueryLaserStatus(RowParams rowParams) {
        return rowParams.getParam("ramonSlotid") != null && !rowParams.getParam("ramonSlotid").getValue().equals("-1") && rowParams.getParam("ipaEnable") != null && rowParams.getParam("ipaEnable").getValue().equals("N");
    }

    @Override
    protected ArrayList handleOperation(ArrayList tl1OperationList, Map<String, String> rtnMap) {
        ArrayList<TL1Operation> laserCfgOpers = new ArrayList<TL1Operation>();
        Iterator iter = tl1OperationList.iterator();
        OutMsg curOutput = null;
        while (iter.hasNext()) {
            TL1Operation operTemp = (TL1Operation)iter.next();
            if (!operTemp.getName().equals("ED-IPA")) continue;
            AID aid = operTemp.getInMsg().getStagBlock().getAID();
            String oprtAID = aid.getPart(1).getValue();
            int slotID = TETL1CommonUtil.getNMSlotStr((String)oprtAID, (int)this.neid);
            int portID = TETL1CommonUtil.getPortIDFromAID((String)oprtAID, (int)this.neid);
            if (rtnMap.get(slotID + "-" + portID) == null) continue;
            for (int index = operTemp.getOutMsgCount() - 1; index >= 0; --index) {
                curOutput = operTemp.getOutMsg(index);
                curOutput.getFault().setCompletionCode(1090593017);
                curOutput.getFault().setErrDesc("Not all RAMAN lasers within IPA pair are OFF.");
            }
            laserCfgOpers.add(operTemp);
            iter.remove();
        }
        return laserCfgOpers;
    }
}

