/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.ipa;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1necommon.TETL1NecommonUtil;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class TEIPADelBean
extends TETL1NEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            Map rtnMap = this.handleRamanLaserStatus(inputData);
            this.tl1OperList = super.getTL1Operation(neid, subFunc, inputData, memeryData);
            ArrayList laserCfgOpers = this.handleOperation(this.tl1OperList, rtnMap);
            if (null == this.tl1OperList || this.tl1OperList.isEmpty()) {
                super.handleMessage(neid, laserCfgOpers, subFunc, this.getFilterErrorCodeList());
            } else {
                int result = this.sendMessage(neid, this.tl1OperList);
                if (result == 0) {
                    this.tl1OperList.addAll(laserCfgOpers);
                    this.handleMessage(neid, this.tl1OperList, subFunc, this.getFilterErrorCodeList());
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                }
            }
            this.printLog();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    protected Map handleRamanLaserStatus(Datainterface inputData) {
        int i;
        ArrayList laserOperationList = new ArrayList();
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        HashSet<Integer> slotidList = new HashSet<Integer>();
        HashMap<Integer, String> ipaIDMap = new HashMap<Integer, String>();
        int len = rowParams.length;
        for (i = 0; i < len; ++i) {
            if (!this.isNeedQueryLaserStatus(rowParams[i])) continue;
            slotidList.add(Integer.parseInt(rowParams[i].getParam("ramonSlotid").getValue()));
        }
        if (slotidList.isEmpty()) {
            return ipaIDMap;
        }
        this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)this.neid, slotidList, (Datainterface)this.outputData);
        len = rowParams.length;
        for (i = 0; i < len; ++i) {
            if (!this.isNeedQueryLaserStatus(rowParams[i])) continue;
            int ramonSlotid = Integer.parseInt(rowParams[i].getParam("ramonSlotid").getValue());
            String ctlSlotid = rowParams[i].getParam("ctlSlotid").getValue();
            String ctlPort = rowParams[i].getParam("ctlPort").getValue();
            ipaIDMap.put(ramonSlotid, ctlSlotid + "-" + ctlPort);
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, ramonSlotid);
            if (boardType == 2318) {
                this.getQueryLaserStatusTL1OperationList(ramonSlotid, 9, 1, laserOperationList);
                continue;
            }
            this.getQueryLaserStatusTL1OperationList(ramonSlotid, 1, 1, laserOperationList);
            this.getQueryLaserStatusTL1OperationList(ramonSlotid, 1, 2, laserOperationList);
        }
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neid, laserOperationList, 30);
        if (result.retCode == 0) {
            TL1Operation tmpOper = null;
            DataBlock dataBlock = null;
            Part part = null;
            int len2 = laserOperationList.size();
            for (int i2 = 0; i2 < len2; ++i2) {
                tmpOper = (TL1Operation)laserOperationList.get(i2);
                if (tmpOper.getOutMsgCount() <= 0) continue;
                AID aid = tmpOper.getInMsg().getStagBlock().getAID();
                int slotID = TETL1CommonUtil.getNMSlotStr((String)aid.getPart(0).getValue(), (int)this.neid);
                String newKey = (String)ipaIDMap.get(slotID);
                int count = tmpOper.getOutMsg(0).getMsgBlock().getDataBlockCount();
                block3: for (int j = 0; j < count; ++j) {
                    dataBlock = tmpOper.getOutMsg(0).getMsgBlock().getDataBlock(j);
                    int size = dataBlock.getPartCount();
                    for (int k = 0; k < size; ++k) {
                        part = dataBlock.getPart(k);
                        if (!part.getName().equals("LSRSTATE") || part.getValue() == null || !part.getValue().equals("OPEN")) continue;
                        rtnMap.put(newKey, "OPEN");
                        continue block3;
                    }
                }
            }
        }
        return rtnMap;
    }

    protected ArrayList handleOperation(ArrayList tl1OperationList, Map<String, String> rtnMap) {
        ArrayList<TL1Operation> laserCfgOpers = new ArrayList<TL1Operation>();
        Iterator iter = tl1OperationList.iterator();
        OutMsg curOutput = null;
        while (iter.hasNext()) {
            TL1Operation operTemp = (TL1Operation)iter.next();
            AID aid = operTemp.getInMsg().getStagBlock().getAID();
            String oprtAID = aid.getPart(1).getValue();
            int slotID = TETL1CommonUtil.getNMSlotStr((String)oprtAID, (int)this.neid);
            int portID = TETL1CommonUtil.getPortIDFromAID((String)oprtAID, (int)this.neid);
            if (rtnMap.get(slotID + "-" + portID) == null) continue;
            for (int index = operTemp.getOutMsgCount() - 1; index >= 0; --index) {
                curOutput = operTemp.getOutMsg(index);
                curOutput.getFault().setCompletionCode(1090593017);
                curOutput.getFault().setErrDesc("Not all RAMAN lasers within IPA pair are OFF.");
            }
            laserCfgOpers.add(operTemp);
            iter.remove();
        }
        return laserCfgOpers;
    }

    private void getQueryLaserStatusTL1OperationList(int slotID, int portID, int pathID, ArrayList laserOperationList) {
        try {
            TL1Definitions tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            String aid = "";
            String mod2 = "";
            if (pathID == 0) {
                aid = this.aidAndTypeList.getAID(this.neid, slotID, portID);
                mod2 = this.aidAndTypeList.getPayLoadMod2(this.neid, slotID, portID);
            } else {
                aid = this.aidAndTypeList.getAID(this.neid, slotID, portID, pathID);
                mod2 = this.aidAndTypeList.getPayLoadMod2(this.neid, slotID, portID, pathID);
            }
            TL1Operation tl1Op = tl1definitions.getTL1Operation("RTRV-" + mod2);
            tl1Op.getInMsg().getStagBlock().getAID().getPart(0).setValue(aid);
            laserOperationList.add(tl1Op.clone());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEIPADelBean getQueryLaserStatusTL1OperationList fail!", (Throwable)e);
        }
    }

    protected boolean isNeedQueryLaserStatus(RowParams rowParams) {
        return rowParams.getParam("ramonSlotid") != null && !rowParams.getParam("ramonSlotid").getValue().equals("-1");
    }

    protected boolean convertPartValue(Part part, RowParams rowparamsTmp) {
        boolean flag = true;
        if (part.getName().equalsIgnoreCase("DECT")) {
            StringBuffer sb = new StringBuffer();
            sb.append("FAC-");
            Param slotIDParam = rowparamsTmp.getParam("alarmSlotid");
            Param portParam = rowparamsTmp.getParam("alarmPort");
            Param neidParam = rowparamsTmp.getParam("neid");
            if (slotIDParam == null || portParam == null || neidParam == null) {
                return false;
            }
            if (slotIDParam.getValue().equals("0")) {
                part.setValue("NULL");
            } else {
                String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)Integer.parseInt(neidParam.getValue()), (int)Integer.parseInt(slotIDParam.getValue()));
                sb.append(shelfSlotID);
                sb.append("-").append(portParam.getValue());
                part.setValue(sb.toString());
            }
        } else if (part.getName().equalsIgnoreCase("OPRT")) {
            StringBuffer sb = new StringBuffer();
            sb.append("FAC-");
            Param slotIDParam = rowparamsTmp.getParam("ctlSlotid");
            Param portParam = rowparamsTmp.getParam("ctlPort");
            Param neidParam = rowparamsTmp.getParam("neid");
            if (slotIDParam == null || portParam == null || neidParam == null) {
                return false;
            }
            if (slotIDParam.getValue().equals("0")) {
                part.setValue("NULL");
            } else {
                String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)Integer.parseInt(neidParam.getValue()), (int)Integer.parseInt(slotIDParam.getValue()));
                sb.append(shelfSlotID);
                sb.append("-").append(portParam.getValue());
                part.setValue(sb.toString());
            }
        } else {
            return super.convertPartValue(part, rowparamsTmp);
        }
        return flag;
    }

    public void addErrorParam(int neid, RowErrors rowError) {
        TETL1NecommonUtil.addErrorParam((int)neid, (RowErrors)rowError);
    }
}

