/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.ipa;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.tl1necommon.TETL1NecommonUtil;
import com.huawei.nglct.nemgr.tl1ngwdm.config.ipa.TENEIpaContainer;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class TEIPAAvailabeResQueryBean
implements TENEMgrInterface {
    private static final String W32PORT_ATTR_IPA_ALM = "DWDMW32PORT_ATTR_IPA_ALM";
    private static final String W32PORT_ATTR_IPA_CTRL = "DWDMW32PORT_ATTR_IPA_CTRL";
    private static final String W32PORT_ATTR_IPA_RAMAN = "DWDMW32PORT_ATTR_IPA_RAMAN";
    private static final String W32PORT_ATTR_IPA_RAMAN_AUX = "DWDMW32PORT_ATTR_IPA_RAMAN_AUX";
    private static final String W32PORT_ATTR_IPA_RAMAN_ROP = "DWDMW32PORT_ATTR_IPA_RAMAN_ROP";
    private int neid;
    private Datainterface output;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = new Datainterface();
        TENE neObj = TENEListUtils.getNEObj((int)neid);
        try {
            if (null != neObj) {
                this.getAvaliableIPABoard();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
        }
        catch (Exception e) {
            this.log.error("Get Avaliable IPA Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    private void getAvaliableIPABoard() {
        this.output.setBussinessParams(new BussinessParams());
        ArrayList almBoardList = this.getAttrSupportCPs(this.neid, W32PORT_ATTR_IPA_ALM);
        this.convertToDatainterface(this.neid, W32PORT_ATTR_IPA_ALM, almBoardList, "alarm");
        ArrayList ctrlBoardList = this.getAttrSupportCPs(this.neid, W32PORT_ATTR_IPA_CTRL);
        this.convertToDatainterface(this.neid, W32PORT_ATTR_IPA_CTRL, ctrlBoardList, "control");
        ArrayList ramanBoardList = null;
        int ramanNeId = this.neid;
        ramanBoardList = this.getAttrSupportCPs(ramanNeId, W32PORT_ATTR_IPA_RAMAN);
        this.filterList(ramanBoardList, TENEIpaContainer.getInstance().getRamanUsedBoard());
        this.filterList(ramanBoardList, TENEIpaContainer.getInstance().getRamanAuxUsedBoard());
        this.filterList(ramanBoardList, TENEIpaContainer.getInstance().getRamanRopUsedBoard());
        this.convertToDatainterface(ramanNeId, W32PORT_ATTR_IPA_RAMAN, ramanBoardList, "raman");
        ArrayList ramanAuxBoardList = null;
        ramanAuxBoardList = this.getAttrSupportCPs(ramanNeId, W32PORT_ATTR_IPA_RAMAN_AUX);
        this.filterList(ramanAuxBoardList, TENEIpaContainer.getInstance().getRamanUsedBoard());
        this.filterList(ramanAuxBoardList, TENEIpaContainer.getInstance().getRamanAuxUsedBoard());
        this.convertToDatainterface(ramanNeId, W32PORT_ATTR_IPA_RAMAN_AUX, ramanAuxBoardList, "raman_aux");
        ArrayList ramanRopBoardList = null;
        ramanRopBoardList = this.getAttrSupportCPs(ramanNeId, W32PORT_ATTR_IPA_RAMAN_ROP);
        this.filterList(ramanRopBoardList, TENEIpaContainer.getInstance().getRamanUsedBoard());
        this.filterList(ramanRopBoardList, TENEIpaContainer.getInstance().getRamanRopUsedBoard());
        this.convertToDatainterface(ramanNeId, W32PORT_ATTR_IPA_RAMAN_ROP, ramanRopBoardList, "raman_rop");
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    private void filterList(ArrayList ramanBoardList, List ramanUsedBoard) {
        int n = ramanBoardList.size();
        for (int i = 0; i < n; ++i) {
            TEBoard board = (TEBoard)ramanBoardList.get(i);
            int nn = ramanUsedBoard.size();
            for (int ii = 0; ii < nn; ++ii) {
                String slotID = (String)ramanUsedBoard.get(ii);
                if (board.getSlotID() != Integer.parseInt(slotID)) continue;
                ramanBoardList.remove(board);
                --n;
            }
        }
    }

    private void convertToDatainterface(int neid, String attrId, ArrayList boardList, String type) {
        if (null == boardList) {
            return;
        }
        String nename = TENEListUtils.getNEObj((int)neid).getNEName();
        TEBoard board = null;
        RowParams rowparams = null;
        RowParams newrowparams = null;
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            rowparams = new RowParams();
            board = (TEBoard)boardList.get(i);
            rowparams.addParam("type", type);
            rowparams.addParam("neid", String.valueOf(neid));
            rowparams.addParam("nename", nename);
            rowparams.addParam("slotid", String.valueOf(board.getSlotID()));
            rowparams.addParam("boardid", String.valueOf(board.getBoardType()));
            rowparams.addParam("boardname", board.getBoardName());
            rowparams.addParam("subrackName", TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)board.getSlotID()));
            if (type.indexOf("raman") < 0) {
                ArrayList portList = TEGenCfgDataMgr.getGenCfgMode((int)board.getBoardType()).getAttrFromId(attrId).getPortList();
                if (null == portList) continue;
                int size = portList.size();
                for (int j = 0; j < size; ++j) {
                    newrowparams = new RowParams();
                    TEGenCfgPortAttribute portObj = (TEGenCfgPortAttribute)portList.get(j);
                    newrowparams.setParam(rowparams.getParam());
                    newrowparams.addParam("port", String.valueOf(portObj.getPort()));
                    newrowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, board.getSlotID(), board.getBoardType(), portObj.getPort()));
                    this.output.getBussinessParams().addRowParams(newrowparams);
                }
            } else {
                this.output.getBussinessParams().addRowParams(rowparams);
            }
            ArrayList sortList = this.output.getBussinessParams().getRowParamList();
            Collections.sort(sortList, new Comparator<RowParams>(){

                @Override
                public int compare(RowParams rp1, RowParams rp2) {
                    int portid2;
                    int slotid2;
                    int slotid1 = Integer.parseInt(rp1.getParam("slotid").getValue());
                    if (slotid1 > (slotid2 = Integer.parseInt(rp2.getParam("slotid").getValue()))) {
                        return 1;
                    }
                    if (slotid1 < slotid2) {
                        return -1;
                    }
                    int portid1 = Integer.parseInt(rp1.getParam("slotid").getValue());
                    if (portid1 >= (portid2 = Integer.parseInt(rp2.getParam("slotid").getValue()))) {
                        return 1;
                    }
                    return -1;
                }
            });
        }
    }

    private ArrayList getAttrSupportCPs(int neid, String attrId) {
        TENE neObj = TENEListUtils.getNEObj((int)neid);
        ArrayList<TEBoard> supportCPs = new ArrayList<TEBoard>();
        if (null == neObj) {
            return null;
        }
        Vector boardList = neObj.getBoardList();
        if (null == boardList) {
            return null;
        }
        TEBoard board = null;
        TEGenCfgModel genCfgMode = null;
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            board = (TEBoard)boardList.get(i);
            genCfgMode = TEGenCfgDataMgr.getGenCfgMode((int)board.getBoardType());
            if (null == genCfgMode || null == genCfgMode.getAttrFromId(attrId)) continue;
            supportCPs.add(board);
        }
        return supportCPs;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    public void addErrorParam(int neid, RowErrors rowError) {
        TETL1NecommonUtil.addErrorParam((int)neid, (RowErrors)rowError);
    }
}

