/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.ipa;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.tl1necommon.TETL1NecommonUtil;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TEIPAAddBean
extends TETL1NEExplorerBean {
    String ramanAid = "";

    public TEIPAAddBean() {
        this.bQueryAidAndType = true;
        this.msgBlockFlag = true;
    }

    protected TL1Operation changeMod2BySub(TL1Operation tl1Operation, RowParams rowparams) {
        if (tl1Operation.getName().equals("ED-ALMTH-MOD2")) {
            boolean flag = false;
            if (this.ramanAid.equals("")) {
                tl1Operation = null;
                return tl1Operation;
            }
            String mod2 = this.aidAndTypeList.getMod2(this.neid, this.ramanAid);
            ArrayList actTypesList = TETL1CommonUtil.parseString((String)mod2, (String)"|");
            int n = actTypesList.size();
            for (int i = 0; i < n; ++i) {
                String mod2Value = (String)actTypesList.get(i);
                if (!mod2Value.equals("WDM")) continue;
                tl1Operation.setMod2(mod2Value);
                tl1Operation.setName("ED-ALMTH-" + mod2Value);
                flag = true;
            }
            if (!flag || rowparams.getParam("DOWNTH") == null) {
                tl1Operation = null;
            }
            return tl1Operation;
        }
        return tl1Operation;
    }

    public ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions, ArrayList tl1OperNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> tl1List = tl1OperNameList;
        if (null == tl1OperNameList) {
            tl1List = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                tl1List.add(subfunc.getQxMapping(i).getContent());
            }
        }
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = tl1List.size();
            for (int i = 0; i < size; ++i) {
                tl1Operation = tl1Definitions.getTL1Operation((String)tl1List.get(i));
                this.curTL1Operation = tl1Operation = this.changeMod2BySub(tl1Operation, rowparams);
                if (null == tl1Operation) continue;
                inputMsg = tl1Operation.getInMsg();
                if (null == inputMsg) {
                    tl1OperList.add(tl1Operation);
                    continue;
                }
                tl1Operation.clearCmdFaultInfo();
                fillComplete = this.fillStagBlock(rowparams, inputMsg.getStagBlock());
                if (fillComplete) {
                    fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                }
                if (!this.msgBlockFlag && !fillComplete) continue;
                tl1OperList.add(tl1Operation);
            }
        }
        Param paramDec = businessparams.getRowParams(0).getParam("addDetectBoard");
        if (paramDec != null && !paramDec.getValue().equals("")) {
            tl1Operation = tl1Definitions.getTL1Operation("ENT-IPA-ASTDECT");
            ArrayList decOperList = this.createIPADecOperList(rowparams, tl1Operation);
            tl1OperList.addAll(decOperList);
        }
        return tl1OperList;
    }

    private ArrayList createIPADecOperList(RowParams rowparams, TL1Operation tl1Operation) {
        ArrayList<TL1Operation> list = new ArrayList<TL1Operation>();
        String[] str = rowparams.getParam("addDetectBoard").getValue().split(",");
        int len = str.length;
        for (int i = 0; i < len; ++i) {
            String[] boardStr = str[i].split("-");
            String slotid = boardStr[0];
            String port = boardStr[1];
            TL1Operation oper = (TL1Operation)tl1Operation.clone();
            boolean fillComplete = this.fillStagBlock(rowparams, oper.getInMsg().getStagBlock());
            if (!fillComplete) continue;
            String aid = TETL1CommonUtil.getAIDFromPort((int)this.neid, (String)slotid, (String)port, (String)"");
            oper.getInMsg().getMsgBlock().getPart("ASTDECT").setValue(aid);
            list.add(oper);
        }
        return list;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        if (part.getName().equalsIgnoreCase("DECT")) {
            StringBuffer sb = new StringBuffer();
            sb.append("FAC-");
            Param slotIDParam = rowparams.getParam("alarmSlotid");
            Param portParam = rowparams.getParam("alarmPort");
            Param neidParam = rowparams.getParam("neid");
            if (slotIDParam == null || portParam == null || neidParam == null) {
                return false;
            }
            if (slotIDParam.getValue().equals("0")) {
                part.setValue("NULL");
            } else {
                String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)Integer.parseInt(neidParam.getValue()), (int)Integer.parseInt(slotIDParam.getValue()));
                sb.append(shelfSlotID);
                sb.append("-").append(portParam.getValue());
                part.setValue(sb.toString());
            }
        } else if (part.getName().equalsIgnoreCase("OPRT")) {
            StringBuffer sb = new StringBuffer();
            sb.append("FAC-");
            Param slotIDParam = rowparams.getParam("ctlSlotid");
            Param portParam = rowparams.getParam("ctlPort");
            Param neidParam = rowparams.getParam("neid");
            if (slotIDParam == null || portParam == null || neidParam == null) {
                return false;
            }
            if (slotIDParam.getValue().equals("0")) {
                part.setValue("NULL");
            } else {
                String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)Integer.parseInt(neidParam.getValue()), (int)Integer.parseInt(slotIDParam.getValue()));
                sb.append(shelfSlotID);
                sb.append("-").append(portParam.getValue());
                part.setValue(sb.toString());
            }
        } else if (part.getName().equalsIgnoreCase("RAMANOPRT")) {
            Param slotIDParam = rowparams.getParam("raman_aux");
            if (slotIDParam == null) {
                return false;
            }
            if (slotIDParam.getValue().equals("-")) {
                part.setValue(null);
            } else {
                String slot = slotIDParam.getValue();
                String value = this.writeAidFormat(slot, "SLOT");
                part.setValue(value);
            }
        } else if (part.getName().equalsIgnoreCase("ROPOPRT")) {
            Param slotIDParam = rowparams.getParam("raman_rop");
            if (slotIDParam == null) {
                return false;
            }
            if (slotIDParam.getValue().equals("-")) {
                part.setValue(null);
            } else {
                String slot = slotIDParam.getValue();
                String value = this.writeAidFormat(slot, "SLOT");
                part.setValue(value);
            }
        } else if (part.getName().equalsIgnoreCase("RAMANBID")) {
            Param slotIDParam = rowparams.getParam("raman");
            if (slotIDParam == null) {
                return false;
            }
            if (slotIDParam.getValue().equals("-")) {
                part.setValue(null);
            } else {
                String slot = slotIDParam.getValue();
                String value = this.writeAidFormat(slot, "SLOT");
                String portValue = this.writeAidFormat(slot, "FAC");
                this.ramanAid = portValue + "-1";
                part.setValue(value);
            }
        } else if (part.getName().equalsIgnoreCase("RAMANTID")) {
            Param slotIDParam = rowparams.getParam("ramantid");
            if (slotIDParam == null) {
                return false;
            }
            if (slotIDParam.getValue().equals("-") || slotIDParam.getValue().equals("")) {
                part.setValue(null);
            } else {
                String slot = slotIDParam.getValue();
                part.setValue(slot);
            }
        } else if (part.getName().equalsIgnoreCase("AID")) {
            part.setValue(this.ramanAid);
        } else if (part.getName().equals("RXLOSTH")) {
            Param slotIDParam = rowparams.getParam("ramanAlarmTH");
            if (slotIDParam == null) {
                return false;
            }
            if (slotIDParam.getValue().equals("-")) {
                part.setValue(null);
            } else {
                part.setValue(slotIDParam.getValue());
            }
        } else if (part.getName().equals("RMNALMFLAG")) {
            Param slotIDParam = rowparams.getParam("ramanAlarmEnable");
            if (slotIDParam == null) {
                return false;
            }
            if (slotIDParam.getValue().equals("-")) {
                part.setValue(null);
            } else {
                part.setValue(slotIDParam.getValue());
            }
        } else {
            return super.convertPartValue(part, rowparams);
        }
        return flag;
    }

    private String writeAidFormat(String slotID, String index) {
        StringBuffer sb = new StringBuffer();
        sb.append(index);
        sb.append("-");
        String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotID));
        sb.append(shelfSlotID);
        return sb.toString();
    }

    public void addErrorParam(int neid, RowErrors rowError) {
        TETL1NecommonUtil.addErrorParam((int)neid, (RowErrors)rowError);
    }
}

