/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.ipa;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TESDCircuitPackRecord;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.tl1necommon.TETL1NecommonUtil;
import com.huawei.nglct.tl1.TEAIDAndType;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;

public class TEAssistantCheckBoardQueryBean
extends TETL1NEExplorerBean {
    private static final String W32PORT_ATTR_STDOUTPOW = "DWDMW32PORT_ATTR_STDOUTPOW";
    private int neid;
    private Datainterface output;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = super.performBussinessProcess(neid, subFunc, inputData, null, user, ipAddress);
        TENE neObj = TENEListUtils.getNEObj((int)neid);
        try {
            if (null != neObj) {
                this.getAvaliableIPABoard();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, (ArrayList)this.tl1OperList.clone());
            }
        }
        catch (Exception e) {
            this.log.error("Get Avaliable IPA Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    protected boolean convertPartValue(Part part1, RowParams rowparams) {
        boolean flag = true;
        if (part1.getName().equalsIgnoreCase("DECT")) {
            StringBuffer sb1 = new StringBuffer();
            sb1.append("FAC-");
            Param slotIDParam = rowparams.getParam("alarmSlotid");
            Param portParam = rowparams.getParam("alarmPort");
            Param neidParam = rowparams.getParam("neid");
            if (slotIDParam == null || portParam == null || neidParam == null) {
                return false;
            }
            if (slotIDParam.getValue().equals("0")) {
                part1.setValue("NULL");
            } else {
                String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)Integer.parseInt(neidParam.getValue()), (int)Integer.parseInt(slotIDParam.getValue()));
                sb1.append(shelfSlotID);
                sb1.append("-").append(portParam.getValue());
                part1.setValue(sb1.toString());
            }
        } else if (part1.getName().equalsIgnoreCase("OPRT")) {
            StringBuffer sb = new StringBuffer();
            sb.append("FAC-");
            Param slotIDParam = rowparams.getParam("ctlSlotid");
            Param portParam = rowparams.getParam("ctlPort");
            Param neidParam = rowparams.getParam("neid");
            if (slotIDParam == null || portParam == null || neidParam == null) {
                return false;
            }
            String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)Integer.parseInt(neidParam.getValue()), (int)Integer.parseInt(slotIDParam.getValue()));
            sb.append(shelfSlotID);
            sb.append("-").append(portParam.getValue());
            part1.setValue(sb.toString());
        } else {
            return super.convertPartValue(part1, rowparams);
        }
        return flag;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData.setBussinessParams(new BussinessParams());
        int opersize = tl1OperList.size();
        for (int i = 0; i < opersize; ++i) {
            TL1Operation operation = (TL1Operation)tl1OperList.get(i);
            int size = operation.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                OutMsg output = operation.getOutMsg(row);
                if (null == output || output.getFault().getCompletionCode() != 0) continue;
                this.calOut(neid, output);
            }
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }

    private void calOut(int neid, OutMsg output) {
        HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
        for (Map.Entry entry : hm.entrySet()) {
            String name = (String)entry.getKey();
            Part value = (Part)entry.getValue();
            if (!name.equals("ASTDECT1") && !name.equals("ASTDECT2") && !name.equals("ASTDECT3") && !name.equals("ASTDECT4")) continue;
            this.setOutputParam(neid, value);
        }
    }

    private void setOutputParam(int neid, Part value) {
        String astdect = value.getValue();
        if (astdect != null && astdect.indexOf("-") != -1) {
            int slotid = TETL1CommonUtil.getNMSlotStr((String)astdect, (int)neid);
            int port = TETL1CommonUtil.getNMPortNOFromAidStruct((String)astdect, (int)neid);
            TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
            if (board != null) {
                int boardid = board.getBoardType();
                RowParams rowparams = new RowParams();
                rowparams.addParam("type", "selected");
                rowparams.addParam("neid", String.valueOf(neid));
                rowparams.addParam("nename", TENEListUtils.getNEObj((int)neid).getNEName());
                rowparams.addParam("slotid", slotid + "");
                rowparams.addParam("boardid", boardid + "");
                rowparams.addParam("boardname", board.getBoardName());
                rowparams.addParam("port", port + "");
                rowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardid, port));
                rowparams.addParam("subrackName", TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid));
                TESDCircuitPackRecord boardTypePro = TEConfigurationDataMgr.getInstance().getBoardTypeProperty(neid, boardid);
                rowparams.addParam("wdmcptype", String.valueOf(boardTypePro.wdmType));
                this.outputData.getBussinessParams().addRowParams(rowparams);
            }
        }
    }

    private void getAvaliableIPABoard() {
        if (null == this.output.getBussinessParams()) {
            this.output.setBussinessParams(new BussinessParams());
        }
        ArrayList almBoardList = this.getAttrSupportCPs(this.neid, W32PORT_ATTR_STDOUTPOW);
        this.convertToDatainterface(this.neid, W32PORT_ATTR_STDOUTPOW, almBoardList, "avaliable");
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    private void convertToDatainterface(int neid, String attrId, ArrayList boardList, String type) {
        if (null == boardList) {
            return;
        }
        String nename = TENEListUtils.getNEObj((int)neid).getNEName();
        TEBoard board = null;
        RowParams rowparams = null;
        RowParams newrowparams = null;
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            ArrayList portList;
            rowparams = new RowParams();
            board = (TEBoard)boardList.get(i);
            rowparams.addParam("type", type);
            rowparams.addParam("neid", String.valueOf(neid));
            rowparams.addParam("nename", nename);
            rowparams.addParam("slotid", String.valueOf(board.getSlotID()));
            rowparams.addParam("boardid", String.valueOf(board.getBoardType()));
            rowparams.addParam("boardname", board.getBoardName());
            rowparams.addParam("subrackName", TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)board.getSlotID()));
            TESDCircuitPackRecord boardTypePro = TEConfigurationDataMgr.getInstance().getBoardTypeProperty(neid, board.getBoardType());
            rowparams.addParam("wdmcptype", String.valueOf(boardTypePro.wdmType));
            if (board.getBoardType() == 60034) {
                portList = this.getTomSupportPortList(board);
                if (portList == null) continue;
                int y = portList.size();
                for (int x = 0; x < y; ++x) {
                    String portID = (String)portList.get(x);
                    newrowparams = new RowParams();
                    newrowparams.setParam(rowparams.getParam());
                    newrowparams.addParam("port", portID);
                    newrowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, board.getSlotID(), board.getBoardType(), Integer.parseInt(portID)));
                    this.output.getBussinessParams().addRowParams(newrowparams);
                }
                continue;
            }
            portList = TEGenCfgDataMgr.getGenCfgMode((int)board.getBoardType()).getAttrFromId(attrId).getPortList();
            if (null == portList) continue;
            int size = portList.size();
            for (int j = 0; j < size; ++j) {
                newrowparams = new RowParams();
                TEGenCfgPortAttribute portObj = (TEGenCfgPortAttribute)portList.get(j);
                newrowparams.setParam(rowparams.getParam());
                newrowparams.addParam("port", String.valueOf(portObj.getPort()));
                newrowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, board.getSlotID(), board.getBoardType(), portObj.getPort()));
                this.output.getBussinessParams().addRowParams(newrowparams);
            }
        }
    }

    private ArrayList getTomSupportPortList(TEBoard board) {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(board.getSlotID());
        this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)this.neid, set);
        HashMap aidMap = this.aidAndTypeList.getAidAndTypeMap();
        Iterator it = aidMap.entrySet().iterator();
        ArrayList portList = null;
        ArrayList<TL1Operation> queryTypeOperList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ArrayList list = (ArrayList)entry.getValue();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    TEAIDAndType aidAndType = (TEAIDAndType)list.get(i);
                    if (!aidAndType.getType().equals("OCH")) continue;
                    TL1Operation queryOper = definitions.getTL1Operation("RTRV-OCH");
                    InMsg input = queryOper.getInMsg();
                    input.getPart("AID").setValue(aidAndType.getAid());
                    queryOper.setCmdCode("RTRV");
                    queryOper.setMod1(aidAndType.getType());
                    queryOper.setName("RTRV-" + aidAndType.getType());
                    queryTypeOperList.add(queryOper);
                }
            }
            if (queryTypeOperList.isEmpty()) {
                return null;
            }
            int result = this.sendMessage(this.neid, queryTypeOperList);
            if (result == 0) {
                portList = this.handleMessage(queryTypeOperList, board.getSlotID());
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Search TOM Port Fail!", (Throwable)e);
        }
        return portList;
    }

    private ArrayList handleMessage(ArrayList tl1OperList, int slotID) {
        ArrayList<String> portList = new ArrayList<String>();
        int n = tl1OperList.size();
        for (int i = 0; i < n; ++i) {
            TL1Operation tl1Operation = (TL1Operation)tl1OperList.get(i);
            for (OutMsg out : tl1Operation.getOutMsg()) {
                HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
                Part typePart = (Part)hm.get("TYPE");
                Part aidPart = (Part)hm.get("AID");
                if (typePart.getValue() == null || !typePart.getValue().equals("LINE")) continue;
                String[] aids = TETL1CommonUtil.parseAID((String)aidPart.getValue(), (int)this.neid);
                portList.add(aids[3]);
            }
        }
        return portList;
    }

    private ArrayList getAttrSupportCPs(int neid, String attrId) {
        TENE neObj = TENEListUtils.getNEObj((int)neid);
        ArrayList<TEBoard> supportCPs = new ArrayList<TEBoard>();
        if (null == neObj) {
            return null;
        }
        Vector boardList = neObj.getBoardList();
        if (null == boardList) {
            return null;
        }
        TEBoard board = null;
        TEGenCfgModel genCfgMode = null;
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            board = (TEBoard)boardList.get(i);
            if (null == board || null == (genCfgMode = TEGenCfgDataMgr.getGenCfgMode((int)board.getBoardType())) || null == genCfgMode.getAttrFromId(attrId)) continue;
            supportCPs.add(board);
        }
        return supportCPs;
    }

    public void addErrorParam(int neid, RowErrors rowError) {
        TETL1NecommonUtil.addErrorParam((int)neid, (RowErrors)rowError);
    }
}

