/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.inversemultifexing;

import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.inversemultifexing.TEInverseMultifexingBoardBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEParseInverseMultifexingBoardTypeXML {
    private HashMap boardTypeMap = new HashMap();
    private int neid = -1;
    private static TEParseInverseMultifexingBoardTypeXML m_instance = null;
    private static final String FILE_PATH = "nemgr" + File.separator + "tl1ngwdm" + File.separator + "conf" + File.separator + "ne_attribute" + File.separator + "config" + File.separator + "inversemultifexing" + File.separator + "boardsupportinversemultifexing.xml";

    public static synchronized TEParseInverseMultifexingBoardTypeXML getInstance(int neid) {
        if (m_instance == null) {
            m_instance = new TEParseInverseMultifexingBoardTypeXML(neid);
        }
        return m_instance;
    }

    public boolean isContains(int boardType) {
        return this.boardTypeMap.containsKey(boardType);
    }

    public List getPortList(int boardType) {
        ArrayList portList = new ArrayList();
        Integer bType = boardType;
        if (this.boardTypeMap.containsKey(bType)) {
            TEInverseMultifexingBoardBean boardBean = (TEInverseMultifexingBoardBean)this.boardTypeMap.get(bType);
            Map portMap = boardBean.getPortMap();
            portList.addAll(portMap.keySet());
        }
        return portList;
    }

    public String getServiceLevel(int boardType) {
        String serviceLevel = "";
        Integer bType = boardType;
        if (this.boardTypeMap.containsKey(bType)) {
            TEInverseMultifexingBoardBean boardBean = (TEInverseMultifexingBoardBean)this.boardTypeMap.get(bType);
            serviceLevel = boardBean.getServiceLevel();
        }
        return serviceLevel;
    }

    public List getPathList(int boardType, int portId) {
        Integer port;
        TEInverseMultifexingBoardBean boardBean;
        Map portMap;
        List pathList = null;
        Integer bType = boardType;
        if (this.boardTypeMap.containsKey(bType) && (portMap = (boardBean = (TEInverseMultifexingBoardBean)this.boardTypeMap.get(bType)).getPortMap()).containsKey(port = Integer.valueOf(portId))) {
            pathList = (List)portMap.get(port);
        }
        return pathList;
    }

    private TEParseInverseMultifexingBoardTypeXML(int neid) {
        this.neid = neid;
        this.loadBoardTypeData(neid);
    }

    private void loadBoardTypeData(int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        String bundleName = TEGetFilePath.getNEBundleName((int)neType);
        File file = TEResourceManager.getFileByName((String)bundleName, (String)FILE_PATH);
        Document doc = TEParseXMLFile.parseFile((File)file);
        NodeList firstNodeList = doc.getChildNodes();
        Node firstNode = firstNodeList.item(0);
        NodeList secondNodeList = firstNode.getChildNodes();
        int m = secondNodeList.getLength();
        for (int i = 0; i < m; ++i) {
            Node secondNode = secondNodeList.item(i);
            if (!secondNode.getNodeName().equalsIgnoreCase("board")) continue;
            Integer boardType = Integer.valueOf(secondNode.getAttributes().getNamedItem("board_type").getNodeValue());
            String boardName = secondNode.getAttributes().getNamedItem("board_name").getNodeValue();
            String clientLevel = secondNode.getAttributes().getNamedItem("client_level").getNodeValue();
            String serviceLevel = secondNode.getAttributes().getNamedItem("service_level").getNodeValue();
            HashMap portMap = new HashMap();
            NodeList thirdNodeList = secondNode.getChildNodes();
            int n = thirdNodeList.getLength();
            for (int j = 0; j < n; ++j) {
                Node thirdNode = thirdNodeList.item(j);
                if (!thirdNode.getNodeName().equalsIgnoreCase("port")) continue;
                NamedNodeMap namedNodeMap = thirdNode.getAttributes();
                Integer portId = Integer.valueOf(namedNodeMap.getNamedItem("port_no").getNodeValue());
                String pathStr = namedNodeMap.getNamedItem("path_no_list").getNodeValue();
                ArrayList<Integer> pathList = new ArrayList<Integer>();
                StringTokenizer token = new StringTokenizer(pathStr, ",");
                while (token.hasMoreTokens()) {
                    String subStr = token.nextToken();
                    int index = subStr.indexOf("-");
                    if (index > 0) {
                        int max = Integer.parseInt(subStr.substring(index + 1));
                        for (int min = Integer.parseInt(subStr.substring(0, index)); min <= max; ++min) {
                            pathList.add(min);
                        }
                        continue;
                    }
                    pathList.add(Integer.valueOf(subStr));
                }
                portMap.put(portId, pathList);
            }
            TEInverseMultifexingBoardBean boardBean = new TEInverseMultifexingBoardBean();
            boardBean.setBoardName(boardName);
            boardBean.setBoardType(boardType);
            boardBean.setClientLevel(clientLevel);
            boardBean.setServiceLevel(serviceLevel);
            boardBean.setPortMap(portMap);
            this.boardTypeMap.put(boardType, boardBean);
        }
    }
}

