/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.fiber;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nemgr.tl1ngwdm.config.fiber.PortComparetor;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TECreateFiberPreBean
extends TETL1NEExplorerBean {
    private static final String filename = "stringresource_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private static final String PAKAGE_PATH = "res" + File.separator + filename;
    private final TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private List usedSrcPortList = new ArrayList();
    private List usedSnkPortList = new ArrayList();
    private List srcPortList = new ArrayList();
    private List snkPortList = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int result;
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.tl1OperList = this.getTL1Operation(neid, subFunc, inputData, memeryData);
        if (null != this.tl1OperList && this.tl1OperList.size() > 0 && ((result = this.sendMessage(neid, this.tl1OperList)) == 0 || result == 1)) {
            this.handleMessage(neid, this.tl1OperList, subFunc);
        }
        this.getAvaliableRes();
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        if (null != operationList && operationList.size() > 0) {
            int len = operationList.size();
            block0: for (int i = 0; i < len; ++i) {
                TL1Operation operation = (TL1Operation)operationList.get(i);
                int size = operation.getOutMsgCount();
                for (int row = 0; row < size; ++row) {
                    OutMsg output = operation.getOutMsg(row);
                    if (null == output) continue;
                    boolean flag = true;
                    if (output.getFault().getCompletionCode() != 0) {
                        flag = false;
                        continue block0;
                    }
                    if (!flag) continue;
                    for (int tmpCol = output.getMsgBlock().getDataBlockCount() - 1; tmpCol >= 0; --tmpCol) {
                        TENE ne;
                        if (null != output.getMsgBlock().getPart("SRCTID") && !"".equals(output.getMsgBlock().getPart("SRCTID").getValue())) {
                            String srcNeName = output.getMsgBlock().getPart("SRCTID").getValue();
                            ne = TENEListUtils.getNEObj((int)neid);
                            if (ne.getNEName().equals(srcNeName)) {
                                String[] srcPort = TETL1CommonUtil.parseAID((String)output.getMsgBlock().getPart("SRCPORT").getValue(), (int)neid);
                                String usedSrcPort = TETL1CommonUtil.getNMSlotStr((String)output.getMsgBlock().getPart("SRCPORT").getValue(), (int)neid) + "-" + srcPort[3];
                                this.usedSrcPortList.add(usedSrcPort);
                            }
                        }
                        if (null == output.getMsgBlock().getPart("DSTTID") || "".equals(output.getMsgBlock().getPart("DSTTID").getValue())) continue;
                        String snkNeName = output.getMsgBlock().getPart("DSTTID").getValue();
                        ne = TENEListUtils.getNEObj((int)neid);
                        if (!ne.getNEName().equals(snkNeName)) continue;
                        String[] snkPort = TETL1CommonUtil.parseAID((String)output.getMsgBlock().getPart("DSTPORT").getValue(), (int)neid);
                        String usedSnkPort = TETL1CommonUtil.getNMSlotStr((String)output.getMsgBlock().getPart("DSTPORT").getValue(), (int)neid) + "-" + snkPort[3];
                        this.usedSnkPortList.add(usedSnkPort);
                    }
                }
            }
        }
    }

    private void getAvaliableRes() {
        this.tl1OperList = new ArrayList();
        TL1Operation oper = null;
        try {
            TL1Definitions tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            oper = tl1definitions.getTL1Operation("RTRV-EQPT");
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse TL1 description file fail!", (Throwable)e);
        }
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)PAKAGE_PATH);
        String fiberLevel = resourceUtil.getString("fiberlevel");
        String fiberDirection = resourceUtil.getString("fiberdirection");
        TENE ne = TENEListUtils.getNEObj((int)this.neid);
        String neName = ne.getNEName();
        Vector boardList = ne.getBoardList();
        if (boardList != null) {
            if (boardList.size() > 0) {
                int m = boardList.size();
                for (int i = 0; i < m; ++i) {
                    TEBoard board = (TEBoard)boardList.get(i);
                    int board_solt = board.getSlotID();
                    int boardType = board.getBoardType();
                    if (1095 == boardType && null != oper) {
                        InMsg input = oper.getInMsg();
                        Part part = input.getPart("AID");
                        part.setValue("SLOT-" + TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)board_solt));
                        this.tl1OperList.add(oper.clone());
                    }
                    List portTypeList = this.mgr.getBoardPortTypeList(this.neid, boardType);
                    ArrayList logicPortList = this.mgr.getLogicPortList(this.neid, board_solt);
                    if (portTypeList == null || portTypeList.size() <= 0) continue;
                    int n = portTypeList.size();
                    for (int j = 0; j < n; ++j) {
                        Integer port = (Integer)portTypeList.get(j);
                        List portList = this.mgr.getPortListFromPortType(this.neid, boardType, port.intValue());
                        int nn = portList.size();
                        block9: for (int jj = 0; jj < nn; ++jj) {
                            int portNo = (Integer)portList.get(jj);
                            if (this.mgr.isDynPort(this.neid, boardType, portNo) && !logicPortList.contains(portList.get(jj))) continue;
                            int portUsage = this.mgr.getPortUsage(this.neid, boardType, port.intValue(), portNo);
                            String slot_port = board_solt + "-" + portNo;
                            switch (portUsage) {
                                case 0: {
                                    if (!this.usedSrcPortList.contains(slot_port)) {
                                        this.addSrcPort(this.neid, board, portNo);
                                    }
                                    if (this.usedSnkPortList.contains(slot_port)) continue block9;
                                    this.addSnkPort(this.neid, board, portNo);
                                    continue block9;
                                }
                                case 3: {
                                    if (this.usedSrcPortList.contains(slot_port)) continue block9;
                                    this.addSrcPort(this.neid, board, portNo);
                                    continue block9;
                                }
                                case 2: {
                                    if (this.usedSnkPortList.contains(slot_port)) continue block9;
                                    this.addSnkPort(this.neid, board, portNo);
                                    continue block9;
                                }
                            }
                        }
                    }
                }
            }
            this.dealWithToEcom();
            Collections.sort(this.srcPortList, new PortComparetor());
            Collections.sort(this.snkPortList, new PortComparetor());
            Datainterface output = new Datainterface();
            output.setBussinessParams(new BussinessParams());
            RowParams comRowParams = new RowParams();
            Param comParam = new Param("nename", neName);
            comRowParams.addParam(comParam);
            comParam = new Param("fiberlevel", fiberLevel);
            comRowParams.addParam(comParam);
            comParam = new Param("fiberdirection", fiberDirection);
            comRowParams.addParam(comParam);
            output.getBussinessParams().addRowParams(0, comRowParams);
            RowParams rowParams = new RowParams();
            Param srcParam = new Param("srcPort", "");
            if (this.srcPortList.size() > 0) {
                String solt_port = (String)this.srcPortList.get(0);
                String slotid = solt_port.substring(0, solt_port.indexOf("-"));
                String showSlot = TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)Integer.parseInt(slotid));
                String portvar = solt_port.substring(solt_port.indexOf("-"), solt_port.length());
                srcParam.setValue(showSlot + portvar + "&" + solt_port);
                int mn = this.srcPortList.size();
                for (int k = 1; k < mn; ++k) {
                    solt_port = (String)this.srcPortList.get(k);
                    slotid = solt_port.substring(0, solt_port.indexOf("-"));
                    showSlot = TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)Integer.parseInt(slotid));
                    portvar = solt_port.substring(solt_port.indexOf("-"), solt_port.length());
                    Option option = new Option(showSlot + portvar + "&" + solt_port);
                    srcParam.addOption(option);
                }
            }
            rowParams.addParam(srcParam);
            Param snkParam = new Param("snkPort", "");
            if (this.snkPortList.size() > 0) {
                String snk_port = (String)this.snkPortList.get(0);
                String slotid = snk_port.substring(0, snk_port.indexOf("-"));
                String showSlot = TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)Integer.parseInt(slotid));
                String portvar = snk_port.substring(snk_port.indexOf("-"), snk_port.length());
                snkParam.setValue(showSlot + portvar + "&" + snk_port);
                int mn = this.snkPortList.size();
                for (int kk = 1; kk < mn; ++kk) {
                    snk_port = (String)this.snkPortList.get(kk);
                    slotid = snk_port.substring(0, snk_port.indexOf("-"));
                    showSlot = TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)Integer.parseInt(slotid));
                    portvar = snk_port.substring(snk_port.indexOf("-"), snk_port.length());
                    snk_port = showSlot + portvar + "&" + snk_port;
                    Option option = new Option(snk_port);
                    snkParam.addOption(option);
                }
            }
            rowParams.addParam(snkParam);
            output.getBussinessParams().addRowParams(1, rowParams);
            this.outputData = output;
            this.usedSrcPortList.clear();
            this.usedSrcPortList = null;
            this.usedSnkPortList.clear();
            this.usedSnkPortList = null;
            this.srcPortList.clear();
            this.srcPortList = null;
            this.snkPortList.clear();
            this.snkPortList = null;
        }
    }

    private void addSrcPort(int neid, TEBoard board, int portNo) {
        TEPortParaRecord portParaRecord = this.mgr.getPortParaRecord(neid, board.getBoardType(), portNo);
        if (portParaRecord != null) {
            if (portParaRecord.outName != null) {
                String src_solt_port = board.getSlotID() + "-" + board.getBoardTypeName() + "-" + portNo + "(" + portParaRecord.outName + ")";
                this.srcPortList.add(src_solt_port);
            }
        } else {
            String src_solt_port = board.getSlotID() + "-" + board.getBoardTypeName() + "-" + portNo + "(UNKNOWN)";
            this.srcPortList.add(src_solt_port);
        }
    }

    private void addSnkPort(int neid, TEBoard board, int portNo) {
        TEPortParaRecord portParaRecord = this.mgr.getPortParaRecord(neid, board.getBoardType(), portNo);
        if (portParaRecord != null) {
            if (portParaRecord.inName != null) {
                String snk_solt_port = board.getSlotID() + "-" + board.getBoardTypeName() + "-" + portNo + "(" + portParaRecord.inName + ")";
                this.snkPortList.add(snk_solt_port);
            }
        } else {
            String snk_solt_port = board.getSlotID() + "-" + board.getBoardTypeName() + "-" + portNo + "(UNKNOWN)";
            this.snkPortList.add(snk_solt_port);
        }
    }

    private void dealWithToEcom() {
        int result;
        String SERVICE_MODE = "HUB";
        ArrayList<String> deleteResList = new ArrayList<String>();
        if (null != this.tl1OperList && this.tl1OperList.size() > 0 && 0 == (result = this.sendMessage(this.neid, this.tl1OperList))) {
            int m = this.tl1OperList.size();
            for (int i = 0; i < m; ++i) {
                String boardMode;
                Operation operation = (Operation)this.tl1OperList.get(i);
                Output output = operation.getOutput(0);
                if (!output.getFault(0).getCode().equals("0") || !"HUB".equals(boardMode = output.getPartValue("WORKMODE"))) continue;
                String aid = output.getPartValue("AID");
                int slotId = Integer.parseInt(TETL1CommonUtil.parseAID((String)aid, (int)this.neid)[2]);
                String boardName = this.mgr.getBoardTypeName(this.neid, this.mgr.getBoardType(this.neid, slotId));
                deleteResList.add(slotId + "-" + boardName + "-1(IN)");
                deleteResList.add(slotId + "-" + boardName + "-1(OUT)");
            }
        }
        this.srcPortList.removeAll(deleteResList);
        this.snkPortList.removeAll(deleteResList);
    }
}

