/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.exc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TEWDMEXCUtil;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TEWDMUsableResource;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TEWDMGetUsableResourceBean
implements TENEMgrInterface {
    private Datainterface datainterface = new Datainterface();
    private int neID = -1;
    private ArrayList usableResourceList = new ArrayList();
    private int hasXCboard = -1;
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private static final int XC_BOARD = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        RowParams rParams = inputData.getBussinessParams().getRowParams()[0];
        Param[] paramArr = rParams.getParam();
        ArrayList<Integer> sevTypeList = new ArrayList<Integer>();
        int len = paramArr.length;
        for (int i = 0; i < len; ++i) {
            String name = paramArr[i].getName();
            String value = paramArr[i].getValue();
            if (name.equalsIgnoreCase("neID")) {
                this.neID = Integer.parseInt(value);
                continue;
            }
            if (!name.equalsIgnoreCase("sevType")) continue;
            sevTypeList.add(new Integer(value));
        }
        this.mgr.setNEType(1);
        TENE ne = this.mgr.getNE(this.neID);
        Vector boardList = null;
        if (ne != null) {
            boardList = ne.getBoardList();
        }
        if (boardList == null || boardList.size() == 0) {
            this.datainterface.setBussinessParams(new BussinessParams());
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
            return this.datainterface;
        }
        Collections.sort(boardList);
        ArrayList<Integer> tomBoardList = new ArrayList<Integer>();
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int bdType = board.getBoardType();
            int simpleGrade = TEOTNModelDataMgr.getInstance().getGradeFromBoard(bdType);
            if (bdType == 1620) {
                simpleGrade = 2;
            }
            if (bdType == -1) continue;
            if (board.getBoardType() == 0) {
                this.hasXCboard = 1;
            }
            int size2 = sevTypeList.size();
            for (int j = 0; j < size2; ++j) {
                String bdName;
                TEWDMUsableResource usableRes;
                Integer sevType = (Integer)sevTypeList.get(j);
                int slotID = board.getSlotID();
                ArrayList portList = new ArrayList();
                try {
                    portList = this.mgr.getBoardPortList(this.neID, bdType);
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("getBoardPortList fail!boardType=" + bdType, (Throwable)e);
                }
                Collections.sort(portList);
                if (1573 == bdType && !tomBoardList.contains(slotID)) {
                    tomBoardList.add(slotID);
                    HashSet<Integer> slotIDSet = new HashSet<Integer>();
                    slotIDSet.add(slotID);
                    TEAIDAndTypeList typeListAID = TETL1CommonUtil.queryPortType((int)neid, slotIDSet);
                    TEConfigurationDataMgr.getInstance().addTL1PayloadTypeList(neid, slotID, typeListAID);
                }
                ArrayList<String> usablePortList = new ArrayList<String>();
                int size3 = portList.size();
                for (int k = 0; k < size3; ++k) {
                    int portID = (Integer)portList.get(k);
                    ArrayList tmpSevTypeList = this.getSupportXCLevelList(this.neID, bdType, portID, slotID);
                    if (tmpSevTypeList == null || tmpSevTypeList.size() <= 0 || !tmpSevTypeList.contains(sevType)) continue;
                    String portName = this.mgr.getPortName(this.neID, slotID, bdType, portID);
                    usablePortList.add(portID + "," + portName);
                }
                if (usablePortList.size() <= 0 || this.usableResourceList.contains(usableRes = new TEWDMUsableResource(slotID, bdType, bdName = board.getBoardName(), usablePortList, sevType, simpleGrade))) continue;
                this.usableResourceList.add(usableRes);
            }
        }
        return this.constructRtnData();
    }

    public String getSimplePath(int bdType, List portList) {
        ArrayList pathList = new ArrayList();
        TEPortParaRecord paraRecod = null;
        int len = portList.size();
        for (int i = 0; i < len; ++i) {
            String[] ports = ((String)portList.get(i)).split(",");
            paraRecod = TECircuitPackDescription.getInstance().getCPPortPara(bdType, Integer.parseInt(ports[0]));
            if (paraRecod.snkPathIDList == null || paraRecod.snkPathIDList.isEmpty() || pathList.containsAll(paraRecod.snkPathIDList)) continue;
            pathList.addAll(paraRecod.snkPathIDList);
        }
        Collections.sort(pathList);
        StringBuffer sb = new StringBuffer();
        Iterator iterator = pathList.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next()).append(",");
        }
        return sb.toString();
    }

    private ArrayList getSupportXCLevelList(int neID2, int bdType, int portID, int slotID) {
        if (1573 == bdType) {
            return TEWDMEXCUtil.getInstance().get52TomXCLevelList(neID2, portID, slotID);
        }
        return this.mgr.getSupportTLlXCLevelList(this.neID, bdType, portID, slotID);
    }

    public Datainterface constructRtnData() {
        BussinessParams bParams = new BussinessParams();
        int size = this.usableResourceList.size();
        for (int i = 0; i < size; ++i) {
            TEWDMUsableResource res = (TEWDMUsableResource)this.usableResourceList.get(i);
            if (res.getPorts().size() < 1) continue;
            RowParams rParams = new RowParams();
            Param param = null;
            param = new Param("hasXCboard", String.valueOf(this.hasXCboard));
            rParams.addParam(param);
            param = new Param("sevType", String.valueOf(res.getSevType()));
            rParams.addParam(param);
            param = new Param("subrackid", String.valueOf(TEBoardUtil.getSubrackIDFromSlot((int)this.neID, (int)res.getSlotID())));
            rParams.addParam(param);
            param = new Param("subrackname", TEBoardUtil.getSubrackNameFromSlot((int)this.neID, (int)res.getSlotID()));
            rParams.addParam(param);
            param = new Param("showslotid", String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)this.neID, (int)res.getSlotID())));
            rParams.addParam(param);
            param = new Param("slotID", String.valueOf(res.getSlotID()));
            rParams.addParam(param);
            param = new Param("bdType", String.valueOf(res.getBoardType()));
            rParams.addParam(param);
            param = new Param("bdName", res.getBoardName());
            rParams.addParam(param);
            param = new Param("simpleGrade", String.valueOf(res.getSimpleGrade()));
            rParams.addParam(param);
            param = res.getSimpleGrade() != -1 ? new Param("simplePath", this.getSimplePath(res.getBoardType(), res.getPorts())) : new Param("simplePath", "");
            rParams.addParam(param);
            if (null != res.getPorts() && res.getPorts().size() > 0) {
                param = new Param("port", (String)res.getPorts().get(0));
                int size1 = res.getPorts().size();
                for (int j = 1; j < size1; ++j) {
                    Option option = new Option((String)res.getPorts().get(j));
                    param.addOption(option);
                }
                rParams.addParam(param);
            }
            rParams.addParam(param);
            bParams.addRowParams(rParams);
        }
        this.datainterface.setBussinessParams(bParams);
        this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
        return this.datainterface;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

