/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.exc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.mo.CfgDataMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TETL1AIDKey;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TEEXCSpeedConstant;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TETL1WDMBoardPathMulti;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TETL1WDMExcPortPath;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1AID;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEWDMEXCUtil {
    public static final int BIDIRECTIONAL = 0;
    public static final int UNIDIRECTIONAL = 1;
    public static final int SWSNCP_PROTECTION = 1;
    public static final int SNCN_PROTECTION = 3;
    public static final int SNCS_PROTECTION = 4;
    public static final int INVALID_VALUE = -1;
    public static final int PREPATH_WORKING = 0;
    public static final int PREPATH_PROTECTION = 1;
    public static final int RESUME_MODE = 1;
    public static final int NORESUME_MODE = 0;
    public static final int REDLINE_FLAG = 0;
    public static final int REDLINE_FLAG_NO = 1;
    public static final int SDFLAG_ENABLE = 1;
    public static final int SDFLAG_DISENABLE = 0;
    private static Hashtable<String, ArrayList> levelAidMap = new Hashtable();
    private static TEWDMEXCUtil instance = null;

    private TEWDMEXCUtil() {
    }

    public static synchronized TEWDMEXCUtil getInstance() {
        if (instance == null) {
            instance = new TEWDMEXCUtil();
        }
        return instance;
    }

    public void putStaticEXCData(String level, ArrayList<TETL1AID> aidList) {
        levelAidMap.put(level, aidList);
    }

    public void clearStaticEXCData() {
        levelAidMap.clear();
    }

    public ArrayList<TETL1AID> getStaticEXCData(String level) {
        return levelAidMap.get(level);
    }

    public static ArrayList convertPathData(String pathStr) {
        ArrayList<Integer> pathList = new ArrayList<Integer>();
        for (String s : pathStr.split(",")) {
            int end;
            String[] arr1 = s.split("-");
            int start = Integer.parseInt(arr1[0]);
            if (start > (end = Integer.parseInt(arr1[arr1.length - 1]))) {
                start = end;
                end = Integer.parseInt(arr1[0]);
            }
            for (int j = start; j <= end; ++j) {
                pathList.add(j);
            }
        }
        return pathList;
    }

    public static String getMOD2FromLevel(String level) {
        if (level.equals("GE")) {
            return "GETH";
        }
        if (level.equals("FE")) {
            return "FETH";
        }
        if (level.equalsIgnoreCase("FICONExpress")) {
            return "FICONEXP";
        }
        if (level.equals("FC50")) {
            return "FC";
        }
        if (level.equals("10GE")) {
            return "XGETH";
        }
        return level;
    }

    public static TL1Operation createEditFACAttrTL1Operation(int neid, String mod2, String aidFAC, boolean isWork, String workdelaytime, String protectdelaytime) {
        TL1Definitions tl1definitions = null;
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
        String cmdType = "ED";
        TL1Operation operation = tl1definitions.getTL1Operation("ED-MOD2");
        operation.setCmdCode(cmdType);
        operation.setMod1(mod2);
        operation.setName(cmdType + "-" + mod2);
        AID aid = operation.getInMsg().getStagBlock().getAID();
        Part part = aid.getPart(0);
        part.setValue(aidFAC);
        DataBlock data = operation.getInMsg().getMsgBlock().getDataBlock(1);
        Part timePart = data.getPart(0);
        if (isWork) {
            timePart.setValue(workdelaytime);
        } else {
            timePart.setValue(protectdelaytime);
        }
        return operation;
    }

    public static RowErrors createRowErrors(int neid, SubFunc subfunc, InMsg input, OutMsg output) {
        Fault fault = output.getFault();
        String errorCode = fault.getErrCode();
        String errorinfo = fault.getErrDesc();
        String aidstr = input.getStagBlock().getAID().getPart(0).getValue();
        String aidstrto = input.getStagBlock().getAID().getPart(1).getValue();
        String[] arr = aidstr.split("&");
        String monObj = TETL1CommonUtil.getBoardStructFromAID((String)arr[0], (int)neid, (boolean)false);
        monObj = monObj + "&" + TETL1CommonUtil.getBoardStructFromAID((String)aidstrto, (int)neid, (boolean)false);
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param("nename", monObj);
        rowError.addParam(errorparam);
        return rowError;
    }

    private static ArrayList parseWdmPathMulti() {
        ArrayList<TETL1WDMBoardPathMulti> list = new ArrayList<TETL1WDMBoardPathMulti>();
        String filepath = "nemgr" + File.separator + "tl1ngwdm" + File.separator + "conf" + File.separator + "ne_attribute" + File.separator + "config" + File.separator + "exc" + File.separator + "wdmpathmulti" + ".xml";
        Document doc = null;
        doc = TEParseXMLFile.parseFile((String)(TEResourceManager.getPath() + File.separator + filepath));
        if (null == doc) {
            TELogFactory.getNormalLogger().info("Parse board fail: " + filepath);
            return null;
        }
        SDXMLInterpreterMgr instance = SDXMLInterpreterMgr.getInstance();
        NodeList nl = doc.getElementsByTagName("path_multi_desc");
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            TETL1WDMBoardPathMulti wdmPath = new TETL1WDMBoardPathMulti();
            Element eltWdm = (Element)nl.item(i);
            String cpTypeValue = eltWdm.getAttribute("cp_type");
            int cptype = instance.parseInt(cpTypeValue);
            if (cptype != 0) {
                wdmPath.cpType = cptype;
            }
            NodeList itemNode = eltWdm.getElementsByTagName("item");
            int size = itemNode.getLength();
            for (int j = 0; j < size; ++j) {
                String no_exclevel;
                String exclevel;
                Element eltTmp = (Element)itemNode.item(j);
                TETL1WDMExcPortPath wdmexc = new TETL1WDMExcPortPath();
                String portStr = eltTmp.getAttribute("port_support_list");
                TENEListUtils.getPortArr((String)portStr, (ArrayList)wdmexc.port_list);
                String pathStr = eltTmp.getAttribute("path_multi_list");
                TENEListUtils.getPortArr((String)pathStr, (ArrayList)wdmexc.path_list);
                wdmexc.exc_level = exclevel = eltTmp.getAttribute("xc_multi_level");
                wdmexc.noSupprot_exc_level = no_exclevel = eltTmp.getAttribute("no_xc_multi_level");
                wdmPath.addPortPath(wdmexc);
            }
            list.add(wdmPath);
        }
        return list;
    }

    public static String getExcAid(int neid, String slot, String port, String path, String level) {
        TEConfigurationDataMgr cfgdata = TEConfigurationDataMgr.getInstance();
        int slotID = Integer.parseInt(slot);
        int pathID = -1;
        if (!path.isEmpty()) {
            pathID = Integer.parseInt(path);
        }
        int nePathID = pathID;
        int boardType = cfgdata.getBoardType(neid, slotID);
        int tmpPath = TEOTNModelDataMgr.getInstance().getNePath(pathID, boardType);
        if (tmpPath != -1) {
            nePathID = tmpPath;
        }
        if (nePathID == 1) {
            int portID = Integer.parseInt(port);
            if (boardType == 1573) {
                String mod2 = TEEXCSpeedConstant.getInstance().getMod2Level(Integer.parseInt(level));
                TEAIDAndTypeList aidTypeList = cfgdata.getTL1AIDTypeList(neid, slotID);
                if (aidTypeList != null) {
                    int path_52tom = aidTypeList.getPortPathID(neid, slotID, portID, mod2);
                    if (path_52tom > 0) {
                        return TETL1CommonUtil.getAIDFromPort((int)neid, (String)slot, (String)port, (String)path);
                    }
                    return TETL1CommonUtil.getAIDFromPort((int)neid, (String)slot, (String)port, (String)"");
                }
            } else {
                if (boardType == 2272 && (portID == 201 || portID == 202)) {
                    return TETL1CommonUtil.getAIDFromPort((int)neid, (String)slot, (String)port, (String)"") + "-" + path;
                }
                Integer excLevel = Integer.valueOf(level);
                TEPortParaRecord portPara = cfgdata.getExcPortParaRecord(neid, boardType, portID, excLevel);
                if (portPara == null) {
                    portPara = cfgdata.getPortParaRecord(neid, boardType, portID);
                }
                if (portPara != null) {
                    TETL1WDMBoardPathMulti boardPath;
                    ArrayList pathList = portPara.srcPathIDList;
                    if (pathList.size() == 0 || pathList.size() == 1) {
                        return TETL1CommonUtil.getAIDFromPort((int)neid, (String)slot, (String)port, (String)"");
                    }
                    if (pathList.size() > 1 && (boardPath = TEWDMEXCUtil.boardPathMulti(boardType)) != null && boardPath.isExistPortPath(portID, pathID, level)) {
                        return TETL1CommonUtil.getAIDFromPort((int)neid, (String)slot, (String)port, (String)"");
                    }
                }
            }
        }
        return TETL1CommonUtil.getAIDFromPort((int)neid, (String)slot, (String)port, (String)path);
    }

    private static TETL1WDMBoardPathMulti boardPathMulti(int cptype) {
        ArrayList wdmPortPathList = TEWDMEXCUtil.parseWdmPathMulti();
        int size = wdmPortPathList.size();
        for (int i = 0; i < size; ++i) {
            TETL1WDMBoardPathMulti board = (TETL1WDMBoardPathMulti)wdmPortPathList.get(i);
            if (board.cpType != cptype) continue;
            return board;
        }
        return null;
    }

    public ArrayList get52TomXCLevelList(int neID, int portID, int slotID) {
        if (3 <= portID && portID <= 10) {
            int[] xcLevelArr = new int[]{257, 260, 513, 769, 770, 771, 1025, 1026, 1027, 1282, 1283, 1537, 1538, 1793, 2049, 2050, 2305, 2561, 65535};
            return new ArrayList(Arrays.asList(new int[][]{xcLevelArr}));
        }
        return this.getTL1PayLoadTypeList(neID, slotID, portID);
    }

    private ArrayList getTL1PayLoadTypeList(int neid, int slotid, int portid) {
        TEAIDAndTypeList typeListAID = TEConfigurationDataMgr.getInstance().getTL1AIDTypeList(neid, slotid);
        if (typeListAID == null) {
            HashSet<Integer> slotIDSet = new HashSet<Integer>();
            slotIDSet.add(slotid);
            typeListAID = TETL1CommonUtil.queryPortType((int)neid, slotIDSet);
            TEConfigurationDataMgr.getInstance().addTL1PayloadTypeList(neid, slotid, typeListAID);
        }
        ArrayList<Integer> tempList = new ArrayList<Integer>();
        if (typeListAID == null) {
            return tempList;
        }
        ArrayList payLoadList = typeListAID.getPortPayloadMod2(neid, slotid, portid);
        String value = "";
        String payload = "";
        int size = payLoadList.size();
        for (int i = 0; i < size; ++i) {
            TETL1AIDKey aidkey = (TETL1AIDKey)payLoadList.get(i);
            payload = aidkey.getMod2();
            ArrayList list = levelAidMap.get(payload);
            boolean flag = false;
            if (list != null) {
                int len = list.size();
                for (int j = 0; j < len; ++j) {
                    TETL1AID aid = (TETL1AID)list.get(j);
                    if (aidkey.getPortID() != aid.getPortID() || aidkey.getSlotID() != aid.getSlotID() || !aidkey.getAidPre().equalsIgnoreCase(aid.getAidPre()) || aidkey.getShelfID() != aid.getShelfID()) continue;
                    flag = true;
                    break;
                }
            }
            if (flag) continue;
            if (payload.equals("GETH")) {
                payload = "GE";
            } else if (payload.equals("FETH")) {
                payload = "FE";
            } else if (payload.equals("FICONEXP")) {
                payload = "FICONEXPESS";
            } else if (payload.equals("HDSDI")) {
                payload = "HDTV";
            } else if (payload.equals("SDI")) {
                payload = "DVBSDI";
            }
            payload = "XC_LEVEL_" + payload;
            value = i > 0 ? value + "," + payload : payload;
        }
        TIntArrayList iList = new TIntArrayList();
        SDXMLInterpreterMgr.getInstance().parseIntList(value, iList);
        CfgDataMgr dataMgr = CfgDataMgr.getInstance();
        int size2 = iList.size();
        for (int i = 0; i < size2; ++i) {
            int nmServiceType = iList.get(i);
            int neServiceType = dataMgr.getNESerTypeByNM(nmServiceType);
            tempList.add(neServiceType);
        }
        return tempList;
    }

    public static String getOTNLevelFromType(int typeVal, int i) {
        if (typeVal == 3) {
            switch (i) {
                case 1: {
                    return "PM";
                }
                case 2: {
                    return "TCM1";
                }
                case 3: {
                    return "TCM2";
                }
                case 4: {
                    return "TCM3";
                }
                case 5: {
                    return "TCM4";
                }
                case 6: {
                    return "TCM5";
                }
                case 7: {
                    return "TCM6";
                }
            }
            return "";
        }
        if (typeVal == 4) {
            switch (i) {
                case 2: {
                    return "TCM1";
                }
                case 3: {
                    return "TCM2";
                }
                case 4: {
                    return "TCM3";
                }
                case 5: {
                    return "TCM4";
                }
                case 6: {
                    return "TCM5";
                }
                case 7: {
                    return "TCM6";
                }
            }
            return "";
        }
        return "";
    }
}

