/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.exc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.config.exc.AutoExcItem;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TEEXCCreateBean;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TEEXCSpeedConstant;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TETL1ExcCreateSuperBean;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TEWDMEXCUtil;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TEWDMEXCCreateSNCPBean
extends TETL1ExcCreateSuperBean {
    private String workAID = "";
    private String proAID = "";
    private String snkAID = "";
    private String mod2 = "";
    private String workDelayTime = "";
    private String protectDelayTime = "";
    private ArrayList tempOperationLogList = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        Datainterface excOutputData = new Datainterface();
        excOutputData.setBussinessParams(this.outputData.getBussinessParams());
        excOutputData.setPageParams(this.outputData.getPageParams());
        excOutputData.setErrorMessage(this.outputData.getErrorMessage());
        if (0 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            ArrayList workSinlAutoExcs;
            RowParams inputRow = inputData.getBussinessParams().getRowParams(0);
            inputData.getBussinessParams().clearRowParams();
            String serviceType = inputRow.getParam("sevType").getValue();
            String workSourceSlot = inputRow.getParam("workSourceSlot").getValue();
            String workSourcePort = inputRow.getParam("workSourcePort").getValue();
            String workSinkSlot = inputRow.getParam("workSinkSlot").getValue();
            String workSinkPort = inputRow.getParam("workSinkPort").getValue();
            ArrayList workSourceAutoExcs = super.getAutoExcByboard(Integer.parseInt(workSourceSlot), Integer.parseInt(workSourcePort), "XC_SRC_TP", serviceType);
            if (workSourceAutoExcs != null) {
                for (int i = workSourceAutoExcs.size() - 1; i >= 0; --i) {
                    inputData.getBussinessParams().addRowParams(this.buildSNCPRowParams((AutoExcItem)workSourceAutoExcs.get(i), inputRow, workSourceSlot));
                }
            }
            if ((workSinlAutoExcs = super.getAutoExcByboard(Integer.parseInt(workSinkSlot), Integer.parseInt(workSinkPort), "XC_SNK_TP", serviceType)) != null) {
                for (int i = workSinlAutoExcs.size() - 1; i >= 0; --i) {
                    inputData.getBussinessParams().addRowParams(this.buildSNCPRowParams((AutoExcItem)workSinlAutoExcs.get(i), inputRow, workSourceSlot));
                }
            }
            String pctSourceSlot = inputRow.getParam("pctSourceSlot").getValue();
            String pctSourcePort = inputRow.getParam("pctSourcePort").getValue();
            ArrayList pctSourceAutoExcs = super.getAutoExcByboard(Integer.parseInt(pctSourceSlot), Integer.parseInt(pctSourcePort), "XC_SRC_TP", serviceType);
            if (pctSourceAutoExcs != null) {
                for (int i = pctSourceAutoExcs.size() - 1; i >= 0; --i) {
                    inputData.getBussinessParams().addRowParams(this.buildSNCPRowParams((AutoExcItem)pctSourceAutoExcs.get(i), inputRow, pctSourceSlot));
                }
            }
            TEEXCCreateBean excCreateBean = new TEEXCCreateBean();
            excCreateBean.performCreateExcProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        }
        return excOutputData;
    }

    private RowParams buildSNCPRowParams(AutoExcItem autoExcItem, RowParams inputRow, String srcSoltID) {
        RowParams inputRowParam = new RowParams();
        inputRowParam.addParam("level", autoExcItem.getExc_level());
        inputRowParam.addParam("srcSoltID", srcSoltID);
        inputRowParam.addParam("srcPortNO", String.valueOf(autoExcItem.getSrcPortNum()));
        inputRowParam.addParam("srcPathNO", String.valueOf(autoExcItem.getSrcChannelNum()));
        inputRowParam.addParam("snkSoltID", srcSoltID);
        inputRowParam.addParam("snkPortNO", String.valueOf(autoExcItem.getSnkPortNum()));
        inputRowParam.addParam("snkPathNO", String.valueOf(autoExcItem.getSnkChannelNum()));
        inputRowParam.addParam("direction", String.valueOf(inputRow.getParam("direction").getValue()));
        inputRowParam.addParam("name", String.valueOf(inputRow.getParam("wdmName").getValue()));
        int redline = Integer.parseInt(inputRow.getParam("wdmRedline").getValue());
        if (redline == 0) {
            inputRowParam.addParam("redline", "RDLD");
        } else if (redline == 1) {
            inputRowParam.addParam("redline", "RDLD-DEA");
        } else {
            TELogFactory.getNormalLogger().error("SST Error!" + redline);
            inputRowParam.addParam("redline", "");
        }
        return inputRowParam;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = this.convertToDatainterface(neid, subfunc, tl1OperList, filterErrorCodeList);
        if (Integer.parseInt(this.outputData.getErrorMessage().getErrorcode()) == 0) {
            if (66 != this.neType) {
                this.sendDelayTime();
            }
            this.cloneTL1OperationList.addAll(this.tempOperationLogList);
        }
    }

    private void sendDelayTime() {
        ArrayList<TL1Operation> tl1OperationList = new ArrayList<TL1Operation>(3);
        TL1Operation srcWorkOperation = TEWDMEXCUtil.createEditFACAttrTL1Operation(this.neid, this.mod2, this.workAID, true, this.workDelayTime, this.protectDelayTime);
        tl1OperationList.add(srcWorkOperation);
        TL1Operation snkWorkOperation = TEWDMEXCUtil.createEditFACAttrTL1Operation(this.neid, this.mod2, this.snkAID, true, this.workDelayTime, this.protectDelayTime);
        tl1OperationList.add(snkWorkOperation);
        TL1Operation srcProOperation = TEWDMEXCUtil.createEditFACAttrTL1Operation(this.neid, this.mod2, this.proAID, false, this.workDelayTime, this.protectDelayTime);
        tl1OperationList.add(srcProOperation);
        this.sendMessage(this.neid, tl1OperationList);
        int size = tl1OperationList.size();
        for (int i = 0; i < size; ++i) {
            TL1Operation oper = (TL1Operation)tl1OperationList.get(i);
            this.tempOperationLogList.add(oper.clone());
        }
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        String serviceType = rowparams.getParam("sevType").getValue();
        String mod2 = TEEXCSpeedConstant.getInstance().getMod2Level(Integer.parseInt(serviceType));
        TETL1CommonUtil.modifyMOD2((TL1Operation)tl1Operation, (String)mod2);
    }

    protected boolean fillStagBlock(RowParams rowparams, StagBlock stagBlock) {
        this.workDelayTime = rowparams.getParam("workDelayTime").getValue();
        this.protectDelayTime = rowparams.getParam("protectDelayTime").getValue();
        int mod2level = Integer.parseInt(rowparams.getParam("sevType").getValue());
        this.mod2 = TEEXCSpeedConstant.getInstance().getMod2Level(mod2level);
        return super.fillStagBlock(rowparams, stagBlock);
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        try {
            String value;
            if (part.getName().equalsIgnoreCase("FROM")) {
                this.workAID = this.getWorkAID(part, rowparams);
                this.proAID = this.getProAID(part, rowparams);
                part.setValue(this.workAID + "&" + this.proAID);
            }
            if (part.getName().equalsIgnoreCase("TO")) {
                String snksoltStr = rowparams.getParam("workSinkSlot").getValue();
                String snkportStr = rowparams.getParam("workSinkPort").getValue();
                String snkpathStr = rowparams.getParam("workSinkPath").getValue();
                String level = rowparams.getParam("sevType").getValue();
                this.snkAID = TEWDMEXCUtil.getExcAid(this.neid, snksoltStr, snkportStr, snkpathStr, level);
                part.setValue(this.snkAID);
            }
            if (part.getName().equalsIgnoreCase("CCT")) {
                this.dealCCT(part, rowparams);
            }
            if (part.getName().equalsIgnoreCase("SNCPTYPE")) {
                this.dealSNCPType(part, rowparams);
            }
            if (part.getName().equalsIgnoreCase("OTNLEVEL")) {
                int sncType = Integer.parseInt(rowparams.getParam("pctType").getValue());
                int otnlevel = Integer.parseInt(rowparams.getParam("OTNLevel").getValue());
                if (otnlevel == -1) {
                    return true;
                }
                String level = TEWDMEXCUtil.getOTNLevelFromType(sncType, otnlevel);
                part.setValue(level);
            }
            if (part.getName().equalsIgnoreCase("PREFERREDPATH")) {
                this.dealPreferredPath(part, rowparams);
            }
            if (part.getName().equalsIgnoreCase("RVRTV")) {
                this.dealRVRTV(part, rowparams);
            }
            if (part.getName().equalsIgnoreCase("RVTM")) {
                int rvrtv = Integer.parseInt(rowparams.getParam("revertiveMode").getValue());
                String rvtm = null;
                if (rvrtv == 1) {
                    rvtm = rowparams.getParam("WTRTime").getValue();
                }
                part.setValue(rvtm);
            }
            if (part.getName().equalsIgnoreCase("SDFLAG")) {
                int sdflag = Integer.parseInt(rowparams.getParam("SDTriggerFlag").getValue());
                if (sdflag == 0) {
                    part.setValue("DISABLE");
                } else if (sdflag == 1) {
                    part.setValue("ENABLE");
                } else {
                    TELogFactory.getNormalLogger().error("SST Error!" + sdflag);
                    part.setValue("");
                }
            }
            if (part.getName().equals("TS")) {
                value = rowparams.getParam("oduflexslot").getValue();
                if (value == null || value.equals("") || value.equals("0")) {
                    return false;
                }
                part.setValue(value);
            }
            if (part.getName().equals("PLDTYPE")) {
                value = rowparams.getParam("oduflexsevtype").getValue();
                String mod2Level = TEEXCSpeedConstant.getInstance().getMod2Level(Integer.parseInt(value));
                if (mod2Level == null || mod2Level.equals("")) {
                    return false;
                }
                part.setValue(mod2Level);
            }
            if (part.getName().equals("PLDRATE")) {
                value = rowparams.getParam("oduflexsevrate").getValue();
                if (value == null || value.equals("") || value.equals("0") || value.equals("-")) {
                    return false;
                }
                part.setValue(value);
            }
            if (part.getName().equalsIgnoreCase("CKTID")) {
                String wdmName = rowparams.getParam("wdmName").getValue();
                part.setValue("\"" + wdmName + "\"");
            }
            if (part.getName().equalsIgnoreCase("PST")) {
                part.setValue("");
            }
            if (part.getName().equalsIgnoreCase("SST")) {
                int redline = Integer.parseInt(rowparams.getParam("wdmRedline").getValue());
                if (redline == 0) {
                    part.setValue("RDLD");
                } else if (redline == 1) {
                    part.setValue("RDLD-DEA");
                } else {
                    TELogFactory.getNormalLogger().error("SST Error!" + redline);
                    part.setValue("");
                }
            }
            if (66 == this.neType) {
                if (part.getName().equalsIgnoreCase("WKCHNDLYTIME")) {
                    part.setValue(rowparams.getParam("workDelayTime").getValue());
                }
                if (part.getName().equalsIgnoreCase("PROTCHNDLYTIME")) {
                    part.setValue(rowparams.getParam("protectDelayTime").getValue());
                }
                if (part.getName().equalsIgnoreCase("PSDIRN")) {
                    if (rowparams.getParam("switchMode") != null) {
                        part.setValue(rowparams.getParam("switchMode").getValue());
                    } else {
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse TL1 Param Error", (Throwable)e);
            return true;
        }
    }

    private void dealPreferredPath(Part part, RowParams rowparams) {
        int prePath = Integer.parseInt(rowparams.getParam("wdmPrePath").getValue());
        if (prePath == 0) {
            String worksoltStr = rowparams.getParam("workSourceSlot").getValue();
            String workportStr = rowparams.getParam("workSourcePort").getValue();
            String workpathStr = rowparams.getParam("workSourcePath").getValue();
            String level = rowparams.getParam("sevType").getValue();
            String workAID = TEWDMEXCUtil.getExcAid(this.neid, worksoltStr, workportStr, workpathStr, level);
            part.setValue(workAID);
        } else if (prePath == 1) {
            String prosoltStr = rowparams.getParam("pctSourceSlot").getValue();
            String proportStr = rowparams.getParam("pctSourcePort").getValue();
            String propathStr = rowparams.getParam("pctSourcePath").getValue();
            String level = rowparams.getParam("sevType").getValue();
            String proAID = TEWDMEXCUtil.getExcAid(this.neid, prosoltStr, proportStr, propathStr, level);
            part.setValue(proAID);
        } else {
            TELogFactory.getNormalLogger().error("Preferred Path Error!" + prePath);
            part.setValue("");
        }
    }
}

