/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.exc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TEEXCSpeedConstant;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TETL1ExcCreateSuperBean;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TEWDMEXCUtil;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TEWDMEXCConvertNormalToSNCPBean
extends TETL1ExcCreateSuperBean {
    private String workAID = "";
    private String proAID = "";
    private String snkAID = "";
    private String mod2 = "";
    private String workDelayTime = "";
    private String protectDelayTime = "";
    private ArrayList tempOperationLogList = new ArrayList();

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = this.convertToDatainterface(neid, subfunc, tl1OperList, filterErrorCodeList);
        if (Integer.parseInt(this.outputData.getErrorMessage().getErrorcode()) == 0) {
            this.sendDelayTime();
            this.cloneTL1OperationList.addAll(this.tempOperationLogList);
        }
    }

    private void sendDelayTime() {
        ArrayList<TL1Operation> tl1OperationLists = new ArrayList<TL1Operation>(3);
        TL1Operation srcWorkOperation = TEWDMEXCUtil.createEditFACAttrTL1Operation(this.neid, this.mod2, this.workAID, true, this.workDelayTime, this.protectDelayTime);
        tl1OperationLists.add(srcWorkOperation);
        TL1Operation srcProOperation = TEWDMEXCUtil.createEditFACAttrTL1Operation(this.neid, this.mod2, this.proAID, false, this.workDelayTime, this.protectDelayTime);
        tl1OperationLists.add(srcProOperation);
        this.sendMessage(this.neid, tl1OperationLists);
        int size = tl1OperationLists.size();
        for (int i = 0; i < size; ++i) {
            TL1Operation oper = (TL1Operation)tl1OperationLists.get(i);
            this.tempOperationLogList.add(oper.clone());
        }
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        String serviceType = rowparams.getParam("sevType").getValue();
        String mod2 = TEEXCSpeedConstant.getInstance().getMod2Level(Integer.parseInt(serviceType));
        TETL1CommonUtil.modifyMOD2((TL1Operation)tl1Operation, (String)mod2);
    }

    protected boolean fillStagBlock(RowParams rowParas, StagBlock stagBlock) {
        this.workDelayTime = rowParas.getParam("workDelayTime").getValue();
        this.protectDelayTime = rowParas.getParam("protectDelayTime").getValue();
        int mod2level = Integer.parseInt(rowParas.getParam("sevType").getValue());
        this.mod2 = TEEXCSpeedConstant.getInstance().getMod2Level(mod2level);
        return super.fillStagBlock(rowParas, stagBlock);
    }

    protected boolean convertPartValue(Part partVal, RowParams rowparams) {
        try {
            String level;
            if (partVal.getName().equalsIgnoreCase("FROM")) {
                String worksoltStr = rowparams.getParam("wSrcSlot").getValue();
                String workportStr = rowparams.getParam("wSrcPort").getValue();
                String workpathStr = rowparams.getParam("wSrcPath").getValue();
                level = rowparams.getParam("sevType").getValue();
                this.workAID = TEWDMEXCUtil.getExcAid(this.neid, worksoltStr, workportStr, workpathStr, level);
                String snksoltStr = rowparams.getParam("pSrcSlot").getValue();
                String snkportStr = rowparams.getParam("pSrcPort").getValue();
                String snkpathStr = rowparams.getParam("pSrcPath").getValue();
                this.proAID = TEWDMEXCUtil.getExcAid(this.neid, snksoltStr, snkportStr, snkpathStr, level);
                partVal.setValue(this.proAID);
            }
            if (partVal.getName().equalsIgnoreCase("TO")) {
                String prosoltStr = rowparams.getParam("wSinkSlot").getValue();
                String proportStr = rowparams.getParam("wSinkPort").getValue();
                String propathStr = rowparams.getParam("wSinkPath").getValue();
                level = rowparams.getParam("sevType").getValue();
                this.snkAID = TEWDMEXCUtil.getExcAid(this.neid, prosoltStr, proportStr, propathStr, level);
                partVal.setValue(this.snkAID);
            }
            if (partVal.getName().equalsIgnoreCase("CCT")) {
                this.dealCCT(partVal, rowparams);
            }
            if (partVal.getName().equalsIgnoreCase("SNCPTYPE")) {
                this.dealSNCPType(partVal, rowparams);
            }
            if (partVal.getName().equalsIgnoreCase("OTNLEVEL")) {
                int sncType = Integer.parseInt(rowparams.getParam("pctType").getValue());
                int otnlevel = Integer.parseInt(rowparams.getParam("OTNLevel").getValue());
                if (otnlevel == -1) {
                    return true;
                }
                String level2 = TEWDMEXCUtil.getOTNLevelFromType(sncType, otnlevel);
                partVal.setValue(level2);
            }
            if (partVal.getName().equalsIgnoreCase("PREFERREDPATH")) {
                this.dealPreferredPath(partVal, rowparams);
            }
            if (partVal.getName().equalsIgnoreCase("RVRTV")) {
                this.dealRVRTV(partVal, rowparams);
            }
            if (partVal.getName().equalsIgnoreCase("RVTM")) {
                String rvtm = rowparams.getParam("WTRTime").getValue();
                partVal.setValue(rvtm);
            }
            if (partVal.getName().equalsIgnoreCase("SDFLAG")) {
                this.dealSDFlag(partVal, rowparams);
            }
            if (partVal.getName().equalsIgnoreCase("CKTID")) {
                String wdmName = rowparams.getParam("wdmName").getValue();
                partVal.setValue("\"" + wdmName + "\"");
            }
            if (partVal.getName().equalsIgnoreCase("PST")) {
                partVal.setValue("");
            }
            if (partVal.getName().equalsIgnoreCase("SST")) {
                this.dealSST(partVal, rowparams);
            }
            if (partVal.getName().equalsIgnoreCase("PSDIRN")) {
                if (rowparams.getParam("switchMode") != null) {
                    partVal.setValue(rowparams.getParam("switchMode").getValue());
                } else {
                    return false;
                }
            }
            if (partVal.getName().equals("TS")) {
                String value = rowparams.getParam("oduflexslot").getValue();
                if (value == null || value.equals("-") || value.equals("0")) {
                    return false;
                }
                partVal.setValue(value);
            }
            if (partVal.getName().equals("PLDTYPE")) {
                String value = rowparams.getParam("oduflexsevtype").getValue();
                String mod2Level = TEEXCSpeedConstant.getInstance().getMod2Level(Integer.parseInt(value));
                if (mod2Level == null || mod2Level.equals("")) {
                    return false;
                }
                partVal.setValue(mod2Level);
            }
            if (partVal.getName().equals("PLDRATE")) {
                String value = rowparams.getParam("oduflexsevrate").getValue();
                if (value == null || value.equals("-") || value.equals("0")) {
                    return false;
                }
                partVal.setValue(value);
            }
            return true;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse TL1 Param Error", (Throwable)e);
            return true;
        }
    }

    private void dealSST(Part part, RowParams rowparams) {
        int redLine = Integer.parseInt(rowparams.getParam("wdmRedline").getValue());
        if (redLine == 0) {
            part.setValue("RDLD");
        } else if (redLine == 1) {
            part.setValue("RDLD-DEA");
        } else {
            TELogFactory.getNormalLogger().error("SST Error!" + redLine);
            part.setValue("");
        }
    }

    private void dealSDFlag(Part part, RowParams rowparams) {
        int sdFlag = Integer.parseInt(rowparams.getParam("SDTriggerFlag").getValue());
        if (sdFlag == 0) {
            part.setValue("DISABLE");
        } else if (sdFlag == 1) {
            part.setValue("ENABLE");
        } else {
            TELogFactory.getNormalLogger().error("SST Error!" + sdFlag);
            part.setValue("");
        }
    }

    private void dealPreferredPath(Part part, RowParams rowparams) {
        int prPath = Integer.parseInt(rowparams.getParam("wdmPrePath").getValue());
        if (prPath == 0) {
            String worksoltStr = rowparams.getParam("wSrcSlot").getValue();
            String workportStr = rowparams.getParam("wSrcPort").getValue();
            String workpathStr = rowparams.getParam("wSrcPath").getValue();
            String level = rowparams.getParam("sevType").getValue();
            String workAID = TEWDMEXCUtil.getExcAid(this.neid, worksoltStr, workportStr, workpathStr, level);
            part.setValue(workAID);
        } else if (prPath == 1) {
            String prosoltStr = rowparams.getParam("pSrcSlot").getValue();
            String proportStr = rowparams.getParam("pSrcPort").getValue();
            String propathStr = rowparams.getParam("pSrcPath").getValue();
            String level = rowparams.getParam("sevType").getValue();
            String proAID = TEWDMEXCUtil.getExcAid(this.neid, prosoltStr, proportStr, propathStr, level);
            part.setValue(proAID);
        } else {
            TELogFactory.getNormalLogger().error("Preferred Path Error!" + prPath);
            part.setValue("");
        }
    }
}

