/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.exc;

import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.FACAttr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TEWDMEXCUtil;
import com.huawei.nglct.ngwdm_pub.TETL1SimpleAID;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;

public class TESNCQueryBean
extends TETL1NEExplorerBean {
    private String sourceSubrackName = "";
    private String sourceShowSlot = "";
    private String sourceBoardNameStr = "";
    private String sourcePortNameStr = "";
    private String sourcePathStr = "";
    private String sinkSubrackName = "";
    private String sinkShowSlot = "";
    private String sinkBoardNameStr = "";
    private String sinkPortNameStr = "";
    private String sinkPathStr = "";
    private HashMap facAttrMap = new HashMap();
    private int pgNO = -1;
    private static final int FIRST_INDEX = 0;
    private static final int INDEX_ONE = 1;
    public static final int SNCP_SWSTATE_NORMAL = 0;
    public static final int SNCP_SWSTATE_WTR = 5;
    public static final int SNCP_SWSTATE_MANTOBACKUP = 7;
    public static final int SNCP_SWSTATE_MANTOMAIN = 23;
    public static final int SNCP_SWSTATE_SD = 9;
    public static final int SNCP_SWSTATE_SF = 12;
    public static final int SNCP_SWSTATE_FORCETOBACKUP = 14;
    public static final int SNCP_SWSTATE_FORCETOMAIN = 30;
    public static final int SNCP_SWSTATE_LOCK = 15;
    public static final int SNCP_SWSTATE_CLEARLOCK = 16;
    public static final int SNCP_SWSTATE_UNKNOWN = 255;

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        TENE ne = TENEListUtils.getNEObj((int)this.neid);
        if (66 == ne.getNEType() && ne.getShowNEVersion().compareTo("5.67.02.11") < 0) {
            tl1Operation.setMod2("GETH");
            tl1Operation.setName("RTRV-CRS-GETH");
        }
    }

    private boolean isSNCPProService(String from, String to) {
        String[] tmpFrom = from.split("&");
        String[] tmpTo = to.split("&");
        return tmpFrom.length > 1 || tmpTo.length > 1;
    }

    protected boolean isFilterRowData(HashMap partmap) {
        Part fromPart = (Part)partmap.get("FROM");
        Part topart = (Part)partmap.get("TO");
        String[] source = fromPart.getValue().split("&");
        String[] sink = topart.getValue().split("&");
        int slot = TETL1CommonUtil.getNMSlotStr((String)source[0].trim(), (int)this.neid);
        int slotsnk = TETL1CommonUtil.getNMSlotStr((String)sink[0].trim(), (int)this.neid);
        if (slot == -1 || slotsnk == -1) {
            return true;
        }
        Part autoFlag = (Part)partmap.get("AUTOFLAG");
        if (autoFlag == null) {
            return false;
        }
        if (autoFlag.getValue() == null || autoFlag.getValue().equals("Y")) {
            return true;
        }
        return !this.isSNCPProService(fromPart.getValue().trim(), topart.getValue().trim());
    }

    protected boolean handleRowData(int neid, SubFunc subfunc, RowParams rowparams, InMsg input, OutMsg output) {
        TENE ne = TENEListUtils.getNEObj((int)neid);
        this.neType = ne.getNEType();
        HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
        Part fromPart = (Part)partmap.get("FROM");
        Part topart = (Part)partmap.get("TO");
        if (fromPart.getValue() == null || topart.getValue() == null) {
            return true;
        }
        if (this.isSNCPProService(fromPart.getValue().trim(), topart.getValue().trim())) {
            ++this.pgNO;
            if (this.neType != 66) {
                String level = ((Part)partmap.get("LEVEL")).getValue();
                String mod2 = TEWDMEXCUtil.getMOD2FromLevel(level);
                ArrayList tl1OperationList = null;
                String[] source = fromPart.getValue().split("&");
                String[] sink = topart.getValue().split("&");
                if (source.length > 1) {
                    tl1OperationList = TETL1CommonUtil.createQueryFACAttrTL1Operation((int)neid, (String)mod2, (String[])source);
                } else if (sink.length > 1) {
                    tl1OperationList = TETL1CommonUtil.createQueryFACAttrTL1Operation((int)neid, (String)mod2, (String[])sink);
                }
                int result = this.sendMessage(neid, tl1OperationList);
                if (result == 0) {
                    this.handleFACAttrData(tl1OperationList);
                }
            }
        }
        return super.handleRowData(neid, subfunc, rowparams, input, output);
    }

    private void handleFACAttrData(ArrayList tl1OperationList) {
        TL1Operation oper = (TL1Operation)tl1OperationList.get(0);
        OutMsg out_first = oper.getOutMsg(0);
        HashMap partMap_first = TETL1CommonUtil.getOutMsgPart((OutMsg)out_first);
        Part holdTime_first = (Part)partMap_first.get("DELAYTIME");
        Part switchState_first = (Part)partMap_first.get("SWITCHSTATE");
        this.cloneTL1OperationList.add(oper.clone());
        TL1Operation oper1 = (TL1Operation)tl1OperationList.get(1);
        OutMsg out_sencond = oper1.getOutMsg(0);
        HashMap partMap_second = TETL1CommonUtil.getOutMsgPart((OutMsg)out_sencond);
        Part holdTime_sec = (Part)partMap_second.get("DELAYTIME");
        Part switchState_sec = (Part)partMap_second.get("SWITCHSTATE");
        this.cloneTL1OperationList.add(oper1.clone());
        FACAttr facAttr = new FACAttr(this.isNullReturnZero(holdTime_first.getValue()), this.isNullReturnZero(switchState_first.getValue()), this.isNullReturnZero(holdTime_sec.getValue()), this.isNullReturnZero(switchState_sec.getValue()));
        this.facAttrMap.put(this.pgNO, facAttr);
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap) {
        TEConfigurationDataMgr configMgr = null;
        if (oldParam.getName().equalsIgnoreCase("pgno")) {
            oldParam.setValue(String.valueOf(this.pgNO));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("sourceSubrackName")) {
            String subrackName;
            Part part = (Part)partmap.get("FROM");
            String[] source = part.getValue().split("&");
            int slot = TETL1CommonUtil.getNMSlotStr((String)source[0].trim(), (int)this.neid);
            this.sourceSubrackName = subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slot);
            oldParam.setValue(subrackName);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("sourceShowSlot")) {
            Part part = (Part)partmap.get("FROM");
            String[] source = part.getValue().split("&");
            int slot = TETL1CommonUtil.getNMSlotStr((String)source[0].trim(), (int)this.neid);
            int showSlot = TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slot);
            this.sourceShowSlot = String.valueOf(showSlot);
            oldParam.setValue(String.valueOf(showSlot));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("sourceBoard")) {
            configMgr = TEConfigurationDataMgr.getInstance();
            Part part = (Part)partmap.get("FROM");
            String[] source = part.getValue().split("&");
            int slot = TETL1CommonUtil.getNMSlotStr((String)source[0].trim(), (int)this.neid);
            int bdtype = configMgr.getBoard(this.neid, slot).getBoardType();
            this.sourceBoardNameStr = configMgr.getBoardTypeName(this.neid, bdtype);
            oldParam.setValue(this.sourceBoardNameStr);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("sourcePortName")) {
            this.dealSourcePortName(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("sourcePath")) {
            this.dealSourcePath(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("sinkSubrackName")) {
            String subrackName;
            Part part = (Part)partmap.get("TO");
            String[] source = part.getValue().split("&");
            int slot = TETL1CommonUtil.getNMSlotStr((String)source[0].trim(), (int)this.neid);
            this.sinkSubrackName = subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slot);
            oldParam.setValue(subrackName);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("sinkShowSlot")) {
            Part part = (Part)partmap.get("TO");
            String[] source = part.getValue().split("&");
            int slot = TETL1CommonUtil.getNMSlotStr((String)source[0].trim(), (int)this.neid);
            int showSlot = TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slot);
            this.sinkShowSlot = String.valueOf(showSlot);
            oldParam.setValue(String.valueOf(showSlot));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("sinkBoard")) {
            configMgr = TEConfigurationDataMgr.getInstance();
            Part part = (Part)partmap.get("TO");
            String[] source = part.getValue().split("&");
            int slot = TETL1CommonUtil.getNMSlotStr((String)source[0].trim(), (int)this.neid);
            int bdtype = configMgr.getBoard(this.neid, slot).getBoardType();
            this.sinkBoardNameStr = configMgr.getBoardTypeName(this.neid, bdtype);
            oldParam.setValue(this.sinkBoardNameStr);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("sinkPortName")) {
            this.dealSinkPortName(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("sinkPath")) {
            this.dealSinkPath(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pSourceSubrackName")) {
            this.dealPSourceSubrackName(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pSourceShowSlot")) {
            this.dealPSourceShowSlot(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pSourceBoard")) {
            this.dealPSourceBoard(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pSourcePortName")) {
            this.dealPsourcePortName(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pSourcePath")) {
            this.dealPSourcePath(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pSinkSubrackName")) {
            this.dealPSinkSubrackName(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pSinkShowSlot")) {
            this.dealPSinkShowSlot(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pSinkBoard")) {
            this.dealPSinkBoard(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pSinkPortName")) {
            this.dealPSinkPortName(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pSinkPath")) {
            this.dealPSinkPath(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("serviceType") || oldParam.getName().equalsIgnoreCase("pServiceType")) {
            Part part = (Part)partmap.get("LEVEL");
            oldParam.setValue(TETL1CommonUtil.isNull((String)part.getValue()));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("revertivemode") || oldParam.getName().equalsIgnoreCase("hideRevertiveMode")) {
            this.dealRevertiveMode(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("WTRtime")) {
            this.dealWTRTime(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("sdenablingflag")) {
            Part part = (Part)partmap.get("SDFLAG");
            oldParam.setValue(TETL1CommonUtil.isNull((String)part.getValue()));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("level")) {
            this.dealLevel(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("protectType")) {
            Part part = (Part)partmap.get("SNCPTYPE");
            oldParam.setValue(this.getSNCPType(TETL1CommonUtil.isNull((String)part.getValue())));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("autoflag")) {
            Part part = (Part)partmap.get("AUTOFLAG");
            oldParam.setValue(TETL1CommonUtil.isNull((String)part.getValue()));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("preferCurAID")) {
            this.dealPreferCurAID(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("workCurAID")) {
            this.dealWorkCurAID(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("preferProCurAID")) {
            this.dealPreferProCurAID(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("proCurAID")) {
            this.dealProCurAID(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pCurFAC")) {
            Part part = (Part)partmap.get("ACTIVEPATH");
            oldParam.setValue(TETL1CommonUtil.isNull((String)part.getValue()));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("curFAC")) {
            Part part = (Part)partmap.get("ACTIVEPATH");
            oldParam.setValue(TETL1CommonUtil.isNull((String)part.getValue()));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("excname")) {
            Part part = (Part)partmap.get("CKTID");
            oldParam.setValue(TETL1FaultUtil.subStringSpecial((String)TETL1CommonUtil.isNull((String)part.getValue())));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("redline")) {
            String value = this.dealRedLine(partmap);
            oldParam.setValue(value);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("oduflexslot")) {
            Part part = (Part)partmap.get("TS");
            if (part != null && part.getValue() != null) {
                oldParam.setValue(part.getValue());
            } else {
                oldParam.setValue("-");
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("oduflexsevtype")) {
            Part part = (Part)partmap.get("PLDTYPE");
            if (part != null && part.getValue() != null) {
                oldParam.setValue(part.getValue());
            } else {
                oldParam.setValue("-");
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("oduflexsevrate")) {
            Part part = (Part)partmap.get("PLDRATE");
            if (part != null && part.getValue() != null) {
                oldParam.setValue(part.getValue());
            } else {
                oldParam.setValue("-");
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("delayTime")) {
            this.dealDelayTime(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pDelayTime")) {
            this.dealPDelayTime(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("currentStatus") || oldParam.getName().equalsIgnoreCase("pCurrentStatus")) {
            this.dealCurrentStatus(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pathStatus")) {
            this.dealWorkPathStatus(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("pPathStatus")) {
            this.dealProtectPathStatus(oldParam, partmap);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("workSourceAid")) {
            Part part = (Part)partmap.get("FROM");
            String[] source = part.getValue().split("&");
            oldParam.setValue(source[0]);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("workSinkAid")) {
            Part part = (Part)partmap.get("TO");
            String[] source = part.getValue().split("&");
            oldParam.setValue(source[0]);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("proSourceAid")) {
            Part part = (Part)partmap.get("FROM");
            String[] source = part.getValue().split("&");
            String value = source.length > 1 ? source[1] : source[0];
            oldParam.setValue(value);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("proSinkAid")) {
            Part part = (Part)partmap.get("TO");
            String[] source = part.getValue().split("&");
            String value = source.length > 1 ? source[1] : source[0];
            oldParam.setValue(value);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("switchMode")) {
            Part part = (Part)partmap.get("PSDIRN");
            if (part != null && part.getValue() != null) {
                oldParam.setValue(part.getValue());
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("switchType")) {
            Part part = (Part)partmap.get("SWRQST");
            if (part != null && part.getValue() != null) {
                oldParam.setValue(part.getValue());
            }
            return oldParam;
        }
        return oldParam;
    }

    private String dealRedLine(HashMap partmap) {
        Part part = (Part)partmap.get("SST");
        String value = "";
        value = part.getValue() == null || part.getValue().equals("RDLD-DEA") ? "No" : "Yes";
        return value;
    }

    private void dealRevertiveMode(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("RVRTV");
        if (part.getValue().equals("N")) {
            oldParam.setValue("0");
        } else if (part.getValue().equals("Y")) {
            oldParam.setValue("1");
        }
    }

    private void dealProCurAID(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("ACTIVEPATH");
        if (part.getValue() == null) {
            oldParam.setValue("/");
        } else {
            String[] strArray = part.getValue().split("&");
            String aidstr = strArray.length > 1 ? strArray[1] : strArray[0];
            Part levelPart = (Part)partmap.get("LEVEL");
            String aid = TETL1CommonUtil.getGencfgObjFromAID((int)this.neid, (String)aidstr, (String)levelPart.getValue());
            oldParam.setValue(aid);
        }
    }

    private void dealPreferProCurAID(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("PREFERREDPATH");
        if (part.getValue() == null) {
            oldParam.setValue("/");
        } else {
            String[] strArray = part.getValue().split("&");
            String aidstr = strArray.length > 1 ? strArray[1] : strArray[0];
            String aid = TETL1CommonUtil.getBoardStructFromAID((String)aidstr, (int)this.neid, (boolean)false);
            oldParam.setValue(aid);
        }
    }

    private void dealWorkCurAID(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("ACTIVEPATH");
        if (part.getValue() == null) {
            oldParam.setValue("/");
        } else {
            String[] strArray = part.getValue().split("&");
            Part levelPart = (Part)partmap.get("LEVEL");
            String aid = TETL1CommonUtil.getGencfgObjFromAID((int)this.neid, (String)strArray[0], (String)levelPart.getValue());
            oldParam.setValue(aid);
        }
    }

    private void dealPreferCurAID(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("PREFERREDPATH");
        if (part.getValue() == null) {
            oldParam.setValue("/");
        } else {
            String[] strArray = part.getValue().split("&");
            String aid = TETL1CommonUtil.getBoardStructFromAID((String)strArray[0], (int)this.neid, (boolean)false);
            oldParam.setValue(aid);
        }
    }

    private void dealLevel(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("OTNLEVEL");
        if (part.getValue() == null || part.getValue().equals("")) {
            oldParam.setValue("-");
        } else {
            oldParam.setValue(part.getValue());
        }
    }

    private void dealWTRTime(Param oldParam, HashMap partmap) {
        Part partV = (Part)partmap.get("RVRTV");
        Part part = (Part)partmap.get("RVTM");
        String value = "";
        value = partV == null || partV.getValue().equals("N") ? "-" : (part.getValue() == null ? "0" : part.getValue());
        oldParam.setValue(value);
    }

    private void dealWorkPathStatus(Param oldParam, HashMap partmap) {
        String switchStatusValue = "";
        if (this.neType == 66) {
            Part swState = (Part)partmap.get("WKCHNSTATE");
            if (swState != null) {
                switchStatusValue = TESNCQueryBean.getPathStatus(swState.getValue());
            }
        } else {
            FACAttr fac = (FACAttr)this.facAttrMap.get(this.pgNO);
            fac = fac != null ? fac : new FACAttr();
            String strWork = fac.workSwitchStatus;
            switchStatusValue = TESNCQueryBean.getPathStatus(strWork);
        }
        oldParam.setValue(switchStatusValue);
    }

    private void dealProtectPathStatus(Param oldParam, HashMap partmap) {
        String switchStatusValue = "";
        if (this.neType == 66) {
            Part swState = (Part)partmap.get("PROTCHNSTATE");
            if (swState != null) {
                switchStatusValue = TESNCQueryBean.getPathStatus(swState.getValue());
            }
        } else {
            FACAttr fac = (FACAttr)this.facAttrMap.get(this.pgNO);
            fac = fac != null ? fac : new FACAttr();
            String strProt = fac.proSwitchStatus;
            switchStatusValue = TESNCQueryBean.getPathStatus(strProt);
        }
        oldParam.setValue(switchStatusValue);
    }

    private static String getPathStatus(String strSwState) {
        if (strSwState == null) {
            return "";
        }
        int retState = 255;
        if (strSwState.equals("SD")) {
            retState = 1;
        } else if (strSwState.equals("SF")) {
            retState = 2;
        } else if (strSwState.equals("IDLE")) {
            retState = 3;
        } else if (strSwState.equals("MAN")) {
            retState = 4;
        } else if (strSwState.equals("FRCD")) {
            retState = 5;
        } else if (strSwState.equals("LOCK") || strSwState.equals("LOCKOUT")) {
            retState = 6;
        } else if (strSwState.equals("DNR")) {
            retState = 7;
        } else if (strSwState.equals("WTR")) {
            retState = 8;
        }
        return String.valueOf(retState);
    }

    private void dealCurrentStatus(Param oldParam, HashMap partmap) {
        String switchStatusValue = "";
        if (this.neType == 66) {
            Part activePath = (Part)partmap.get("ACTIVEPATH");
            Part swState = (Part)partmap.get("SWSTATE");
            Part from = (Part)partmap.get("FROM");
            String[] src = from.getValue().split("&");
            boolean bIsWorkPath = false;
            if (src[0].equals(activePath.getValue())) {
                bIsWorkPath = true;
            }
            switchStatusValue = String.valueOf(this.GetSWStateEx(swState.getValue(), bIsWorkPath));
        } else {
            FACAttr fac = (FACAttr)this.facAttrMap.get(this.pgNO);
            fac = fac != null ? fac : new FACAttr();
            switchStatusValue = String.valueOf(this.createSwitchStatusValue(fac));
        }
        oldParam.setValue(switchStatusValue);
    }

    private void dealPDelayTime(Param oldParam, HashMap partmap) {
        if (this.neType == 66) {
            Part tempPart = (Part)partmap.get("PROTCHNDLYTIME");
            if (tempPart != null && tempPart.getValue() != null) {
                oldParam.setValue(tempPart.getValue());
            } else {
                oldParam.setValue("/");
            }
        } else {
            FACAttr fac = (FACAttr)this.facAttrMap.get(this.pgNO);
            fac = fac != null ? fac : new FACAttr();
            oldParam.setValue(fac.proHoldTime);
        }
    }

    private void dealDelayTime(Param oldParam, HashMap partmap) {
        if (this.neType == 66) {
            Part tempPart = (Part)partmap.get("WKCHNDLYTIME");
            if (tempPart != null && tempPart.getValue() != null) {
                oldParam.setValue(tempPart.getValue());
            } else {
                oldParam.setValue("/");
            }
        } else {
            FACAttr fac = (FACAttr)this.facAttrMap.get(this.pgNO);
            fac = fac != null ? fac : new FACAttr();
            oldParam.setValue(fac.workHoldTime);
        }
    }

    private void dealPSourceBoard(Param oldParam, HashMap partmap) {
        TEConfigurationDataMgr configMgr = TEConfigurationDataMgr.getInstance();
        Part part = (Part)partmap.get("FROM");
        String[] source = part.getValue().split("&");
        if (source.length > 1) {
            int slot = TETL1CommonUtil.getNMSlotStr((String)source[1].trim(), (int)this.neid);
            int bdtype = configMgr.getBoard(this.neid, slot).getBoardType();
            String bdname = configMgr.getBoardTypeName(this.neid, bdtype);
            oldParam.setValue(bdname);
        } else {
            oldParam.setValue(this.sourceBoardNameStr);
        }
    }

    private void dealPSourceShowSlot(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("FROM");
        String[] source = part.getValue().split("&");
        if (source.length > 1) {
            int slot = TETL1CommonUtil.getNMSlotStr((String)source[1].trim(), (int)this.neid);
            int showSlot = TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slot);
            oldParam.setValue(String.valueOf(showSlot));
        } else {
            oldParam.setValue(this.sourceShowSlot);
        }
    }

    private void dealPSourceSubrackName(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("FROM");
        String[] source = part.getValue().split("&");
        if (source.length > 1) {
            int slot = TETL1CommonUtil.getNMSlotStr((String)source[1].trim(), (int)this.neid);
            String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slot);
            oldParam.setValue(subrackName);
        } else {
            oldParam.setValue(this.sourceSubrackName);
        }
    }

    private void dealSinkPath(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("TO");
        String[] source = part.getValue().split("&");
        String[] slot = TETL1CommonUtil.parseAID((String)source[0].trim(), (int)this.neid);
        try {
            this.sinkPathStr = slot[4];
            this.sinkPathStr = this.sinkPathStr.equals("-1") ? "" : this.sinkPathStr;
            oldParam.setValue(this.sinkPathStr);
        }
        catch (Exception e) {
            oldParam.setValue("");
        }
    }

    private void dealSinkPortName(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("TO");
        String[] source = part.getValue().split("&");
        String[] slotStr = TETL1CommonUtil.parseAID((String)source[0].trim(), (int)this.neid);
        int nmslot = TETL1CommonUtil.getNMSlotStr((String)source[0].trim(), (int)this.neid);
        try {
            int portID = Integer.parseInt(slotStr[3]);
            this.sinkPortNameStr = TETL1CommonUtil.getPortNameFromNEPort((String)slotStr[0], (int)nmslot, (int)portID, (int)this.neid);
            oldParam.setValue(this.sinkPortNameStr);
        }
        catch (Exception e) {
            oldParam.setValue("");
        }
    }

    private void dealSourcePath(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("FROM");
        String[] source = part.getValue().split("&");
        TETL1SimpleAID simpleAID = new TETL1SimpleAID(source[0].trim(), this.neid);
        try {
            Part levelPart = (Part)partmap.get("LEVEL");
            int tmpPath = simpleAID.getNmPath(levelPart.getValue());
            if (tmpPath <= 0) {
                oldParam.setValue(String.valueOf(""));
            } else {
                oldParam.setValue(String.valueOf(tmpPath));
            }
        }
        catch (Exception e) {
            oldParam.setValue("");
        }
    }

    private void dealSourcePortName(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("FROM");
        String[] source = part.getValue().split("&");
        String[] slotStr = TETL1CommonUtil.parseAID((String)source[0].trim(), (int)this.neid);
        int nmslot = TETL1CommonUtil.getNMSlotStr((String)source[0].trim(), (int)this.neid);
        try {
            int portID = Integer.parseInt(slotStr[3]);
            this.sourcePortNameStr = TETL1CommonUtil.getPortNameFromNEPort((String)slotStr[0], (int)nmslot, (int)portID, (int)this.neid);
            oldParam.setValue(this.sourcePortNameStr);
        }
        catch (Exception e) {
            oldParam.setValue("");
        }
    }

    private void dealPSinkPath(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("TO");
        String[] source = part.getValue().split("&");
        if (source.length > 1) {
            Part levelPart;
            TETL1SimpleAID simpleAID = new TETL1SimpleAID(source[0].trim(), this.neid);
            int tmpPath = simpleAID.getNmPath((levelPart = (Part)partmap.get("LEVEL")).getValue());
            if (tmpPath <= 0) {
                oldParam.setValue(String.valueOf(""));
            } else {
                oldParam.setValue(String.valueOf(tmpPath));
            }
        } else {
            oldParam.setValue(this.sinkPathStr);
        }
    }

    private void dealPSinkPortName(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("TO");
        String[] source = part.getValue().split("&");
        if (source.length > 1) {
            String[] slotStr = TETL1CommonUtil.parseAID((String)source[0].trim(), (int)this.neid);
            int nmslot = TETL1CommonUtil.getNMSlotStr((String)source[0].trim(), (int)this.neid);
            try {
                int portID = Integer.parseInt(slotStr[3]);
                String portname = TETL1CommonUtil.getPortNameFromNEPort((String)slotStr[0], (int)nmslot, (int)portID, (int)this.neid);
                oldParam.setValue(portname);
            }
            catch (Exception e) {
                oldParam.setValue("");
            }
        } else {
            oldParam.setValue(this.sinkPortNameStr);
        }
    }

    private void dealPSinkBoard(Param oldParam, HashMap partmap) {
        TEConfigurationDataMgr configMgr = TEConfigurationDataMgr.getInstance();
        Part part = (Part)partmap.get("TO");
        String[] source = part.getValue().split("&");
        if (source.length > 1) {
            int slot = TETL1CommonUtil.getNMSlotStr((String)source[0].trim(), (int)this.neid);
            int bdtype = configMgr.getBoard(this.neid, slot).getBoardType();
            String bdname = configMgr.getBoardTypeName(this.neid, bdtype);
            oldParam.setValue(bdname);
        } else {
            oldParam.setValue(this.sinkBoardNameStr);
        }
    }

    private void dealPSinkShowSlot(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("TO");
        String[] source = part.getValue().split("&");
        if (source.length > 1) {
            int slot = TETL1CommonUtil.getNMSlotStr((String)source[0].trim(), (int)this.neid);
            int showSlot = TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slot);
            oldParam.setValue(String.valueOf(showSlot));
        } else {
            oldParam.setValue(this.sinkShowSlot);
        }
    }

    private void dealPSinkSubrackName(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("TO");
        String[] source = part.getValue().split("&");
        if (source.length > 1) {
            int slot = TETL1CommonUtil.getNMSlotStr((String)source[0].trim(), (int)this.neid);
            String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slot);
            oldParam.setValue(subrackName);
        } else {
            oldParam.setValue(this.sinkSubrackName);
        }
    }

    private void dealPSourcePath(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("FROM");
        String[] source = part.getValue().split("&");
        if (source.length > 1) {
            Part levelPart;
            TETL1SimpleAID simpleAID = new TETL1SimpleAID(source[1].trim(), this.neid);
            int tmpPath = simpleAID.getNmPath((levelPart = (Part)partmap.get("LEVEL")).getValue());
            if (tmpPath <= 0) {
                oldParam.setValue(String.valueOf(""));
            } else {
                oldParam.setValue(String.valueOf(tmpPath));
            }
        } else {
            oldParam.setValue(this.sourcePathStr);
        }
    }

    private void dealPsourcePortName(Param oldParam, HashMap partmap) {
        Part part = (Part)partmap.get("FROM");
        String[] source = part.getValue().split("&");
        if (source.length > 1) {
            String[] slotStr = TETL1CommonUtil.parseAID((String)source[1].trim(), (int)this.neid);
            int nmslot = TETL1CommonUtil.getNMSlotStr((String)source[1].trim(), (int)this.neid);
            try {
                int portID = Integer.parseInt(slotStr[3]);
                String portname = TETL1CommonUtil.getPortNameFromNEPort((String)slotStr[0], (int)nmslot, (int)portID, (int)this.neid);
                oldParam.setValue(portname);
            }
            catch (Exception e) {
                oldParam.setValue("");
            }
        } else {
            oldParam.setValue(this.sourcePortNameStr);
        }
    }

    private int createSwitchStatusValue(FACAttr fac) {
        String strWork = fac.workSwitchStatus;
        String strProt = fac.proSwitchStatus;
        if (strWork.equals("LOCKOUT") || strProt.equals("LOCKOUT")) {
            return 15;
        }
        if (strWork.equals("FRCD")) {
            return 14;
        }
        if (strProt.equals("FRCD")) {
            return 30;
        }
        if (strWork.equals("MAN")) {
            return 7;
        }
        if (strProt.equals("MAN")) {
            return 23;
        }
        if (strWork.equals("SF") || strProt.equals("MAN")) {
            return 12;
        }
        if (strWork.equals("SD") || strProt.equals("SD")) {
            return 9;
        }
        if (strWork.equals("WTR") && strProt.equals("IDLE")) {
            return 5;
        }
        if ((strWork.equals("DNR") || strWork.equals("IDLE")) && strProt.equals("IDLE")) {
            return 0;
        }
        return 255;
    }

    private int GetSWStateEx(String strSwState, boolean bIsWorkPath) {
        int retState = 255;
        if (strSwState.equals("NORMAL")) {
            retState = 0;
        } else if (strSwState.equals("WTR")) {
            retState = 5;
        } else if (strSwState.equals("MAN") && !bIsWorkPath) {
            retState = 7;
        } else if (strSwState.equals("MAN") && bIsWorkPath) {
            retState = 23;
        } else if (strSwState.equals("FRCD") && !bIsWorkPath) {
            retState = 14;
        } else if (strSwState.equals("FRCD") && bIsWorkPath) {
            retState = 30;
        } else if (strSwState.equals("LOCK") || strSwState.equals("LOCKOUT")) {
            retState = 15;
        } else if (strSwState.equals("SF")) {
            retState = 12;
        } else if (strSwState.equals("SD")) {
            retState = 9;
        }
        return retState;
    }

    private String getSNCPType(String neSncType) {
        if (neSncType.equals("SNCI")) {
            return "SNC/I";
        }
        if (neSncType.equals("SNCN")) {
            return "SNC/N";
        }
        if (neSncType.equals("SNCS")) {
            return "SNC/S";
        }
        return "-";
    }

    private String isNullReturnZero(String temp) {
        return temp == null ? "0" : temp;
    }

    public int getTimeOut() {
        return 180;
    }
}

