/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.exc;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.config.exc.AutoExcItem;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TEEXCSpeedConstant;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TETL1ExcCreateSuperBean;
import com.huawei.nglct.nemgr.tl1ngwdm.config.exc.TEWDMEXCUtil;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TEEXCCreateBean
extends TETL1ExcCreateSuperBean {
    protected int srcBoardID;
    protected int srcPortID;
    protected int srcPathID;
    protected int snkBoardID;
    protected int snkPortID;
    protected int snkPathID;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        Datainterface excOutputData = new Datainterface();
        excOutputData.setBussinessParams(this.outputData.getBussinessParams());
        excOutputData.setPageParams(this.outputData.getPageParams());
        excOutputData.setErrorMessage(this.outputData.getErrorMessage());
        if (0 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            Datainterface inputDataAutoExc = new Datainterface();
            inputDataAutoExc.setBussinessParams(new BussinessParams());
            int size = inputData.getBussinessParams().getRowParamsCount();
            for (int j = 0; j < size; ++j) {
                ArrayList snkAutoExcs;
                RowParams inputRow = inputData.getBussinessParams().getRowParams(j);
                String srcSlotID = inputRow.getParam("srcSoltID").getValue();
                String srcPortID = inputRow.getParam("srcPortNO").getValue();
                String srcPathID = inputRow.getParam("srcPathNO").getValue();
                String snkSlotID = inputRow.getParam("snkSoltID").getValue();
                String snkPortID = inputRow.getParam("snkPortNO").getValue();
                String snkPathID = inputRow.getParam("snkPathNO").getValue();
                this.srcBoardID = Integer.parseInt(srcSlotID);
                this.srcPortID = Integer.parseInt(srcPortID);
                this.srcPathID = Integer.parseInt(srcPathID);
                this.snkBoardID = Integer.parseInt(snkSlotID);
                this.snkPortID = Integer.parseInt(snkPortID);
                this.snkPathID = Integer.parseInt(snkPathID);
                String level = inputRow.getParam("level").getValue();
                ArrayList srcAutoExcs = super.getAutoExcByboard(this.srcBoardID, this.srcPortID, "XC_SRC_TP", level);
                if (srcAutoExcs != null) {
                    for (int i = srcAutoExcs.size() - 1; i >= 0; --i) {
                        inputDataAutoExc.getBussinessParams().addRowParams(this.buildRowParams((AutoExcItem)srcAutoExcs.get(i), inputRow, String.valueOf(this.srcBoardID)));
                    }
                }
                if ((snkAutoExcs = super.getAutoExcByboard(this.snkBoardID, this.snkPortID, "XC_SNK_TP", level)) == null) continue;
                for (int i = snkAutoExcs.size() - 1; i >= 0; --i) {
                    inputDataAutoExc.getBussinessParams().addRowParams(this.buildRowParams((AutoExcItem)snkAutoExcs.get(i), inputRow, String.valueOf(this.snkBoardID)));
                }
            }
            super.performBussinessProcess(neid, subFunc, inputDataAutoExc, memeryData, user, ipAddress);
        }
        return excOutputData;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TL1Operation tl1Oper;
        if (tl1OperList.size() == 2 && (tl1Oper = (TL1Operation)tl1OperList.get(1)).getOutMsgCount() > 0 && tl1Oper.getOutMsg(0).getFault().getErrDesc().equals("PARAMETER NOT VALID, Cross connection already exists")) {
            tl1OperList.remove(1);
        }
        this.outputData = this.convertToDatainterface(neid, subfunc, tl1OperList, filterErrorCodeList);
    }

    protected RowParams buildRowParams(AutoExcItem autoExcItem, RowParams inputRow, String srcSoltID) {
        RowParams inputRowParam = new RowParams();
        inputRowParam.addParam("level", autoExcItem.getExc_level());
        inputRowParam.addParam("srcSoltID", srcSoltID);
        inputRowParam.addParam("srcPortNO", String.valueOf(autoExcItem.getSrcPortNum()));
        inputRowParam.addParam("srcPathNO", String.valueOf(autoExcItem.getSrcChannelNum()));
        inputRowParam.addParam("snkSoltID", srcSoltID);
        inputRowParam.addParam("snkPortNO", String.valueOf(autoExcItem.getSnkPortNum()));
        inputRowParam.addParam("snkPathNO", String.valueOf(autoExcItem.getSnkChannelNum()));
        inputRowParam.addParam("direction", String.valueOf(inputRow.getParam("direction").getValue()));
        inputRowParam.addParam("name", String.valueOf(inputRow.getParam("name").getValue()));
        inputRowParam.addParam("redline", String.valueOf(inputRow.getParam("redline").getValue()));
        return inputRowParam;
    }

    public Datainterface performCreateExcProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        return this.outputData;
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        String level = rowparams.getParam("level").getValue();
        int _level = Integer.parseInt(level);
        String mod2Level = TEEXCSpeedConstant.getInstance().getMod2Level(_level);
        tl1Operation.setMod2(mod2Level);
        tl1Operation.setName(tl1Operation.getCmdCode() + "-" + tl1Operation.getMod1() + "-" + mod2Level);
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        if (part.getName().equals("FROM")) {
            String srcSlotID = rowparams.getParam("srcSoltID").getValue();
            String srcPortID = rowparams.getParam("srcPortNO").getValue();
            String srcPathID = rowparams.getParam("srcPathNO").getValue();
            String level = rowparams.getParam("level").getValue();
            String neAid = TEWDMEXCUtil.getExcAid(this.neid, srcSlotID, srcPortID, srcPathID, level);
            part.setValue(neAid);
        } else if (part.getName().equals("TO")) {
            String snkSlotID = rowparams.getParam("snkSoltID").getValue();
            String snkPortID = rowparams.getParam("snkPortNO").getValue();
            String snkPathID = rowparams.getParam("snkPathNO").getValue();
            String level = rowparams.getParam("level").getValue();
            String neAid = TEWDMEXCUtil.getExcAid(this.neid, snkSlotID, snkPortID, snkPathID, level);
            part.setValue(neAid);
        } else if (part.getName().equals("CCT")) {
            String cct = rowparams.getParam("direction").getValue();
            String value = null;
            value = cct.equals("bidirectional") ? "2WAY" : "1WAY";
            part.setValue(value);
        } else if (part.getName().equals("CKTID")) {
            String value = rowparams.getParam("name").getValue();
            if ("null".equalsIgnoreCase(value)) {
                value = "";
            }
            part.setValue("\"" + value + "\"");
        } else if (part.getName().equals("SST")) {
            String value = rowparams.getParam("redline").getValue();
            if ("null".equalsIgnoreCase(value)) {
                value = "";
            }
            part.setValue(value);
        } else if (part.getName().equals("TS")) {
            String value = rowparams.getParam("oduflexslot").getValue();
            if (value == null || value.equals("-") || value.equals("0")) {
                return false;
            }
            part.setValue(value);
        } else if (part.getName().equals("PLDTYPE")) {
            String value = rowparams.getParam("oduflexsevtype").getValue();
            String mod2Level = TEEXCSpeedConstant.getInstance().getMod2Level(Integer.parseInt(value));
            if (mod2Level == null || mod2Level.equals("")) {
                return false;
            }
            part.setValue(mod2Level);
        } else if (part.getName().equals("PLDRATE")) {
            String value = rowparams.getParam("oduflexsevrate").getValue();
            if (value == null || value.equals("-") || value.equals("0")) {
                return false;
            }
            part.setValue(value);
        }
        return true;
    }
}

