/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.dlinkaggregation;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEDLAGBoardMgr
extends TETL1NEExplorerBean {
    private static final String FILEPATH = "nemgr" + File.separator + "tl1ngwdm" + File.separator + "conf" + File.separator + "ne_attribute" + File.separator + "config" + File.separator + "dlinkaggregation" + File.separator + "boardsupportdlag.xml";
    private static List boardTypeSupportDlagList;
    private List boardSupportDalgList = new ArrayList();
    private HashMap slotPortsMap = new HashMap();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.outputData = new Datainterface();
        this.boardSupportDalgList = this.getBoardList();
        if (this.boardSupportDalgList.size() == 0) {
            TELogFactory.getNormalLogger().error("There is no board support dlag!");
            return this.outputData;
        }
        this.filterUsedPorts(neid, subFunc, null);
        return this.outputData;
    }

    private void filterUsedPorts(int neid, SubFunc subfunc, ArrayList filterErrorCodeList) {
        ArrayList operationList = this.getOperationList();
        int result = this.sendMessage(neid, operationList);
        if (result == 0) {
            this.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        } else {
            TELogFactory.getNormalLogger().error("Send operation list failed! --Dlag");
        }
    }

    public int sendMessage(int neid, ArrayList tl1OperList) {
        int retCode = 0;
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, (List)tl1OperList, this.getTimeOut());
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    private ArrayList getOperationList() {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TL1Operation operation = null;
            TEBoard board = null;
            InMsg input = null;
            int size = this.boardSupportDalgList.size();
            for (int i = 0; i < size; ++i) {
                StringBuffer sb = new StringBuffer();
                sb.append("FAC-");
                board = (TEBoard)this.boardSupportDalgList.get(i);
                String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)board.getSlotID());
                sb.append(shelfSlotID).append("-ALL");
                StringBuffer slotSb = new StringBuffer();
                slotSb.append("SLOT-");
                slotSb.append(shelfSlotID);
                operation = definitions.getTL1Operation("RTRV-ETHLINK");
                input = operation.getInMsg();
                input.getPart("LINKFROM").setValue(slotSb.toString());
                input.getPart("LINKTO").setValue(slotSb.toString());
                operationList.add(operation);
                operation = definitions.getTL1Operation("RTRV-LAG");
                input = operation.getInMsg();
                input.getPart("AID").setValue(sb.toString());
                operationList.add(operation);
            }
            operation = definitions.getTL1Operation("RTRV-DLAG");
            input = operation.getInMsg();
            input.getPart("AID").setValue("");
            operationList.add(operation);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEDLAGBoardMgr.getOperationList() fail!", (Throwable)e);
        }
        return operationList;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        ArrayList<Object> tempOperationList = new ArrayList<Object>();
        int len = tl1OperList.size();
        for (int t = 0; t < len; ++t) {
            tempOperationList.add(((TL1Operation)tl1OperList.get(t)).clone());
        }
        int n = tl1OperList.size();
        for (int i = 0; i < n; ++i) {
            TL1Operation temp = (TL1Operation)tl1OperList.get(i);
            if (temp.getName().equals("RTRV-LAG")) {
                this.getLagPorts(temp);
                continue;
            }
            if (temp.getName().equals("RTRV-ETHLINK")) {
                this.getEthLinkPorts(temp);
                continue;
            }
            if (!temp.getName().equals("RTRV-DLAG")) continue;
            this.getDLagPorts(temp);
        }
        this.handleOutputData();
    }

    private void handleOutputData() {
        this.outputData.setBussinessParams(new BussinessParams());
        String neName = TEConfigurationDataMgr.getInstance().getNE(this.neid).getNEName();
        ArrayList slotIDList = new ArrayList(this.slotPortsMap.size());
        Set slotIDSet = this.slotPortsMap.keySet();
        Iterator iter = slotIDSet.iterator();
        while (iter.hasNext()) {
            slotIDList.add(iter.next());
        }
        Collections.sort(slotIDList);
        RowParams rowParams = null;
        Param param = null;
        int size = slotIDList.size();
        for (int i = 0; i < size; ++i) {
            Resource temp = (Resource)this.slotPortsMap.get(slotIDList.get(i));
            rowParams = new RowParams();
            rowParams.addParam(new Param("neName", neName));
            rowParams.addParam(new Param("slotid", String.valueOf(temp.slotid)));
            String showSlot = TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)temp.slotid);
            rowParams.addParam(new Param("boardName", showSlot + "-" + temp.boardName));
            param = new Param("macPort", "");
            int len = temp.macPortList.size();
            for (int j = 0; j < len; ++j) {
                Option option = new Option(String.valueOf(temp.macPortList.get(j)));
                param.addOption(option);
            }
            rowParams.addParam(param);
            rowParams.addParam(new Param("hasFilterMain", String.valueOf(temp.hasFilterMain)));
            rowParams.addParam(new Param("hasFilterSlave", String.valueOf(temp.hasFilterSlave)));
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }

    private void getEthLinkPorts(TL1Operation ethLink) {
        OutMsg[] outmsgs = ethLink.getOutMsg();
        Resource temp = null;
        for (OutMsg out : outmsgs) {
            if (out.getFault().getCompletionCode() != 0) {
                return;
            }
            HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
            for (Map.Entry entry : partmap.entrySet()) {
                int shelfSlotID;
                String name = (String)entry.getKey();
                Part value = (Part)entry.getValue();
                if (!name.equals("LINKFROM") && !name.equals("LINKTO") || value.getValue() == null || (temp = (Resource)this.slotPortsMap.get(String.valueOf(shelfSlotID = TETL1CommonUtil.getNMSlotStr((String)value.getValue(), (int)this.neid)))) == null) continue;
                temp.hasFilterSlave = true;
            }
        }
    }

    private void getLagPorts(TL1Operation lag) {
        OutMsg[] outmsgs = lag.getOutMsg();
        Resource temp = null;
        for (OutMsg out : outmsgs) {
            if (out.getFault().getCompletionCode() != 0) {
                return;
            }
            HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
            int boardID = TETL1CommonUtil.getNMSlotStr((String)((Part)partmap.get("AID")).getValue(), (int)this.neid);
            temp = (Resource)this.slotPortsMap.get(String.valueOf(boardID));
            if (temp == null) continue;
            for (Map.Entry entry : partmap.entrySet()) {
                String name = (String)entry.getKey();
                Part value = (Part)entry.getValue();
                if (name.equals("AID")) {
                    String[] str = TETL1CommonUtil.parseAID((String)value.getValue(), (int)this.neid);
                    Integer mainPort = Integer.valueOf(str[3]);
                    if (!str[0].equals("FAC")) continue;
                    temp.macPortList.remove(mainPort);
                    continue;
                }
                if (!name.equals("SLVPORTS")) continue;
                Object[] slvPorts = this.getPorts(value.getValue());
                int m = slvPorts.length;
                for (int i = 0; i < m; ++i) {
                    temp.macPortList.remove(new Integer((String)slvPorts[i]));
                }
            }
        }
    }

    private void getDLagPorts(TL1Operation lag) {
        OutMsg[] outmsgs = lag.getOutMsg();
        Resource temp = null;
        for (OutMsg out : outmsgs) {
            if (out.getFault().getCompletionCode() != 0) {
                return;
            }
            HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
            for (Map.Entry entry : this.slotPortsMap.entrySet()) {
                String[] str;
                temp = (Resource)entry.getValue();
                Part main = (Part)partmap.get("AID");
                Part slv = (Part)partmap.get("SLVPORT");
                int mainSlotID = TETL1CommonUtil.getNMSlotStr((String)main.getValue(), (int)this.neid);
                int slvSlotID = TETL1CommonUtil.getNMSlotStr((String)slv.getValue(), (int)this.neid);
                if (temp.slotid == mainSlotID) {
                    str = TETL1CommonUtil.parseAID((String)main.getValue(), (int)this.neid);
                    Integer mainPort = Integer.valueOf(str[3]);
                    if (str[0].equals("FAC")) {
                        temp.macPortList.remove(mainPort);
                    }
                }
                if (temp.slotid != slvSlotID) continue;
                str = TETL1CommonUtil.parseAID((String)main.getValue(), (int)this.neid);
                Integer slvPort = Integer.valueOf(str[3]);
                if (!str[0].equals("FAC")) continue;
                temp.macPortList.remove(slvPort);
                temp.hasFilterMain = true;
            }
        }
    }

    private Object[] getPorts(String ports) {
        Object[] result = new Object[]{};
        if (ports == null) {
            return result;
        }
        StringBuffer sb = new StringBuffer();
        String[] value = ports.split("&&");
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            String[] portList = value[i].split("&");
            int m = portList.length;
            for (int j = 0; j < m; ++j) {
                String[] port = TETL1CommonUtil.parseAID((String)portList[j], (int)this.neid);
                sb.append(port[3]);
                if (j >= m - 1) continue;
                sb.append("&");
            }
            if (i >= n - 1) continue;
            sb.append("&&");
        }
        result = TETL1CommonUtil.getPorts((String)sb.toString());
        return result;
    }

    private List getBoardList() {
        if (null == boardTypeSupportDlagList) {
            this.initBoardTypeSupportDlagList();
        }
        ArrayList ethBoardList = new ArrayList();
        int jSize = boardTypeSupportDlagList.size();
        for (int j = 0; j < jSize; ++j) {
            ethBoardList.addAll(TEConfigurationDataMgr.getInstance().getBoardList(this.neid, ((Integer)boardTypeSupportDlagList.get(j)).intValue()));
        }
        for (int i = ethBoardList.size() - 1; i >= 0; --i) {
            TEBoard board = (TEBoard)ethBoardList.get(i);
            Integer slotid = board.getSlotID();
            Resource temp = new Resource(board);
            this.slotPortsMap.put(slotid, temp);
        }
        return ethBoardList;
    }

    private void initBoardTypeSupportDlagList() {
        boardTypeSupportDlagList = new ArrayList();
        Document doc = TEParseXMLFile.parseFile((String)(TEResourceManager.getPath() + FILEPATH));
        NodeList options = doc.getElementsByTagName("option");
        int size = options.getLength();
        for (int i = 0; i < size; ++i) {
            Element element = (Element)options.item(i);
            Integer boardTypeSupportDlag = Integer.valueOf(element.getAttribute("value"));
            boardTypeSupportDlagList.add(boardTypeSupportDlag);
        }
    }

    private static class Resource {
        int slotid;
        String boardName;
        List macPortList = new ArrayList();
        boolean hasFilterMain = false;
        boolean hasFilterSlave = false;

        public Resource(TEBoard board) {
            this.slotid = board.getSlotID();
            this.boardName = board.getBoardName();
            TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
            this.macPortList.addAll(mgr.getETHMACPort(board.getNEID(), board.getBoardType()));
        }
    }
}

