/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.dbps;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class TEDBPSGetAvailPortBean
extends TETL1NEExplorerBean {
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        RowParams row = new RowParams();
        Param param = new Param("portid", "");
        row.addParam(param);
        RowParams rowParam = inputData.getBussinessParams().getRowParams(0);
        int slotId = Integer.parseInt(rowParam.getParam("slotid").getValue());
        int boardType = this.mgr.getBoardType(neid, slotId);
        String boardName = this.mgr.getBoardTypeName(neid, boardType);
        String portType = rowParam.getParam("porttype").getValue();
        List portList = this.getPortList(portType, boardType);
        StringBuffer sb = null;
        int m = portList.size();
        for (int i = 0; i < m; ++i) {
            sb = new StringBuffer();
            sb.append(slotId).append("-");
            sb.append(boardName).append("-");
            Integer portId = (Integer)portList.get(i);
            sb.append(portId);
            param.addOption(new Option(sb.toString()));
        }
        this.outputData.getBussinessParams().addRowParams(row);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return this.outputData;
    }

    private List getPortList(String portType, int boardType) {
        if ("ip".equalsIgnoreCase(portType)) {
            return this.getIpPortList(boardType);
        }
        if ("vctrunk".equalsIgnoreCase(portType)) {
            return this.getVctrunkPortList(boardType);
        }
        List retList = this.getIpPortList(boardType);
        retList.addAll(this.getVctrunkPortList(boardType));
        return retList;
    }

    private List getIpPortList(int boardType) {
        ArrayList portList = new ArrayList(new HashSet(this.mgr.getSupportedDynPortList(this.neid, boardType)));
        Collections.sort(portList);
        return portList;
    }

    private List getVctrunkPortList(int boardType) {
        return this.mgr.getETHVCTrunkPort(this.neid, boardType);
    }
}

