/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;

public class TETL1QueryClockSwitchInfoBean
extends TETL1NEExplorerBean {
    private static final String INTERNAL_CLOCKSOURCE = "INTERNAL";
    private ArrayList operLogList = new ArrayList();

    public TETL1QueryClockSwitchInfoBean() {
        this.bQueryAidAndType = true;
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap) {
        if (oldParam.getName().equalsIgnoreCase("clockname")) {
            Part part = (Part)partmap.get("SYNCAID");
            if (part.getValue() == null || part.getValue().equals("")) {
                oldParam.setValue("/");
            } else if (part.getValue().equalsIgnoreCase(INTERNAL_CLOCKSOURCE)) {
                oldParam.setValue(part.getValue());
            } else {
                String strStruct = TETL1CommonUtil.getBoardStructFromAID((String)part.getValue(), (int)this.neid, (boolean)false);
                oldParam.setValue(strStruct);
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("clockstate")) {
            Part part = (Part)partmap.get("STATE");
            if (part.getValue() == null || part.getValue().equals("")) {
                oldParam.setValue("/");
            } else {
                oldParam.setValue(part.getValue());
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("lockstate")) {
            oldParam.setValue("/");
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("clockaid")) {
            Part part = (Part)partmap.get("SYNCAID");
            if (part.getValue() == null || part.getValue().equals("")) {
                oldParam.setValue("/");
            } else {
                oldParam.setValue(part.getValue());
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("mode2")) {
            Part part = (Part)partmap.get("SYNCAID");
            if (part.getValue() == null || part.getValue().equals("")) {
                oldParam.setValue("");
            } else {
                String mod2 = this.aidAndTypeList.getPayLoadMod2(this.neid, part.getValue());
                oldParam.setValue(mod2);
            }
            return oldParam;
        }
        return super.convertParamValue(oldParam, partmap);
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        if (part.getName().equalsIgnoreCase("AID")) {
            String slotNMID = rowparams.getParam("clockslotno").getValue();
            String neslot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotNMID));
            part.setValue("SLOT-" + neslot);
            return true;
        }
        return super.convertPartValue(part, rowparams);
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = super.convertToDatainterface(neid, subfunc, tl1OperList, filterErrorCodeList);
        ArrayList queryLockOperList = this.getQueryLockStatusOperList();
        if (null == queryLockOperList || queryLockOperList.size() == 0) {
            return;
        }
        int result = this.sendMessage(neid, queryLockOperList);
        if (result != 0) {
            return;
        }
        this.processOperList(queryLockOperList);
        this.cloneTL1OperationList.addAll(this.operLogList);
    }

    private void processOperList(ArrayList tl1OperList) {
        BussinessParams bussinessparams = this.outputData.getBussinessParams();
        int size = tl1OperList.size();
        block0: for (int i = 0; i < size; ++i) {
            TL1Operation oper = (TL1Operation)tl1OperList.get(i);
            HashMap map = TETL1CommonUtil.getOutMsgPart((OutMsg)oper.getOutMsg(0));
            int count = bussinessparams.getRowParamsCount();
            for (int j = 0; j < count; ++j) {
                Param param = bussinessparams.getRowParams(j).getParam("clockaid");
                if (param.getValue().equalsIgnoreCase(INTERNAL_CLOCKSOURCE)) {
                    bussinessparams.getRowParams(j).getParam("lockstate").setValue("-");
                    continue;
                }
                Part part = (Part)map.get("AID");
                if (part.getValue() == null || !part.getValue().equalsIgnoreCase(param.getValue())) continue;
                Part part1 = (Part)map.get("SYNCLOCK");
                bussinessparams.getRowParams(j).getParam("lockstate").setValue(part1.getValue());
                this.operLogList.add(oper.clone());
                continue block0;
            }
        }
    }

    private ArrayList getQueryLockStatusOperList() {
        this.operLogList.clear();
        BussinessParams bussinessparams = this.outputData.getBussinessParams();
        ArrayList<TL1Operation> queryLockOperList = new ArrayList<TL1Operation>();
        TL1Definitions tl1definitions = null;
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return queryLockOperList;
        }
        int count = bussinessparams.getRowParamsCount();
        for (int i = 0; i < count; ++i) {
            Param param = bussinessparams.getRowParams(i).getParam("clockaid");
            if (param.getValue().equalsIgnoreCase(INTERNAL_CLOCKSOURCE)) {
                bussinessparams.getRowParams(i).getParam("lockstate").setValue("-");
                continue;
            }
            String aid = param.getValue();
            String mod2 = this.aidAndTypeList.getPayLoadMod2(this.neid, aid);
            String tl1Cmd = TETL1CommonUtil.getTL1CmdMod2((String)("RTRV-" + mod2));
            TL1Operation operation = tl1definitions.getTL1Operation(tl1Cmd);
            TETL1CommonUtil.modifyMOD2((TL1Operation)operation, (String)mod2);
            operation.getInMsg().getStagBlock().getAID().getPart(0).setValue(aid);
            queryLockOperList.add(operation);
        }
        return queryLockOperList;
    }
}

